/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model.grouper;

import edu.cmu.scs.azurite.model.grouper.BaseChangeInformation;
import edu.cmu.scs.azurite.model.grouper.ChangeKind;
import edu.cmu.scs.azurite.model.grouper.IChangeInformation;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Range;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public class DeleteMethodInformation
extends BaseChangeInformation {
    private final MethodDeclaration preMethodNode;

    public DeleteMethodInformation(DocChange mergedChange, MethodDeclaration preMethodNode) {
        super(mergedChange);
        this.preMethodNode = preMethodNode;
    }

    @Override
    public ChangeKind getChangeKind() {
        return ChangeKind.DELETE_METHOD;
    }

    @Override
    public String getChangeSummary() {
        String methodName = this.getMethodName((ASTNode)this.getPreNode());
        if (methodName != null) {
            return String.format("Deleted method '%s'", methodName);
        }
        return "Deleted a method";
    }

    @Override
    public boolean shouldBeMerged(int level, IChangeInformation nextChange) {
        switch (level) {
            case 1: {
                return false;
            }
            case 2: {
                switch (nextChange.getChangeKind()) {
                    case CHANGE_TYPE: 
                    case DELETE_TYPE: 
                    case ADD_METHOD: 
                    case CHANGE_METHOD: 
                    case DELETE_METHOD: 
                    case ADD_FIELD: 
                    case CHANGE_FIELD: 
                    case DELETE_FIELD: {
                        return this.getPostTypeRange().equals((Object)nextChange.getPreTypeRange());
                    }
                }
                return false;
            }
        }
        return false;
    }

    public MethodDeclaration getPreNode() {
        return this.preMethodNode;
    }

    @Override
    public Range getPreTypeRange() {
        return new Range((ASTNode)this.getEnclosingType((ASTNode)this.getPreNode()));
    }

    @Override
    public Range getPostTypeRange() {
        if (this.getMergedChange() != null) {
            return this.getMergedChange().apply(this.getPreTypeRange());
        }
        return this.getPreTypeRange();
    }
}

