/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.preference;

import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class AzuritePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button buttonMarker;
    private Button buttonShowChunks;
    private Table table;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.buttonMarker = new Button(comp, 32);
        this.buttonMarker.setText("Enable code highlighting for the selected rectangles");
        this.buttonMarker.setSelection(store.getBoolean("Azurite_EnableMarkers"));
        this.buttonShowChunks = new Button(comp, 32);
        this.buttonShowChunks.setText("Show individual chunks in the Interactive Selective Undo Dialog");
        this.buttonShowChunks.setSelection(store.getBoolean("Azurite_InteractiveSelectiveUndoShowChunks"));
        Label label = new Label(comp, 0);
        label.setText("Events to be displayed in the Timeline View");
        this.table = new Table(comp, 67620);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        TableColumn col = new TableColumn(this.table, 16384);
        col.setText("Type");
        col.setWidth(100);
        col = new TableColumn(this.table, 16384);
        col.setText("Color");
        col.setWidth(100);
        col = new TableColumn(this.table, 16384);
        col.setText("Icon Path");
        col.setWidth(200);
        this.readIntoTable(store.getString("Azurite_EventDisplaySettings"));
        return comp;
    }

    private void readIntoTable(String settings) {
        this.table.removeAll();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StringReader reader = new StringReader(settings);){
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento[] iMementoArray = memento.getChildren();
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    String type = child.getString("type");
                    String color = child.getString("color");
                    String iconPath = child.getString("iconPath");
                    boolean enabled = child.getBoolean("enabled");
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(new String[]{type, color, iconPath});
                    item.setChecked(enabled);
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }

    private String getStringFromTable() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter writer = new StringWriter();){
                XMLMemento root = XMLMemento.createWriteRoot((String)"Azurite_EventDisplaySettings");
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    IMemento child = root.createChild("item");
                    child.putString("type", item.getText(0));
                    child.putString("color", item.getText(1));
                    child.putString("iconPath", item.getText(2));
                    child.putBoolean("enabled", item.getChecked());
                    ++n2;
                }
                root.save((Writer)writer);
                return writer.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.buttonMarker.setSelection(store.getDefaultBoolean("Azurite_EnableMarkers"));
        this.buttonShowChunks.setSelection(store.getDefaultBoolean("Azurite_InteractiveSelectiveUndoShowChunks"));
        this.readIntoTable(store.getDefaultString("Azurite_EventDisplaySettings"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean enableMarkers = this.buttonMarker.getSelection();
        store.setValue("Azurite_EnableMarkers", enableMarkers);
        TimelineViewPart timeline = TimelineViewPart.getInstance();
        if (timeline != null) {
            if (enableMarkers) {
                timeline.getMarkerManager().rectSelectionChanged();
            } else {
                timeline.getMarkerManager().removeAllMarkers();
            }
        }
        boolean showChunks = this.buttonShowChunks.getSelection();
        store.setValue("Azurite_InteractiveSelectiveUndoShowChunks", showChunks);
        store.setValue("Azurite_EventDisplaySettings", this.getStringFromTable());
        RuntimeHistoryManager.updateTimelineEventsList();
        TimelineViewPart.updateTimelineEventColorMap();
        TimelineViewPart.updateTimelineEventIconMap();
        TimelineViewPart.updateTimelineEventDisplayMap();
        TimelineViewPart.getInstance().redrawEvents();
        return super.performOk();
    }
}

