/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.compare;

import edu.cmu.scs.azurite.compare.BaseCompareItem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class DocumentRangeCompareItem
extends BaseCompareItem
implements IDocumentRange {
    private IDocument mDocument;
    private Position mRange;

    public DocumentRangeCompareItem(String name, IDocument doc, int start, int length, boolean editable) {
        this(name, 0L, doc, start, length, editable);
    }

    public DocumentRangeCompareItem(String name, long time, IDocument doc, int start, int length, boolean editable) {
        super(name, time, editable);
        this.mDocument = doc;
        this.registerPositionUpdater(start, length);
    }

    private void registerPositionUpdater(int start, int length) {
        this.mDocument.addPositionCategory("DocumentRangeCategory");
        this.mRange = new Position(start, length);
        try {
            this.mDocument.addPosition("DocumentRangeCategory", this.mRange);
        }
        catch (BadLocationException | BadPositionCategoryException e) {
            e.printStackTrace();
        }
    }

    public InputStream getContents() throws CoreException {
        String result = null;
        try {
            result = this.mDocument.get(this.mRange.getOffset(), this.mRange.getLength());
        }
        catch (BadLocationException badLocationException) {
            result = "";
        }
        return new ByteArrayInputStream(result.getBytes());
    }

    public IDocument getDocument() {
        return this.mDocument;
    }

    public Position getRange() {
        return this.mRange;
    }
}

