/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.commands.runtime;

import edu.cmu.scs.azurite.commands.runtime.EditComponent;
import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.commands.runtime.RuntimeDelete;
import edu.cmu.scs.azurite.commands.runtime.RuntimeInsert;
import edu.cmu.scs.azurite.commands.runtime.RuntimeReplace;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import java.util.List;

public class DeleteComponent
implements EditComponent {
    private Segment mDeleteSegment;

    @Override
    public void initialize(Segment initialSegment) {
        this.mDeleteSegment = initialSegment;
    }

    @Override
    public boolean applyInsert(RuntimeInsert insert) {
        List<Segment> insertSegments = insert.getInsertSegments();
        if (insertSegments.size() != 1) {
            throw new IllegalArgumentException("A new insert object must have exactly one insertion segment.");
        }
        Segment insertSegment = insertSegments.get(0);
        Segment dummyDelete = new Segment(insertSegment.getOffset(), 0, "", insertSegment.getBelongsTo(), insertSegment.getOwner(), true);
        return this.applyHelper(dummyDelete, insertSegment, insert);
    }

    @Override
    public boolean applyDelete(RuntimeDelete delete) {
        Segment deleteSegment = delete.getDeleteSegment();
        Segment dummyInsert = new Segment(deleteSegment.getOffset(), 0, "", deleteSegment.getBelongsTo(), deleteSegment.getOwner(), false);
        return this.applyHelper(deleteSegment, dummyInsert, delete);
    }

    @Override
    public boolean applyReplace(RuntimeReplace replace) {
        List<Segment> insertSegments = replace.getInsertSegments();
        if (insertSegments.size() != 1) {
            throw new IllegalArgumentException("A new replace object must have exactly one insertion segment.");
        }
        return this.applyHelper(replace.getDeleteSegment(), insertSegments.get(0), replace);
    }

    private boolean applyHelper(Segment deleteSegment, Segment insertSegment, RuntimeDC docChange) {
        boolean dummyDelete;
        int lengthDiff = insertSegment.getLength() - deleteSegment.getLength();
        Segment segment = this.getDeleteSegment();
        boolean conflict = false;
        boolean bl = dummyDelete = deleteSegment.getLength() == 0;
        if (deleteSegment.getEndOffset() <= segment.getOffset()) {
            if (deleteSegment.getEndOffset() == segment.getOffset() && !dummyDelete) {
                deleteSegment.addRight(segment);
            }
            segment.incrementOffset(lengthDiff);
        } else if (deleteSegment.getOffset() < segment.getOffset() && segment.getOffset() < deleteSegment.getEndOffset()) {
            if (deleteSegment.getLength() == 0) {
                throw new RuntimeException("delete segment should not be a dummy.");
            }
            deleteSegment.closeSegment(segment);
            conflict = true;
        } else if (segment.getOffset() > deleteSegment.getOffset()) {
            throw new IllegalStateException();
        }
        return conflict;
    }

    public Segment getDeleteSegment() {
        return this.mDeleteSegment;
    }
}

