/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model.grouper;

import edu.cmu.scs.azurite.model.grouper.BaseChangeInformation;
import edu.cmu.scs.azurite.model.grouper.ChangeKind;
import edu.cmu.scs.azurite.model.grouper.IChangeInformation;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Range;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;

public class AddFieldInformation
extends BaseChangeInformation {
    private final FieldDeclaration postFieldNode;

    public AddFieldInformation(DocChange mergedChange, FieldDeclaration postFieldNode) {
        super(mergedChange);
        this.postFieldNode = postFieldNode;
    }

    @Override
    public ChangeKind getChangeKind() {
        return ChangeKind.ADD_FIELD;
    }

    @Override
    public String getChangeSummary() {
        String fieldName = this.getFieldName((ASTNode)this.getPostNode());
        if (fieldName != null) {
            return String.format("Added field '%s'", fieldName);
        }
        return "Added a field";
    }

    @Override
    public boolean shouldBeMerged(int level, IChangeInformation nextChange) {
        switch (level) {
            case 1: {
                switch (nextChange.getChangeKind()) {
                    case CHANGE_FIELD: 
                    case DELETE_FIELD: {
                        return this.getPostRange().equals((Object)nextChange.getPreRange());
                    }
                }
                return false;
            }
            case 2: {
                switch (nextChange.getChangeKind()) {
                    case CHANGE_TYPE: 
                    case DELETE_TYPE: 
                    case ADD_METHOD: 
                    case CHANGE_METHOD: 
                    case DELETE_METHOD: 
                    case ADD_FIELD: 
                    case CHANGE_FIELD: 
                    case DELETE_FIELD: {
                        return this.getPostTypeRange().equals((Object)nextChange.getPreTypeRange());
                    }
                }
                return false;
            }
        }
        return false;
    }

    public FieldDeclaration getPostNode() {
        return this.postFieldNode;
    }

    @Override
    public Range getPreTypeRange() {
        if (this.getMergedChange() != null) {
            return this.getMergedChange().applyInverse(this.getPostTypeRange());
        }
        return this.getPostTypeRange();
    }

    @Override
    public Range getPostTypeRange() {
        return new Range((ASTNode)this.getEnclosingType((ASTNode)this.getPostNode()));
    }
}

