/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.dialogs;

import edu.cmu.scs.azurite.plugin.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HistorySearchDialog
extends Dialog {
    private Text mTextSearch;
    private Button mButtonCaseSensitive;
    private Button mButtonSelectedCode;
    private Button mButtonCurrentSession;
    private String mInitialSearchString;
    private boolean mCreatedDialogArea;
    private boolean mCaseSensitive;
    private boolean mScopeSelectedCode;
    private boolean mCurrentSession;
    private String mSearchText;
    public static final int SEARCH = 0;
    public static final int CLOSE = 1;

    public HistorySearchDialog(Shell shell, String initialSearchString) {
        super(shell);
        this.setShellStyle(2160);
        this.mInitialSearchString = initialSearchString;
        this.mCreatedDialogArea = false;
    }

    protected Control createDialogArea(Composite parent) {
        IPreferenceStore prefStore;
        this.getShell().setText("History Search");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Composite stringComp = new Composite(comp, 0);
        stringComp.setLayout((Layout)new GridLayout(2, false));
        stringComp.setLayoutData((Object)new GridData(768));
        Label label = new Label(stringComp, 0);
        label.setText("Search &text:");
        this.mTextSearch = new Text(stringComp, 2048);
        this.mTextSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        stringComp.pack();
        Composite dirScopeComp = new Composite(comp, 0);
        dirScopeComp.setLayout((Layout)new GridLayout(2, true));
        dirScopeComp.setLayoutData((Object)new GridData(768));
        Group locScopeGroup = new Group(dirScopeComp, 0);
        locScopeGroup.setText("Location scope");
        locScopeGroup.setLayout((Layout)new GridLayout());
        locScopeGroup.setLayoutData((Object)new GridData(768));
        Button buttonAll = new Button((Composite)locScopeGroup, 16);
        buttonAll.setText("All");
        this.mButtonSelectedCode = new Button((Composite)locScopeGroup, 16);
        this.mButtonSelectedCode.setText("Selected code");
        Group sessionScopeGroup = new Group(dirScopeComp, 0);
        sessionScopeGroup.setText("Session scope");
        sessionScopeGroup.setLayout((Layout)new GridLayout());
        sessionScopeGroup.setLayoutData((Object)new GridData(768));
        Button buttonAllSessions = new Button((Composite)sessionScopeGroup, 16);
        buttonAllSessions.setText("All sessions");
        this.mButtonCurrentSession = new Button((Composite)sessionScopeGroup, 16);
        this.mButtonCurrentSession.setText("Latest session");
        Group optionsGroup = new Group(dirScopeComp, 0);
        optionsGroup.setText("Options");
        optionsGroup.setLayout((Layout)new GridLayout(2, false));
        optionsGroup.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.mButtonCaseSensitive = new Button((Composite)optionsGroup, 32);
        this.mButtonCaseSensitive.setText("&Case sensitive");
        dirScopeComp.pack();
        if (this.mInitialSearchString != null) {
            this.mTextSearch.setText(this.mInitialSearchString);
        }
        if ((prefStore = Activator.getDefault().getPreferenceStore()).getBoolean("Azurite_HistorySearchSelectedCode")) {
            this.mButtonSelectedCode.setSelection(true);
        } else {
            buttonAll.setSelection(true);
        }
        if (prefStore.getBoolean("Azurite_HistorySearchCurrentSession")) {
            this.mButtonCurrentSession.setSelection(true);
        } else {
            buttonAllSessions.setSelection(true);
        }
        this.mButtonCaseSensitive.setSelection(prefStore.getBoolean("Azurite_HistorySearchCaseSensitive"));
        this.mTextSearch.selectAll();
        this.mCreatedDialogArea = true;
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.mCreatedDialogArea) {
            return;
        }
        this.createButton(parent, 0, "Search", true);
        this.createButton(parent, 1, "Close", false);
    }

    public boolean close() {
        this.mCaseSensitive = this.mButtonCaseSensitive.getSelection();
        this.mScopeSelectedCode = this.mButtonSelectedCode.getSelection();
        this.mCurrentSession = this.mButtonCurrentSession.getSelection();
        this.mSearchText = this.mTextSearch.getText();
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        if (prefStore != null) {
            prefStore.setValue("Azurite_HistorySearchSelectedCode", this.mScopeSelectedCode);
            prefStore.setValue("Azurite_HistorySearchCurrentSession", this.mCurrentSession);
            prefStore.setValue("Azurite_HistorySearchCaseSensitive", this.mCaseSensitive);
        }
        return super.close();
    }

    public boolean isCaseSensitive() {
        return this.mCaseSensitive;
    }

    public boolean isScopeSelectedCode() {
        return this.mScopeSelectedCode;
    }

    public boolean isCurrentSession() {
        return this.mCurrentSession;
    }

    public String getSearchText() {
        return this.mSearchText;
    }
}

