/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.views;

import edu.cmu.scs.azurite.commands.diff.DiffDelete;
import edu.cmu.scs.azurite.commands.diff.DiffInsert;
import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.jface.action.CommandAction;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.azurite.model.RuntimeDCListener;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.azurite.model.undo.SelectiveUndoEngine;
import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.views.CodeHistoryDiffViewPart;
import edu.cmu.scs.azurite.views.RectMarkerManager;
import edu.cmu.scs.azurite.views.RectSelectionListener;
import edu.cmu.scs.fluorite.commands.FileOpenCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.ITimestampOverridable;
import edu.cmu.scs.fluorite.commands.ITypeOverridable;
import edu.cmu.scs.fluorite.commands.document.Delete;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Insert;
import edu.cmu.scs.fluorite.commands.document.Replace;
import edu.cmu.scs.fluorite.model.CommandExecutionListener;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.model.Events;
import edu.cmu.scs.fluorite.util.Utilities;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class TimelineViewPart
extends ViewPart
implements RuntimeDCListener,
CommandExecutionListener {
    private static final String RETURN_CODE_OK = "ok";
    private static final String RETURN_CODE_FAIL = "fail";
    private static final String RETURN_CODE_UNKNOWN = "unknown";
    private static final String EXECUTE_JS_CODE_COMMAND_ID = "edu.cmu.scs.azurite.ui.commands.executeJSCode";
    private static final String EXECUTE_JS_CODE_COMMAND_PARAM_ID = "edu.cmu.scs.azurite.ui.commands.executeJSCode.codeToExecute";
    private static String BROWSER_FUNC_PREFIX = "__AZURITE__";
    private static final String TIMELINE_VIEW_ID = "edu.cmu.scs.azurite.views.TimelineViewPart";
    private static TimelineViewPart me = null;
    private static Map<String, String> timelineEventColorMap;
    private static Map<String, String> timelineEventIconMap;
    private static Map<String, Boolean> timelineEventDisplayMap;
    private Browser browser;
    private ListenerList rectSelectionListenerList = new ListenerList();
    private RectMarkerManager rectMarkerManager = new RectMarkerManager();

    public static TimelineViewPart getInstance() {
        return me;
    }

    public static void openTimeline() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                page.showView(TIMELINE_VIEW_ID);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateTimelineEventColorMap() {
        timelineEventColorMap = new HashMap<String, String>();
        if (Activator.getDefault() != null && Activator.getDefault().getPreferenceStore() != null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String str = store.getString("Azurite_EventDisplaySettings");
            if (str == null) {
                str = store.getDefaultString("Azurite_EventDisplaySettings");
            }
            if (str != null) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (StringReader reader = new StringReader(str);){
                        XMLMemento root = XMLMemento.createReadRoot((Reader)reader);
                        IMemento[] iMementoArray = root.getChildren();
                        int n = iMementoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemento child = iMementoArray[n2];
                            timelineEventColorMap.put(child.getString("type"), child.getString("color"));
                            ++n2;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (WorkbenchException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Map<String, String> getTimelineEventColorMap() {
        if (timelineEventColorMap == null) {
            TimelineViewPart.updateTimelineEventColorMap();
        }
        return Collections.unmodifiableMap(timelineEventColorMap);
    }

    public static void updateTimelineEventIconMap() {
        timelineEventIconMap = new HashMap<String, String>();
        if (Activator.getDefault() != null && Activator.getDefault().getPreferenceStore() != null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String str = store.getString("Azurite_EventDisplaySettings");
            if (str == null) {
                str = store.getDefaultString("Azurite_EventDisplaySettings");
            }
            if (str != null) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (StringReader reader = new StringReader(str);){
                        XMLMemento root = XMLMemento.createReadRoot((Reader)reader);
                        IMemento[] iMementoArray = root.getChildren();
                        int n = iMementoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemento child = iMementoArray[n2];
                            timelineEventIconMap.put(child.getString("type"), child.getString("iconPath"));
                            ++n2;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (WorkbenchException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Map<String, String> getTimelineEventIconMap() {
        if (timelineEventIconMap == null) {
            TimelineViewPart.updateTimelineEventIconMap();
        }
        return Collections.unmodifiableMap(timelineEventIconMap);
    }

    public static void updateTimelineEventDisplayMap() {
        timelineEventDisplayMap = new HashMap<String, Boolean>();
        if (Activator.getDefault() != null && Activator.getDefault().getPreferenceStore() != null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String str = store.getString("Azurite_EventDisplaySettings");
            if (str == null) {
                str = store.getDefaultString("Azurite_EventDisplaySettings");
            }
            if (str != null) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (StringReader reader = new StringReader(str);){
                        XMLMemento root = XMLMemento.createReadRoot((Reader)reader);
                        IMemento[] iMementoArray = root.getChildren();
                        int n = iMementoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemento child = iMementoArray[n2];
                            timelineEventDisplayMap.put(child.getString("type"), child.getBoolean("enabled"));
                            ++n2;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (WorkbenchException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Map<String, Boolean> getTimelineEventDisplayMap() {
        if (timelineEventDisplayMap == null) {
            TimelineViewPart.updateTimelineEventDisplayMap();
        }
        return Collections.unmodifiableMap(timelineEventDisplayMap);
    }

    public TimelineViewPart() {
        this.addRectSelectionListener(this.rectMarkerManager);
    }

    public void addRectSelectionListener(RectSelectionListener listener) {
        this.rectSelectionListenerList.add((Object)listener);
    }

    public void removeRectSelectionListener(RectSelectionListener listener) {
        this.rectSelectionListenerList.remove((Object)listener);
    }

    public void fireRectSelectionChanged() {
        Object[] objectArray = this.rectSelectionListenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((RectSelectionListener)listenerObj).rectSelectionChanged();
            ++n2;
        }
    }

    public void createPartControl(Composite parent) {
        me = this;
        this.browser = new Browser(parent, 0);
        this.addBrowserFunctions();
        this.moveToIndexPage();
        this.setupContextMenu();
        RuntimeHistoryManager.getInstance().addRuntimeDocumentChangeListener(this);
        EventRecorder.getInstance().addCommandExecutionListener((CommandExecutionListener)this);
    }

    private void setupContextMenu() {
        final HashMap<String, String> paramMap = new HashMap<String, String>();
        final CommandAction selectiveUndoAction = new CommandAction("Selective Undo", "edu.cmu.scs.azurite.ui.commands.selectiveUndoCommand");
        ImageDescriptor isuIcon = Activator.getImageDescriptor("icons/undo_in_region.png");
        final CommandAction interactiveSelectiveUndoAction = new CommandAction("Interactive Selective Undo", "edu.cmu.scs.azurite.ui.commands.interactiveSelectiveUndoCommand");
        interactiveSelectiveUndoAction.setImageDescriptor(isuIcon);
        final CommandAction jumpToTheAffectedCodeAction = new CommandAction("Jump to the Code", "edu.cmu.scs.azurite.ui.commands.jumpToTheAffectedCodeCommand");
        paramMap.clear();
        paramMap.put(EXECUTE_JS_CODE_COMMAND_PARAM_ID, "removeAllSelections();");
        final CommandAction deselectAllRectanglesAction = new CommandAction("Deselect All Rectangles", EXECUTE_JS_CODE_COMMAND_ID, paramMap);
        paramMap.clear();
        paramMap.put(EXECUTE_JS_CODE_COMMAND_PARAM_ID, "showSelectedFile();");
        final CommandAction showThisFileOnlyAction = new CommandAction("Show This File Only", EXECUTE_JS_CODE_COMMAND_ID, paramMap);
        paramMap.clear();
        paramMap.put(EXECUTE_JS_CODE_COMMAND_PARAM_ID, "showAllFilesInProject();");
        final CommandAction showAllFilesInTheSameProjectAction = new CommandAction("Show All Files in the Same Project", EXECUTE_JS_CODE_COMMAND_ID, paramMap);
        paramMap.clear();
        paramMap.put(EXECUTE_JS_CODE_COMMAND_PARAM_ID, "showAllFiles();");
        final CommandAction showAllFilesAction = new CommandAction("Show All Files", EXECUTE_JS_CODE_COMMAND_ID, paramMap);
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    String menuType;
                    switch (menuType = TimelineViewPart.this.browser.evaluate("return cmenu.typeName;").toString()) {
                        case "main_nothing": {
                            manager.add((IAction)interactiveSelectiveUndoAction);
                            break;
                        }
                        case "main_single": {
                            manager.add((IAction)selectiveUndoAction);
                            manager.add((IAction)interactiveSelectiveUndoAction);
                            manager.add((IAction)jumpToTheAffectedCodeAction);
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)deselectAllRectanglesAction);
                            break;
                        }
                        case "main_multi": {
                            manager.add((IAction)selectiveUndoAction);
                            manager.add((IAction)interactiveSelectiveUndoAction);
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)deselectAllRectanglesAction);
                            break;
                        }
                        case "file_in": {
                            manager.add((IAction)showThisFileOnlyAction);
                            manager.add((IAction)showAllFilesInTheSameProjectAction);
                            manager.add((IAction)showAllFilesAction);
                            break;
                        }
                        case "file_out": {
                            manager.add((IAction)showAllFilesAction);
                            break;
                        }
                        case "time_range": {
                            CommandAction selectAllInside = new CommandAction("Select All Rectangles Inside", "edu.cmu.scs.azurite.ui.commands.selectAllInsideCommand");
                            CommandAction selectAllOutside = new CommandAction("Select All Rectangles Outside", "edu.cmu.scs.azurite.ui.commands.selectAllOutsideCommand");
                            CommandAction deselectAllInside = new CommandAction("Deselect All Rectangles Inside", "edu.cmu.scs.azurite.ui.commands.deselectAllInsideCommand");
                            CommandAction deselectAllOutside = new CommandAction("Deselect All Rectangles Outside", "edu.cmu.scs.azurite.ui.commands.deselectAllOutsideCommand");
                            CommandAction showAllFilesEditedInRange = new CommandAction("Show All Files Edited In Range", "edu.cmu.scs.azurite.ui.commands.showFilesInRangeCommand");
                            CommandAction openAllFilesEditedInRange = new CommandAction("Open All Files Edited In Range", "edu.cmu.scs.azurite.ui.commands.openFilesInRangeCommand");
                            manager.add((IAction)selectAllInside);
                            manager.add((IAction)selectAllOutside);
                            manager.add((IAction)deselectAllInside);
                            manager.add((IAction)deselectAllOutside);
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)showAllFilesEditedInRange);
                            manager.add((IAction)openAllFilesEditedInRange);
                            break;
                        }
                        case "marker": {
                            Action undoCurrentFileToThisPointAction;
                            IEditorInput editorInput;
                            long absTimestamp = TimelineViewPart.this.getMarkerTimestamp();
                            CommandAction tagThisPointAction = new CommandAction("Tag This Point", "edu.cmu.scs.azurite.ui.commands.tagMarkerCommand");
                            manager.add((IAction)tagThisPointAction);
                            paramMap.clear();
                            paramMap.put("edu.cmu.scs.azurite.ui.commands.undoAllFilesToThisPoint.absTimestamp", Long.toString(absTimestamp));
                            CommandAction undoAllFilesToThisPointAction = new CommandAction("Undo All Files to This Point", "edu.cmu.scs.azurite.ui.commands.undoAllFilesToThisPoint", paramMap);
                            manager.add((IAction)undoAllFilesToThisPointAction);
                            paramMap.clear();
                            paramMap.put("edu.cmu.scs.azurite.ui.commands.undoAllFilesToThisPointInteractively.absTimestamp", Long.toString(absTimestamp));
                            CommandAction undoAllFilesToThisPointInteractivelyAction = new CommandAction("Undo All Files to This Point Interactively", "edu.cmu.scs.azurite.ui.commands.undoAllFilesToThisPointInteractively", paramMap);
                            manager.add((IAction)undoAllFilesToThisPointInteractivelyAction);
                            IEditorPart activeEditor = Utilities.getActiveEditor();
                            String fileName = null;
                            if (activeEditor != null && activeEditor instanceof AbstractTextEditor && (editorInput = activeEditor.getEditorInput()) instanceof IFileEditorInput) {
                                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                                fileName = fileEditorInput.getFile().getName();
                            }
                            if (fileName != null) {
                                paramMap.clear();
                                paramMap.put("edu.cmu.scs.azurite.ui.commands.undoCurrentFileToThisPoint.absTimestamp", Long.toString(absTimestamp));
                                undoCurrentFileToThisPointAction = new CommandAction("Undo \"" + fileName + "\" to This Point", "edu.cmu.scs.azurite.ui.commands.undoCurrentFileToThisPoint", paramMap);
                                if (!RuntimeHistoryManager.getInstance().hasDocumentChangesLaterThanTimestamp(absTimestamp)) {
                                    undoCurrentFileToThisPointAction.setEnabled(false);
                                }
                                manager.add((IAction)undoCurrentFileToThisPointAction);
                            } else {
                                undoCurrentFileToThisPointAction = new Action("Undo Current File to This Point"){};
                                undoCurrentFileToThisPointAction.setEnabled(false);
                                manager.add((IAction)undoCurrentFileToThisPointAction);
                            }
                            manager.add((IContributionItem)new Separator());
                            paramMap.clear();
                            paramMap.put("edu.cmu.scs.azurite.ui.commands.absTimestamp", Long.toString(absTimestamp));
                            CommandAction selectAllAfter = new CommandAction("Select All Rectangles After This Point", "edu.cmu.scs.azurite.ui.commands.selectAllAfterCommand", paramMap);
                            CommandAction selectAllBefore = new CommandAction("Select All Rectangles Before This Point", "edu.cmu.scs.azurite.ui.commands.selectAllBeforeCommand", paramMap);
                            CommandAction deselectAllAfter = new CommandAction("Deselect All Rectangles After This Point", "edu.cmu.scs.azurite.ui.commands.deselectAllAfterCommand", paramMap);
                            CommandAction deselectAllBefore = new CommandAction("Deselect All Rectangles Before This Point", "edu.cmu.scs.azurite.ui.commands.deselectAllBeforeCommand", paramMap);
                            manager.add((IAction)selectAllAfter);
                            manager.add((IAction)selectAllBefore);
                            manager.add((IAction)deselectAllAfter);
                            manager.add((IAction)deselectAllBefore);
                        }
                    }
                    manager.add((IContributionItem)new Separator("additions"));
                }
                catch (Exception exception) {}
            }
        });
        this.browser.setMenu(mgr.createContextMenu((Control)this.browser));
    }

    private void moveToIndexPage() {
        try {
            URL indexUrl = FileLocator.toFileURL((URL)Platform.getBundle((String)"edu.cmu.scs.azurite").getEntry("/html/index.html"));
            this.browser.setUrl(indexUrl.toString());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void addBrowserFunctions() {
        new UndoFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "selectiveUndo");
        new InitializeFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "initialize");
        new JumpFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "jump");
        new LogFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "log");
        new GetInfoFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "getInfo");
        new MarkerMoveFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "markerMove");
        new OpenAllFilesEditedInRangeFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "openAllFilesEditedInRange");
        new EclipseCommandFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "eclipseCommand");
        new NotifySelectionChangedFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "notifySelectionChanged");
        new EventColorFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "eventColorFunc");
        new EventIconFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "eventIconFunc");
        new EventDisplayFunction(this.browser, String.valueOf(BROWSER_FUNC_PREFIX) + "eventDisplayFunc");
    }

    public void dispose() {
        RuntimeHistoryManager.getInstance().removeRuntimeDocumentChangeListener(this);
        EventRecorder.getInstance().removeCommandExecutionListener((CommandExecutionListener)this);
        this.rectMarkerManager.removeAllMarkers();
        this.removeRectSelectionListener(this.rectMarkerManager);
        me = null;
        super.dispose();
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    @Override
    public void activeFileChanged(String projectName, String filePath) {
        if (projectName == null || filePath == null) {
            return;
        }
        this.addFile(projectName, filePath);
    }

    @Override
    public void runtimeDCAdded(RuntimeDC docChange) {
    }

    @Override
    public void documentChangeAdded(DocChange docChange) {
        this.addOperation(docChange, true, true);
    }

    public RectMarkerManager getMarkerManager() {
        return this.rectMarkerManager;
    }

    private void addFile(String projectName, String filePath) {
        String executeStr = this.getAddFileString(projectName, filePath);
        this.browser.execute(executeStr);
    }

    private String getAddFileString(String projectName, String filePath) {
        String executeStr = String.format("addFile('%1$s', '%2$s');", projectName, filePath == null ? "null" : filePath.replace('\\', '/'));
        return executeStr;
    }

    private void addEventToTimeline(ICommand event) {
        final String executeStr = this.getAddEventString(event);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineViewPart.this.browser.execute(executeStr);
            }
        });
    }

    private String getAddEventString(ICommand event) {
        long sessionId = event.getSessionId();
        long timestamp = event.getTimestamp();
        long displayTimestamp = event instanceof ITimestampOverridable ? ((ITimestampOverridable)event).getTimestampForDisplay() : sessionId + timestamp;
        String type = null;
        type = event instanceof ITypeOverridable ? ((ITypeOverridable)event).getTypeForDisplay() : event.getCommandType();
        String executeStr = String.format("addEvent(%1$d, %2$d, %3$d, %4$d, '%5$s', '%6$s');", sessionId, event.getCommandIndex(), timestamp, displayTimestamp, type, event.getDescription());
        return executeStr;
    }

    private void addOperation(DocChange docChange, boolean scroll, boolean current) {
        String executeStr = this.getAddOperationString(docChange, scroll, true, current);
        this.browser.execute(executeStr);
    }

    private void addOperations(Events events) {
        this.browser.execute("pushCurrentFile();");
        StringBuilder builder = new StringBuilder();
        for (ICommand command : events.getCommands()) {
            if (!(command instanceof DocChange)) continue;
            DocChange docChange = (DocChange)command;
            if (docChange instanceof FileOpenCommand) {
                FileOpenCommand foc = (FileOpenCommand)docChange;
                if (foc.getFilePath() == null) continue;
                builder.append(this.getAddFileString(foc.getProjectName(), foc.getFilePath()));
                continue;
            }
            builder.append(this.getAddOperationString(docChange, false, false, false));
        }
        this.browser.execute(builder.toString());
        this.browser.execute("popCurrentFile();");
    }

    private String getAddOperationString(DocChange docChange, boolean scroll, boolean layout, boolean current) {
        String executeStr = String.format("addOperation(%1$d, %2$d, %3$d, %4$d, %5$f, %6$f, %7$d, %8$s, %9$s, %10$s);", docChange.getSessionId(), docChange.getCommandIndex(), docChange.getTimestamp(), docChange.getTimestamp2(), docChange.getY1(), docChange.getY2(), this.getTypeIndex(docChange), Boolean.toString(scroll), Boolean.toString(layout), Boolean.toString(current));
        return executeStr;
    }

    private void addEvents(Events events) {
        StringBuilder builder = new StringBuilder();
        for (ICommand command : events.getCommands()) {
            if (!RuntimeHistoryManager.shouldCommandBeDisplayed(command)) continue;
            builder.append(this.getAddEventString(command));
        }
        this.browser.execute(builder.toString());
    }

    private int getTypeIndex(DocChange docChange) {
        if (docChange instanceof DiffInsert) {
            return 10;
        }
        if (docChange instanceof DiffDelete) {
            return 11;
        }
        if (docChange instanceof Insert) {
            return 0;
        }
        if (docChange instanceof Delete) {
            return 1;
        }
        if (docChange instanceof Replace) {
            return 2;
        }
        return -1;
    }

    @Override
    public void documentChangeUpdated(DocChange docChange) {
        String executeStr = String.format("updateOperation(%1$d, %2$d, %3$d, %4$f, %5$f, %6$d, true);", docChange.getSessionId(), docChange.getCommandIndex(), docChange.getTimestamp2(), docChange.getY1(), docChange.getY2(), this.getTypeIndex(docChange));
        this.browser.execute(executeStr);
    }

    @Override
    public void documentChangeAmended(DocChange oldDocChange, DocChange newDocChange) {
        String executeStr = String.format("updateOperation(%1$d, %2$d, %3$d, %4$f, %5$f, %6$d, true);", oldDocChange.getSessionId(), oldDocChange.getCommandIndex(), newDocChange.getTimestamp2(), newDocChange.getY1(), newDocChange.getY2(), this.getTypeIndex(newDocChange));
        this.browser.execute(executeStr);
    }

    public void addSelection(List<OperationId> ids, boolean clearSelection) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("addSelectionsByIds(");
        this.getJavaScriptListFromOperationIds(buffer, ids);
        buffer.append(", " + Boolean.toString(clearSelection) + ");");
        this.browser.execute(buffer.toString());
    }

    public void removeSelection(List<OperationId> ids) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("removeSelectionsByIds(");
        this.getJavaScriptListFromOperationIds(buffer, ids);
        buffer.append(");");
        this.browser.execute(buffer.toString());
    }

    private void getJavaScriptListFromOperationIds(StringBuffer buffer, List<OperationId> ids) {
        buffer.append("[");
        Iterator<OperationId> it = ids.iterator();
        if (it.hasNext()) {
            buffer.append(Long.toString(it.next().sid));
            while (it.hasNext()) {
                buffer.append(", " + it.next().sid);
            }
        }
        buffer.append("], [");
        it = ids.iterator();
        if (it.hasNext()) {
            buffer.append(Long.toString(it.next().id));
            while (it.hasNext()) {
                buffer.append(", " + it.next().id);
            }
        }
        buffer.append("]");
    }

    public void activateFirebugLite() {
        this.browser.execute("activateFirebugLite();");
    }

    @Override
    public void pastLogsRead(List<Events> listEvents) {
        if (listEvents == null) {
            throw new IllegalArgumentException();
        }
        if (listEvents.isEmpty()) {
            return;
        }
        for (Events events : listEvents) {
            this.addOperations(events);
            this.addEvents(events);
        }
        this.performLayout();
    }

    private void scrollToEnd() {
        this.browser.execute("scrollToEnd()");
    }

    public void executeJSCode(String codeToExecute) {
        this.browser.execute(codeToExecute);
    }

    public Object evaluateJSCode(String codeToExecute) {
        return this.browser.evaluate(codeToExecute);
    }

    public void refresh() {
        this.moveToIndexPage();
    }

    public void showMarkerAtTimestamp(long absTimestamp) {
        this.browser.execute("showMarkerAtTimestamp(" + absTimestamp + ");");
    }

    public void hideMarker() {
        this.browser.execute("hideMarker();");
    }

    public int getSelectedRectsCount() {
        try {
            Object result = this.evaluateJSCode("return global.selectedRects.length;");
            if (result instanceof Number) {
                return ((Number)result).intValue();
            }
            return 0;
        }
        catch (SWTException sWTException) {
            return 0;
        }
    }

    public List<OperationId> getRectSelection() {
        Object selected = this.evaluateJSCode("return getStandardRectSelection();");
        return TimelineViewPart.translateSelection(selected);
    }

    public boolean isRangeSelected() {
        try {
            Object result = this.evaluateJSCode("return global.selectedTimestampRange !== null;");
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return false;
        }
        catch (SWTException sWTException) {
            return false;
        }
    }

    public boolean isMarkerVisible() {
        try {
            Object result = this.evaluateJSCode("return isMarkerVisible();");
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return false;
        }
        catch (SWTException sWTException) {
            return false;
        }
    }

    public static List<OperationId> translateSelection(Object selected) {
        Object[] selectedArray = (Object[])selected;
        ArrayList<OperationId> ids = new ArrayList<OperationId>();
        Object[] objectArray = selectedArray;
        int n = selectedArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] idComponents;
            Object element = objectArray[n2];
            if (element instanceof Object[] && (idComponents = (Object[])element).length == 2 && idComponents[0] instanceof Number && idComponents[1] instanceof Number) {
                Number sid = (Number)idComponents[0];
                Number id = (Number)idComponents[1];
                ids.add(new OperationId(sid.longValue(), id.longValue()));
            }
            ++n2;
        }
        return ids;
    }

    public void commandExecuted(ICommand command) {
        if (RuntimeHistoryManager.shouldCommandBeDisplayed(command)) {
            this.addEventToTimeline(command);
        }
    }

    private void performLayout() {
        this.browser.execute("layout();");
    }

    public long getMarkerTimestamp() {
        return ((Number)this.browser.evaluate("return global.markerTimestamp;")).longValue();
    }

    public long getTimeRangeStart() {
        return ((Number)this.browser.evaluate("return global.selectedTimestampRange[0];")).longValue();
    }

    public long getTimeRangeEnd() {
        return ((Number)this.browser.evaluate("return global.selectedTimestampRange[1];")).longValue();
    }

    public void redrawEvents() {
        this.browser.execute("updateEvents();");
    }

    class EclipseCommandFunction
    extends BrowserFunction {
        public EclipseCommandFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            if (arguments.length != 1 || !(arguments[0] instanceof String)) {
                return TimelineViewPart.RETURN_CODE_FAIL;
            }
            String eclipseCmdId = (String)arguments[0];
            IHandlerService handlerService = (IHandlerService)TimelineViewPart.this.getSite().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(eclipseCmdId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return TimelineViewPart.RETURN_CODE_OK;
        }
    }

    class EventColorFunction
    extends BrowserFunction {
        public EventColorFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            if (arguments.length != 1) {
                return "";
            }
            Map colorMap = TimelineViewPart.getTimelineEventColorMap();
            if (colorMap == null || !colorMap.containsKey(arguments[0])) {
                return "";
            }
            return colorMap.get(arguments[0]);
        }
    }

    class EventDisplayFunction
    extends BrowserFunction {
        public EventDisplayFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            if (arguments.length != 1) {
                return "none";
            }
            Map displayMap = TimelineViewPart.getTimelineEventDisplayMap();
            if (displayMap == null || !displayMap.containsKey(arguments[0])) {
                return "none";
            }
            return Boolean.valueOf((Boolean)displayMap.get(arguments[0])) != false ? "" : "none";
        }
    }

    class EventIconFunction
    extends BrowserFunction {
        private static final String ERROR_ICON = "images/event_icons/error.png";

        public EventIconFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            if (arguments.length != 1) {
                return ERROR_ICON;
            }
            Map iconMap = TimelineViewPart.getTimelineEventIconMap();
            if (iconMap == null || !iconMap.containsKey(arguments[0])) {
                return ERROR_ICON;
            }
            return iconMap.get(arguments[0]);
        }
    }

    class GetInfoFunction
    extends BrowserFunction {
        public GetInfoFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            if (!(arguments != null && arguments.length == 4 && arguments[0] instanceof String && arguments[1] instanceof String && arguments[2] instanceof Number && arguments[3] instanceof Number)) {
                return TimelineViewPart.RETURN_CODE_FAIL;
            }
            try {
                String result;
                String projectName = (String)arguments[0];
                String filePath = (String)arguments[1];
                FileKey key = new FileKey(projectName, filePath);
                long sid = ((Number)arguments[2]).longValue();
                long id = ((Number)arguments[3]).longValue();
                OperationId oid = new OperationId(sid, id);
                RuntimeDC runtimeDC = RuntimeHistoryManager.getInstance().filterDocumentChangeByIdWithoutCalculating(key, oid);
                if (runtimeDC != null && (result = runtimeDC.getHtmlInfo()) != null) {
                    return result;
                }
                return TimelineViewPart.RETURN_CODE_UNKNOWN;
            }
            catch (Exception exception) {
                return TimelineViewPart.RETURN_CODE_UNKNOWN;
            }
        }
    }

    class InitializeFunction
    extends BrowserFunction {
        public InitializeFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            final long currentTimestamp = EventRecorder.getInstance().getStartTimestamp();
            final RuntimeHistoryManager manager = RuntimeHistoryManager.getInstance();
            manager.scheduleTask(new Runnable(){

                @Override
                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (FileKey key : manager.getFileKeys()) {
                                if (key.getProjectName() == null || key.getFilePath() == null) continue;
                                TimelineViewPart.this.addFile(key.getProjectName(), key.getFilePath());
                                for (RuntimeDC dc : manager.getRuntimeDocumentChanges(key)) {
                                    TimelineViewPart.this.addOperation(dc.getOriginal(), false, dc.getOriginal().getSessionId() == currentTimestamp);
                                }
                            }
                            for (ICommand eventToBeDisplayed : manager.getEventsToBeDisplayed()) {
                                TimelineViewPart.this.addEventToTimeline(eventToBeDisplayed);
                            }
                            TimelineViewPart.this.scrollToEnd();
                        }
                    });
                }
            });
            TimelineViewPart.this.performLayout();
            return TimelineViewPart.RETURN_CODE_OK;
        }
    }

    class JumpFunction
    extends BrowserFunction {
        public JumpFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            RuntimeDC runtimeDC;
            IEditorPart editor;
            block4: {
                if (!(arguments != null && arguments.length == 4 && arguments[0] instanceof String && arguments[1] instanceof String && arguments[2] instanceof Number && arguments[3] instanceof Number)) {
                    return TimelineViewPart.RETURN_CODE_FAIL;
                }
                try {
                    String projectName = (String)arguments[0];
                    String filePath = (String)arguments[1];
                    FileKey key = new FileKey(projectName, filePath);
                    long sid = ((Number)arguments[2]).longValue();
                    long id = ((Number)arguments[3]).longValue();
                    editor = edu.cmu.scs.azurite.util.Utilities.openEditorWithKey(key);
                    runtimeDC = RuntimeHistoryManager.getInstance().filterDocumentChangeById(key, new OperationId(sid, id));
                    if (runtimeDC != null) break block4;
                    return TimelineViewPart.RETURN_CODE_FAIL;
                }
                catch (Exception exception) {
                    return TimelineViewPart.RETURN_CODE_FAIL;
                }
            }
            edu.cmu.scs.azurite.util.Utilities.moveCursorToChangeLocation(editor, runtimeDC);
            return TimelineViewPart.RETURN_CODE_OK;
        }
    }

    class LogFunction
    extends BrowserFunction {
        public LogFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            System.out.println(arguments[0]);
            return TimelineViewPart.RETURN_CODE_OK;
        }
    }

    class MarkerMoveFunction
    extends BrowserFunction {
        private CodeHistoryViewUpdateRule rule;

        public MarkerMoveFunction(Browser browser, String name) {
            super(browser, name);
            this.rule = new CodeHistoryViewUpdateRule();
        }

        public Object function(Object[] arguments) {
            if (arguments.length != 1 || !(arguments[0] instanceof Number)) {
                return TimelineViewPart.RETURN_CODE_FAIL;
            }
            long absTimestamp = ((Number)arguments[0]).longValue();
            CodeHistoryViewUpdateJob job = new CodeHistoryViewUpdateJob(absTimestamp);
            Job[] jobArray = Job.getJobManager().find((Object)"Code History View Update");
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                Job existingJob = jobArray[n2];
                if (existingJob.getState() == 2) {
                    existingJob.cancel();
                }
                ++n2;
            }
            job.setSystem(true);
            job.setUser(false);
            job.setRule(this.rule);
            job.schedule();
            return TimelineViewPart.RETURN_CODE_OK;
        }

        class CodeHistoryViewUpdateJob
        extends UIJob {
            static final String JOB_NAME = "Code History View Update";
            private long absTimestamp;

            public CodeHistoryViewUpdateJob(long absTimestamp) {
                super(JOB_NAME);
                this.absTimestamp = absTimestamp;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                for (CodeHistoryDiffViewPart view : CodeHistoryDiffViewPart.getInstances()) {
                    view.selectVersionWithAbsTimestamp(this.absTimestamp);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JOB_NAME.equals(family);
            }
        }

        class CodeHistoryViewUpdateRule
        implements ISchedulingRule {
            CodeHistoryViewUpdateRule() {
            }

            public boolean contains(ISchedulingRule rule) {
                return rule instanceof CodeHistoryViewUpdateRule;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule instanceof CodeHistoryViewUpdateRule;
            }
        }
    }

    class NotifySelectionChangedFunction
    extends BrowserFunction {
        public NotifySelectionChangedFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            try {
                TimelineViewPart.this.fireRectSelectionChanged();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return TimelineViewPart.RETURN_CODE_OK;
        }
    }

    class OpenAllFilesEditedInRangeFunction
    extends BrowserFunction {
        public OpenAllFilesEditedInRangeFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            if (arguments.length != 1) {
                return TimelineViewPart.RETURN_CODE_FAIL;
            }
            try {
                Object[] filePaths;
                Object[] objectArray = filePaths = (Object[])arguments[0];
                int n = filePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    String filePath = (String)element;
                    File fileToOpen = new File(filePath);
                    if (fileToOpen.exists() && fileToOpen.isFile()) {
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        }
                        catch (PartInitException partInitException) {}
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return TimelineViewPart.RETURN_CODE_OK;
        }
    }

    class UndoFunction
    extends BrowserFunction {
        public UndoFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            if (arguments == null || arguments.length != 1 || arguments[0] == null) {
                return TimelineViewPart.RETURN_CODE_FAIL;
            }
            try {
                List<OperationId> ids = TimelineViewPart.translateSelection(arguments[0]);
                Map<FileKey, List<RuntimeDC>> params = RuntimeHistoryManager.getInstance().extractFileDCMapFromOperationIds(ids);
                SelectiveUndoEngine.getInstance().doSelectiveUndoOnMultipleFiles(params);
                return TimelineViewPart.RETURN_CODE_OK;
            }
            catch (Exception e) {
                e.printStackTrace();
                return TimelineViewPart.RETURN_CODE_FAIL;
            }
        }
    }
}

