/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.ui.handlers;

import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.ui.handlers.HandlerUtilities;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.IHandlerService;

public class SelectedCodeHandler
extends AbstractHandler {
    private static final String DIALOG_TITLE = "Azurite - Commands for Selected Code";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] result;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (!HandlerUtilities.isCodeSelected()) {
            MessageDialog.openInformation((Shell)shell, (String)DIALOG_TITLE, (String)"You must select some code first, in order to invoke these commands.");
            return null;
        }
        ListDialog dialog = new ListDialog(shell);
        dialog.setTitle(DIALOG_TITLE);
        dialog.setMessage("Which of the following commands do you want to execute on the selected code?");
        dialog.setHelpAvailable(false);
        dialog.setContentProvider((IStructuredContentProvider)new SelectedCodeOperationContentProvider());
        dialog.setLabelProvider((ILabelProvider)new SelectedCodeOperationLabelProvider());
        Object[][] objectArrayArray = new Object[4][];
        Object[] objectArray = new Object[3];
        objectArray[1] = "Select Corresponding Timeline Rectangles";
        objectArray[2] = "edu.cmu.scs.azurite.ui.commands.selectCorrespondingTimelineRectanglesCommand";
        objectArrayArray[0] = objectArray;
        objectArrayArray[1] = new Object[]{"icons/undo_in_region.png", "Undo All Operations on the Selection", "edu.cmu.scs.azurite.ui.commands.undoInRegionCommand"};
        Object[] objectArray2 = new Object[3];
        objectArray2[1] = "Stepwise Undo Operations on the Selection";
        objectArray2[2] = "edu.cmu.scs.azurite.ui.commands.stepwiseUndoInRegionCommand";
        objectArrayArray[2] = objectArray2;
        objectArrayArray[3] = new Object[]{"icons/time_machine.png", "Launch Code History Diff", "edu.cmu.scs.azurite.ui.commands.launchCodeHistoryDiff"};
        Object[][] input = objectArrayArray;
        dialog.setInput((Object)input);
        dialog.setInitialSelections(new Object[]{input[0]});
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            Object[] resultItem = (Object[])result[0];
            String commandId = resultItem[2].toString();
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(commandId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class SelectedCodeOperationContentProvider
    implements IStructuredContentProvider {
        private SelectedCodeOperationContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private static class SelectedCodeOperationLabelProvider
    extends LabelProvider {
        private List<Image> imagesToDispose = new ArrayList<Image>();

        private SelectedCodeOperationLabelProvider() {
        }

        public void dispose() {
            super.dispose();
            for (Image image : this.imagesToDispose) {
                image.dispose();
            }
        }

        public Image getImage(Object element) {
            if (element == null || ((Object[])element)[0] == null) {
                return null;
            }
            Image image = Activator.getImageDescriptor(((Object[])element)[0].toString()).createImage();
            this.imagesToDispose.add(image);
            return image;
        }

        public String getText(Object element) {
            return ((Object[])element)[1].toString();
        }
    }
}

