/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.ui.handlers;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.model.undo.Chunk;
import edu.cmu.scs.azurite.model.undo.SelectiveUndoEngine;
import edu.cmu.scs.azurite.ui.handlers.HandlerUtilities;
import edu.cmu.scs.fluorite.commands.document.Delete;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Insert;
import edu.cmu.scs.fluorite.commands.document.Replace;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.recorders.DocumentRecorder;
import edu.cmu.scs.fluorite.recorders.IDocumentRecorderInterceptor;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import name.fraser.neil.plaintext.diff_match_patch;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class StepwiseUndoInRegionHandler
extends AbstractHandler {
    private IDocument lastReferredActiveDocument;
    private ISelectionProvider lastSelectionProvider;
    private CompoundCancelListener lastCompoundCancelListener;
    private ITextSelection lastKnownSelection;
    private String lastKnownSnapshot;
    private long lastModificationStamp;
    private List<String> snapshotsAfterEachStep;
    private ITextSelection originalSelection;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextSelection selection = HandlerUtilities.getSelectedRegion();
        IEditorPart editorPart = Utilities.getActiveEditor();
        if (!(editorPart instanceof AbstractTextEditor)) {
            return null;
        }
        ITextEditor editor = (ITextEditor)editorPart;
        IDocumentProvider dp = editor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)editor.getEditorInput());
        if (!(doc instanceof IDocumentExtension4)) {
            throw new RuntimeException("Document should be extending IDocumentExtension4!!");
        }
        IDocumentExtension4 ext4 = (IDocumentExtension4)doc;
        boolean firstInvocation = this.determineFirstInvocation(doc, selection);
        if (firstInvocation) {
            List<RuntimeDC> dcs;
            if (this.lastReferredActiveDocument != null) {
                this.lastReferredActiveDocument.removePrenotifiedDocumentListener((IDocumentListener)this.lastCompoundCancelListener);
            }
            if (this.lastSelectionProvider != null) {
                this.lastSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.lastCompoundCancelListener);
            }
            if ((dcs = HandlerUtilities.getOperationsInSelectedRegion()) == null) {
                return null;
            }
            this.lastReferredActiveDocument = doc;
            this.lastSelectionProvider = editorPart.getEditorSite().getSelectionProvider();
            this.lastCompoundCancelListener = new CompoundCancelListener();
            this.lastReferredActiveDocument.addPrenotifiedDocumentListener((IDocumentListener)this.lastCompoundCancelListener);
            this.lastSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.lastCompoundCancelListener);
            this.originalSelection = selection;
            StepwiseUndoState.clear();
            this.snapshotsAfterEachStep = new ArrayList<String>();
            this.snapshotsAfterEachStep.add(doc.get());
            int i = 1;
            while (i <= dcs.size()) {
                List<RuntimeDC> subDCs = dcs.subList(dcs.size() - i, dcs.size());
                Chunk chunk = Chunk.fromDCList(subDCs, selection.getOffset(), selection.getOffset() + selection.getLength());
                int startOffset = chunk.getStartOffset();
                int endOffset = chunk.getEndOffset();
                String initialContent = doc.get().substring(startOffset, endOffset);
                String undoResult = SelectiveUndoEngine.getInstance().doSelectiveUndoChunkWithoutConflicts(chunk, initialContent);
                StringBuilder snapshot = new StringBuilder(doc.get());
                snapshot.replace(Math.max(startOffset, selection.getOffset()), Math.min(endOffset, selection.getOffset() + selection.getLength()), undoResult);
                this.snapshotsAfterEachStep.add(snapshot.toString());
                ++i;
            }
            ISourceViewer sourceViewer = Utilities.getSourceViewer((IEditorPart)editorPart);
            if (sourceViewer instanceof ITextViewerExtension6) {
                IUndoManager mgr = ((ITextViewerExtension6)sourceViewer).getUndoManager();
                mgr.beginCompoundChange();
                StepwiseUndoState.setUndoManager(mgr);
            }
        }
        if (this.snapshotsAfterEachStep.size() <= StepwiseUndoState.getStepCount() + 1) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openInformation((Shell)shell, (String)"Azurite - Stepwise Undo in Region", (String)"No more operations to be undone.");
            return null;
        }
        StepwiseUndoState.incrementStepCount();
        String originalSnapshot = this.snapshotsAfterEachStep.get(0);
        String newSnapshot = this.snapshotsAfterEachStep.get(StepwiseUndoState.getStepCount());
        diff_match_patch dmp = new diff_match_patch();
        int prefix = dmp.diff_commonPrefix(originalSnapshot, newSnapshot);
        int suffix = dmp.diff_commonSuffix(originalSnapshot, newSnapshot);
        if (prefix + suffix > originalSnapshot.length()) {
            suffix = originalSnapshot.length() - prefix;
        }
        if (prefix + suffix > newSnapshot.length()) {
            suffix = newSnapshot.length() - prefix;
        }
        try {
            int curSuffix;
            int curPrefix;
            long stamp = ext4.getModificationStamp();
            long nextStamp = this.getNextStamp(stamp);
            if (!firstInvocation) {
                DocumentRecorder.getInstance().setIntercept(doc, stamp, nextStamp, (IDocumentRecorderInterceptor)new DocumentRecorderInterceptor(prefix, suffix, newSnapshot, originalSnapshot, doc));
            }
            if ((curPrefix = dmp.diff_commonPrefix(doc.get(), newSnapshot)) + (curSuffix = dmp.diff_commonSuffix(doc.get(), newSnapshot)) > doc.getLength()) {
                curSuffix = doc.getLength() - curPrefix;
            }
            if (curPrefix + curSuffix > newSnapshot.length()) {
                curSuffix = newSnapshot.length() - curPrefix;
            }
            this.lastCompoundCancelListener.disable();
            ext4.replace(curPrefix, doc.getLength() - curPrefix - curSuffix, newSnapshot.substring(curPrefix, newSnapshot.length() - curSuffix), nextStamp);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        int startOffset = this.originalSelection.getOffset();
        int endOffset = startOffset + this.originalSelection.getLength() + newSnapshot.length() - originalSnapshot.length();
        if (prefix < startOffset) {
            startOffset = prefix;
        }
        if (newSnapshot.length() - suffix > endOffset) {
            endOffset = newSnapshot.length() - suffix;
        }
        this.lastSelectionProvider.setSelection((ISelection)new TextSelection(doc, startOffset, endOffset - startOffset));
        this.lastCompoundCancelListener.enable();
        this.lastKnownSelection = new TextSelection(doc, startOffset, endOffset - startOffset);
        this.lastKnownSnapshot = doc.get();
        this.lastModificationStamp = ext4.getModificationStamp();
        return null;
    }

    private boolean determineFirstInvocation(IDocument doc, ITextSelection selection) {
        IDocumentExtension4 ext4 = (IDocumentExtension4)doc;
        return StepwiseUndoState.getStepCount() == 0 || this.lastReferredActiveDocument == null || this.lastKnownSelection == null || this.lastReferredActiveDocument != doc || !this.lastKnownSnapshot.equals(doc.get()) || this.lastModificationStamp != ext4.getModificationStamp() || this.lastKnownSelection.getOffset() != selection.getOffset() || this.lastKnownSelection.getLength() != selection.getLength();
    }

    private long getNextStamp(long stamp) {
        return stamp == -1L || stamp == Long.MAX_VALUE ? 0L : stamp + 1L;
    }

    private static class CompoundCancelListener
    implements IDocumentListener,
    ISelectionChangedListener {
        private boolean enabled = false;

        private CompoundCancelListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.checkAndClear();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.checkAndClear();
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }

        private void checkAndClear() {
            if (this.enabled) {
                StepwiseUndoState.clear();
                this.disable();
            }
        }
    }

    private static final class DocumentRecorderInterceptor
    implements IDocumentRecorderInterceptor {
        private final int prefix;
        private final int suffix;
        private final String newSnapshot;
        private final String originalSnapshot;
        private final IDocument doc;

        private DocumentRecorderInterceptor(int prefix, int suffix, String newSnapshot, String originalSnapshot, IDocument doc) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.newSnapshot = newSnapshot;
            this.originalSnapshot = originalSnapshot;
            this.doc = doc;
        }

        public void documentChanged(DocumentEvent event, EventRecorder recorder) {
            Document originalDoc = new Document(this.originalSnapshot);
            int startLine = -1;
            int endLine = -1;
            try {
                startLine = originalDoc.getLineOfOffset(this.prefix);
                endLine = originalDoc.getLineOfOffset(originalDoc.getLength() - this.suffix);
            }
            catch (BadLocationException badLocationException) {}
            if (this.prefix + this.suffix == this.originalSnapshot.length()) {
                Insert insert = new Insert(this.prefix, this.newSnapshot.substring(this.prefix, this.newSnapshot.length() - this.suffix), this.doc);
                recorder.amendLastDocumentChange((DocChange)insert, true);
            } else if (this.prefix + this.suffix == this.newSnapshot.length()) {
                Delete delete = new Delete(this.prefix, this.originalSnapshot.length() - this.prefix - this.suffix, startLine, endLine, this.originalSnapshot.substring(this.prefix, this.originalSnapshot.length() - this.suffix), (IDocument)originalDoc);
                recorder.amendLastDocumentChange((DocChange)delete, true);
            } else {
                Replace replace = new Replace(this.prefix, this.originalSnapshot.length() - this.prefix - this.suffix, startLine, endLine, this.newSnapshot.length() - this.prefix - this.suffix, this.originalSnapshot.substring(this.prefix, this.originalSnapshot.length() - this.suffix), this.newSnapshot.substring(this.prefix, this.newSnapshot.length() - this.suffix), (IDocument)originalDoc);
                recorder.amendLastDocumentChange((DocChange)replace, true);
            }
        }
    }

    public static class StepwiseUndoState {
        private static int stepCount = 0;
        private static IUndoManager undoManager = null;

        public static void clear() {
            stepCount = 0;
            if (undoManager != null) {
                undoManager.endCompoundChange();
                undoManager = null;
            }
        }

        public static int getStepCount() {
            return stepCount;
        }

        public static void incrementStepCount() {
            ++stepCount;
        }

        public static void setUndoManager(IUndoManager mgr) {
            undoManager = mgr;
        }
    }
}

