/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.ui.handlers;

import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.IHandlerService;

public class SelectedRangeHandler
extends AbstractHandler {
    private static final String DIALOG_TITLE = "Azurite - Commands for Selected Time Range in Timeline";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] result;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TimelineViewPart timeline = TimelineViewPart.getInstance();
        if (timeline == null) {
            MessageDialog.openInformation((Shell)shell, (String)DIALOG_TITLE, (String)"You must open the timeline first.");
            return null;
        }
        if (!timeline.isRangeSelected()) {
            MessageDialog.openInformation((Shell)shell, (String)DIALOG_TITLE, (String)"You must select some time range first.");
            return null;
        }
        ListDialog dialog = new ListDialog(shell);
        dialog.setTitle(DIALOG_TITLE);
        dialog.setMessage("Which of the following commands do you want to execute on the selected time range?");
        dialog.setHelpAvailable(false);
        dialog.setContentProvider((IStructuredContentProvider)new SelectedRangeOperationContentProvider());
        dialog.setLabelProvider((ILabelProvider)new SelectedRangeOperationLabelProvider());
        Object[][] objectArrayArray = new Object[6][];
        Object[] objectArray = new Object[3];
        objectArray[1] = "Select All Rectangles Inside";
        objectArray[2] = "edu.cmu.scs.azurite.ui.commands.selectAllInsideCommand";
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[1] = "Select All Rectangles Outside";
        objectArray2[2] = "edu.cmu.scs.azurite.ui.commands.selectAllOutsideCommand";
        objectArrayArray[1] = objectArray2;
        Object[] objectArray3 = new Object[3];
        objectArray3[1] = "Deselect All Rectangles Inside";
        objectArray3[2] = "edu.cmu.scs.azurite.ui.commands.deselectAllInsideCommand";
        objectArrayArray[2] = objectArray3;
        Object[] objectArray4 = new Object[3];
        objectArray4[1] = "Deselect All Rectangles Outside";
        objectArray4[2] = "edu.cmu.scs.azurite.ui.commands.deselectAllOutsideCommand";
        objectArrayArray[3] = objectArray4;
        Object[] objectArray5 = new Object[3];
        objectArray5[1] = "Show All Files Edited In Range";
        objectArray5[2] = "edu.cmu.scs.azurite.ui.commands.showFilesInRangeCommand";
        objectArrayArray[4] = objectArray5;
        Object[] objectArray6 = new Object[3];
        objectArray6[1] = "Open All Files Edited In Range";
        objectArray6[2] = "edu.cmu.scs.azurite.ui.commands.openFilesInRangeCommand";
        objectArrayArray[5] = objectArray6;
        Object[][] input = objectArrayArray;
        dialog.setInput((Object)input);
        dialog.setInitialSelections(new Object[]{input[0]});
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            Object[] resultItem = (Object[])result[0];
            String commandId = resultItem[2].toString();
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(commandId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class SelectedRangeOperationContentProvider
    implements IStructuredContentProvider {
        private SelectedRangeOperationContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private static class SelectedRangeOperationLabelProvider
    extends LabelProvider {
        private List<Image> imagesToDispose = new ArrayList<Image>();

        private SelectedRangeOperationLabelProvider() {
        }

        public void dispose() {
            super.dispose();
            for (Image image : this.imagesToDispose) {
                image.dispose();
            }
        }

        public Image getImage(Object element) {
            if (element == null || ((Object[])element)[0] == null) {
                return null;
            }
            Image image = Activator.getImageDescriptor(((Object[])element)[0].toString()).createImage();
            this.imagesToDispose.add(image);
            return image;
        }

        public String getText(Object element) {
            return ((Object[])element)[1].toString();
        }
    }
}

