/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.dialogs;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.compare.AzuriteCompareInput;
import edu.cmu.scs.azurite.compare.AzuriteCompareLabelProvider;
import edu.cmu.scs.azurite.compare.DocumentRangeCompareItem;
import edu.cmu.scs.azurite.jface.widgets.AlternativeButton;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.azurite.model.undo.Chunk;
import edu.cmu.scs.azurite.model.undo.SelectiveUndoEngine;
import edu.cmu.scs.azurite.model.undo.SelectiveUndoParams;
import edu.cmu.scs.azurite.model.undo.UndoAlternative;
import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.util.Utilities;
import edu.cmu.scs.azurite.views.RectSelectionListener;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ViewerPane;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class InteractiveSelectiveUndoDialog
extends TitleAreaDialog
implements RectSelectionListener {
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int SPACING = 10;
    private static final int SURROUNDING_CONTEXT_SIZE = 3;
    private static final String TEXT = "Azurite - Interactive Selective Undo";
    private static final String TITLE = "Interactive Selective Undo";
    private static final String DEFAULT_MESSAGE = "The preview will be updated as you select/deselect rectangles from the timeline.";
    private static final String CHUNKS_TITLE = "Changes to be performed";
    private static final String ALTERNATIVES_TITLE = "Choose one of the alternatives below to resolve the conflict.";
    protected static final String NEXT_CHANGE_ID = "edu.cmu.scs.azurite.nextChange";
    protected static final String NEXT_CHANGE_TOOLTOP = "Select Next Chunk";
    protected static final String PREVIOUS_CHANGE_ID = "edu.cmu.scs.azurite.previousChange";
    protected static final String PREVIOUS_CHANGE_TOOLTIP = "Select Previous Chunk";
    private static final String INFORMATION_SELECT_RECTS = "You must select some rectangles to undo.";
    private static final String INFORMATION_SELECT_CHUNK = "Select a chunk from the list on the top to see the preview.";
    private static final String GENERATING_PREVIEW_ERROR_MSG = "Error occurred while generating the preview.";
    private static final String KEEP_ACTION_ID = "edu.cmu.scs.azurite.keepAction";
    private static InteractiveSelectiveUndoDialog instance = null;
    private boolean mShowChunks;
    private MenuManager mLeftSourceViewerMenuMgr;
    private SashForm mBottomSash;
    private ChunksTreeViewer mChunksTreeViewer;
    private Composite mBottomArea;
    private StackLayout mBottomStackLayout;
    private Composite mConflictResolutionArea;
    private CompareViewerSwitchingPane mPreviewPane;
    private CompareConfiguration mCompareConfiguration;
    private String mCompareTitle;
    private SourceViewer mLeftSourceViewer;
    private ViewerPane mConflictResolutionPane;
    private Label mInformationLabel;

    public static InteractiveSelectiveUndoDialog getInstance() {
        return instance;
    }

    public static void launch() {
        if (InteractiveSelectiveUndoDialog.getInstance() != null) {
            InteractiveSelectiveUndoDialog.getInstance().getShell().forceActive();
        } else {
            Shell parentShell = Display.getDefault().getActiveShell();
            InteractiveSelectiveUndoDialog isuDialog = new InteractiveSelectiveUndoDialog(parentShell);
            isuDialog.create();
            isuDialog.open();
        }
    }

    public InteractiveSelectiveUndoDialog(Shell parent) {
        super(parent);
        this.setShellStyle(2160);
        this.setBlockOnOpen(false);
        this.setHelpAvailable(false);
        this.mCompareConfiguration = this.createCompareConfiguration();
        this.mShowChunks = Activator.getDefault().getPreferenceStore().getBoolean("Azurite_InteractiveSelectiveUndoShowChunks");
    }

    private CompareConfiguration createCompareConfiguration() {
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setDefaultLabelProvider((ICompareInputLabelProvider)new AzuriteCompareLabelProvider());
        return configuration;
    }

    public void create() {
        super.create();
        instance = this;
        this.getShell().setText(TEXT);
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        this.getShell().setSize(800, 600);
        TimelineViewPart.getInstance().addRectSelectionListener(this);
    }

    protected void handleShellCloseEvent() {
        this.cleanup();
        super.handleShellCloseEvent();
    }

    protected void cancelPressed() {
        this.cleanup();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.cleanup();
        TopLevelElement[] topElems = (TopLevelElement[])this.mChunksTreeViewer.getInput();
        HashMap<FileKey, SelectiveUndoParams> paramsMap = new HashMap<FileKey, SelectiveUndoParams>();
        TopLevelElement[] topLevelElementArray = topElems;
        int n = topElems.length;
        int n2 = 0;
        while (n2 < n) {
            TopLevelElement topElem = topLevelElementArray[n2];
            paramsMap.put(topElem.getFileKey(), topElem.getSelectiveUndoParams());
            ++n2;
        }
        SelectiveUndoEngine.getInstance().doSelectiveUndoOnMultipleFilesWithChoices(paramsMap);
        super.okPressed();
    }

    private void cleanup() {
        TimelineViewPart.getInstance().removeRectSelectionListener(this);
        instance = null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createMainArea(parent);
        SashForm topSash = new SashForm(composite, 512);
        this.createChunksTreeViewer((Composite)topSash);
        this.createBottomArea((Composite)topSash);
        topSash.setSashWidth(10);
        topSash.setWeights(new int[]{1, 3});
        this.createMenuBar();
        this.setChunksTreeViewerInput();
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateOKButtonEnabled();
        return contents;
    }

    private void createMenuBar() {
        Menu menuBar = new Menu((Decorations)this.getShell(), 2);
        MenuItem testMenu = new MenuItem(menuBar, 64);
        testMenu.setText("Test");
        this.mLeftSourceViewerMenuMgr = new MenuManager();
        this.mLeftSourceViewerMenuMgr.setRemoveAllWhenShown(true);
        this.mLeftSourceViewerMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITextSelection sel;
                if (InteractiveSelectiveUndoDialog.this.mLeftSourceViewer != null && (sel = (ITextSelection)InteractiveSelectiveUndoDialog.this.mLeftSourceViewer.getSelection()).getLength() > 0) {
                    manager.add((IAction)new KeepSelectedCodeUnchanged("Keep this code unchanged"));
                }
            }
        });
        MenuManager treeViewerMenuMgr = new MenuManager();
        treeViewerMenuMgr.setRemoveAllWhenShown(true);
        treeViewerMenuMgr.addMenuListener((IMenuListener)new TreeViewerMenuListener());
        Control treeControl = this.mChunksTreeViewer.getControl();
        treeControl.setMenu(treeViewerMenuMgr.createContextMenu(treeControl));
    }

    private Composite createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 10;
        fillLayout.marginHeight = 10;
        composite.setLayout((Layout)fillLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    private void createChunksTreeViewer(Composite parent) {
        ViewerPane chunksPane = new ViewerPane(parent, 0x800800);
        this.mChunksTreeViewer = new ChunksTreeViewer((Composite)chunksPane, 0);
        chunksPane.setText(CHUNKS_TITLE);
        ToolBarManager tbm = chunksPane.getToolBarManager();
        tbm.add((IAction)new NextChunk());
        tbm.add((IAction)new PreviousChunk());
        tbm.update(true);
        this.mChunksTreeViewer.setContentProvider((IContentProvider)this.createChunksTreeContentProvider());
        this.mChunksTreeViewer.setLabelProvider((IBaseLabelProvider)this.createChunksTreeLabelProvider());
        this.mChunksTreeViewer.setComparator(this.createChunksTreeComparator());
        this.mChunksTreeViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.mChunksTreeViewer.setAutoExpandLevel(2);
        chunksPane.setContent(this.mChunksTreeViewer.getControl());
    }

    private ITreeContentProvider createChunksTreeContentProvider() {
        return new ChunksContentProvider();
    }

    private ILabelProvider createChunksTreeLabelProvider() {
        return new ChunksLabelProvider();
    }

    private ViewerComparator createChunksTreeComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof TopLevelElement && e2 instanceof TopLevelElement) {
                    String rhsFileName;
                    TopLevelElement lhs = (TopLevelElement)e1;
                    TopLevelElement rhs = (TopLevelElement)e2;
                    String lhsFileName = lhs.getFileKey().getFileNameOnly();
                    int result = lhsFileName.compareTo(rhsFileName = rhs.getFileKey().getFileNameOnly());
                    if (result != 0) {
                        return result;
                    }
                    lhsFileName = lhs.getFileKey().getFilePath();
                    rhsFileName = rhs.getFileKey().getFilePath();
                    return lhsFileName.compareTo(rhsFileName);
                }
                if (e1 instanceof ChunkLevelElement && e2 instanceof ChunkLevelElement) {
                    ChunkLevelElement lhs = (ChunkLevelElement)e1;
                    ChunkLevelElement rhs = (ChunkLevelElement)e2;
                    return Chunk.getLocationComparator().compare(lhs.getChunk(), rhs.getChunk());
                }
                return 0;
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                final IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                UIJob job = new UIJob("Interactive Selective Undo Dialog Update"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        InteractiveSelectiveUndoDialog.this.updateBottomPanel(sel);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.setUser(false);
                job.schedule();
            }
        };
    }

    private void setChunksTreeViewerInput() {
        if (this.mChunksTreeViewer == null) {
            return;
        }
        TimelineViewPart timeline = TimelineViewPart.getInstance();
        if (timeline == null) {
            return;
        }
        List<OperationId> ids = timeline.getRectSelection();
        Map<FileKey, List<RuntimeDC>> fileDCMap = RuntimeHistoryManager.getInstance().extractFileDCMapFromOperationIds(ids);
        ArrayList<TopLevelElement> topList = new ArrayList<TopLevelElement>();
        for (FileKey fileKey : fileDCMap.keySet()) {
            List<Chunk> chunksForThisFile = SelectiveUndoEngine.getInstance().determineChunksWithRuntimeDCs(fileDCMap.get(fileKey));
            TopLevelElement topElem = new TopLevelElement(fileKey, chunksForThisFile);
            topList.add(topElem);
        }
        TopLevelElement[] oldInput = (TopLevelElement[])this.mChunksTreeViewer.getInput();
        Object oldSelection = ((IStructuredSelection)this.mChunksTreeViewer.getSelection()).getFirstElement();
        TopLevelElement[] newInput = topList.toArray(new TopLevelElement[topList.size()]);
        if (oldInput != null) {
            this.restoreChosenAlternatives(oldInput, newInput);
        }
        this.mChunksTreeViewer.setInput(newInput);
        this.restoreSelections(oldSelection, newInput);
        this.updateOKButtonEnabled();
    }

    private void restoreSelections(Object oldSelection, TopLevelElement[] newInput) {
        if (oldSelection instanceof TopLevelElement) {
            TopLevelElement oldTopElem = (TopLevelElement)oldSelection;
            TopLevelElement[] topLevelElementArray = newInput;
            int n = newInput.length;
            int n2 = 0;
            while (n2 < n) {
                TopLevelElement newTopElem = topLevelElementArray[n2];
                if (oldTopElem.getFileKey().equals(newTopElem.getFileKey())) {
                    this.mChunksTreeViewer.setSelection((ISelection)new StructuredSelection((Object)newTopElem), true);
                    break;
                }
                ++n2;
            }
        } else if (oldSelection instanceof ChunkLevelElement) {
            ChunkLevelElement oldChunkElem = (ChunkLevelElement)oldSelection;
            TopLevelElement oldTopElem = oldChunkElem.getParent();
            TopLevelElement[] topLevelElementArray = newInput;
            int n = newInput.length;
            int n3 = 0;
            while (n3 < n) {
                TopLevelElement newTopElem = topLevelElementArray[n3];
                if (!this.restoreSelectionsForTopElement(oldChunkElem, oldTopElem, newTopElem)) {
                    ++n3;
                    continue;
                }
                break;
            }
        } else if (oldSelection == null && newInput != null && newInput.length > 0) {
            this.mChunksTreeViewer.setSelection((ISelection)new StructuredSelection((Object)newInput[0]), true);
        }
    }

    private boolean restoreSelectionsForTopElement(ChunkLevelElement oldChunkElem, TopLevelElement oldTopElem, TopLevelElement newTopElem) {
        if (oldTopElem.getFileKey().equals(newTopElem.getFileKey())) {
            for (ChunkLevelElement newChunkElem : newTopElem.getChunkElements()) {
                if (!this.areSameChunks(oldChunkElem.getChunk(), newChunkElem.getChunk())) continue;
                this.mChunksTreeViewer.setSelection((ISelection)new StructuredSelection((Object)newChunkElem), true);
                break;
            }
            return true;
        }
        return false;
    }

    private void restoreChosenAlternatives(TopLevelElement[] oldInput, TopLevelElement[] newInput) {
        TopLevelElement[] topLevelElementArray = oldInput;
        int n = oldInput.length;
        int n2 = 0;
        while (n2 < n) {
            TopLevelElement oldTopElem = topLevelElementArray[n2];
            TopLevelElement matchingTopElem = null;
            TopLevelElement[] topLevelElementArray2 = newInput;
            int n3 = newInput.length;
            int n4 = 0;
            while (n4 < n3) {
                TopLevelElement newTopElem = topLevelElementArray2[n4];
                if (oldTopElem.getFileKey().equals(newTopElem.getFileKey())) {
                    matchingTopElem = newTopElem;
                    break;
                }
                ++n4;
            }
            if (matchingTopElem != null) {
                this.restoreChosenAlternatives(oldTopElem, matchingTopElem);
            }
            ++n2;
        }
    }

    private void restoreChosenAlternatives(TopLevelElement oldTopElem, TopLevelElement matchingTopElem) {
        for (ChunkLevelElement oldChunkElem : oldTopElem.getChunkElements()) {
            if (oldChunkElem.getChosenAlternative() == null) continue;
            boolean found = false;
            for (ChunkLevelElement newChunkElem : matchingTopElem.getChunkElements()) {
                if (!this.areSameChunks(oldChunkElem.getChunk(), newChunkElem.getChunk()) || oldChunkElem.getUndoAlternatives().size() != newChunkElem.getUndoAlternatives().size()) continue;
                int oldAlternativeIndex = oldChunkElem.getUndoAlternatives().indexOf(oldChunkElem.getChosenAlternative());
                newChunkElem.setChosenAlternative(newChunkElem.getUndoAlternatives().get(oldAlternativeIndex));
                found = true;
                break;
            }
            if (!found) continue;
        }
    }

    @Override
    public void rectSelectionChanged() {
        this.setChunksTreeViewerInput();
        this.updateBottomPanel();
    }

    private void createBottomArea(Composite parent) {
        this.mBottomSash = new SashForm(parent, 512);
        this.mBottomSash.setSashWidth(10);
        this.createConflictResolutionArea((Composite)this.mBottomSash);
        this.mBottomArea = new Composite((Composite)this.mBottomSash, 0);
        this.mBottomSash.setWeights(new int[]{1, 3});
        this.mBottomStackLayout = new StackLayout();
        this.mBottomArea.setLayout((Layout)this.mBottomStackLayout);
        this.createPreviewPanel(this.mBottomArea);
        this.createInformationPanel(this.mBottomArea);
        this.updateBottomPanel();
    }

    private void createConflictResolutionArea(Composite parent) {
        this.mConflictResolutionPane = new ViewerPane((Composite)this.mBottomSash, 0x800800);
        this.mConflictResolutionPane.setText(ALTERNATIVES_TITLE);
    }

    private void createPreviewPanel(Composite parent) {
        this.mPreviewPane = new CompareViewerSwitchingPane(parent, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                StyledText te;
                Viewer v = CompareUI.findContentViewer((Viewer)oldViewer, (Object)input, (Composite)this, (CompareConfiguration)InteractiveSelectiveUndoDialog.this.mCompareConfiguration);
                v.getControl().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)InteractiveSelectiveUndoDialog.this.mCompareTitle);
                ToolBarManager tbm = CompareViewerSwitchingPane.getToolBarManager((Composite)this);
                ArrayList<IContributionItem> toBeDeleted = new ArrayList<IContributionItem>();
                String[] unwanted = new String[]{"Next Difference", "Previous Difference", "Copy Current Change to Right", "Copy Current Change to Left", "Copy Left to Right", "Copy Right to Left"};
                List<String> unwantedList = Arrays.asList(unwanted);
                IContributionItem[] iContributionItemArray = tbm.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionContributionItem aci;
                    IContributionItem item = iContributionItemArray[n2];
                    if (item instanceof ActionContributionItem && (aci = (ActionContributionItem)item).getAction() != null && unwantedList.contains(aci.getAction().getText())) {
                        toBeDeleted.add(item);
                    }
                    ++n2;
                }
                for (IContributionItem item : toBeDeleted) {
                    tbm.remove(item);
                }
                InteractiveSelectiveUndoDialog.this.mLeftSourceViewer = null;
                SourceViewer rightSourceViewer = null;
                try {
                    Field leftField = InteractiveSelectiveUndoDialog.getField(TextMergeViewer.class, "fLeft");
                    Field rightField = InteractiveSelectiveUndoDialog.getField(TextMergeViewer.class, "fRight");
                    leftField.setAccessible(true);
                    rightField.setAccessible(true);
                    InteractiveSelectiveUndoDialog.this.mLeftSourceViewer = ((MergeSourceViewer)leftField.get(v)).getSourceViewer();
                    rightSourceViewer = ((MergeSourceViewer)rightField.get(v)).getSourceViewer();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (InteractiveSelectiveUndoDialog.this.mLeftSourceViewer != null) {
                    te = InteractiveSelectiveUndoDialog.this.mLeftSourceViewer.getTextWidget();
                    te.setMenu(InteractiveSelectiveUndoDialog.this.mLeftSourceViewerMenuMgr.createContextMenu((Control)te));
                }
                if (rightSourceViewer != null) {
                    te = rightSourceViewer.getTextWidget();
                    te.setMenu(null);
                }
                if (tbm.find(InteractiveSelectiveUndoDialog.KEEP_ACTION_ID) == null) {
                    final KeepSelectedCodeUnchanged keepAction = new KeepSelectedCodeUnchanged("Keep Selection Unchanged", Activator.getImageDescriptor("icons/copycont_r_co.gif"));
                    final ActionContributionItem keepActionContributionItem = new ActionContributionItem((IAction)keepAction);
                    tbm.appendToGroup("merge", (IContributionItem)keepActionContributionItem);
                    if (InteractiveSelectiveUndoDialog.this.mLeftSourceViewer != null) {
                        InteractiveSelectiveUndoDialog.this.mLeftSourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                            public void selectionChanged(SelectionChangedEvent event) {
                                ITextSelection sel = (ITextSelection)event.getSelection();
                                boolean selected = sel != null && sel.getLength() > 0;
                                keepAction.setEnabled(selected);
                                keepActionContributionItem.update();
                            }
                        });
                    }
                }
                return v;
            }
        };
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Class<?> tmpClass = clazz;
        while (true) {
            try {
                Field f = tmpClass.getDeclaredField(fieldName);
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((tmpClass = tmpClass.getSuperclass()) != null) continue;
                throw new RuntimeException("Field '" + fieldName + "' not found on class " + clazz);
            }
            break;
        }
    }

    private void showConflictResolution() {
        this.mBottomSash.setMaximizedControl(null);
        this.mBottomSash.setWeights(new int[]{1, 3});
    }

    private void hideConflictResolution() {
        this.mBottomSash.setMaximizedControl((Control)this.mBottomArea);
    }

    private void showBottomPanel(boolean showConflictResolution, String informationMessage) {
        if (showConflictResolution) {
            this.showConflictResolution();
        } else {
            this.hideConflictResolution();
        }
        if (informationMessage != null) {
            this.mInformationLabel.setText(informationMessage);
            this.mBottomStackLayout.topControl = this.mInformationLabel;
        } else {
            this.mBottomStackLayout.topControl = this.mPreviewPane;
        }
        this.mBottomArea.layout();
    }

    private void createInformationPanel(Composite parent) {
        this.mInformationLabel = new Label(parent, 0x800800);
    }

    private void showPreviewPanel(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException();
        }
        try {
            IDocument doc = this.findDocumentForChunk(chunk);
            String originalContents = doc.get(chunk.getStartOffset(), chunk.getChunkLength());
            String undoResult = SelectiveUndoEngine.getInstance().doSelectiveUndoChunkWithoutConflicts(chunk, originalContents);
            this.mCompareTitle = this.getLabelForChunk(chunk, doc);
            this.setPreviewInput(doc, undoResult, chunk.getStartOffset(), chunk.getChunkLength());
            this.showBottomPanel(false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = GENERATING_PREVIEW_ERROR_MSG;
            this.showBottomPanel(false, msg);
        }
    }

    private void setPreviewInput(IDocument doc, String undoResult, int start, int length) throws BadLocationException {
        Document originalDoc = new Document(doc.get());
        Document resultDoc = new Document(originalDoc.get());
        resultDoc.replace(start, length, undoResult);
        this.setupDocumentForJava(originalDoc);
        this.setupDocumentForJava(resultDoc);
        int startLine = originalDoc.getLineOfOffset(start);
        int endLine = originalDoc.getLineOfOffset(start + length);
        int contextStartLine = Math.max(startLine - 3, 0);
        int contextEndLine = Math.min(endLine + 3, originalDoc.getNumberOfLines() - 1);
        int contextStartOffset = originalDoc.getLineOffset(contextStartLine);
        int contextEndOffset = originalDoc.getLineOffset(contextEndLine) + originalDoc.getLineLength(contextEndLine);
        int beforeContextLength = start - contextStartOffset;
        int afterContextLength = contextEndOffset - (start + length);
        DocumentRangeCompareItem leftItem = new DocumentRangeCompareItem("Current Source", (IDocument)originalDoc, contextStartOffset, beforeContextLength + length + afterContextLength, false);
        DocumentRangeCompareItem rightItem = new DocumentRangeCompareItem("Preview of Selective Undo Result", (IDocument)resultDoc, contextStartOffset, beforeContextLength + undoResult.length() + afterContextLength, false);
        AzuriteCompareInput compareInput = new AzuriteCompareInput(leftItem, rightItem);
        this.mPreviewPane.setInput((Object)compareInput);
    }

    private void setupDocumentForJava(Document resultDoc) {
        IDocumentPartitioner partitioner = JavaPlugin.getDefault().getJavaTextTools().createDocumentPartitioner();
        resultDoc.setDocumentPartitioner("___java_partitioning", partitioner);
        partitioner.connect((IDocument)resultDoc);
    }

    private void showPreviewPanel(TopLevelElement topElem) {
        if (topElem == null) {
            throw new IllegalArgumentException();
        }
        try {
            FileKey fileKey = topElem.getFileKey();
            IDocument doc = Utilities.findDocumentForKey(fileKey);
            String originalContents = doc.get();
            Document docResult = new Document(originalContents);
            SelectiveUndoEngine.getInstance().doSelectiveUndoWithChunks(topElem.getChunks(), (IDocument)docResult, topElem.getAlternativeChoiceMap());
            String undoResult = docResult.get();
            this.mCompareTitle = fileKey.getFileNameOnly();
            this.setPreviewInput(doc, undoResult, 0, doc.get().length());
            this.showBottomPanel(false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = GENERATING_PREVIEW_ERROR_MSG;
            this.showBottomPanel(false, msg);
        }
    }

    public String getLabelForChunk(Chunk chunk, IDocument doc) {
        try {
            int startLine = doc.getLineOfOffset(chunk.getStartOffset());
            int endLine = doc.getLineOfOffset(chunk.getEndOffset());
            if (startLine == endLine) {
                return String.valueOf(chunk.getBelongsTo().getFileNameOnly()) + ": line " + startLine;
            }
            return String.valueOf(chunk.getBelongsTo().getFileNameOnly()) + ": lines " + startLine + "-" + endLine;
        }
        catch (Exception exception) {
            return chunk.getBelongsTo().getFileNameOnly();
        }
    }

    public IDocument findDocumentForChunk(Chunk chunk) {
        return Utilities.findDocumentForKey(chunk.getBelongsTo());
    }

    private void showConflictResolutionPanel(final ChunkLevelElement chunkElem) {
        this.clearConflictResolutionArea();
        this.mConflictResolutionArea = new Composite((Composite)this.mConflictResolutionPane, 0);
        this.mConflictResolutionArea.setLayout((Layout)new FillLayout());
        this.mConflictResolutionPane.setContent((Control)this.mConflictResolutionArea);
        for (final UndoAlternative alternative : chunkElem.getUndoAlternatives()) {
            AlternativeButton buttonAlternative = new AlternativeButton(this.mConflictResolutionArea, 16);
            buttonAlternative.setAlternativeCode(alternative.getResultingCode());
            buttonAlternative.setToolTipText(alternative.getDescription());
            if (chunkElem.getChosenAlternative() == alternative) {
                buttonAlternative.setSelected(true);
                this.showPreviewForConflictResolution(chunkElem);
            }
            buttonAlternative.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    chunkElem.setChosenAlternative(alternative);
                    InteractiveSelectiveUndoDialog.this.mChunksTreeViewer.update(chunkElem, null);
                    InteractiveSelectiveUndoDialog.this.mChunksTreeViewer.update(chunkElem.getParent(), null);
                    InteractiveSelectiveUndoDialog.this.showPreviewForConflictResolution(chunkElem);
                    InteractiveSelectiveUndoDialog.this.updateOKButtonEnabled();
                }
            });
        }
        this.mConflictResolutionArea.layout(true);
        if (chunkElem.getChosenAlternative() == null) {
            String msg = "Please select one of the alternatives to resolve this conflict.";
            this.showBottomPanel(true, msg);
        } else {
            this.showBottomPanel(true, null);
        }
    }

    private void updateOKButtonEnabled() {
        block4: {
            Button okButton = null;
            try {
                okButton = this.getButton(0);
                boolean enabled = true;
                TopLevelElement[] topLevelElementArray = (TopLevelElement[])this.mChunksTreeViewer.getInput();
                int n = topLevelElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TopLevelElement topElem = topLevelElementArray[n2];
                    if (topElem.hasUnresolvedConflict()) {
                        enabled = false;
                        break;
                    }
                    ++n2;
                }
                okButton.setEnabled(enabled);
            }
            catch (Exception exception) {
                if (okButton == null) break block4;
                okButton.setEnabled(false);
            }
        }
    }

    private void showPreviewForConflictResolution(ChunkLevelElement chunkElem) {
        try {
            Chunk chunk = chunkElem.getChunk();
            IDocument doc = this.findDocumentForChunk(chunk);
            Chunk expandedChunk = chunk.getExpandedChunkWithDepth(2);
            String undoResult = chunkElem.getChosenAlternative().getResultingCode();
            this.mCompareTitle = this.getLabelForChunk(expandedChunk, doc);
            this.setPreviewInput(doc, undoResult, expandedChunk.getStartOffset(), expandedChunk.getChunkLength());
            this.showBottomPanel(true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = GENERATING_PREVIEW_ERROR_MSG;
            this.showBottomPanel(true, msg);
        }
    }

    public void clearConflictResolutionArea() {
        if (this.mConflictResolutionArea != null) {
            this.mConflictResolutionArea.dispose();
            this.mConflictResolutionArea = null;
            this.mConflictResolutionPane.layout(true);
        }
    }

    public void updateBottomPanel() {
        this.updateBottomPanel((IStructuredSelection)this.mChunksTreeViewer.getSelection());
    }

    public void updateBottomPanel(IStructuredSelection sel) {
        if (sel.size() == 1) {
            Object firstElement = sel.getFirstElement();
            if (firstElement instanceof ChunkLevelElement) {
                ChunkLevelElement chunkElem = (ChunkLevelElement)firstElement;
                Chunk chunk = chunkElem.getChunk();
                if (chunk.hasConflictOutsideThisChunk() && chunkElem.getUndoAlternatives().size() > 1) {
                    this.showConflictResolutionPanel(chunkElem);
                } else {
                    this.showPreviewPanel(chunk);
                }
            } else if (firstElement instanceof TopLevelElement) {
                TopLevelElement topElem = (TopLevelElement)firstElement;
                if (topElem.hasUnresolvedConflict()) {
                    String msg = "You must resolve all the conflicts under this file to be able to see the entire preview.";
                    this.showBottomPanel(false, msg);
                } else {
                    this.showPreviewPanel(topElem);
                }
            }
        } else {
            TopLevelElement[] input = (TopLevelElement[])this.mChunksTreeViewer.getInput();
            boolean chunksEmpty = input == null || input.length == 0;
            String msg = chunksEmpty ? INFORMATION_SELECT_RECTS : INFORMATION_SELECT_CHUNK;
            this.showBottomPanel(false, msg);
        }
    }

    private boolean areSameChunks(Chunk lhs, Chunk rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (!lhs.getBelongsTo().equals(rhs.getBelongsTo())) {
            return false;
        }
        if (lhs.size() != rhs.size()) {
            return false;
        }
        int i = 0;
        while (i < lhs.size()) {
            if (lhs.get(i) != rhs.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class ChunkLevelElement {
        private Chunk mChunk;
        private List<UndoAlternative> mAlternatives;
        private UndoAlternative mChosenAlternative;
        private TopLevelElement mParent;

        public ChunkLevelElement(Chunk chunk, TopLevelElement parent) {
            if (chunk == null || parent == null) {
                throw new IllegalArgumentException();
            }
            this.mChunk = chunk;
            this.mParent = parent;
            this.calculateUndoAlternatives();
        }

        private void calculateUndoAlternatives() {
            if (this.getChunk().hasConflictOutsideThisChunk()) {
                try {
                    IDocument doc = InteractiveSelectiveUndoDialog.this.findDocumentForChunk(this.getChunk());
                    Chunk expandedChunk = this.getChunk().getExpandedChunkWithDepth(2);
                    int initialOffset = expandedChunk.getStartOffset();
                    String initialContent = doc.get(initialOffset, expandedChunk.getChunkLength());
                    this.mAlternatives = SelectiveUndoEngine.getInstance().doSelectiveUndoChunkWithConflicts(this.getChunk(), initialContent);
                    this.mChosenAlternative = this.mAlternatives.size() == 1 ? this.mAlternatives.get(0) : null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public Chunk getChunk() {
            return this.mChunk;
        }

        public TopLevelElement getParent() {
            return this.mParent;
        }

        public boolean hasUnresolvedConflict() {
            return this.mChunk.hasConflictOutsideThisChunk() && this.mChosenAlternative == null;
        }

        public List<UndoAlternative> getUndoAlternatives() {
            return this.mAlternatives;
        }

        public UndoAlternative getChosenAlternative() {
            return this.mChosenAlternative;
        }

        public void setChosenAlternative(UndoAlternative chosenAlternative) {
            this.mChosenAlternative = chosenAlternative;
        }
    }

    private class ChunksContentProvider
    implements ITreeContentProvider {
        private ChunksContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            TopLevelElement topElem;
            if (InteractiveSelectiveUndoDialog.this.mShowChunks) {
                if (parentElement instanceof TopLevelElement) {
                    TopLevelElement topElem2 = (TopLevelElement)parentElement;
                    return topElem2.getChunkElements().toArray();
                }
            } else if (parentElement instanceof TopLevelElement && (topElem = (TopLevelElement)parentElement).hasUnresolvedConflict()) {
                ArrayList<ChunkLevelElement> unresolvedChunks = new ArrayList<ChunkLevelElement>();
                for (ChunkLevelElement chunkElem : topElem.getChunkElements()) {
                    if (!chunkElem.hasUnresolvedConflict()) continue;
                    unresolvedChunks.add(chunkElem);
                }
                return unresolvedChunks.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ChunkLevelElement) {
                ChunkLevelElement chunkElem = (ChunkLevelElement)element;
                return chunkElem.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TopLevelElement) {
                TopLevelElement topElem = (TopLevelElement)element;
                return !topElem.getChunkElements().isEmpty();
            }
            return false;
        }
    }

    private class ChunksLabelProvider
    extends LabelProvider {
        private Map<ImageDescriptor, Image> mImages = new HashMap<ImageDescriptor, Image>();

        public Image getImage(Object element) {
            if (element instanceof TopLevelElement) {
                TopLevelElement topElem = (TopLevelElement)element;
                FileKey fileKey = topElem.getFileKey();
                ImageDescriptor baseImageDesc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileKey.getFileNameOnly());
                Image baseImage = this.getImage(baseImageDesc);
                if (topElem.hasUnresolvedConflict()) {
                    ImageDescriptor decError = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
                    DecorationOverlayIcon decorated = new DecorationOverlayIcon(baseImage, decError, 3);
                    return this.getImage((ImageDescriptor)decorated);
                }
                return baseImage;
            }
            if (element instanceof ChunkLevelElement) {
                ChunkLevelElement chunkElem = (ChunkLevelElement)element;
                ImageDescriptor errorImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK");
                ImageDescriptor resolvedImage = Activator.getImageDescriptor("icons/tick.png");
                return chunkElem.hasUnresolvedConflict() ? this.getImage(errorImage) : (chunkElem.getChunk().hasConflictOutsideThisChunk() && chunkElem.getUndoAlternatives().size() > 1 ? this.getImage(resolvedImage) : null);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TopLevelElement) {
                TopLevelElement topElem = (TopLevelElement)element;
                return topElem.getFileKey().getFileNameOnly();
            }
            if (element instanceof ChunkLevelElement) {
                ChunkLevelElement chunkElem = (ChunkLevelElement)element;
                Chunk chunk = chunkElem.getChunk();
                IDocument doc = InteractiveSelectiveUndoDialog.this.findDocumentForChunk(chunk);
                String label = InteractiveSelectiveUndoDialog.this.getLabelForChunk(chunk, doc);
                if (chunkElem.getChunk().hasConflictOutsideThisChunk() && chunkElem.getUndoAlternatives().size() == 1) {
                    label = String.valueOf(label) + " [no effect]";
                }
                return label;
            }
            return super.getText(element);
        }

        public void dispose() {
            super.dispose();
            for (Image image : this.mImages.values()) {
                image.dispose();
            }
        }

        private Image getImage(ImageDescriptor imgDesc) {
            if (!this.mImages.containsKey(imgDesc)) {
                Image image = imgDesc.createImage();
                this.mImages.put(imgDesc, image);
            }
            return this.mImages.get(imgDesc);
        }
    }

    private class ChunksTreeViewer
    extends TreeViewer {
        public ChunksTreeViewer(Composite parent) {
            super(parent);
        }

        public ChunksTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public ChunksTreeViewer(Tree tree) {
            super(tree);
        }

        public void revealNext() {
            this.revealElement(true);
        }

        public void revealPrevious() {
            this.revealElement(false);
        }

        private void revealElement(boolean next) {
            TopLevelElement[] topElements = (TopLevelElement[])this.getInput();
            topElements = Arrays.copyOf(topElements, topElements.length);
            Arrays.sort(topElements, new Comparator<TopLevelElement>(){

                @Override
                public int compare(TopLevelElement lhs, TopLevelElement rhs) {
                    return ChunksTreeViewer.this.getComparator().compare((Viewer)ChunksTreeViewer.this, (Object)lhs, (Object)rhs);
                }
            });
            Object current = null;
            Object candidate = null;
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            if (!selection.isEmpty()) {
                current = selection.iterator().next();
            }
            candidate = current instanceof TopLevelElement ? this.getCandidateFromTopLevelElement(current, next, topElements) : (current instanceof ChunkLevelElement ? this.getCandidateFromChunkLevelElement(current, next, topElements) : (topElements.length > 0 ? (next ? topElements[0] : topElements[topElements.length - 1]) : null));
            if (candidate != null) {
                this.setSelection((ISelection)new StructuredSelection(candidate), true);
            } else {
                this.getControl().getDisplay().beep();
            }
        }

        private Object getCandidateFromChunkLevelElement(ChunkLevelElement chunkElem, boolean next, TopLevelElement[] topElements) {
            TopLevelElement parentElem = chunkElem.getParent();
            int curChunkIndex = parentElem.getChunkElements().indexOf(chunkElem);
            int curParentIndex = Arrays.asList(topElements).indexOf(parentElem);
            Object candidate = next ? (curChunkIndex < parentElem.getChunkElements().size() - 1 ? parentElem.getChunkElements().get(curChunkIndex + 1) : (curParentIndex < topElements.length - 1 ? topElements[curParentIndex + 1] : null)) : (curChunkIndex > 0 ? parentElem.getChunkElements().get(curChunkIndex - 1) : parentElem);
            return candidate;
        }

        private Object getCandidateFromTopLevelElement(TopLevelElement topElem, boolean next, TopLevelElement[] topElements) {
            Object candidate;
            int curIndex = Arrays.asList(topElements).indexOf(topElem);
            if (next) {
                candidate = InteractiveSelectiveUndoDialog.this.mShowChunks ? topElem.getChunkElements().get(0) : (curIndex < topElements.length - 1 ? topElements[curIndex + 1] : null);
            } else if (InteractiveSelectiveUndoDialog.this.mShowChunks) {
                if (curIndex > 0) {
                    TopLevelElement prevTopElem = topElements[curIndex - 1];
                    candidate = prevTopElem.getChunkElements().get(prevTopElem.getChunkElements().size() - 1);
                } else {
                    candidate = null;
                }
            } else {
                candidate = curIndex > 0 ? topElements[curIndex - 1] : null;
            }
            return candidate;
        }
    }

    private class KeepSelectedCodeUnchanged
    extends Action {
        private KeepSelectedCodeUnchanged(String text) {
            super(text);
            super.setId(InteractiveSelectiveUndoDialog.KEEP_ACTION_ID);
        }

        private KeepSelectedCodeUnchanged(String text, ImageDescriptor image) {
            super(text, image);
            super.setId(InteractiveSelectiveUndoDialog.KEEP_ACTION_ID);
        }

        public void run() {
            try {
                ITextSelection sel = (ITextSelection)InteractiveSelectiveUndoDialog.this.mLeftSourceViewer.getSelection();
                IStructuredSelection treeSelection = (IStructuredSelection)InteractiveSelectiveUndoDialog.this.mChunksTreeViewer.getSelection();
                Object treeSelElem = treeSelection.getFirstElement();
                FileKey key = null;
                if (treeSelElem instanceof TopLevelElement) {
                    key = ((TopLevelElement)treeSelElem).getFileKey();
                } else if (treeSelElem instanceof ChunkLevelElement) {
                    key = ((ChunkLevelElement)treeSelElem).getParent().getFileKey();
                }
                List<RuntimeDC> runtimeDCs = RuntimeHistoryManager.getInstance().filterDocumentChangesByRegionInclusive(key, sel.getOffset(), sel.getOffset() + sel.getLength());
                List<OperationId> ids = OperationId.getOperationIdsFromRuntimeDCs(runtimeDCs);
                TimelineViewPart timeline = TimelineViewPart.getInstance();
                if (timeline != null) {
                    timeline.removeSelection(ids);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class NextChunk
    extends Action {
        public NextChunk() {
            this.setId(InteractiveSelectiveUndoDialog.NEXT_CHANGE_ID);
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(InteractiveSelectiveUndoDialog.NEXT_CHANGE_TOOLTOP);
        }

        public void run() {
            InteractiveSelectiveUndoDialog.this.mChunksTreeViewer.revealNext();
        }
    }

    private class PreviousChunk
    extends Action {
        public PreviousChunk() {
            this.setId(InteractiveSelectiveUndoDialog.PREVIOUS_CHANGE_ID);
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(InteractiveSelectiveUndoDialog.PREVIOUS_CHANGE_TOOLTIP);
        }

        public void run() {
            InteractiveSelectiveUndoDialog.this.mChunksTreeViewer.revealPrevious();
        }
    }

    private class TopLevelElement {
        private FileKey mFileKey;
        private List<ChunkLevelElement> mChunkElements;

        public TopLevelElement(FileKey fileKey, List<Chunk> chunks) {
            if (fileKey == null || chunks == null) {
                throw new IllegalArgumentException();
            }
            this.mFileKey = fileKey;
            this.mChunkElements = new ArrayList<ChunkLevelElement>();
            for (Chunk chunk : chunks) {
                this.mChunkElements.add(new ChunkLevelElement(chunk, this));
            }
        }

        public FileKey getFileKey() {
            return this.mFileKey;
        }

        public List<ChunkLevelElement> getChunkElements() {
            return Collections.unmodifiableList(this.mChunkElements);
        }

        public List<Chunk> getChunks() {
            ArrayList<Chunk> result = new ArrayList<Chunk>();
            for (ChunkLevelElement chunkElem : this.getChunkElements()) {
                result.add(chunkElem.getChunk());
            }
            return result;
        }

        public Map<Chunk, UndoAlternative> getAlternativeChoiceMap() {
            List<ChunkLevelElement> chunkElems = this.getChunkElements();
            HashMap<Chunk, UndoAlternative> chosenAlternatives = new HashMap<Chunk, UndoAlternative>();
            for (ChunkLevelElement chunkElem : chunkElems) {
                Chunk chunk = chunkElem.getChunk();
                if (!chunk.hasConflictOutsideThisChunk()) continue;
                chosenAlternatives.put(chunk, chunkElem.getChosenAlternative());
            }
            return chosenAlternatives;
        }

        public SelectiveUndoParams getSelectiveUndoParams() {
            return new SelectiveUndoParams(this.getChunks(), Utilities.findDocumentForKey(this.getFileKey()), this.getAlternativeChoiceMap());
        }

        public boolean hasUnresolvedConflict() {
            for (ChunkLevelElement chunkElem : this.mChunkElements) {
                if (!chunkElem.hasUnresolvedConflict()) continue;
                return true;
            }
            return false;
        }
    }

    private final class TreeViewerMenuListener
    implements IMenuListener {
        private TreeViewerMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            IStructuredSelection treeSel = (IStructuredSelection)InteractiveSelectiveUndoDialog.this.mChunksTreeViewer.getSelection();
            if (treeSel != null && treeSel.size() > 0) {
                final Object selElem = treeSel.getFirstElement();
                if (selElem instanceof TopLevelElement) {
                    manager.add((IAction)new Action("Remove this file from the selection (Keep it unchanged)"){

                        public void run() {
                            TopLevelElement topElem = (TopLevelElement)selElem;
                            ArrayList<RuntimeDC> runtimeDCs = new ArrayList<RuntimeDC>();
                            for (Chunk chunk : topElem.getChunks()) {
                                runtimeDCs.addAll(chunk.getInvolvedChanges());
                            }
                            List<OperationId> ids = OperationId.getOperationIdsFromRuntimeDCs(runtimeDCs);
                            TimelineViewPart timeline = TimelineViewPart.getInstance();
                            if (timeline != null) {
                                timeline.removeSelection(ids);
                            }
                        }
                    });
                } else if (selElem instanceof ChunkLevelElement) {
                    manager.add((IAction)new Action("Remove this chunk from the selection (Keep it unchanged)"){

                        public void run() {
                            ChunkLevelElement chunkElem = (ChunkLevelElement)selElem;
                            List<RuntimeDC> runtimeDCs = chunkElem.getChunk().getInvolvedChanges();
                            List<OperationId> ids = OperationId.getOperationIdsFromRuntimeDCs(runtimeDCs);
                            TimelineViewPart timeline = TimelineViewPart.getInstance();
                            if (timeline != null) {
                                timeline.removeSelection(ids);
                            }
                        }
                    });
                }
            }
        }
    }
}

