/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.commands.runtime;

import edu.cmu.scs.azurite.commands.runtime.EditComponent;
import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.commands.runtime.RuntimeDelete;
import edu.cmu.scs.azurite.commands.runtime.RuntimeInsert;
import edu.cmu.scs.azurite.commands.runtime.RuntimeReplace;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class InsertComponent
implements EditComponent {
    private LinkedList<Segment> mInsertSegments;

    @Override
    public void initialize(Segment initialSegment) {
        this.mInsertSegments = new LinkedList();
        this.mInsertSegments.addLast(initialSegment);
    }

    @Override
    public boolean applyInsert(RuntimeInsert insert) {
        List<Segment> insertSegments = insert.getInsertSegments();
        if (insertSegments.size() != 1) {
            throw new IllegalArgumentException("A new insert object must have exactly one insertion segment.");
        }
        Segment insertSegment = insertSegments.get(0);
        Segment dummyDelete = new Segment(insertSegment.getOffset(), 0, "", insertSegment.getBelongsTo(), insertSegment.getOwner(), true);
        return this.applyHelper(dummyDelete, insertSegment, insert);
    }

    @Override
    public boolean applyDelete(RuntimeDelete delete) {
        Segment deleteSegment = delete.getDeleteSegment();
        Segment dummyInsert = new Segment(deleteSegment.getOffset(), 0, "", deleteSegment.getBelongsTo(), deleteSegment.getOwner(), false);
        return this.applyHelper(deleteSegment, dummyInsert, delete);
    }

    @Override
    public boolean applyReplace(RuntimeReplace replace) {
        List<Segment> insertSegments = replace.getInsertSegments();
        if (insertSegments.size() != 1) {
            throw new IllegalArgumentException("A new replace object must have exactly one insertion segment.");
        }
        return this.applyHelper(replace.getDeleteSegment(), insertSegments.get(0), replace);
    }

    private boolean applyHelper(Segment deleteSegment, Segment insertSegment, RuntimeDC docChange) {
        int lengthDiff = insertSegment.getLength() - deleteSegment.getLength();
        ListIterator<Segment> it = this.mInsertSegments.listIterator();
        boolean conflict = false;
        boolean dummyDelete = deleteSegment.getLength() == 0;
        while (it.hasNext()) {
            Segment segmentToBeAdded;
            Segment segment = (Segment)it.next();
            if (deleteSegment.getEndOffset() <= segment.getOffset()) {
                segment.incrementOffset(lengthDiff);
                while (it.hasNext()) {
                    ((Segment)it.next()).incrementOffset(lengthDiff);
                }
                continue;
            }
            if (deleteSegment.getOffset() <= segment.getOffset() && segment.getOffset() < deleteSegment.getEndOffset() && deleteSegment.getEndOffset() < segment.getEndOffset()) {
                segmentToBeAdded = segment.subSegment(deleteSegment.getEndOffset(), segment.getEndOffset() - deleteSegment.getEndOffset());
                segmentToBeAdded.incrementOffset(lengthDiff);
                it.add(segmentToBeAdded);
                segment.cutDown(deleteSegment.getEndOffset());
                deleteSegment.closeSegment(segment);
                while (it.hasNext()) {
                    ((Segment)it.next()).incrementOffset(lengthDiff);
                }
                conflict = true;
                continue;
            }
            if (deleteSegment.getOffset() <= segment.getOffset() && segment.getEndOffset() <= deleteSegment.getEndOffset()) {
                deleteSegment.closeSegment(segment);
                conflict = true;
                continue;
            }
            if (segment.getOffset() < deleteSegment.getOffset() && deleteSegment.getEndOffset() < segment.getEndOffset()) {
                if (!dummyDelete) {
                    Segment segmentInTheMiddle = segment.subSegment(deleteSegment.getOffset(), deleteSegment.getLength());
                    deleteSegment.closeSegment(segmentInTheMiddle);
                    it.add(segmentInTheMiddle);
                }
                Segment segmentAtTheEnd = segment.subSegment(deleteSegment.getEndOffset());
                segmentAtTheEnd.incrementOffset(lengthDiff);
                it.add(segmentAtTheEnd);
                segment.cutDown(deleteSegment.getOffset());
                while (it.hasNext()) {
                    ((Segment)it.next()).incrementOffset(lengthDiff);
                }
                conflict = true;
                continue;
            }
            if (segment.getOffset() < deleteSegment.getOffset() && deleteSegment.getOffset() < segment.getEndOffset() && segment.getEndOffset() <= deleteSegment.getEndOffset()) {
                segmentToBeAdded = segment.subSegment(deleteSegment.getOffset());
                deleteSegment.closeSegment(segmentToBeAdded);
                it.add(segmentToBeAdded);
                segment.cutDown(deleteSegment.getOffset());
                conflict = true;
                continue;
            }
            if (segment.getEndOffset() <= deleteSegment.getOffset()) continue;
            throw new IllegalStateException();
        }
        return conflict;
    }

    public List<Segment> getInsertSegments() {
        return this.mInsertSegments;
    }
}

