/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.commands.runtime;

import edu.cmu.scs.azurite.commands.runtime.DeleteComponent;
import edu.cmu.scs.azurite.commands.runtime.InsertComponent;
import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.commands.runtime.RuntimeDelete;
import edu.cmu.scs.azurite.commands.runtime.RuntimeInsert;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Replace;
import java.util.ArrayList;
import java.util.List;

public class RuntimeReplace
extends RuntimeDC {
    private DeleteComponent mDeleteComponent = new DeleteComponent();
    private InsertComponent mInsertComponent = new InsertComponent();

    public RuntimeReplace() {
        this(new Replace(0, 0, 0, 0, 0, "", "", null));
    }

    public RuntimeReplace(Replace replace) {
        super((DocChange)replace);
        this.getDeleteComponent().initialize(Segment.createInitialDeleteSegmentFromReplace(this.getOriginal(), this));
        this.getInsertComponent().initialize(Segment.createInitialInsertSegmentFromReplace(this.getOriginal(), this));
    }

    public Replace getOriginal() {
        return (Replace)super.getOriginal();
    }

    @Override
    public void applyInsert(RuntimeInsert insert) {
        boolean conflict = false;
        conflict |= this.getDeleteComponent().applyInsert(insert);
        if (conflict |= this.getInsertComponent().applyInsert(insert)) {
            this.addConflict(insert);
        }
    }

    @Override
    public void applyDelete(RuntimeDelete delete) {
        boolean conflict = false;
        conflict |= this.getDeleteComponent().applyDelete(delete);
        if (conflict |= this.getInsertComponent().applyDelete(delete)) {
            this.addConflict(delete);
        }
    }

    @Override
    public void applyReplace(RuntimeReplace replace) {
        boolean conflict = false;
        conflict |= this.getDeleteComponent().applyReplace(replace);
        if (conflict |= this.getInsertComponent().applyReplace(replace)) {
            this.addConflict(replace);
        }
    }

    @Override
    public void applyTo(RuntimeDC docChange) {
        docChange.applyReplace(this);
    }

    public Segment getDeleteSegment() {
        return this.getDeleteComponent().getDeleteSegment();
    }

    public List<Segment> getInsertSegments() {
        return this.getInsertComponent().getInsertSegments();
    }

    private DeleteComponent getDeleteComponent() {
        return this.mDeleteComponent;
    }

    private InsertComponent getInsertComponent() {
        return this.mInsertComponent;
    }

    @Override
    public List<Segment> getAllSegments() {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        segments.add(this.getDeleteSegment());
        segments.addAll(this.getInsertSegments());
        return segments;
    }

    @Override
    public int getTypeIndex() {
        return 2;
    }

    public String toString() {
        return "[Replace:" + this.getOriginal().getCommandIndex() + "] \"" + this.getOriginal().getDeletedText() + "\" -> \"" + this.getOriginal().getInsertedText() + "\"";
    }

    @Override
    public String getHtmlInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("----------\n");
        builder.append(this.transformToHtmlString(this.getOriginal().getDeletedText()));
        builder.append("\n----------");
        builder.append("\n++++++++++\n");
        builder.append(this.transformToHtmlString(this.getOriginal().getInsertedText()));
        builder.append("\n++++++++++");
        return builder.toString().replace("\n", "<br>");
    }

    @Override
    public String getTypeString() {
        return "replace";
    }

    @Override
    public String getMarkerMessage() {
        return "Replaced code: \"" + this.getOriginal().getDeletedText() + "\" -> \"" + this.getOriginal().getInsertedText() + "\"";
    }
}

