/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HistorySearchCommand
extends AbstractCommand {
    private static final String SEARCH_TEXT_TAG = "searchText";
    private static final String CASE_SENSITIVE_ATTR = "caseSensitive";
    private static final String SELECTED_CODE_ATTR = "selectedCode";
    private static final String CURRENT_SESSION_ATTR = "currentSession";
    private String mSearchText;
    private boolean mCaseSensitive;
    private boolean mSelectedCode;
    private boolean mCurrentSession;

    public HistorySearchCommand() {
    }

    public HistorySearchCommand(String searchText, boolean caseSensitive, boolean selectedCode, boolean currentSession) {
        this.mSearchText = searchText;
        this.mCaseSensitive = caseSensitive;
        this.mSelectedCode = selectedCode;
        this.mCurrentSession = currentSession;
    }

    public void createFrom(Element commandElement) {
        Node textNode;
        super.createFrom(commandElement);
        Attr attr = null;
        String value = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode(CASE_SENSITIVE_ATTR);
        if (attr != null) {
            this.mCaseSensitive = Boolean.parseBoolean(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(SELECTED_CODE_ATTR)) != null) {
            this.mSelectedCode = Boolean.parseBoolean(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(CURRENT_SESSION_ATTR)) != null) {
            this.mCurrentSession = Boolean.parseBoolean(attr.getValue());
        }
        this.mSearchText = (nodeList = commandElement.getElementsByTagName(SEARCH_TEXT_TAG)).getLength() > 0 ? ((value = (textNode = nodeList.item(0)).getTextContent()).equals("null") ? null : value) : null;
    }

    public boolean execute(IEditorPart target) {
        return false;
    }

    public void dump() {
    }

    public Map<String, String> getAttributesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(CASE_SENSITIVE_ATTR, Boolean.toString(this.mCaseSensitive));
        result.put(SELECTED_CODE_ATTR, Boolean.toString(this.mSelectedCode));
        result.put(CURRENT_SESSION_ATTR, Boolean.toString(this.mCurrentSession));
        return result;
    }

    public Map<String, String> getDataMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(SEARCH_TEXT_TAG, this.mSearchText);
        return result;
    }

    public String getCommandType() {
        return "HistorySearchCommand";
    }

    public String getName() {
        return "HistorySearch";
    }

    public String getDescription() {
        return null;
    }

    public String getCategory() {
        return "EventLogger utility command";
    }

    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    public boolean combine(ICommand anotherCommand) {
        return false;
    }
}

