/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.views;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.util.Utilities;
import edu.cmu.scs.azurite.views.RectSelectionListener;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;

public class RectMarkerManager
implements RectSelectionListener {
    private static final String BASE_MARKER_ID = "edu.cmu.scs.azurite.baseMarker";
    private Map<OperationId, List<IMarker>> currentMarkers = new HashMap<OperationId, List<IMarker>>();

    @Override
    public void rectSelectionChanged() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (!store.getBoolean("Azurite_EnableMarkers")) {
            return;
        }
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            List<OperationId> ids = TimelineViewPart.getInstance().getRectSelection();
            Iterator<OperationId> it = this.currentMarkers.keySet().iterator();
            while (it.hasNext()) {
                OperationId oid = it.next();
                if (ids.contains(oid)) continue;
                for (IMarker marker : this.currentMarkers.get(oid)) {
                    marker.delete();
                }
                it.remove();
            }
            ArrayList<OperationId> newIds = new ArrayList<OperationId>();
            for (OperationId oid : ids) {
                if (this.currentMarkers.containsKey(oid)) continue;
                newIds.add(oid);
            }
            Map<FileKey, List<RuntimeDC>> fileDCMap = RuntimeHistoryManager.getInstance().extractFileDCMapFromOperationIds(newIds);
            for (FileKey fileKey : fileDCMap.keySet()) {
                IDocument doc;
                IFile fileResource = root.getFileForLocation((IPath)new Path(fileKey.getFilePath()));
                if (fileResource == null || (doc = Utilities.findDocumentForKey(fileKey)) == null) continue;
                for (RuntimeDC dc : fileDCMap.get(fileKey)) {
                    ArrayList<IMarker> markers = new ArrayList<IMarker>();
                    this.currentMarkers.put(dc.getOperationId(), markers);
                    for (Segment segment : dc.getAllSegments()) {
                        IMarker marker = fileResource.createMarker("edu.cmu.scs.azurite." + dc.getTypeString() + "Marker");
                        marker.setAttribute("severity", 0);
                        marker.setAttribute("message", (Object)dc.getMarkerMessage());
                        marker.setAttribute("lineNumber", doc.getLineOfOffset(segment.getOffset()));
                        marker.setAttribute("charStart", segment.getOffset());
                        marker.setAttribute("charEnd", segment.getEffectiveEndOffset());
                        markers.add(marker);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAllMarkers() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            root.deleteMarkers(BASE_MARKER_ID, true, 2);
            this.currentMarkers.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

