/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.views;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.compare.AzuriteCompareLabelProvider;
import edu.cmu.scs.azurite.jface.viewers.CodeHistoryDiffViewer;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class CodeHistoryDiffViewPart
extends ViewPart {
    private static final int MAX_VIEWS = 10;
    private static final Deque<Integer> availableViewerIds = new LinkedList<Integer>();
    private static Map<Integer, CodeHistoryDiffViewPart> mes;
    private int viewerId = -1;
    private CodeHistoryDiffViewer viewer;
    private CompareConfiguration mConfiguration;

    static {
        int i = 0;
        while (i < 10) {
            availableViewerIds.addLast(i);
            ++i;
        }
        mes = new HashMap<Integer, CodeHistoryDiffViewPart>();
    }

    public static Collection<CodeHistoryDiffViewPart> getInstances() {
        return Collections.unmodifiableCollection(mes.values());
    }

    public static Integer getNextViewerId() {
        return availableViewerIds.peekFirst();
    }

    public void createPartControl(Composite parent) {
        this.viewerId = CodeHistoryDiffViewPart.getNextViewerId();
        mes.put(this.viewerId, this);
        availableViewerIds.removeFirst();
        this.viewer = new CodeHistoryDiffViewer(parent, 0);
        this.mConfiguration = this.createConfiguration();
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void dispose() {
        mes.remove(this.viewerId);
        availableViewerIds.addLast(this.viewerId);
        if (mes.isEmpty()) {
            this.hideMarker();
        }
        super.dispose();
    }

    private void hideMarker() {
        if (TimelineViewPart.getInstance() != null) {
            TimelineViewPart.getInstance().hideMarker();
        }
    }

    private CompareConfiguration createConfiguration() {
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setDefaultLabelProvider((ICompareInputLabelProvider)new AzuriteCompareLabelProvider());
        return configuration;
    }

    public void addCodeHistoryDiffViewer(String fileName, String fileContent, int selectionStart, int selectionEnd, List<RuntimeDC> involvedDCs, FileKey key) {
        this.addCodeHistoryDiffViewer(fileName, fileContent, selectionStart, selectionEnd, involvedDCs, -1, -1, key);
    }

    public void addCodeHistoryDiffViewer(String fileName, String fileContent, int selectionStart, int selectionEnd, List<RuntimeDC> involvedDCs, int startLine, int endLine, FileKey key) {
        String title = fileName;
        if (startLine != -1 && endLine != -1) {
            title = String.valueOf(title) + ":" + startLine + "-" + endLine;
        }
        this.viewer.setParameters((IViewPart)this, this.mConfiguration, title, fileContent, selectionStart, selectionEnd, involvedDCs, key);
        this.viewer.create();
        this.viewer.setFocus();
    }

    public void selectVersionWithAbsTimestamp(long absTimestamp) {
        this.viewer.selectVersionWithAbsTimestamp(absTimestamp);
    }
}

