/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.ui.handlers;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.azurite.ui.handlers.HandlerUtilities;
import edu.cmu.scs.azurite.views.CodeHistoryDiffViewPart;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LaunchCodeHistoryDiffHandler
extends AbstractHandler {
    private static final String CODE_HISTORY_DIFF_VIEW_ID = "edu.cmu.scs.azurite.views.CodeHistoryDiffViewPart";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage page;
        List<RuntimeDC> dcs = HandlerUtilities.getOperationsInSelectedRegion();
        if (dcs == null || dcs.isEmpty()) {
            return null;
        }
        IEditorPart editor = EventRecorder.getInstance().getEditor();
        if (editor == null) {
            return null;
        }
        IDocument doc = Utilities.getDocument((IEditorPart)editor);
        if (doc == null) {
            return null;
        }
        String fileContent = doc.get();
        ITextSelection selection = HandlerUtilities.getSelectedRegion();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            block8: {
                Integer nextViewerId = CodeHistoryDiffViewPart.getNextViewerId();
                if (nextViewerId != null) break block8;
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Azurite - Failed to open code history diff view", (String)"Failed to open a new code history diff view because there are too many code history views open.\nPlease close some existing code history diff views and try again.");
                return null;
            }
            try {
                IViewPart viewPart = page.showView(CODE_HISTORY_DIFF_VIEW_ID, Integer.toString(CodeHistoryDiffViewPart.getNextViewerId()), 3);
                if (viewPart instanceof CodeHistoryDiffViewPart) {
                    CodeHistoryDiffViewPart chdView = (CodeHistoryDiffViewPart)viewPart;
                    String fileName = editor.getEditorInput().getName();
                    chdView.addCodeHistoryDiffViewer(fileName, fileContent, selection.getOffset(), selection.getOffset() + selection.getLength(), dcs, selection.getStartLine(), selection.getEndLine(), RuntimeHistoryManager.getInstance().getCurrentFileKey());
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

