/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.commands.runtime;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDelete;
import edu.cmu.scs.azurite.commands.runtime.RuntimeInsert;
import edu.cmu.scs.azurite.commands.runtime.RuntimeReplace;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.fluorite.commands.document.Delete;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Insert;
import edu.cmu.scs.fluorite.commands.document.Replace;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class RuntimeDC {
    private DocChange mOriginal;
    private List<RuntimeDC> mConflicts;
    private FileKey mBelongsTo;
    private static Comparator<RuntimeDC> commandIDComparator;
    private OperationId mOperationId;

    public static RuntimeDC createRuntimeDocumentChange(DocChange original) {
        if (original instanceof Insert) {
            return new RuntimeInsert((Insert)original);
        }
        if (original instanceof Delete) {
            return new RuntimeDelete((Delete)original);
        }
        if (original instanceof Replace) {
            return new RuntimeReplace((Replace)original);
        }
        throw new IllegalArgumentException("argument should be one of Insert / Delete / Replace");
    }

    protected RuntimeDC(DocChange original) {
        this.mOriginal = original;
        this.mConflicts = new ArrayList<RuntimeDC>();
    }

    public DocChange getOriginal() {
        return this.mOriginal;
    }

    public abstract void applyInsert(RuntimeInsert var1);

    public abstract void applyDelete(RuntimeDelete var1);

    public abstract void applyReplace(RuntimeReplace var1);

    public abstract void applyTo(RuntimeDC var1);

    public List<RuntimeDC> getConflicts() {
        return this.mConflicts;
    }

    protected void addConflict(RuntimeDC docChange) {
        this.mConflicts.add(docChange);
    }

    public void setBelongsTo(FileKey belongsTo) {
        this.mBelongsTo = belongsTo;
    }

    public FileKey getBelongsTo() {
        return this.mBelongsTo;
    }

    public abstract List<Segment> getAllSegments();

    public abstract int getTypeIndex();

    public static Comparator<RuntimeDC> getCommandIDComparator() {
        if (commandIDComparator == null) {
            commandIDComparator = new Comparator<RuntimeDC>(){

                @Override
                public int compare(RuntimeDC lhs, RuntimeDC rhs) {
                    if (lhs.getOriginal().getSessionId() < rhs.getOriginal().getSessionId()) {
                        return -1;
                    }
                    if (lhs.getOriginal().getSessionId() > rhs.getOriginal().getSessionId()) {
                        return 1;
                    }
                    int lindex = lhs.getOriginal().getCommandIndex();
                    int rindex = rhs.getOriginal().getCommandIndex();
                    return new Integer(lindex).compareTo(rindex);
                }
            };
        }
        return commandIDComparator;
    }

    public abstract String getHtmlInfo();

    protected String transformToHtmlString(String originalCode) {
        return originalCode.replace("\r\n", "\n").replace("\r", "\n").replace("\n", "&crarr;<br>");
    }

    public abstract String getTypeString();

    public abstract String getMarkerMessage();

    public OperationId getOperationId() {
        if (this.mOperationId == null) {
            this.mOperationId = new OperationId(this.getOriginal().getSessionId(), this.getOriginal().getCommandIndex());
        }
        return this.mOperationId;
    }
}

