




/* PVM benchmarking routine.  */

/* This program times some operations using the normal (with static groups) */
/* PVM collective communication routines to compare them against ECO. */

/* Bruce Lowekamp */

#include <pvm3.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

main(int argc, char** argv) {

  int nhosts,narchs;
  struct pvmhostinfo *hostp;
  int iam;
  int* tids;
  char gname[30];
  int inst;

  int loop,nloops;
  int i;
  int data;
  int foo;

  struct timeval starttime; /* time communication test began*/
  struct timeval finishtime; /* time communication test over*/

  iam=pvm_mytid();

  if (pvm_parent() == PvmNoParent) {
    pvm_config(&nhosts, &narchs, &hostp);
    tids=(int*) malloc(nhosts*sizeof(int));
    tids[0] = iam;

    if((argc < 2)||((nloops=atoi(argv[1]))< 1)) {
      fprintf (stderr, "use: eco_bench n_iterations\n");
      exit(1);
    }

    if (pvm_spawn("pvm_bench", NULL, PvmTaskHost|PvmHostCompl,
		  ".", nhosts-1,tids+1) < nhosts-1) {
      fprintf (stderr, "unable to spawn all tasks\n");
      exit(1);
    }

    pvm_initsend(PvmDataDefault);
    pvm_pkint(&nhosts,1,1);
    pvm_pkint(tids,nhosts, 1);
    pvm_pkint(&nloops,1,1);
    pvm_mcast(tids+1, nhosts-1,1);
  }
  else {
    pvm_recv(-1,1);
    pvm_upkint(&nhosts,1,1);
    tids=(int*) malloc(nhosts*sizeof(int));
    pvm_upkint(tids,nhosts,1);
    pvm_upkint(&nloops,1,1);
  }

  sprintf(gname, "pvmbenchgroup%i", tids[0]);
  inst = pvm_joingroup(gname);
  pvm_freezegroup(gname,nhosts);

  printf ("group formed.  Timing about to be started.\n");

  gettimeofday(&starttime,NULL);

  for(loop=0;loop<nloops;loop++) {
    for(i=0;i<nhosts;i++){
      if(tids[i]==iam){
	pvm_initsend(PvmDataDefault);
	pvm_pkint(&iam,1,1);
	pvm_bcast(gname,100+i);
      }
      else {
	pvm_recv(tids[i],100+i);
	pvm_upkint(&foo,1,1);
      }
    }
    
    for(i=0;i<nhosts;i++){
      data=iam;
      pvm_reduce(PvmSum,
		 &data, 1, PVM_INT, 200+i, gname, i);
    }
    
    data=iam;
    pvm_reduce(PvmSum,
	       &data, 1, PVM_INT, 200+nhosts, gname, 0);
    if(inst==0) {
      pvm_initsend(PvmDataDefault);
      pvm_pkint(&data,1,1);
      pvm_bcast(gname, 4);
    } 
    else {
      pvm_recv(-1,4);
      pvm_upkint(&data,1,1);
    }
  }
  gettimeofday(&finishtime,NULL);

  printf ("finished\n");

  printf ("elapsed time: %lf\n",
	  (finishtime.tv_usec-starttime.tv_usec)*1e-6 +
	    (finishtime.tv_sec - starttime.tv_sec));


  if (iam == tids[0]) {
    for(i=1;i<nhosts;i++)
      pvm_notify(PvmTaskExit, 99, 1, &tids[i]);
    
    for(i=1;i<nhosts;i++)
      pvm_send(tids[i], 99);

    for(i=1;i<nhosts;i++)
      pvm_recv(-1, 99);
  }
  else {
    pvm_recv(tids[0], 99);
  }

  
}



      
      
  

		

