



/********************************************************************/
/*  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING   */
/*      DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!      */
/*      DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!      */
/*                                                                  */
/*                      THIS IS NOT A SOURCE FILE                   */
/*  All ECO code is written using a set of m4 macros.  If you want  */
/*  to edit, or read, the ECO code, please use the m4 macro code.   */
/********************************************************************/

/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided `as is' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */


/**/
/* Graph partitioning using algorithm*/
/**/
/*   1) add edges which are within ADD_MARGIN of the least weight edge*/
/*      for both vertices*/
/*   2) break graph into connected components*/

/* Bruce Lowekamp*/
/* November 1995*/


#include <stdio.h>
#include <stdlib.h>
#include <values.h>



#include <pvm3.h>



#include "eco_netutil.h"

#define min(a, b) ((a) < (b) ? (a) : (b))
#define min3(a,b,c) ((a) < min((b),(c)) ? (a) : (min((b),(c))))

#define ADD_MARGIN 1.20

typedef struct {
  double min_edge;
  int subnet;
  int partition;
} nodeinfo;

int find_root(nodeinfo* nodes, int child);
int join_trees(nodeinfo* nodes, int tree_a, int tree_b);

#ifdef USE_WISH
char *colors[] = {"red","green","blue", "cyan", "purple", "brown", "orange",
		  "coral"};
#endif
		  

main(int argc, char** argv)
{
  nodeinfo* nodes;
  int p;
  int i,j,k;
  double** edges;
  double* min_times;
  char** host_names;

  int parent;
  int subnet_count;
  double** internet_time;
  int** internet_count;

  if((p = get_host_names(stdin, &host_names)) < 1) {
    fprintf (stderr, "unable to read host names\n");
    exit(1);
  }
  nodes = (nodeinfo*) malloc (p*sizeof(nodeinfo));
  edges = (double**) malloc(p * sizeof(double*));
  for(i=0;i<p;i++)
    edges[i] = (double*) malloc(p*sizeof(double));
  min_times = (double*) malloc(p*sizeof(double));
  
  /* read in graph*/
  if(u_t_table_in(stdin, p, edges))
    exit(1);

  /* setup graph using weights*/
  /* node parametization is time of min edge in subnet*/
  /* edge parametization is time of edge*/
  for(i=0;i<p;i++) {
    nodes[i].min_edge = MAXINT;
    nodes[i].subnet = i;
  }
  for(i=0;i<p;i++) {
    min_times[i] = MAXINT;
    for(j=0;j<p;j++)
      if (i!= j) {
	if (i<j){
	  if(edges[i][j] < min_times[i])
	    min_times[i] = edges[i][j];
	}
	else {
	  if(edges[j][i] < min_times[i])
	    min_times[i] = edges[j][i];
	}
      }
  }    

  
  for(i=0;i<p;i++) {
    for(j=i+1;j<p;j++) {
      if(find_root(nodes, i)!=find_root(nodes, j))
	if
	  /* simple test on min edges for ends of edge*/
	  ((edges[i][j] < ADD_MARGIN * min_times[i]) &&
	   (edges[i][j] < ADD_MARGIN * min_times[j]) &&
	   
	   /* if either end is already in a set, verify edge meets those */
	   /* criteria as well*/
	   
	   (edges[i][j] < ADD_MARGIN * nodes[find_root(nodes, i)].min_edge) &&
	   (edges[i][j] < ADD_MARGIN * nodes[find_root(nodes, j)].min_edge))
	  {
	    nodes[find_root(nodes,i)].min_edge =
	      nodes[find_root(nodes,j)].min_edge =
	      min3(nodes[find_root(nodes,i)].min_edge,
		   nodes[find_root(nodes,j)].min_edge,
		   edges[i][j]);
	    
	    join_trees(nodes, i, j);
	    /*printf ("%i-%i:%lf\n", i, j, edges[i][j]);*/
	  }
    }
  }

  /* check paths*/
  for (i=0;i<p;i++)
    find_root(nodes, i);

  subnet_count = 0;
  /* construct subnet sets externally and output*/
#ifndef USE_WISH
  for(i=0;i<p;i++) {
    if(nodes[i].subnet == i) {
      printf("\n");
      parent = i;
      for(j=0;j<p;j++)
	if(find_root(nodes,j)== parent) {
	  nodes[j].partition = subnet_count;
	  printf ("%s\n", host_names[j]);
	}
      subnet_count++;
    }
  }
#else
  { int tk_level=0;
  
  for(i=0;i<p;i++) {
    if(nodes[i].subnet == i) {
      fprintf(stderr, "frame .%i -height 10 -width 5\n", tk_level++);
      parent = i;
      for(j=0;j<p;j++)
	if(find_root(nodes,j)== parent) {
	  nodes[j].partition = subnet_count;
	  fprintf (stderr, "label .%i -text \"%s\" -fg %s -borderwidth 0\n", tk_level++,
		  host_names[j], colors[subnet_count%8]);
	}
      subnet_count++;
    }
  }
  fprintf (stderr, "pack ");
  for(i=0;i<tk_level;i++)
    fprintf (stderr, ".%i ", i);
  fprintf (stderr, "-anchor w\n");
  }
#endif

  internet_time = (double**) malloc(subnet_count * sizeof(double*));
  internet_count = (int**) malloc(subnet_count * sizeof(int*));
  for(i=0;i<subnet_count;i++) {
    internet_time[i] = (double*) malloc(subnet_count * sizeof(double));
    internet_count[i] = (int*) malloc(subnet_count * sizeof(int));
    for (j=0;j<subnet_count;j++) {
      internet_time[i][j] = 0;
      internet_count[i][j] = 0;
    }
  }
  
  for(i=0;i<p;i++)
    for(j=i+1;j<p;j++)
      if(nodes[i].partition != nodes[j].partition) {
	if(nodes[i].partition < nodes[j].partition) {
	  internet_time[nodes[i].partition][nodes[j].partition]
	    += edges[i][j];
	  internet_count[nodes[i].partition][nodes[j].partition]++;
	}
	else {
	  internet_time[nodes[j].partition][nodes[i].partition]
	    += edges[i][j];
	  internet_count[nodes[j].partition][nodes[i].partition]++;
	}
	  
      }

  for(i=0;i<subnet_count;i++)
    for(j=i+1;j<subnet_count;j++)
      if(internet_count[i][j] > 0)
	internet_time[i][j] /= internet_count[i][j];

  printf ("---------\n");
  printf ("subnets: %i\n", subnet_count);

  for(i=0;i<subnet_count;i++) {
    /* count nodes*/
    k = 0;
    for(j=0;j<p;j++)
      if(nodes[j].partition == i)
	k++;
    printf("%i ", k);
    for(j=0;j<p;j++)
      if(nodes[j].partition == i)
	printf ("%s ", host_names[j]);
    printf ("\n");
  }

  
  for (i=0;i<subnet_count;i++) {
    for (j=0;j<i;j++)
      printf ("       ");
    
    for (j=i+1; j< subnet_count;j++)
      printf ("%6.4f ", internet_time[i][j]);
    printf ("\n");
  }

  printf ("\n");
    
  
  
}

	

int find_root(nodeinfo* nodes, int child)
{
  int path_len = 0;
  int node = child;

  while (nodes[node].subnet != node) {
    path_len++;
    node = nodes[node].subnet;
  }

  if(path_len > 1) {
    int retrace = child;
    int next_retrace;

    while (nodes[retrace].subnet != node) {
      next_retrace = nodes[retrace].subnet;
      nodes[retrace].subnet = node;
      retrace = next_retrace;
    }

  }
  
  return node;
}

int join_trees(nodeinfo* nodes, int tree_a, int tree_b)
{
  nodes[find_root(nodes, tree_b)].subnet = tree_a;
}

    
    
    
    
  
