



/********************************************************************/
/*  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING   */
/*      DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!      */
/*      DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!      */
/*                                                                  */
/*                      THIS IS NOT A SOURCE FILE                   */
/*  All ECO code is written using a set of m4 macros.  If you want  */
/*  to edit, or read, the ECO code, please use the m4 macro code.   */
/********************************************************************/

/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided `as is' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */


/* Generic routines for supporting the netstone data.*/

#include <stdio.h>
#include <stdlib.h>
#include<string.h>



#include <pvm3.h>


#include "eco_netanal.h"
#include "eco_netutil.h"
#include "spawn_mpp.h"

/* read in list of hostnames*/
int get_host_names(FILE* data_file, char *** hostarray)
{
  const int maxhosts = 150;
  char linebuf[MAX_LINE_LEN];
  int i;
  char* rv;
  
  (*hostarray) = (char**) malloc(maxhosts * sizeof(char*));

  while((rv = fgets(linebuf, MAX_LINE_LEN, data_file)) == linebuf)
    if(linebuf[0] == '=')
      break;
  if(rv!=linebuf)
    return -1;

  i = 0;
  while(linebuf[0] == '=') {
    (*hostarray)[i] = (char *) malloc(strlen(linebuf));
    *(strchr(linebuf,'\n')) = 0;
    strcpy((*hostarray)[i], linebuf+1);
    i++;
    if((rv = fgets(linebuf, MAX_LINE_LEN, data_file)) != linebuf)
      linebuf[0] = ' ';
  }

  return i;
}
  
  

/* read a table in upper-tri form*/
int u_t_table_in(FILE* data_file, int n,
		 double** data)
{
  int i,j;
  char linebuf[MAX_LINE_LEN];
  char* rv;

  /* scan forward for the table indicator (^^^).  If it's not here,*/
  /* this file isn't formatted properly*/
  while((rv=fgets(linebuf, MAX_LINE_LEN, data_file)) == linebuf)
    if(strcmp(linebuf, "^^^\n") == 0)
      break;

  if(rv != linebuf)
    return -1;

  /* skip line of column headers*/
  if(fgets(linebuf, MAX_LINE_LEN,data_file) != linebuf)
    return -1;
  
  for(i=0;i<n;i++)
    for(j=0;j<n;j++)
      data[i][j]=0;

  for(i=0;i<(n-1);i++) {
    /* skip name*/
    if(fscanf(data_file, "%*s") != 0)
      return -1;

    for(j=i+1;j<n;j++)
      if(fscanf(data_file, "%lf", &(data[i][j])) != 1)
	return -1;
  }

  return 0;
}


/* output an upper-tri matrix with appropriate formatting*/
/* we just sort of assume that the writes won't fail....*/
void u_t_table_out(FILE* data_file, int* tids, int p,
		  double** data)
{
  int i,j;
  int num_tasks;
  struct pvmtaskinfo *taskp;
  struct pvmhostinfo *hostp; /* information on the virtual machine*/


  pvm_config(&i, &j, &hostp);

  fprintf (data_file, "\n\n^^^\n");
  
  fprintf (data_file, "       ");
  for (i=1;i< p;i++) {
    pvm_tasks(tids[i], &num_tasks, &taskp);
   fprintf (data_file, "%6.6s ", pvmhostname(hostp, taskp[0].ti_host));
  }
  fprintf (data_file, "\n");
  
  for (i=0;i<p;i++) {
    
    pvm_tasks(tids[i], &num_tasks, &taskp);
    fprintf (data_file, "%6.6s ", pvmhostname(hostp, taskp[0].ti_host));
    
    for (j=0;j<i;j++)
      fprintf (data_file, "       ");
    
    for (j=i+1; j< p;j++)
      fprintf (data_file, "%6.4f ", data[i][j]);
    fprintf (data_file, "\n");
  }
}
  

  
/* return a pointer to the hostname with pvmd tid ti_host*/
char *pvmhostname(struct pvmhostinfo *hostp, int ti_host)
{
  int hostindex;

  for (hostindex = 0; hostp[hostindex].hi_tid!=ti_host;hostindex++);

  return (hostp[hostindex].hi_name);
}
