




/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided `as is' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */

#include <pvm3.h>
#include "eco.h"


/* ECO benchmarking routine.  */

/* This program times some operations using ECO's collective communication */
/* routines and times them for comparison with pvm's native collective */
/* operations */

/* Bruce Lowekamp */

#include <pvm3.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include "eco.h"

main(int argc, char** argv) {

  int nhosts,narchs;
  struct pvmhostinfo *hostp;
  int iam;
  int* tids;
  char gname[30];
  int inst;

  int loop,nloops;
  int i;
  int data;
  int foo;
  int p_i;

  struct timeval starttime; /* time communication test began*/
  struct timeval finishtime; /* time communication test over*/

  iam=pvm_mytid();

  if (pvm_parent() == PvmNoParent) {
    pvm_config(&nhosts, &narchs, &hostp);
    tids=(int*) malloc(nhosts*sizeof(int));
    tids[0] = iam;
    p_i=0;

    if((argc < 2)||((nloops=atoi(argv[1]))< 1)) {
      fprintf (stderr, "use: eco_bench n_iterations\n");
      exit(1);
    }
      
    if (pvm_spawn("eco_bench", NULL, PvmTaskHost|PvmHostCompl,
		  ".", nhosts-1,tids+1) < nhosts-1) {
      fprintf (stderr, "unable to spawn all tasks\n");
      exit(1);
    }


    pvm_initsend(PvmDataDefault);
    pvm_pkint(&nhosts,1,1);
    pvm_pkint(tids,nhosts, 1);
    pvm_pkint(&nloops,1,1);
    pvm_mcast(tids+1, nhosts-1,1);
  }
  else {
    pvm_recv(-1,1);
    pvm_upkint(&nhosts,1,1);
    tids=(int*) malloc(nhosts*sizeof(int));
    pvm_upkint(tids,nhosts,1);
    pvm_upkint(&nloops,1,1);
    for(p_i=1;tids[p_i]!=iam;p_i++);
  }

  /* ECO initialization */
  eco_init (&p_i, nhosts, tids, NULL, ECO_DEFAULT_TOPOLOGY, NULL);

  printf ("ECO initialized.  Timing about to be started.\n");

  gettimeofday(&starttime,NULL);

  for(loop=0;loop<nloops;loop++){
    for(i=0;i<nhosts;i++){
      if(tids[i]==iam){
	pvm_initsend(PvmDataDefault);
	pvm_pkint(&iam,1,1);
	eco_bcast(i);
      }
      else {
	eco_bcast(i);
	pvm_upkint(&foo,1,1);
      }
    }
    
    for(i=0;i<nhosts;i++){
      data=iam;
      eco_reduce(&data,1,1,
		 &foo,
		 ECO_OP_ADD, i, Eco_Int);
    }
    
    data=iam;
    eco_reduce(&data,1,1,
	       &foo,
	       ECO_OP_ADD, ECO_ALL, Eco_Int);
  }  
  gettimeofday(&finishtime,NULL);

  printf ("finished\n");

  printf ("elapsed time: %lf\n",
	  (finishtime.tv_usec-starttime.tv_usec)*1e-6 +
	    (finishtime.tv_sec - starttime.tv_sec));


}
  

      
      
  

		

