



/********************************************************************/
/*  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING  WARNING   */
/*      DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!      */
/*      DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!  DO NOT EDIT!      */
/*                                                                  */
/*                      THIS IS NOT A SOURCE FILE                   */
/*  All ECO code is written using a set of m4 macros.  If you want  */
/*  to edit, or read, the ECO code, please use the m4 macro code.   */
/********************************************************************/

/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided `as is' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */

#ifndef ECO_ALG_H
#define ECO_ALG_H


#include "eco.h"


#undef min
#undef max
#define max(a,b)  ((a)>(b)?(a):(b))
#define min(a,b)  ((a)<(b)?(a):(b))
























#include <stdio.h>
#include <stdlib.h>
#include <pvm3.h>


/* eco_gather (IN send_vector[], IN int send_length, IN int send_stride, */
/* 	    IN int send_offset, */
/* 	    OUT recv_vector[], IN int recv_length, IN int recv_stride, */
/* 	    IN int root, IN TYPE) */

/* send_vector: vector with data to be gathered */
/* send_length: number of data elements in send_vector */
/* send_stride: stride for data in send_vector */
/* send_offset: position of send_vector in recv_vector */
/* recv_vector: resulting vector (root) */
/* recv_len: size of recv_vector (in terms of data elements) (root) */
/* recv_stride: stride of data in recv_vector (root) */
/* root: gathering process or ECO_ALL */

/* gather takes all send vectors contributed by processes and combines them */
/* to form recv_vector, which is only used at root, unless root=ECO_ALL, in  */
/* which case all processes receive the recv_vector.  Overlapping send */
/* ranges will produce unpredictable results. */

/* send_offset should specify the destination address with recv_stride already */
/* accounted for.  Note that length parameters should not  stride */

 int eco_gather(void* send_vect, int send_len, int send_stride,
		     int send_offset,
		     void* recv_vect, int recv_len, int recv_stride,
		     int root , int Arg_Type)
{
  int i,j;
  int r_loc, r_len;
  ECO_NEW_MTAG;

  if(ECO_tree_parent[root] != -1){
    pvm_initsend(PvmDataDefault);
  }
  else 
    for(i=0;i<send_len;i++)
      
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vect)[send_offset+i*recv_stride] = ((int*)send_vect)[i*send_stride];
  break;
case Eco_Long:
  ((long*)recv_vect)[send_offset+i*recv_stride] = ((long*)send_vect)[i*send_stride];
  break;
case Eco_Float:
  ((float*)recv_vect)[send_offset+i*recv_stride] = ((float*)send_vect)[i*send_stride];
  break;
case Eco_Double:
  ((double*)recv_vect)[send_offset+i*recv_stride] = ((double*)send_vect)[i*send_stride];
  break;
case Eco_Char:
  ((char*)recv_vect)[send_offset+i*recv_stride] = ((char*)send_vect)[i*send_stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      
  /*fprintf (stderr, "root= %i\n", root);*/

  for (i=0;i<ECO_tree_child_count[root];i++) {
    pvm_recv(-1,ECO_GATHER_UP);
    pvm_upkint(&r_loc,1,1);
    while(r_loc != -1) {
      pvm_upkint(&r_len, 1, 1);
      if((root==ECO_ALL)||(root==ECO_myid)) {
	/*printf ("loc %i, 0 %i (%i,%i)\n", r_loc, r_len,
		recv_len, recv_stride);*/
	if(r_loc+(r_len-1)*recv_stride <= recv_len*recv_stride) {
	  /*printf ("before:");
	  for(j=0;j<recv_len*recv_stride;j++)
	    printf ("%4.1lf ", recv_vect[j]);
	  printf ("\n");*/
	  
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)recv_vect)+r_loc,r_len,recv_stride);
  break;
case Eco_Long:
  pvm_upklong(((long*)recv_vect)+r_loc,r_len,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)recv_vect)+r_loc,r_len,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)recv_vect)+r_loc,r_len,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)recv_vect)+r_loc,r_len,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  /*printf ("after:");
	  for(j=0;j<recv_len*recv_stride;j++)
	    printf ("%4.1lf ", recv_vect[j]);
	  printf ("\n");*/
	  
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&r_loc,1,1);
	    pvm_pkint(&r_len,1,1);
	    
switch (Arg_Type) {
case Eco_Int:
  pvm_pkint(((int*)recv_vect)+r_loc,r_len,recv_stride);
  break;
case Eco_Long:
  pvm_pklong(((long*)recv_vect)+r_loc,r_len,recv_stride);
  break;
case Eco_Float:
  pvm_pkfloat(((float*)recv_vect)+r_loc,r_len,recv_stride);
  break;
case Eco_Double:
  pvm_pkdouble(((double*)recv_vect)+r_loc,r_len,recv_stride);
  break;
case Eco_Char:
  pvm_pkbyte(((char*)recv_vect)+r_loc,r_len,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
	}
	else {
	  int len1, len2, loc2;
	  fprintf(stderr, "AAAARRRRRRGGGGGHHHH unwrapping!\n");
	  len1 = r_loc+r_len - recv_len*recv_stride;
	  
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)recv_vect)+r_loc,len1,recv_stride);
  break;
case Eco_Long:
  pvm_upklong(((long*)recv_vect)+r_loc,len1,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)recv_vect)+r_loc,len1,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)recv_vect)+r_loc,len1,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)recv_vect)+r_loc,len1,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&r_loc,1,1);
	    pvm_pkint(&len1, 1, 1);
	    
switch (Arg_Type) {
case Eco_Int:
  pvm_pkint(((int*)recv_vect)+r_loc,len1,recv_stride);
  break;
case Eco_Long:
  pvm_pklong(((long*)recv_vect)+r_loc,len1,recv_stride);
  break;
case Eco_Float:
  pvm_pkfloat(((float*)recv_vect)+r_loc,len1,recv_stride);
  break;
case Eco_Double:
  pvm_pkdouble(((double*)recv_vect)+r_loc,len1,recv_stride);
  break;
case Eco_Char:
  pvm_pkbyte(((char*)recv_vect)+r_loc,len1,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
	  
	  loc2 = 0;
	  len2 = r_len - len1;
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)((void*) recv_vect),len2,recv_stride);
  break;
case Eco_Long:
  pvm_upklong((long*)((void*) recv_vect),len2,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)((void*) recv_vect),len2,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)((void*) recv_vect),len2,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)((void*) recv_vect),len2,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&loc2,1,1);
	    pvm_pkint(&len2, 1, 1);
	    
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)((void*) recv_vect),len2,recv_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)((void*) recv_vect),len2,recv_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)((void*) recv_vect),len2,recv_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)((void*) recv_vect),len2,recv_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)((void*) recv_vect),len2,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
	}
      }
      else {
	double tmp_datat[r_len]; void* tmp_data = tmp_datat;
	
	
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)((void*) tmp_data),r_len,1);
  break;
case Eco_Long:
  pvm_upklong((long*)((void*) tmp_data),r_len,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)((void*) tmp_data),r_len,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)((void*) tmp_data),r_len,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)((void*) tmp_data),r_len,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	pvm_pkint(&r_loc,1,1);
	pvm_pkint(&r_len,1,1);
	
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)((void*) tmp_data),r_len,1);
  break;
case Eco_Long:
  pvm_pklong((long*)((void*) tmp_data),r_len,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)((void*) tmp_data),r_len,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)((void*) tmp_data),r_len,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)((void*) tmp_data),r_len,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      }
      pvm_upkint(&r_loc, 1, 1);
    }
  }

  if(ECO_tree_parent[root] != -1) {
    /*printf ("%i packing %i %i(%i):", ECO_myid, send_offset, send_len,
	    send_stride);
    for(i=0;i<send_len*send_stride;i++)
      printf ("%4.1lf ", send_vect[i]);
    printf("\n");*/
    pvm_pkint(&send_offset, 1, 1);
    pvm_pkint(&send_len, 1, 1);
    
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)send_vect,send_len,send_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)send_vect,send_len,send_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)send_vect,send_len,send_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)send_vect,send_len,send_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)send_vect,send_len,send_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

    i=-1;
    pvm_pkint(&i,1,1);
    pvm_send(ECO_tree_parent[root], ECO_GATHER_UP);
  
  }

  if(root == ECO_ALL) {
    if(ECO_tree_parent[ECO_ALL] != -1) {
      pvm_recv(ECO_tree_parent[root], ECO_GATHER_DOWN);
      pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
    }
    else {
      pvm_initsend(PvmDataDefault);
      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)recv_vect,recv_len,recv_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)recv_vect,recv_len,recv_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)recv_vect,recv_len,recv_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)recv_vect,recv_len,recv_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)recv_vect,recv_len,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }

    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i],ECO_GATHER_DOWN);
    
    if(ECO_tree_parent[ECO_ALL] != -1) {
      pvm_freebuf(pvm_setrbuf(pvm_getsbuf()));
      
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)recv_vect,recv_len,recv_stride);
  break;
case Eco_Long:
  pvm_upklong((long*)recv_vect,recv_len,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)recv_vect,recv_len,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)recv_vect,recv_len,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)recv_vect,recv_len,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }
  }
  
  return 0;
}

 int eco_gatherv(int num_vect, 
		      void** send_vect, int send_len, int send_stride,
		     int send_offset,
		     void** recv_vect, int recv_len, int recv_stride,
		     int root , int Arg_Type)
{
  int i,j,v;
  int r_loc, r_len;
  ECO_NEW_MTAG;

  if(ECO_tree_parent[root] != -1){
    pvm_initsend(PvmDataDefault);
  }
  else 
    for(v=0;v<num_vect;v++)
      for(i=0;i<send_len;i++)
	
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vect[v])[send_offset+i*recv_stride] = ((int*)send_vect[v])[i*send_stride];
  break;
case Eco_Long:
  ((long*)recv_vect[v])[send_offset+i*recv_stride] = ((long*)send_vect[v])[i*send_stride];
  break;
case Eco_Float:
  ((float*)recv_vect[v])[send_offset+i*recv_stride] = ((float*)send_vect[v])[i*send_stride];
  break;
case Eco_Double:
  ((double*)recv_vect[v])[send_offset+i*recv_stride] = ((double*)send_vect[v])[i*send_stride];
  break;
case Eco_Char:
  ((char*)recv_vect[v])[send_offset+i*recv_stride] = ((char*)send_vect[v])[i*send_stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      
  /*fprintf (stderr, "root= %i\n", root);*/

  for (i=0;i<ECO_tree_child_count[root];i++) {
    pvm_recv(-1,ECO_GATHER_UP);
    pvm_upkint(&r_loc,1,1);
    while(r_loc != -1) {
      pvm_upkint(&r_len, 1, 1);
      if((root==ECO_ALL)||(root==ECO_myid)) {
	/*printf ("loc %i, 0 %i (%i,%i)\n", r_loc, r_len,
		recv_len, recv_stride);*/
	if(r_loc+(r_len-1)*recv_stride <= recv_len*recv_stride) {
	  /*printf ("before:");
	  for(j=0;j<recv_len*recv_stride;j++)
	    printf ("%4.1lf ", recv_vect[j]);
	  printf ("\n");*/
	  for(v=0;v<num_vect;v++)
	    
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
case Eco_Long:
  pvm_upklong(((long*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  /*printf ("after:");
	  for(j=0;j<recv_len*recv_stride;j++)
	    printf ("%4.1lf ", recv_vect[j]);
	  printf ("\n");*/
	  
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&r_loc,1,1);
	    pvm_pkint(&r_len,1,1);
	    for(v=0;v<num_vect;v++)
	      
switch (Arg_Type) {
case Eco_Int:
  pvm_pkint(((int*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
case Eco_Long:
  pvm_pklong(((long*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
case Eco_Float:
  pvm_pkfloat(((float*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
case Eco_Double:
  pvm_pkdouble(((double*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
case Eco_Char:
  pvm_pkbyte(((char*)recv_vect[v])+r_loc,r_len,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
	}
	else {
	  int len1, len2, loc2;
	  fprintf(stderr, "AAAARRRRRRGGGGGHHHH unwrapping!\n");
	  len1 = r_loc+r_len - recv_len*recv_stride;
	  for(v=0;v<num_vect;v++)
	    
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
case Eco_Long:
  pvm_upklong(((long*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&r_loc,1,1);
	    pvm_pkint(&len1, 1, 1);
	    for(v=0;v<num_vect;v++)
	      
switch (Arg_Type) {
case Eco_Int:
  pvm_pkint(((int*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
case Eco_Long:
  pvm_pklong(((long*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
case Eco_Float:
  pvm_pkfloat(((float*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
case Eco_Double:
  pvm_pkdouble(((double*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
case Eco_Char:
  pvm_pkbyte(((char*)recv_vect[v])+r_loc,len1,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
	  
	  loc2 = 0;
	  len2 = r_len - len1;
	  for(v=0;v<num_vect;v++)
	    
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)((void*) recv_vect[v]),len2,recv_stride);
  break;
case Eco_Long:
  pvm_upklong((long*)((void*) recv_vect[v]),len2,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)((void*) recv_vect[v]),len2,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)((void*) recv_vect[v]),len2,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)((void*) recv_vect[v]),len2,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&loc2,1,1);
	    pvm_pkint(&len2, 1, 1);
	    for(v=0;v<num_vect;v++)
	      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)((void*) recv_vect[v]),len2,recv_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)((void*) recv_vect[v]),len2,recv_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)((void*) recv_vect[v]),len2,recv_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)((void*) recv_vect[v]),len2,recv_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)((void*) recv_vect[v]),len2,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
	}
      }
      else {
	double tmp_datat[r_len]; void* tmp_data = tmp_datat;
	pvm_pkint(&r_loc,1,1);
	pvm_pkint(&r_len,1,1);

	for(v=0;v<num_vect;v++){
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)((void*) tmp_data),r_len,1);
  break;
case Eco_Long:
  pvm_upklong((long*)((void*) tmp_data),r_len,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)((void*) tmp_data),r_len,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)((void*) tmp_data),r_len,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)((void*) tmp_data),r_len,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)((void*) tmp_data),r_len,1);
  break;
case Eco_Long:
  pvm_pklong((long*)((void*) tmp_data),r_len,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)((void*) tmp_data),r_len,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)((void*) tmp_data),r_len,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)((void*) tmp_data),r_len,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	}
      }
      pvm_upkint(&r_loc, 1, 1);
    }
  }

  if(ECO_tree_parent[root] != -1) {
    /*printf ("%i packing %i %i(%i):", ECO_myid, send_offset, send_len,
	    send_stride);
    for(i=0;i<send_len*send_stride;i++)
      printf ("%4.1lf ", send_vect[i]);
    printf("\n");*/
    pvm_pkint(&send_offset, 1, 1);
    pvm_pkint(&send_len, 1, 1);
    for(v=0;v<num_vect;v++)
      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)send_vect[v],send_len,send_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)send_vect[v],send_len,send_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)send_vect[v],send_len,send_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)send_vect[v],send_len,send_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)send_vect[v],send_len,send_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

    i=-1;
    pvm_pkint(&i,1,1);
    pvm_send(ECO_tree_parent[root], ECO_GATHER_UP);
  
  }

  if(root == ECO_ALL) {
    if(ECO_tree_parent[ECO_ALL] != -1) {
      pvm_recv(ECO_tree_parent[root], ECO_GATHER_DOWN);
      pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
    }
    else {
      pvm_initsend(PvmDataDefault);
      for(v=0;v<num_vect;v++)
	
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)recv_vect[v],recv_len,recv_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)recv_vect[v],recv_len,recv_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)recv_vect[v],recv_len,recv_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)recv_vect[v],recv_len,recv_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)recv_vect[v],recv_len,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }

    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i],ECO_GATHER_DOWN);
    
    if(ECO_tree_parent[ECO_ALL] != -1) {
      pvm_freebuf(pvm_setrbuf(pvm_getsbuf()));
      for(v=0;v<num_vect;v++)
	
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)recv_vect[v],recv_len,recv_stride);
  break;
case Eco_Long:
  pvm_upklong((long*)recv_vect[v],recv_len,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)recv_vect[v],recv_len,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)recv_vect[v],recv_len,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)recv_vect[v],recv_len,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }
  }
  
  return 0;
}



/* eco_scatter(IN send_vector[], IN int send_length, IN int send_stride, */
/* 	IN int lengths[], IN int offsets[], */
/* 	OUT recv_vector[], IN int recv_length, IN int recv_stride, */
/* 	IN int root, IN TYPE) */

/* send_vector: data to be scattered (root) */
/* send_length: number of data items (root) */
/* send_stride: stride of data in send_vector (root) */
/* lengths: number of items process i should receive (root) */
/* offsets: offset of data process i should receive (root) */
/* recv_vector: part of data for process  */
/* recv_length: length of data for process  */
/* recv_stride: stride of data in recv_vector */
/* root: scattering process */

/* scatter divides data input on root and distributes one chunk to each process */
/* (including the root process).  It does check that output_vector is large */
/* enough to store what is passed to it, although overlaps within send_vector */
/* are not checked for. */

/* Note that offsets should specify the source address with stride already */
/* accounted for.  length parameters should not  stride */
 int eco_scatter(void* send_vector, int send_length,int send_stride,
		       int* length, int* offset, 
		       void* recv_vector, int* recv_length,
		      int recv_stride, 
		       int root , int Arg_Type)
{
  int i,j;
  int dummy_int[2];
  double dummy_tt[2]; void* dummy_t = dummy_tt;
  int my_offset;
  int unstrided_offsets[ECO_p];
  
  ECO_NEW_MTAG;

  if(ECO_myid == root) {
    for(i=0;(i<ECO_p) && ((offset[i]+(length[i]-1)*send_stride)<=
			  send_length*send_stride);i++);
    if (i==ECO_p) {
      for(j=0;j<ECO_p;j++)
	unstrided_offsets[j] = offset[j]/send_stride;
      pvm_initsend(PvmDataDefault);
      pvm_pkint(length, ECO_p, 1);
      pvm_pkint(unstrided_offsets, ECO_p, 1);
      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)send_vector,send_length,send_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)send_vector,send_length,send_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)send_vector,send_length,send_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)send_vector,send_length,send_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)send_vector,send_length,send_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      for(i=0;i<ECO_tree_child_count[root];i++)
	pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
    }
    else /* oh great, we have to unwrap it */  {
      int wrap_offset = offset[i];
      int wrap_length = length[i];
      int wrapped = wrap_offset+wrap_length - send_length;
      int unwrap_offset[ECO_p];
      double unwrap_datat[send_length]; void* unwrap_data = unwrap_datat;
      printf ("OH NO!  Not unwrapping!\n");
      for(i=0;i<ECO_p;i++)
	unwrap_offset[i] = offset[i]-wrapped;
      
      for(i=0;i<(send_length-wrapped);i++)
	
switch(Arg_Type){
case Eco_Int:
  ((int*)unwrap_data)[i] = ((int*)send_vector)[wrapped+i];
  break;
case Eco_Long:
  ((long*)unwrap_data)[i] = ((long*)send_vector)[wrapped+i];
  break;
case Eco_Float:
  ((float*)unwrap_data)[i] = ((float*)send_vector)[wrapped+i];
  break;
case Eco_Double:
  ((double*)unwrap_data)[i] = ((double*)send_vector)[wrapped+i];
  break;
case Eco_Char:
  ((char*)unwrap_data)[i] = ((char*)send_vector)[wrapped+i];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      for(i=0;i<wrapped;i++)
	
switch(Arg_Type){
case Eco_Int:
  ((int*)unwrap_data)[(send_length-wrapped)+i] = ((int*)send_vector)[i];
  break;
case Eco_Long:
  ((long*)unwrap_data)[(send_length-wrapped)+i] = ((long*)send_vector)[i];
  break;
case Eco_Float:
  ((float*)unwrap_data)[(send_length-wrapped)+i] = ((float*)send_vector)[i];
  break;
case Eco_Double:
  ((double*)unwrap_data)[(send_length-wrapped)+i] = ((double*)send_vector)[i];
  break;
case Eco_Char:
  ((char*)unwrap_data)[(send_length-wrapped)+i] = ((char*)send_vector)[i];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

#if 0
      memcpy(unwrap_data, &(send_vector[wrapped]),
	     (send_length - wrapped)*
	     sizeof(void));
      memcpy(&(unwrap_data[send_length - wrapped]),
	     send_vector, wrapped*
	     sizeof(void));
#endif
      
      pvm_initsend(PvmDataDefault);
      pvm_pkint(length, ECO_p, 1);
      pvm_pkint(unwrap_offset, ECO_p, 1);
      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)unwrap_data,send_length,send_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)unwrap_data,send_length,send_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)unwrap_data,send_length,send_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)unwrap_data,send_length,send_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)unwrap_data,send_length,send_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      for(i=0;i<ECO_tree_child_count[root];i++)
	pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
    }
    
  }
  else {
    pvm_recv(ECO_tree_parent[root], ECO_BCAST_MSG);
    pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
  }


  pvm_setrbuf(pvm_getsbuf());

  for(i=0;i<ECO_myid;i++)
    pvm_upkint(dummy_int,1,1);
  pvm_upkint(recv_length, 1, 1);
  for(i=ECO_myid+1;i<ECO_p;i++)
    pvm_upkint(dummy_int,1,1);
  for(i=0;i<ECO_myid;i++)
    pvm_upkint(dummy_int,1,1);
  pvm_upkint(&my_offset, 1, 1);
  for(i=ECO_myid+1;i<ECO_p;i++)
    pvm_upkint(dummy_int,1,1);
  for(i=0;i<my_offset;i++)
    
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)dummy_t,1,1);
  break;
case Eco_Long:
  pvm_upklong((long*)dummy_t,1,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)dummy_t,1,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)dummy_t,1,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)dummy_t,1,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

  
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)recv_vector,*recv_length,recv_stride);
  break;
case Eco_Long:
  pvm_upklong((long*)recv_vector,*recv_length,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)recv_vector,*recv_length,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)recv_vector,*recv_length,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)recv_vector,*recv_length,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
  return 0;
  
}

 int eco_scatterv(int num_vect,
		       void** send_vector, int send_length,int send_stride,
		       int* length, int* offset, 
		       void** recv_vector, int* recv_length,
		      int recv_stride, 
		       int root , int Arg_Type)
{
  int i,j,v;
  int dummy_int[2];
  double dummy_tt[2]; void* dummy_t = dummy_tt;
  int my_offset;
  int unstrided_offsets[ECO_p];
  
  ECO_NEW_MTAG;

  if(ECO_myid == root) {
    for(i=0;(i<ECO_p) && ((offset[i]+(length[i]-1)*send_stride)<=
			  send_length*send_stride);i++);
    if (i==ECO_p) {
      for(j=0;j<ECO_p;j++)
	unstrided_offsets[j] = offset[j]/send_stride;
      pvm_initsend(PvmDataDefault);
      pvm_pkint(&send_length, 1,1);
      pvm_pkint(length, ECO_p, 1);
      pvm_pkint(unstrided_offsets, ECO_p, 1);
      for(v=0;v<num_vect;v++)
	
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)send_vector[v],send_length,send_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)send_vector[v],send_length,send_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)send_vector[v],send_length,send_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)send_vector[v],send_length,send_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)send_vector[v],send_length,send_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      for(i=0;i<ECO_tree_child_count[root];i++)
	pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
    }
    else /* oh great, we have to unwrap it */  {
      int wrap_offset = offset[i];
      int wrap_length = length[i];
      int wrapped = wrap_offset+wrap_length - send_length;
      double unwrap_datat[send_length]; void* unwrap_data = unwrap_datat;
      int unwrap_offset[ECO_p];
      printf ("OH NO!  Not unwrapping!\n");
      for(i=0;i<ECO_p;i++)
	unwrap_offset[i] = offset[i]-wrapped;

      for(v=0;v<num_vect;v++) {
	for(i=0;i<(send_length-wrapped);i++)
	  
switch(Arg_Type){
case Eco_Int:
  ((int*)unwrap_data)[i] = ((int*)send_vector[v])[wrapped+i];
  break;
case Eco_Long:
  ((long*)unwrap_data)[i] = ((long*)send_vector[v])[wrapped+i];
  break;
case Eco_Float:
  ((float*)unwrap_data)[i] = ((float*)send_vector[v])[wrapped+i];
  break;
case Eco_Double:
  ((double*)unwrap_data)[i] = ((double*)send_vector[v])[wrapped+i];
  break;
case Eco_Char:
  ((char*)unwrap_data)[i] = ((char*)send_vector[v])[wrapped+i];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	for(i=0;i<wrapped;i++)
	  
switch(Arg_Type){
case Eco_Int:
  ((int*)unwrap_data)[(send_length-wrapped)+i] = ((int*)send_vector[v])[i];
  break;
case Eco_Long:
  ((long*)unwrap_data)[(send_length-wrapped)+i] = ((long*)send_vector[v])[i];
  break;
case Eco_Float:
  ((float*)unwrap_data)[(send_length-wrapped)+i] = ((float*)send_vector[v])[i];
  break;
case Eco_Double:
  ((double*)unwrap_data)[(send_length-wrapped)+i] = ((double*)send_vector[v])[i];
  break;
case Eco_Char:
  ((char*)unwrap_data)[(send_length-wrapped)+i] = ((char*)send_vector[v])[i];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      }

      pvm_initsend(PvmDataDefault);
      pvm_pkint(length, ECO_p, 1);
      pvm_pkint(unwrap_offset, ECO_p, 1);
      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)unwrap_data,send_length,send_stride);
  break;
case Eco_Long:
  pvm_pklong((long*)unwrap_data,send_length,send_stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)unwrap_data,send_length,send_stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)unwrap_data,send_length,send_stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)unwrap_data,send_length,send_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      for(i=0;i<ECO_tree_child_count[root];i++)
	pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
    }
    
  }
  else {
    pvm_recv(ECO_tree_parent[root], ECO_BCAST_MSG);
    pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
  }


  pvm_setrbuf(pvm_getsbuf());

  pvm_upkint(&send_length,1,1);
  for(i=0;i<ECO_myid;i++)
    pvm_upkint(dummy_int,1,1);
  pvm_upkint(recv_length, 1, 1);
  for(i=ECO_myid+1;i<ECO_p;i++)
    pvm_upkint(dummy_int,1,1);
  for(i=0;i<ECO_myid;i++)
    pvm_upkint(dummy_int,1,1);
  pvm_upkint(&my_offset, 1, 1);
  for(i=ECO_myid+1;i<ECO_p;i++)
    pvm_upkint(dummy_int,1,1);
  for(v=0;v<num_vect;v++) {
    for(i=0;i<my_offset;i++)
      
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)dummy_t,1,1);
  break;
case Eco_Long:
  pvm_upklong((long*)dummy_t,1,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)dummy_t,1,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)dummy_t,1,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)dummy_t,1,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

    
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)recv_vector[v],*recv_length,recv_stride);
  break;
case Eco_Long:
  pvm_upklong((long*)recv_vector[v],*recv_length,recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)recv_vector[v],*recv_length,recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)recv_vector[v],*recv_length,recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)recv_vector[v],*recv_length,recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    for(i=my_offset+*recv_length;i<send_length;i++)
      
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)dummy_t,1,1);
  break;
case Eco_Long:
  pvm_upklong((long*)dummy_t,1,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)dummy_t,1,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)dummy_t,1,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)dummy_t,1,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
  }

  return 0;
}



/* eco_alltoall(IN send_vector[], IN int send_length, IN int send_stride, */
/* 	IN int send_lengths[], IN int send_offsets[], */
/* 	OUT recv_vector[], IN int recv_length, IN int recv_stride, */
/* 	IN int recv_lengths[], IN int recv_offsets[], TYPE) */

/* send_vector: data to be scattered */
/* send_length: number of data items in send_vector of send_vector */
/* send_lengths: number of items process i should receive */
/* send_offsets: offset of data process i should receive */
/* recv_vector: data to be gathered */
/* recv_length: number of data items to be gathered */
/* recv_lengths: number of items to be received from process i */
/* recv_offsets: offset in recv_vector at which to store data from process i */

/* alltoall is essentially a combined scatter/gather where each process */
/* sends distinct data to each other process. */

/* Note that offsets should specify the source address with stride already */
/* accounted for.  length parameters should not  stride */
 int eco_alltoall(void* send_vector, int send_length, 
		       int send_stride,
	int* send_lens, int* send_offset,
	void* recv_vector, int recv_length, int recv_stride,
	int* recv_lens, int* recv_offset , int Arg_Type)
{
  int i,j;
  int recip, d_length, sender;
  int buffers[ECO_tree_child_count[ECO_ALL]+1];
  ECO_NEW_MTAG;

  for(i=0;i<=ECO_tree_child_count[ECO_ALL];i++)
    buffers[i] = pvm_mkbuf(PvmDataDefault);

  for(i=0;i<ECO_p;i++) {
    if(i!= ECO_myid) {
      pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][i]]);
      pvm_pkint(&i,1,1);
      pvm_pkint(&ECO_myid, 1, 1);
      pvm_pkint(send_lens+i, 1,1);
      
switch (Arg_Type) {
case Eco_Int:
  pvm_pkint(((int*)send_vector)+send_offset[i],send_lens[i],send_stride);
  break;
case Eco_Long:
  pvm_pklong(((long*)send_vector)+send_offset[i],send_lens[i],send_stride);
  break;
case Eco_Float:
  pvm_pkfloat(((float*)send_vector)+send_offset[i],send_lens[i],send_stride);
  break;
case Eco_Double:
  pvm_pkdouble(((double*)send_vector)+send_offset[i],send_lens[i],send_stride);
  break;
case Eco_Char:
  pvm_pkbyte(((char*)send_vector)+send_offset[i],send_lens[i],send_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    } 
    else /* i == ECO_myid*/ 
      for(j=0;j<recv_lens[i];j++)
	
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vector)[recv_offset[i]+j*recv_stride] = ((int*)send_vector)[send_offset[i]+j*send_stride];
  break;
case Eco_Long:
  ((long*)recv_vector)[recv_offset[i]+j*recv_stride] = ((long*)send_vector)[send_offset[i]+j*send_stride];
  break;
case Eco_Float:
  ((float*)recv_vector)[recv_offset[i]+j*recv_stride] = ((float*)send_vector)[send_offset[i]+j*send_stride];
  break;
case Eco_Double:
  ((double*)recv_vector)[recv_offset[i]+j*recv_stride] = ((double*)send_vector)[send_offset[i]+j*send_stride];
  break;
case Eco_Char:
  ((char*)recv_vector)[recv_offset[i]+j*recv_stride] = ((char*)send_vector)[send_offset[i]+j*send_stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_recv(-1, ECO_ALL2ALL_UP);
    pvm_upkint(&recip, 1, 1);
    while(recip!=-1){
      pvm_upkint(&sender, 1, 1);
      pvm_upkint(&d_length,1,1);
      if ( recip != ECO_myid) {
	double tmpt[d_length]; void* tmp = tmpt;
	
	
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)tmp,d_length,1);
  break;
case Eco_Long:
  pvm_upklong((long*)tmp,d_length,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)tmp,d_length,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)tmp,d_length,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)tmp,d_length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][recip]]);
	pvm_pkint(&recip, 1, 1);
	pvm_pkint(&sender, 1, 1);
	pvm_pkint(&d_length, 1, 1);
	
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp,d_length,1);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp,d_length,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp,d_length,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp,d_length,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp,d_length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      }
      else /* I am recip */
	
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Long:
  pvm_upklong(((long*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      
      pvm_upkint(&recip, 1, 1);
    }
  }
      
  if(ECO_tree_parent[ECO_ALL] != -1) {
    pvm_setsbuf(buffers[ECO_tree_child_count[ECO_ALL]]);
    i=-1;
    pvm_pkint(&i,1,1);
    pvm_send(ECO_tree_parent[ECO_ALL], ECO_ALL2ALL_UP);
    pvm_freebuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    pvm_recv(ECO_tree_parent[ECO_ALL], ECO_ALL2ALL_DOWN);

    pvm_upkint(&recip, 1, 1);
    while(recip!=-1){
      if(ECO_tree_desc_info[ECO_ALL][recip] == ECO_tree_child_count[ECO_ALL]
	 && recip!=ECO_myid) {
	printf ("error in routing\n");
	break;
      }
      pvm_upkint(&sender, 1, 1);
      pvm_upkint(&d_length,1,1);
      if ( recip != ECO_myid) {
	double tmpt[d_length]; void* tmp = tmpt;
	
	
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)tmp,d_length,1);
  break;
case Eco_Long:
  pvm_upklong((long*)tmp,d_length,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)tmp,d_length,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)tmp,d_length,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)tmp,d_length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][recip]]);
	pvm_pkint(&recip, 1, 1);
	pvm_pkint(&sender, 1, 1);
	pvm_pkint(&d_length, 1, 1);
	
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp,d_length,1);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp,d_length,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp,d_length,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp,d_length,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp,d_length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      }
      else /* I am recip */
	
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Long:
  pvm_upklong(((long*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)recv_vector)+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
     

      pvm_upkint(&recip, 1, 1);
    }
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_setsbuf(buffers[i]);
    recip=-1;
    pvm_pkint(&recip, 1, 1);
    pvm_send(ECO_tree_children[ECO_ALL][i], ECO_ALL2ALL_DOWN);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    pvm_freebuf(buffers[i]);

  return 0;
}

 int eco_alltoallv(int num_vect,
			void** send_vector, int send_length, 
		       int send_stride,
	int* send_lens, int* send_offset,
	void** recv_vector, int recv_length, int recv_stride,
	int* recv_lens, int* recv_offset , int Arg_Type)
{
  int i,j,v;
  int recip, d_length, sender;
  int buffers[ECO_tree_child_count[ECO_ALL]+1];
  ECO_NEW_MTAG;

  for(i=0;i<=ECO_tree_child_count[ECO_ALL];i++)
    buffers[i] = pvm_mkbuf(PvmDataDefault);

  for(i=0;i<ECO_p;i++) {
    if(i!= ECO_myid) {
      pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][i]]);
      pvm_pkint(&i,1,1);
      pvm_pkint(&ECO_myid, 1, 1);
      pvm_pkint(send_lens+i, 1,1);
      for(v=0;v<num_vect;v++)
	
switch (Arg_Type) {
case Eco_Int:
  pvm_pkint(((int*)send_vector[v])+send_offset[i],send_lens[i],send_stride);
  break;
case Eco_Long:
  pvm_pklong(((long*)send_vector[v])+send_offset[i],send_lens[i],send_stride);
  break;
case Eco_Float:
  pvm_pkfloat(((float*)send_vector[v])+send_offset[i],send_lens[i],send_stride);
  break;
case Eco_Double:
  pvm_pkdouble(((double*)send_vector[v])+send_offset[i],send_lens[i],send_stride);
  break;
case Eco_Char:
  pvm_pkbyte(((char*)send_vector[v])+send_offset[i],send_lens[i],send_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    } 
    else /* i == ECO_myid*/ 
      for(v=0;v<num_vect;v++)
	for(j=0;j<recv_lens[i];j++)
	  
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vector[v])[recv_offset[i]+j*recv_stride] = ((int*)send_vector[v])[send_offset[i]+j*send_stride];
  break;
case Eco_Long:
  ((long*)recv_vector[v])[recv_offset[i]+j*recv_stride] = ((long*)send_vector[v])[send_offset[i]+j*send_stride];
  break;
case Eco_Float:
  ((float*)recv_vector[v])[recv_offset[i]+j*recv_stride] = ((float*)send_vector[v])[send_offset[i]+j*send_stride];
  break;
case Eco_Double:
  ((double*)recv_vector[v])[recv_offset[i]+j*recv_stride] = ((double*)send_vector[v])[send_offset[i]+j*send_stride];
  break;
case Eco_Char:
  ((char*)recv_vector[v])[recv_offset[i]+j*recv_stride] = ((char*)send_vector[v])[send_offset[i]+j*send_stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_recv(-1, ECO_ALL2ALL_UP);
    pvm_upkint(&recip, 1, 1);
    while(recip!=-1){
      pvm_upkint(&sender, 1, 1);
      pvm_upkint(&d_length,1,1);
      if ( recip != ECO_myid) {
	double tmpt[d_length]; void* tmp = tmpt;

	pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][recip]]);
	pvm_pkint(&recip, 1, 1);
	pvm_pkint(&sender, 1, 1);
	pvm_pkint(&d_length, 1, 1);

	for(v=0;v<num_vect;v++) {
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)tmp,d_length,1);
  break;
case Eco_Long:
  pvm_upklong((long*)tmp,d_length,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)tmp,d_length,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)tmp,d_length,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)tmp,d_length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp,d_length,1);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp,d_length,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp,d_length,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp,d_length,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp,d_length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	}
      }
      else /* I am recip */
	for(v=0;v<num_vect;v++)
	  
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Long:
  pvm_upklong(((long*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      
      pvm_upkint(&recip, 1, 1);
    }
  }
      
  if(ECO_tree_parent[ECO_ALL] != -1) {
    pvm_setsbuf(buffers[ECO_tree_child_count[ECO_ALL]]);
    i=-1;
    pvm_pkint(&i,1,1);
    pvm_send(ECO_tree_parent[ECO_ALL], ECO_ALL2ALL_UP);
    pvm_freebuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    pvm_recv(ECO_tree_parent[ECO_ALL], ECO_ALL2ALL_DOWN);

    pvm_upkint(&recip, 1, 1);
    while(recip!=-1){
      if(ECO_tree_desc_info[ECO_ALL][recip] == ECO_tree_child_count[ECO_ALL]
	 && recip!=ECO_myid) {
	printf ("error in routing\n");
	break;
      }
      pvm_upkint(&sender, 1, 1);
      pvm_upkint(&d_length,1,1);
      if ( recip != ECO_myid) {
	double tmpt[d_length]; void* tmp = tmpt;
	pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][recip]]);
	pvm_pkint(&recip, 1, 1);
	pvm_pkint(&sender, 1, 1);
	pvm_pkint(&d_length, 1, 1);

	for(v=0;v<num_vect;v++) {
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)tmp,d_length,1);
  break;
case Eco_Long:
  pvm_upklong((long*)tmp,d_length,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)tmp,d_length,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)tmp,d_length,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)tmp,d_length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp,d_length,1);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp,d_length,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp,d_length,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp,d_length,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp,d_length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	}
      }
      else /* I am recip */
	for(v=0;v<num_vect;v++)
	  
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Long:
  pvm_upklong(((long*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)recv_vector[v])+recv_offset[sender],recv_lens[sender],recv_stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
     

      pvm_upkint(&recip, 1, 1);
    }
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_setsbuf(buffers[i]);
    recip=-1;
    pvm_pkint(&recip, 1, 1);
    pvm_send(ECO_tree_children[ECO_ALL][i], ECO_ALL2ALL_DOWN);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    pvm_freebuf(buffers[i]);

  return 0;
}
  
    
    
    



/* eco_reduce(IN send_vector[], IN int length, IN int stride, */
/* 	   OUT recv_vector[],  */
/* 	   IN OP_TYPE operation, IN int root, TYPE) */

/* send_vector: local contribution of data */
/* length: number of data items in send_vector and recv_vector */
/* stride: stride of send_vector and recv_vector */
/* recv_vector: result (root) */
/* operation: operation type */
/* root: receiving process or ALL */

/* reduce does operation across all copies of send_vector.  This operation is */
/* elementwise, so recv_vector[i] = OPERATION across all send_vector[i]. */

/* the length parameter should not reflect stride */

 int eco_reduce(void* send_vect, int length, int stride,
		      void* recv_vect, int red_opr, int root
		      , int Arg_Type)
{
  int i,j;
  double tmp_data_at[length*stride]; void* tmp_data_a = tmp_data_at;
  double buffert[length*stride]; void* buffer = buffert;
  void* tmp_data = tmp_data_a;
  ECO_NEW_MTAG;
  
  if((root == ECO_myid) || (root == ECO_ALL)) 
    tmp_data = recv_vect;
  
  if (send_vect != tmp_data)
    for(i=0;i<length;i++)
      
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp_data)[i*stride] = ((int*)send_vect)[i*stride];
  break;
case Eco_Long:
  ((long*)tmp_data)[i*stride] = ((long*)send_vect)[i*stride];
  break;
case Eco_Float:
  ((float*)tmp_data)[i*stride] = ((float*)send_vect)[i*stride];
  break;
case Eco_Double:
  ((double*)tmp_data)[i*stride] = ((double*)send_vect)[i*stride];
  break;
case Eco_Char:
  ((char*)tmp_data)[i*stride] = ((char*)send_vect)[i*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
  
  for (i=0;i<ECO_tree_child_count[root];i++) {
    pvm_recv(-1,ECO_RV_UP);
    
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)buffer,length,stride);
  break;
case Eco_Long:
  pvm_upklong((long*)buffer,length,stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)buffer,length,stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)buffer,length,stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)buffer,length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    
    
    if(red_opr<ECO_user_func_start || stride==1){
	    
switch(Arg_Type) {
	case Eco_Int:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)tmp_data)[j*stride]+=((int*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)tmp_data)[j*stride]*=((int*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)tmp_data)[j*stride]=max(((int*)buffer)[j*stride], ((int*)tmp_data)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)tmp_data)[j*stride]=min(((int*)buffer)[j*stride],((int*)tmp_data)[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)tmp_data)[j*stride]+=((long*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)tmp_data)[j*stride]*=((long*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)tmp_data)[j*stride]=max(((long*)buffer)[j*stride], ((long*)tmp_data)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)tmp_data)[j*stride]=min(((long*)buffer)[j*stride],((long*)tmp_data)[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)tmp_data)[j*stride]+=((double*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)tmp_data)[j*stride]*=((double*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)tmp_data)[j*stride]=max(((double*)buffer)[j*stride], ((double*)tmp_data)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)tmp_data)[j*stride]=min(((double*)buffer)[j*stride],((double*)tmp_data)[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)tmp_data)[j*stride]+=((float*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)tmp_data)[j*stride]*=((float*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)tmp_data)[j*stride]=max(((float*)buffer)[j*stride], ((float*)tmp_data)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)tmp_data)[j*stride]=min(((float*)buffer)[j*stride],((float*)tmp_data)[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)tmp_data)[j*stride]+=((char*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)tmp_data)[j*stride]*=((char*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)tmp_data)[j*stride]=max(((char*)buffer)[j*stride], ((char*)tmp_data)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)tmp_data)[j*stride]=min(((char*)buffer)[j*stride],((char*)tmp_data)[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};
    }
	  else{
	    double tmp1t[length]; void* tmp1 = tmp1t;
	    double tmp2t[length]; void* tmp2 = tmp2t;

	    for(j=0;j<length;j++){
	      
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp1)[j] = ((int*)tmp_data)[j*stride];
  break;
case Eco_Long:
  ((long*)tmp1)[j] = ((long*)tmp_data)[j*stride];
  break;
case Eco_Float:
  ((float*)tmp1)[j] = ((float*)tmp_data)[j*stride];
  break;
case Eco_Double:
  ((double*)tmp1)[j] = ((double*)tmp_data)[j*stride];
  break;
case Eco_Char:
  ((char*)tmp1)[j] = ((char*)tmp_data)[j*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	      
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp2)[j] = ((int*)buffer)[j*stride];
  break;
case Eco_Long:
  ((long*)tmp2)[j] = ((long*)buffer)[j*stride];
  break;
case Eco_Float:
  ((float*)tmp2)[j] = ((float*)buffer)[j*stride];
  break;
case Eco_Double:
  ((double*)tmp2)[j] = ((double*)buffer)[j*stride];
  break;
case Eco_Char:
  ((char*)tmp2)[j] = ((char*)buffer)[j*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
            }

	    
switch(Arg_Type) {
	case Eco_Int:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)tmp1)[j]+=((int*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)tmp1)[j]*=((int*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)tmp1)[j]=max(((int*)tmp2)[j], ((int*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)tmp1)[j]=min(((int*)tmp2)[j],((int*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)tmp1)[j]+=((long*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)tmp1)[j]*=((long*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)tmp1)[j]=max(((long*)tmp2)[j], ((long*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)tmp1)[j]=min(((long*)tmp2)[j],((long*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)tmp1)[j]+=((double*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)tmp1)[j]*=((double*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)tmp1)[j]=max(((double*)tmp2)[j], ((double*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)tmp1)[j]=min(((double*)tmp2)[j],((double*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)tmp1)[j]+=((float*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)tmp1)[j]*=((float*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)tmp1)[j]=max(((float*)tmp2)[j], ((float*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)tmp1)[j]=min(((float*)tmp2)[j],((float*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)tmp1)[j]+=((char*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)tmp1)[j]*=((char*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)tmp1)[j]=max(((char*)tmp2)[j], ((char*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)tmp1)[j]=min(((char*)tmp2)[j],((char*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};
           
            for(j=0;j<length;j++)
	      
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp_data)[j*stride] = ((int*)tmp1)[j];
  break;
case Eco_Long:
  ((long*)tmp_data)[j*stride] = ((long*)tmp1)[j];
  break;
case Eco_Float:
  ((float*)tmp_data)[j*stride] = ((float*)tmp1)[j];
  break;
case Eco_Double:
  ((double*)tmp_data)[j*stride] = ((double*)tmp1)[j];
  break;
case Eco_Char:
  ((char*)tmp_data)[j*stride] = ((char*)tmp1)[j];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

	  }


  }
  
  
  if(ECO_tree_parent[root] != -1) {
    pvm_initsend(PvmDataDefault);
    
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp_data,length,stride);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp_data,length,stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp_data,length,stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp_data,length,stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp_data,length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    
    pvm_send(ECO_tree_parent[root], ECO_RV_UP);
  }
  
  if(root == ECO_ALL) {
    if(ECO_tree_parent[root] != -1) {
      pvm_recv(ECO_tree_parent[root], ECO_RV_DOWN);
      pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
      
      
    }
    else {
      pvm_initsend(PvmDataDefault);
      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)recv_vect,length,stride);
  break;
case Eco_Long:
  pvm_pklong((long*)recv_vect,length,stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)recv_vect,length,stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)recv_vect,length,stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)recv_vect,length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }
    
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i],ECO_RV_DOWN);
    
    if(ECO_tree_parent[root] != -1) {
      pvm_freebuf(pvm_setrbuf(pvm_getsbuf()));
      
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)recv_vect,length,stride);
  break;
case Eco_Long:
  pvm_upklong((long*)recv_vect,length,stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)recv_vect,length,stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)recv_vect,length,stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)recv_vect,length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }
    
    
  }
  
  return 0;
}


 int eco_reducev(int num_vect,
		      void** send_vect, int length, int stride,
		      void** recv_vect, int red_opr, int root
		      , int Arg_Type)
{
  int i,j,v;
  double buffert[length*stride]; void* buffer = buffert;
 void** tmp_data;void**tmp_datat;
  tmp_data = (void**)malloc(num_vect*sizeof(void*));
  for(i=0;i<num_vect;i++)
    tmp_data[i]=(void*)malloc(length*stride*sizeof(double));
  tmp_datat=tmp_data;

  ECO_NEW_MTAG;
  
  if((root == ECO_myid) || (root == ECO_ALL)) 
    tmp_data = recv_vect;
  
  if (send_vect != tmp_data)
    for(v=0;v<num_vect;v++)
      for(i=0;i<length;i++)
	
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp_data[v])[i*stride] = ((int*)send_vect[v])[i*stride];
  break;
case Eco_Long:
  ((long*)tmp_data[v])[i*stride] = ((long*)send_vect[v])[i*stride];
  break;
case Eco_Float:
  ((float*)tmp_data[v])[i*stride] = ((float*)send_vect[v])[i*stride];
  break;
case Eco_Double:
  ((double*)tmp_data[v])[i*stride] = ((double*)send_vect[v])[i*stride];
  break;
case Eco_Char:
  ((char*)tmp_data[v])[i*stride] = ((char*)send_vect[v])[i*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
  
  for (i=0;i<ECO_tree_child_count[root];i++) {
    pvm_recv(-1,ECO_RV_UP);

    for(v=0;v<num_vect;v++) {
      
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)buffer,length,stride);
  break;
case Eco_Long:
  pvm_upklong((long*)buffer,length,stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)buffer,length,stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)buffer,length,stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)buffer,length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    
	  if((red_opr<ECO_user_func_start) || (stride==1)){
	    
switch(Arg_Type) {
	case Eco_Int:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)tmp_data[v])[j*stride]+=((int*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)tmp_data[v])[j*stride]*=((int*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)tmp_data[v])[j*stride]=max(((int*)buffer)[j*stride], ((int*)tmp_data[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)tmp_data[v])[j*stride]=min(((int*)buffer)[j*stride],((int*)tmp_data[v])[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data[v],length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)tmp_data[v])[j*stride]+=((long*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)tmp_data[v])[j*stride]*=((long*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)tmp_data[v])[j*stride]=max(((long*)buffer)[j*stride], ((long*)tmp_data[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)tmp_data[v])[j*stride]=min(((long*)buffer)[j*stride],((long*)tmp_data[v])[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data[v],length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)tmp_data[v])[j*stride]+=((double*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)tmp_data[v])[j*stride]*=((double*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)tmp_data[v])[j*stride]=max(((double*)buffer)[j*stride], ((double*)tmp_data[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)tmp_data[v])[j*stride]=min(((double*)buffer)[j*stride],((double*)tmp_data[v])[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data[v],length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)tmp_data[v])[j*stride]+=((float*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)tmp_data[v])[j*stride]*=((float*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)tmp_data[v])[j*stride]=max(((float*)buffer)[j*stride], ((float*)tmp_data[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)tmp_data[v])[j*stride]=min(((float*)buffer)[j*stride],((float*)tmp_data[v])[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data[v],length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)tmp_data[v])[j*stride]+=((char*)buffer)[j*stride];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)tmp_data[v])[j*stride]*=((char*)buffer)[j*stride];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)tmp_data[v])[j*stride]=max(((char*)buffer)[j*stride], ((char*)tmp_data[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)tmp_data[v])[j*stride]=min(((char*)buffer)[j*stride],((char*)tmp_data[v])[j*stride]);
	  break;
	default:
          eco_oper_list[red_opr](buffer,tmp_data[v],length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};
          }
	  else{
	    double tmp1t[length]; void* tmp1 = tmp1t;
	    double tmp2t[length]; void* tmp2 = tmp2t;

	    for(j=0;j<length;j++){
	      
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp1)[j] = ((int*)tmp_data[v])[j*stride];
  break;
case Eco_Long:
  ((long*)tmp1)[j] = ((long*)tmp_data[v])[j*stride];
  break;
case Eco_Float:
  ((float*)tmp1)[j] = ((float*)tmp_data[v])[j*stride];
  break;
case Eco_Double:
  ((double*)tmp1)[j] = ((double*)tmp_data[v])[j*stride];
  break;
case Eco_Char:
  ((char*)tmp1)[j] = ((char*)tmp_data[v])[j*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	      
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp2)[j] = ((int*)buffer)[j*stride];
  break;
case Eco_Long:
  ((long*)tmp2)[j] = ((long*)buffer)[j*stride];
  break;
case Eco_Float:
  ((float*)tmp2)[j] = ((float*)buffer)[j*stride];
  break;
case Eco_Double:
  ((double*)tmp2)[j] = ((double*)buffer)[j*stride];
  break;
case Eco_Char:
  ((char*)tmp2)[j] = ((char*)buffer)[j*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
            }

	    
switch(Arg_Type) {
	case Eco_Int:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)tmp1)[j]+=((int*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)tmp1)[j]*=((int*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)tmp1)[j]=max(((int*)tmp2)[j], ((int*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)tmp1)[j]=min(((int*)tmp2)[j],((int*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)tmp1)[j]+=((long*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)tmp1)[j]*=((long*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)tmp1)[j]=max(((long*)tmp2)[j], ((long*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)tmp1)[j]=min(((long*)tmp2)[j],((long*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)tmp1)[j]+=((double*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)tmp1)[j]*=((double*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)tmp1)[j]=max(((double*)tmp2)[j], ((double*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)tmp1)[j]=min(((double*)tmp2)[j],((double*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)tmp1)[j]+=((float*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)tmp1)[j]*=((float*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)tmp1)[j]=max(((float*)tmp2)[j], ((float*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)tmp1)[j]=min(((float*)tmp2)[j],((float*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (red_opr) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)tmp1)[j]+=((char*)tmp2)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)tmp1)[j]*=((char*)tmp2)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)tmp1)[j]=max(((char*)tmp2)[j], ((char*)tmp1)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)tmp1)[j]=min(((char*)tmp2)[j],((char*)tmp1)[j]);
	  break;
	default:
          eco_oper_list[red_opr](tmp2,tmp1,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};
           
            for(j=0;j<length;j++)
	      
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp_data[v])[j*stride] = ((int*)tmp1)[j];
  break;
case Eco_Long:
  ((long*)tmp_data[v])[j*stride] = ((long*)tmp1)[j];
  break;
case Eco_Float:
  ((float*)tmp_data[v])[j*stride] = ((float*)tmp1)[j];
  break;
case Eco_Double:
  ((double*)tmp_data[v])[j*stride] = ((double*)tmp1)[j];
  break;
case Eco_Char:
  ((char*)tmp_data[v])[j*stride] = ((char*)tmp1)[j];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

	  }
    }
  }

  
  
  if(ECO_tree_parent[root] != -1) {
    pvm_initsend(PvmDataDefault);
    for(v=0;v<num_vect;v++)
      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp_data[v],length,stride);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp_data[v],length,stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp_data[v],length,stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp_data[v],length,stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp_data[v],length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    
    pvm_send(ECO_tree_parent[root], ECO_RV_UP);
  }
  
  if(root == ECO_ALL) {
    if(ECO_tree_parent[root] != -1) {
      pvm_recv(ECO_tree_parent[root], ECO_RV_DOWN);
      pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
      
      
    }
    else {
      pvm_initsend(PvmDataDefault);
      for(v=0;v<num_vect;v++)
	
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)recv_vect[v],length,stride);
  break;
case Eco_Long:
  pvm_pklong((long*)recv_vect[v],length,stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)recv_vect[v],length,stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)recv_vect[v],length,stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)recv_vect[v],length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }
    
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i],ECO_RV_DOWN);
    
    if(ECO_tree_parent[root] != -1) {
      pvm_freebuf(pvm_setrbuf(pvm_getsbuf()));
      for(v=0;v<num_vect;v++)
	
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)recv_vect[v],length,stride);
  break;
case Eco_Long:
  pvm_upklong((long*)recv_vect[v],length,stride);
  break;
case Eco_Float:
  pvm_upkfloat((float*)recv_vect[v],length,stride);
  break;
case Eco_Double:
  pvm_upkdouble((double*)recv_vect[v],length,stride);
  break;
case Eco_Char:
  pvm_upkbyte((char*)recv_vect[v],length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }
    
    
  }

  for(i=0;i<num_vect;i++)
    free(tmp_datat[i]);
  free(tmp_datat);
  
  return 0;
}


/*    eco_scan(IN send_vector[], IN int length, IN int stride */
/*    OUT recv_vector[], IN OP_TYPE operation, TYPE) */
   
/*    send_vector: local contribution of data */
/*    length: number of data items in send_vector and recv_vector */
/*    stride: stride of send_vector and recv_vector */
/*    recv_vector: operation performed on first 0..i contributions */
/*    operation: operation to do on send_vector */
   
/*    scan implements an inclusive scan, such that the vector returned to  */
/*    process i is the result of applying operation to send_vector from */
/*    processes 0..i.   */
 int eco_scan(void* send_vector, int length, int stride,
		    void* recv_vector, int oper , int Arg_Type)
{
  int i,j;
  int from;
  double tmpt[length*stride]; void* tmp = tmpt;
  int buffers[ECO_tree_child_count[ECO_ALL]+1];
  ECO_NEW_MTAG;

  for(i=0;i<=ECO_tree_child_count[ECO_ALL];i++)
    buffers[i] = pvm_mkbuf(PvmDataDefault);

      
  for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
    if(ECO_myid < ECO_tree_desc_max[ECO_ALL][j]) {
      pvm_setsbuf(buffers[j]);
      pvm_pkint(&ECO_myid, 1, 1);
      
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)send_vector,length,stride);
  break;
case Eco_Long:
  pvm_pklong((long*)send_vector,length,stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)send_vector,length,stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)send_vector,length,stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)send_vector,length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }

  if(recv_vector != send_vector)
    for(i=0;i<length;i++)
      
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vector)[i*stride] = ((int*)send_vector)[i*stride];
  break;
case Eco_Long:
  ((long*)recv_vector)[i*stride] = ((long*)send_vector)[i*stride];
  break;
case Eco_Float:
  ((float*)recv_vector)[i*stride] = ((float*)send_vector)[i*stride];
  break;
case Eco_Double:
  ((double*)recv_vector)[i*stride] = ((double*)send_vector)[i*stride];
  break;
case Eco_Char:
  ((char*)recv_vector)[i*stride] = ((char*)send_vector)[i*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++){
    pvm_recv(ECO_tree_children[ECO_ALL][i], ECO_SCAN_UP);

    pvm_upkint(&from, 1, 1);

    while(from != -1) {
      
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)tmp,length,1);
  break;
case Eco_Long:
  pvm_upklong((long*)tmp,length,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)tmp,length,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)tmp,length,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)tmp,length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      
    if(from < ECO_myid){
      if(oper<ECO_user_func_start || stride==1){
         
switch(Arg_Type) {
	case Eco_Int:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector)[j*stride]+=((int*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector)[j*stride]*=((int*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector)[j*stride]=max(((int*)tmp)[j], ((int*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector)[j*stride]=min(((int*)tmp)[j],((int*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector)[j*stride]+=((long*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector)[j*stride]*=((long*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector)[j*stride]=max(((long*)tmp)[j], ((long*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector)[j*stride]=min(((long*)tmp)[j],((long*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector)[j*stride]+=((double*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector)[j*stride]*=((double*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector)[j*stride]=max(((double*)tmp)[j], ((double*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector)[j*stride]=min(((double*)tmp)[j],((double*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector)[j*stride]+=((float*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector)[j*stride]*=((float*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector)[j*stride]=max(((float*)tmp)[j], ((float*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector)[j*stride]=min(((float*)tmp)[j],((float*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector)[j*stride]+=((char*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector)[j*stride]*=((char*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector)[j*stride]=max(((char*)tmp)[j], ((char*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector)[j*stride]=min(((char*)tmp)[j],((char*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};
         }
	  else{
	    double tmp2t[length]; void* tmp2 = tmp2t;

	    for(j=0;j<length;j++)
              
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp2)[j] = ((int*)recv_vector)[j*stride];
  break;
case Eco_Long:
  ((long*)tmp2)[j] = ((long*)recv_vector)[j*stride];
  break;
case Eco_Float:
  ((float*)tmp2)[j] = ((float*)recv_vector)[j*stride];
  break;
case Eco_Double:
  ((double*)tmp2)[j] = ((double*)recv_vector)[j*stride];
  break;
case Eco_Char:
  ((char*)tmp2)[j] = ((char*)recv_vector)[j*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

	    
switch(Arg_Type) {
	case Eco_Int:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]+=((int*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]*=((int*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]=max(((int*)tmp)[j], ((int*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]=min(((int*)tmp)[j],((int*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]+=((long*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]*=((long*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]=max(((long*)tmp)[j], ((long*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]=min(((long*)tmp)[j],((long*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]+=((double*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]*=((double*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]=max(((double*)tmp)[j], ((double*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]=min(((double*)tmp)[j],((double*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]+=((float*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]*=((float*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]=max(((float*)tmp)[j], ((float*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]=min(((float*)tmp)[j],((float*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]+=((char*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]*=((char*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]=max(((char*)tmp)[j], ((char*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]=min(((char*)tmp)[j],((char*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};

	    for(j=0;j<length;j++)
              
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vector)[j*stride] = ((int*)tmp2)[j];
  break;
case Eco_Long:
  ((long*)recv_vector)[j*stride] = ((long*)tmp2)[j];
  break;
case Eco_Float:
  ((float*)recv_vector)[j*stride] = ((float*)tmp2)[j];
  break;
case Eco_Double:
  ((double*)recv_vector)[j*stride] = ((double*)tmp2)[j];
  break;
case Eco_Char:
  ((char*)recv_vector)[j*stride] = ((char*)tmp2)[j];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
      }
      
       for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
	if((from < ECO_tree_desc_max[ECO_ALL][j]) &&
	   (ECO_tree_desc_info[ECO_ALL][from] != j)){
	  pvm_setsbuf(buffers[j]);
	  pvm_pkint(&from, 1, 1);
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp,length,1);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp,length,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp,length,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp,length,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp,length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	}
      
      pvm_upkint(&from, 1, 1);

    }
  }

  if(ECO_tree_parent[ECO_ALL]!=-1) {
    pvm_setsbuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    from = -1;
    pvm_pkint(&from,1,1);

    pvm_send(ECO_tree_parent[ECO_ALL], ECO_SCAN_UP);
    pvm_freebuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    pvm_recv(ECO_tree_parent[ECO_ALL], ECO_SCAN_DOWN);

    pvm_upkint(&from, 1, 1);

    while(from != -1) {
      
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)tmp,length,1);
  break;
case Eco_Long:
  pvm_upklong((long*)tmp,length,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)tmp,length,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)tmp,length,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)tmp,length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      
      if(from < ECO_myid) {

	  if(oper<ECO_user_func_start || stride==1){
	    
switch(Arg_Type) {
	case Eco_Int:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector)[j*stride]+=((int*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector)[j*stride]*=((int*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector)[j*stride]=max(((int*)tmp)[j], ((int*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector)[j*stride]=min(((int*)tmp)[j],((int*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector)[j*stride]+=((long*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector)[j*stride]*=((long*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector)[j*stride]=max(((long*)tmp)[j], ((long*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector)[j*stride]=min(((long*)tmp)[j],((long*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector)[j*stride]+=((double*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector)[j*stride]*=((double*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector)[j*stride]=max(((double*)tmp)[j], ((double*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector)[j*stride]=min(((double*)tmp)[j],((double*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector)[j*stride]+=((float*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector)[j*stride]*=((float*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector)[j*stride]=max(((float*)tmp)[j], ((float*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector)[j*stride]=min(((float*)tmp)[j],((float*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector)[j*stride]+=((char*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector)[j*stride]*=((char*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector)[j*stride]=max(((char*)tmp)[j], ((char*)recv_vector)[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector)[j*stride]=min(((char*)tmp)[j],((char*)recv_vector)[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};
          }
	  else{
	    double tmp2t[length]; void* tmp2 = tmp2t;

	    for(j=0;j<length;j++)
              
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp2)[j] = ((int*)recv_vector)[j*stride];
  break;
case Eco_Long:
  ((long*)tmp2)[j] = ((long*)recv_vector)[j*stride];
  break;
case Eco_Float:
  ((float*)tmp2)[j] = ((float*)recv_vector)[j*stride];
  break;
case Eco_Double:
  ((double*)tmp2)[j] = ((double*)recv_vector)[j*stride];
  break;
case Eco_Char:
  ((char*)tmp2)[j] = ((char*)recv_vector)[j*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

	    
switch(Arg_Type) {
	case Eco_Int:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]+=((int*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]*=((int*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]=max(((int*)tmp)[j], ((int*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]=min(((int*)tmp)[j],((int*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]+=((long*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]*=((long*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]=max(((long*)tmp)[j], ((long*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]=min(((long*)tmp)[j],((long*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]+=((double*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]*=((double*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]=max(((double*)tmp)[j], ((double*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]=min(((double*)tmp)[j],((double*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]+=((float*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]*=((float*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]=max(((float*)tmp)[j], ((float*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]=min(((float*)tmp)[j],((float*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]+=((char*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]*=((char*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]=max(((char*)tmp)[j], ((char*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]=min(((char*)tmp)[j],((char*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};

	    for(j=0;j<length;j++)
              
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vector)[j*stride] = ((int*)tmp2)[j];
  break;
case Eco_Long:
  ((long*)recv_vector)[j*stride] = ((long*)tmp2)[j];
  break;
case Eco_Float:
  ((float*)recv_vector)[j*stride] = ((float*)tmp2)[j];
  break;
case Eco_Double:
  ((double*)recv_vector)[j*stride] = ((double*)tmp2)[j];
  break;
case Eco_Char:
  ((char*)recv_vector)[j*stride] = ((char*)tmp2)[j];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
      }

      for(j=0;j<ECO_tree_child_count[ECO_ALL];j++)
	if(from < ECO_tree_desc_max[ECO_ALL][j]) {
	  pvm_setsbuf(buffers[j]);
	  pvm_pkint(&from, 1, 1);
	  
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp,length,1);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp,length,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp,length,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp,length,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp,length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	}
      
      pvm_upkint(&from, 1, 1);
    }
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_setsbuf(buffers[i]);
    from = -1;
    pvm_pkint(&from,1,1);
    pvm_send(ECO_tree_children[ECO_ALL][i], ECO_SCAN_DOWN);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    pvm_freebuf(buffers[i]);

  return 0;

}

 int eco_scanv(int num_vect,
		    void** send_vector, int length, int stride,
		    void** recv_vector, int oper , int Arg_Type)
{
  int i,j,v;
  int from;
  double tmpt[length*stride]; void* tmp = tmpt;
  int buffers[ECO_tree_child_count[ECO_ALL]+1];
  ECO_NEW_MTAG;

  for(i=0;i<=ECO_tree_child_count[ECO_ALL];i++)
    buffers[i] = pvm_mkbuf(PvmDataDefault);

      
  for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
    if(ECO_myid < ECO_tree_desc_max[ECO_ALL][j]) {
      pvm_setsbuf(buffers[j]);
      pvm_pkint(&ECO_myid, 1, 1);
      for(v=0;v<num_vect;v++)
	
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)send_vector[v],length,stride);
  break;
case Eco_Long:
  pvm_pklong((long*)send_vector[v],length,stride);
  break;
case Eco_Float:
  pvm_pkfloat((float*)send_vector[v],length,stride);
  break;
case Eco_Double:
  pvm_pkdouble((double*)send_vector[v],length,stride);
  break;
case Eco_Char:
  pvm_pkbyte((char*)send_vector[v],length,stride);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
    }

  if(recv_vector != send_vector)
    for(v=0;v<num_vect;v++)
      for(i=0;i<length;i++)
	
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vector[v])[i*stride] = ((int*)send_vector[v])[i*stride];
  break;
case Eco_Long:
  ((long*)recv_vector[v])[i*stride] = ((long*)send_vector[v])[i*stride];
  break;
case Eco_Float:
  ((float*)recv_vector[v])[i*stride] = ((float*)send_vector[v])[i*stride];
  break;
case Eco_Double:
  ((double*)recv_vector[v])[i*stride] = ((double*)send_vector[v])[i*stride];
  break;
case Eco_Char:
  ((char*)recv_vector[v])[i*stride] = ((char*)send_vector[v])[i*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++){
    pvm_recv(ECO_tree_children[ECO_ALL][i], ECO_SCAN_UP);

    pvm_upkint(&from, 1, 1);

    while(from != -1) {
      for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
	if((from < ECO_tree_desc_max[ECO_ALL][j]) &&
	   (ECO_tree_desc_info[ECO_ALL][from] != j)){
	  pvm_setsbuf(buffers[j]);
	  pvm_pkint(&from, 1, 1);
	}

      for(v=0;v<num_vect;v++) {
	
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)tmp,length,1);
  break;
case Eco_Long:
  pvm_upklong((long*)tmp,length,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)tmp,length,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)tmp,length,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)tmp,length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	
	if(from < ECO_myid){
	  if(oper<ECO_user_func_start || stride==1){
	    
switch(Arg_Type) {
	case Eco_Int:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector[v])[j*stride]+=((int*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector[v])[j*stride]*=((int*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector[v])[j*stride]=max(((int*)tmp)[j], ((int*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector[v])[j*stride]=min(((int*)tmp)[j],((int*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector[v])[j*stride]+=((long*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector[v])[j*stride]*=((long*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector[v])[j*stride]=max(((long*)tmp)[j], ((long*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector[v])[j*stride]=min(((long*)tmp)[j],((long*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector[v])[j*stride]+=((double*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector[v])[j*stride]*=((double*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector[v])[j*stride]=max(((double*)tmp)[j], ((double*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector[v])[j*stride]=min(((double*)tmp)[j],((double*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector[v])[j*stride]+=((float*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector[v])[j*stride]*=((float*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector[v])[j*stride]=max(((float*)tmp)[j], ((float*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector[v])[j*stride]=min(((float*)tmp)[j],((float*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector[v])[j*stride]+=((char*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector[v])[j*stride]*=((char*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector[v])[j*stride]=max(((char*)tmp)[j], ((char*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector[v])[j*stride]=min(((char*)tmp)[j],((char*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};
          }
	  else{
	    double tmp2t[length]; void* tmp2 = tmp2t;

	    for(j=0;j<length;j++)
              
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp2)[j] = ((int*)recv_vector[v])[j*stride];
  break;
case Eco_Long:
  ((long*)tmp2)[j] = ((long*)recv_vector[v])[j*stride];
  break;
case Eco_Float:
  ((float*)tmp2)[j] = ((float*)recv_vector[v])[j*stride];
  break;
case Eco_Double:
  ((double*)tmp2)[j] = ((double*)recv_vector[v])[j*stride];
  break;
case Eco_Char:
  ((char*)tmp2)[j] = ((char*)recv_vector[v])[j*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

	    
switch(Arg_Type) {
	case Eco_Int:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]+=((int*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]*=((int*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]=max(((int*)tmp)[j], ((int*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]=min(((int*)tmp)[j],((int*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]+=((long*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]*=((long*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]=max(((long*)tmp)[j], ((long*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]=min(((long*)tmp)[j],((long*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]+=((double*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]*=((double*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]=max(((double*)tmp)[j], ((double*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]=min(((double*)tmp)[j],((double*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]+=((float*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]*=((float*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]=max(((float*)tmp)[j], ((float*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]=min(((float*)tmp)[j],((float*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]+=((char*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]*=((char*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]=max(((char*)tmp)[j], ((char*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]=min(((char*)tmp)[j],((char*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};

	    for(j=0;j<length;j++)
              
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vector[v])[j*stride] = ((int*)tmp2)[j];
  break;
case Eco_Long:
  ((long*)recv_vector[v])[j*stride] = ((long*)tmp2)[j];
  break;
case Eco_Float:
  ((float*)recv_vector[v])[j*stride] = ((float*)tmp2)[j];
  break;
case Eco_Double:
  ((double*)recv_vector[v])[j*stride] = ((double*)tmp2)[j];
  break;
case Eco_Char:
  ((char*)recv_vector[v])[j*stride] = ((char*)tmp2)[j];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
	}
	
	for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
	  if((from < ECO_tree_desc_max[ECO_ALL][j]) &&
	     (ECO_tree_desc_info[ECO_ALL][from] != j)){
	    pvm_setsbuf(buffers[j]);
	    
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp,length,1);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp,length,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp,length,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp,length,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp,length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
      }
      pvm_upkint(&from, 1, 1);

    }
  }

  if(ECO_tree_parent[ECO_ALL]!=-1) {
    pvm_setsbuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    from = -1;
    pvm_pkint(&from,1,1);

    pvm_send(ECO_tree_parent[ECO_ALL], ECO_SCAN_UP);
    pvm_freebuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    pvm_recv(ECO_tree_parent[ECO_ALL], ECO_SCAN_DOWN);

    pvm_upkint(&from, 1, 1);

    while(from != -1) {
      for(j=0;j<ECO_tree_child_count[ECO_ALL];j++)
	if(from < ECO_tree_desc_max[ECO_ALL][j]) {
	  pvm_setsbuf(buffers[j]);
	  pvm_pkint(&from, 1, 1);
	}

      for(v=0;v<num_vect;v++) {
	
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)tmp,length,1);
  break;
case Eco_Long:
  pvm_upklong((long*)tmp,length,1);
  break;
case Eco_Float:
  pvm_upkfloat((float*)tmp,length,1);
  break;
case Eco_Double:
  pvm_upkdouble((double*)tmp,length,1);
  break;
case Eco_Char:
  pvm_upkbyte((char*)tmp,length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
      
	if(from < ECO_myid) {

		
	  if(oper<ECO_user_func_start || stride==1){
	    
switch(Arg_Type) {
	case Eco_Int:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector[v])[j*stride]+=((int*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector[v])[j*stride]*=((int*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector[v])[j*stride]=max(((int*)tmp)[j], ((int*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)recv_vector[v])[j*stride]=min(((int*)tmp)[j],((int*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector[v])[j*stride]+=((long*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector[v])[j*stride]*=((long*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector[v])[j*stride]=max(((long*)tmp)[j], ((long*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)recv_vector[v])[j*stride]=min(((long*)tmp)[j],((long*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector[v])[j*stride]+=((double*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector[v])[j*stride]*=((double*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector[v])[j*stride]=max(((double*)tmp)[j], ((double*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)recv_vector[v])[j*stride]=min(((double*)tmp)[j],((double*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector[v])[j*stride]+=((float*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector[v])[j*stride]*=((float*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector[v])[j*stride]=max(((float*)tmp)[j], ((float*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)recv_vector[v])[j*stride]=min(((float*)tmp)[j],((float*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector[v])[j*stride]+=((char*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector[v])[j*stride]*=((char*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector[v])[j*stride]=max(((char*)tmp)[j], ((char*)recv_vector[v])[j*stride]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)recv_vector[v])[j*stride]=min(((char*)tmp)[j],((char*)recv_vector[v])[j*stride]);
	  break;
	default:
          eco_oper_list[oper](tmp,recv_vector[v],length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};
	  }
	  else{
	    double tmp2t[length]; void* tmp2 = tmp2t;

	    for(j=0;j<length;j++)
              
switch(Arg_Type){
case Eco_Int:
  ((int*)tmp2)[j] = ((int*)recv_vector[v])[j*stride];
  break;
case Eco_Long:
  ((long*)tmp2)[j] = ((long*)recv_vector[v])[j*stride];
  break;
case Eco_Float:
  ((float*)tmp2)[j] = ((float*)recv_vector[v])[j*stride];
  break;
case Eco_Double:
  ((double*)tmp2)[j] = ((double*)recv_vector[v])[j*stride];
  break;
case Eco_Char:
  ((char*)tmp2)[j] = ((char*)recv_vector[v])[j*stride];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;

	    
switch(Arg_Type) {
	case Eco_Int:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]+=((int*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]*=((int*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]=max(((int*)tmp)[j], ((int*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((int*)tmp2)[j]=min(((int*)tmp)[j],((int*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Long:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]+=((long*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]*=((long*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]=max(((long*)tmp)[j], ((long*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((long*)tmp2)[j]=min(((long*)tmp)[j],((long*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Double:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]+=((double*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]*=((double*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]=max(((double*)tmp)[j], ((double*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((double*)tmp2)[j]=min(((double*)tmp)[j],((double*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Float:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]+=((float*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]*=((float*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]=max(((float*)tmp)[j], ((float*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((float*)tmp2)[j]=min(((float*)tmp)[j],((float*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	case Eco_Char:
		switch (oper) {
	case ECO_OP_ADD:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]+=((char*)tmp)[j];
	  break;
	case ECO_OP_MULT:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]*=((char*)tmp)[j];
	    break;
	case ECO_OP_MAX:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]=max(((char*)tmp)[j], ((char*)tmp2)[j]);
	  break;
	case ECO_OP_MIN:
	  for(j=0;j<length;j++)
	    ((char*)tmp2)[j]=min(((char*)tmp)[j],((char*)tmp2)[j]);
	  break;
	default:
          eco_oper_list[oper](tmp,tmp2,length,&(j));
	  break;
	};
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
};

	    for(j=0;j<length;j++)
              
switch(Arg_Type){
case Eco_Int:
  ((int*)recv_vector[v])[j*stride] = ((int*)tmp2)[j];
  break;
case Eco_Long:
  ((long*)recv_vector[v])[j*stride] = ((long*)tmp2)[j];
  break;
case Eco_Float:
  ((float*)recv_vector[v])[j*stride] = ((float*)tmp2)[j];
  break;
case Eco_Double:
  ((double*)recv_vector[v])[j*stride] = ((double*)tmp2)[j];
  break;
case Eco_Char:
  ((char*)recv_vector[v])[j*stride] = ((char*)tmp2)[j];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
	}

	for(j=0;j<ECO_tree_child_count[ECO_ALL];j++)
	  if(from < ECO_tree_desc_max[ECO_ALL][j]) {
	    pvm_setsbuf(buffers[j]);
	    
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)tmp,length,1);
  break;
case Eco_Long:
  pvm_pklong((long*)tmp,length,1);
  break;
case Eco_Float:
  pvm_pkfloat((float*)tmp,length,1);
  break;
case Eco_Double:
  pvm_pkdouble((double*)tmp,length,1);
  break;
case Eco_Char:
  pvm_pkbyte((char*)tmp,length,1);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
;
	  }
      }
      pvm_upkint(&from, 1, 1);
    }
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_setsbuf(buffers[i]);
    from = -1;
    pvm_pkint(&from,1,1);
    pvm_send(ECO_tree_children[ECO_ALL][i], ECO_SCAN_DOWN);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    pvm_freebuf(buffers[i]);

  return 0;

}

#endif ECO_ALG_H
