/* overloaded pack calls*/

/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided ``as is'' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */


#ifndef _pvm3pack_h_
#define _pvm3pack_h_

ifdef(`E_EXTERNSTDINCLUDES',`extern "C"{')
#include <stdio.h>
ifdef(`E_EXTERNSTDINCLUDES',`}')

ifdef(`E_CPLUSPLUS',`extern "C"{')
#include <pvm3.h>
ifdef(`E_CPLUSPLUS',`}')

/* no default cnt for pkbyte because it's amiguous with pkstring*/
inline int	
pvm_pk(const char *cp, int cnt, int std=1)
	{ return pvm_pkbyte( (char *)cp, cnt, std ); }
inline int	
pvm_pk( const float *fp, int cnt=1, int std=1)
	{ return pvm_pkfloat( (float *)fp, cnt, std); }
inline int	
pvm_pk( const double *dp, int cnt=1, int std=1 )
	{ return pvm_pkdouble( (double *)dp, cnt, std ); }
inline int
pvm_pk( const int *np, int cnt=1, int std=1 )
	{ return pvm_pkint((int *)np, cnt, std); }
inline int	
pvm_pk( const long *np, int cnt=1, int std=1 )
	{ return pvm_pklong( (long *)np, cnt, std ); }
inline int	
pvm_pk( const short *np, int cnt=1, int std=1 )
	{ return pvm_pkshort( (short *)np, cnt, std ); }
inline int	
pvm_pk( const char *cp )
	{ return pvm_pkstr((char *)cp); }
inline int	
pvm_pk( const unsigned int *np, int cnt=1, int std=1 )
	{ return pvm_pkuint((unsigned int *)np, cnt, std ); }
inline int	
pvm_pk( const unsigned long *np, int cnt=1, int std=1 )
	{ return pvm_pkulong( (unsigned long *)np, cnt, std ); }
inline int	
pvm_pk( const unsigned short *np, int cnt=1, int std=1 )
	{ return pvm_pkushort( (unsigned short *)np, cnt, std ); }

/* unpacks*/
inline int	
pvm_upk(char *cp, int cnt, int std=1)
	{ return pvm_upkbyte( cp, cnt, std ); }
inline int	
pvm_upk( float *fp, int cnt=1, int std=1 )
	{ return pvm_upkfloat( fp, cnt, std); }
inline int	
pvm_upk( double *dp, int cnt=1, int std=1 )
	{ return pvm_upkdouble( dp, cnt, std ); }
inline int
pvm_upk( int *np, int cnt=1, int std=1 )
	{ return pvm_upkint(np, cnt, std); }
inline int	
pvm_upk( long *np, int cnt=1, int std=1 )
	{ return pvm_upklong( np, cnt, std ); }
inline int	
pvm_upk( short *np, int cnt=1, int std=1 )
	{ return pvm_upkshort( np, cnt, std ); }
inline int	
pvm_upk( char *cp )
	{ return pvm_upkstr(cp); }
inline int	
pvm_upk( unsigned int *np, int cnt=1, int std=1 )
	{ return pvm_upkuint(np, cnt, std ); }
inline int	
pvm_upk( unsigned long *np, int cnt=1, int std=1 )
	{ return pvm_upkulong( np, cnt, std ); }
inline int	
pvm_upk( unsigned short *np, int cnt=1, int std=1 )
	{ return pvm_upkushort( np, cnt, std ); }

#endif
