E_M4WARNING

/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided ``as is'' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */


ifdef(`E_EXTERNSTDINCLUDES',`extern "C"{')
#include <stdio.h>
#include <stdlib.h>
ifdef(`E_EXTERNSTDINCLUDES',`}')


#include "eco.h"

ifdef(`E_CPLUSPLUS',`extern"C"{')
#include <pvm3.h>
ifdef(`E_CPLUSPLUS',`}
#include <pvm3pack.h>')

void user_add(void* In, void* Out, int length, int* info);

#define P 8
#define sleep if(0)
main(int argc, char** argv)
{
  int i,j;
  int tids[P];
  int p_i;
  int my_add;


  double* test_vec;
  double* comp_vec;
  int my_length;
  double* test_vec2;
  double* comp_vec2;
  void **test_vs;
  void **comp_vs;


  double* test_vec_s;
  double* comp_vec_s;
  double* test_vec_s2;
  double* comp_vec_s2;
  void **test_vs_s;
  void **comp_vs_s;

  test_vec = (double*) malloc(P*2*sizeof(double));
  comp_vec = (double*) malloc(2*sizeof(double));
  test_vec2 = (double*) malloc(P*2*sizeof(double));
  comp_vec2 = (double*) malloc(2*sizeof(double));
  test_vec_s = (double*) malloc(P*4*sizeof(double));
  comp_vec_s = (double*) malloc(4*sizeof(double));
  test_vec_s2 = (double*) malloc(P*4*sizeof(double));
  comp_vec_s2 = (double*) malloc(4*sizeof(double));
  
  test_vs = (void**) malloc(2*sizeof(void*));
  comp_vs = (void**) malloc(2*sizeof(void*));
  test_vs_s = (void**) malloc(2*sizeof(void*));
  comp_vs_s = (void**) malloc(2*sizeof(void*));


  test_vs_s[0] = test_vec_s;
  test_vs_s[1] = test_vec_s2;
  comp_vs_s[0] = comp_vec_s;
  comp_vs_s[1] = comp_vec_s2;
  test_vs[0] = test_vec;
  test_vs[1] = test_vec2;
  comp_vs[0] = comp_vec;
  comp_vs[1] = comp_vec2;


  pvm_setopt(PvmAutoErr, 1);

  pvm_mytid();

  if(pvm_parent() == PvmNoParent) {
    tids[0] = pvm_mytid();

    p_i = 0;
    printf ("root spawned %i\n", 
	    pvm_spawn("eco_test", NULL,PvmTaskDefault,
		      NULL, P-1, tids+1));
    pvm_initsend(PvmDataDefault);
    pvm_pkint(tids, P, 1);
    for(i=1;i<P;i++)
      pvm_send(tids[i], 1);
  }
  else {
    pvm_recv(pvm_parent(), 1);
    pvm_upkint(tids, P, 1);
    for(p_i=1;tids[p_i] != pvm_mytid();p_i++);
  }


  eco_init (&p_i, P, tids, NULL,
	    ECO_RING_TOPOLOGY, NULL);


  printf ("now testing barrier\n");
  fflush(stdout);
  fflush(stderr);
  eco_barrier();
  printf ("barrier test finished\n");
  fflush(stdout);
  fflush(stderr);


  for(i=0;i<P;i++) {
    if(p_i == i) {
      comp_vec[0] = comp_vec[1] = p_i;
      pvm_initsend(PvmDataDefault);
      pvm_pkdouble(comp_vec, 2, 1);
    }
    else
      comp_vec[0] = comp_vec[1] = -1;
    
    eco_bcast(i);
    
    sleep(3);

    if(p_i!=i)
      pvm_upkdouble(comp_vec,2,1);
    
    if(comp_vec[0] != i || comp_vec[1] != i) 
      printf ("p=%i fail on bcast with root=%i\n", p_i, i);
  }


  printf ("bcast tests finished\n");
  fflush(stdout);
  fflush(stderr);

  /* gather*/
  for(i=0;i<P;i++) {
    comp_vec[0] = i*p_i;
    comp_vec[1] = i*p_i;
    eco_gather(comp_vec, 2, 1, 2*p_i,
	      test_vec, 2*P, 1, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
    if(p_i == i)
      for(j=0;j<2*P;j++)
	if(test_vec[j]!=(i*(j/2))) {
	  printf ("error in gather on root =%i, [%i]\n", i, j);
	  break;
	}
  }

  i=ECO_ALL;
  comp_vec[0] = i*p_i;
  comp_vec[1] = i*p_i;
  eco_gather(comp_vec, 2, 1, 2*p_i,
	      test_vec, 2*P, 1, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
  for(j=0;j<2*P;j++)
    if(test_vec[j]!=(i*(j/2))) {
      printf ("error in gather on root =ALL, p=%i, [%i]\n", p_i, j);
      break;
    }

  printf ("finished gather tests\n");
  fflush(stdout);
  fflush(stderr);


  /* gather+strides*/
  for(i=0;i<P;i++) {
    comp_vec_s[0] = p_i;
    comp_vec_s[1] = -p_i;
    comp_vec_s[2] = p_i;
    comp_vec_s[3] = -p_i;
    for(j=0;j<4*P;j++)
      test_vec_s[j] = -.5;
    eco_gather(comp_vec_s, 2, 2, 4*p_i,
	      test_vec_s, 2*P, 2, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
    if(p_i == i) {
      /*for(j=0;j<4*P;j++)
	printf ("%4.1lf ", test_vec_s[j]);
      printf("\n");*/
      for(j=0;j<4*P;j+=2)
	if(test_vec_s[j]!=(j/4)) {
	  printf ("error in gather(s) on root =%i, [%i]\n", i, j);
	  break;
	}
      for(j=1;j<4*P;j+=2)
	if(test_vec_s[j]!=-.5) {
	  printf ("error in gather(s) on root =%i, [%i]\n", i, j);
	  break;
	}
    }
  }

  i=ECO_ALL;
  comp_vec_s[0] = p_i;
  comp_vec_s[1] = -p_i;  
  comp_vec_s[2] = p_i;
  comp_vec_s[3] = -p_i;
    for(j=0;j<4*P;j++)
      test_vec_s[j] = -.5;
  eco_gather(comp_vec_s, 2, 2, 4*p_i,
	      test_vec_s, 2*P, 2, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
  for(j=0;j<4*P;j+=2)
    if(test_vec_s[j]!=(j/4)) {
      printf ("error in gather(s) on root =ALL, p=%i, [%i]\n", p_i, j);
      break;
    }
  for(j=1;j<4*P;j+=2)
    if(test_vec_s[j]!=-.5) {
      printf ("error in gather(s) on root =%i, [%i]\n", i, j);
      break;
    }

  printf ("finished gather(s) tests\n");
  fflush(stdout);
  fflush(stderr);


  /* gatherv*/
  for(i=0;i<P;i++) {
    comp_vec[0] = i*p_i;
    comp_vec[1] = i*p_i;
    comp_vec2[0] = i*p_i*5;
    comp_vec2[1] = i*p_i*5;
    eco_gatherv(2, comp_vs, 2, 1, 2*p_i,
	      test_vs, 2*P, 1, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
    if(p_i == i)
      for(j=0;j<2*P;j++)
	if(test_vec[j]!=(i*(j/2)) ||
	   test_vec2[j]!=(i*(j/2)*5)) {
	  printf ("error in gatherv on root =%i, [%i]\n", i, j);
	  break;
	}
  }

  i=ECO_ALL;
  comp_vec[0] = i*p_i;
  comp_vec[1] = i*p_i;
  comp_vec2[0] = i*p_i*5;
  comp_vec2[1] = i*p_i*5;
  eco_gatherv(2, comp_vs, 2, 1, 2*p_i,
	      test_vs, 2*P, 1, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
  for(j=0;j<2*P;j++)
    if(test_vec[j]!=(i*(j/2)) ||
       test_vec2[j]!=(i*(j/2)*5)) {
      printf ("error in gatherv on root =ALL, p=%i, [%i]\n", p_i, j);
      break;
    }

  printf ("finished gatherv tests\n");
  fflush(stdout);
  fflush(stderr);


  /* gatherv+strides*/
  for(i=0;i<P;i++) {
    comp_vec_s[0] = p_i;
    comp_vec_s[1] = -p_i;
    comp_vec_s[2] = p_i;
    comp_vec_s[3] = -p_i;
    comp_vec_s2[0] = p_i*5;
    comp_vec_s2[1] = -p_i*5;
    comp_vec_s2[2] = p_i*5;
    comp_vec_s2[3] = -p_i*5;
    for(j=0;j<4*P;j++){
      test_vec_s[j] = -.5;
      test_vec_s2[j] = -.5;
    }
    eco_gatherv(2, comp_vs_s, 2, 2, 4*p_i,
	      test_vs_s, 2*P, 2, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
    if(p_i == i) {
      /*for(j=0;j<4*P;j++)
	printf ("%4.1lf ", test_vec_s[j]);
	printf("\n");*/
      for(j=0;j<4*P;j+=2)
	if(test_vec_s[j]!=(j/4)) {
	  printf ("error in gather(s) on root =%i, [%i]\n", i, j);
	  break;
	}
      for(j=1;j<4*P;j+=2)
	if(test_vec_s[j]!=-.5) {
	  printf ("error in gather(s) on root =%i, [%i]\n", i, j);
	  break;
	}
    }
    if(p_i == i) {
      /*for(j=0;j<4*P;j++)
	printf ("%4.1lf ", test_vec_s[j]);
	printf("\n");*/
      for(j=0;j<4*P;j+=2)
	if(test_vec_s2[j]!=(j/4)*5) {
	  printf ("error in gather(s) on root =%i, [%i]\n", i, j);
	  break;
	}
      for(j=1;j<4*P;j+=2)
	if(test_vec_s2[j]!=-.5) {
	  printf ("error in gather(s) on root =%i, [%i]\n", i, j);
	  break;
	}
    }
  }

    i=ECO_ALL;
  comp_vec_s[0] = p_i;
  comp_vec_s[1] = -p_i;  
  comp_vec_s[2] = p_i;
  comp_vec_s[3] = -p_i;
  comp_vec_s2[0] = p_i*5;
  comp_vec_s2[1] = -p_i*5;  
  comp_vec_s2[2] = p_i*5;
  comp_vec_s2[3] = -p_i*5;
  for(j=0;j<4*P;j++){
    test_vec_s[j] = -.5;
    test_vec_s2[j] = -.5;
  }
  eco_gatherv(2, comp_vs_s, 2, 2, 4*p_i,
	      test_vs_s, 2*P, 2, i
#ifndef __cplusplus
, Eco_Double
#endif
);
  sleep(3);
  for(j=0;j<4*P;j+=2)
    if(test_vec_s[j]!=(j/4)) {
      printf ("error in gatherv(s) on root =ALL, p=%i, [%i]\n", p_i, j);
      break;
    }
  for(j=1;j<4*P;j+=2)
    if(test_vec_s[j]!=-.5) {
      printf ("error in gatherv(s) on root =%i, [%i]\n", i, j);
      break;
    }
  for(j=0;j<4*P;j+=2)
    if(test_vec_s2[j]!=(j/4)*5) {
      printf ("error in gatherv(s) on root =ALL, p=%i, [%i]\n", p_i, j);
      break;
    }
  for(j=1;j<4*P;j+=2)
    if(test_vec_s2[j]!=-.5) {
      printf ("error in gatherv(s) on root =%i, [%i]\n", i, j);
      break;
    }

  printf ("finished gatherv(s) tests\n");
  fflush(stdout);
  fflush(stderr);


  /* scatter*/
  
  for(i=0;i<P;i++) {
    if(p_i == i) {
      int length[P];
      int offset[P];

      
      for(j=0;j<2*P;j++)
	test_vec[j] = i;
      for(j=0;j<P;j++){
	length[j] = 2;
	offset[j] = 2*j;
      }

      eco_scatter(test_vec, 2*P, 1, length, offset, 
		   comp_vec, &my_length, 1, i
#ifndef __cplusplus
		  , Eco_Double
#endif
		  );
      sleep(3);
    }
    else
      eco_scatter(test_vec, 0, 1, (int*)0, (int*)0,
		   comp_vec, &my_length, 1, i
#ifndef __cplusplus
, Eco_Double
#endif
);


    if((my_length != 2)||(comp_vec[0]!=i)||(comp_vec[1]!=i))
      printf ("scatter failed (p=%i), root = %i\n", p_i, i);
  }

  printf ("scatter tests complete\n");


  /* scatter+s*/
  
  for(j=0;j<4;j++)
    comp_vec_s[j]=-1;
  for(i=0;i<P;i++) {
    if(p_i == i) {
      int length[P];
      int offset[P];

      
      for(j=0;j<4*P;j+=2)
	test_vec_s[j] = i;
      for(j=0;j<P;j++){
	length[j] = 2;
	offset[j] = 4*j;
      }
      eco_scatter(test_vec_s, 2*P, 2, length, offset, 
		   comp_vec_s, &my_length, 2, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
    }
    else
      eco_scatter(test_vec_s, 0, 1, &i, &i,
		   comp_vec_s, &my_length, 2, i
#ifndef __cplusplus
, Eco_Double
#endif
);


    if((my_length != 2)||(comp_vec_s[0]!=i)||(comp_vec_s[2]!=i)||
       (comp_vec_s[1]!=-1)||(comp_vec_s[3]!=-1))
      printf ("scatter(s) failed (p=%i), root = %i\n", p_i, i);
  }

  printf ("scatter(s) tests complete\n");




  /* scatterv*/
  
  for(i=0;i<P;i++) {
    if(p_i == i) {
      int length[P];
      int offset[P];

      
      for(j=0;j<2*P;j++){
	test_vec[j] = i;
	test_vec2[j] = 5*i;
      }
      for(j=0;j<P;j++){
	length[j] = 2;
	offset[j] = 2*j;
      }

      eco_scatterv(2, test_vs, 2*P, 1, length, offset, 
		   comp_vs, &my_length, 1, i
#ifndef __cplusplus
		  , Eco_Double
#endif
		  );
      sleep(3);
    }
    else
      eco_scatterv(2, test_vs, 0, 1, (int*)0, (int*)0,
		   comp_vs, &my_length, 1, i
#ifndef __cplusplus
, Eco_Double
#endif
);


    if((my_length != 2)||(comp_vec[0]!=i)||(comp_vec[1]!=i)||
       (comp_vec2[0]!=5*i)||(comp_vec2[1]!=5*i))
      printf ("scatterv failed (p=%i), root = %i\n", p_i, i);
  }

  printf ("scatterv tests complete\n");


  /* scatterv+s*/
  
  for(j=0;j<4;j++){
    comp_vec_s[j]=-1;
    comp_vec_s2[j] = -1;
  }
  for(i=0;i<P;i++) {
    if(p_i == i) {
      int length[P];
      int offset[P];

      
      for(j=0;j<4*P;j+=2){
	test_vec_s[j] = i;
	test_vec_s2[j] = 5*i;
      }
      for(j=0;j<P;j++){
	length[j] = 2;
	offset[j] = 4*j;
      }
      eco_scatterv(2, test_vs_s, 2*P, 2, length, offset, 
		   comp_vs_s, &my_length, 2, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
    }
    else
      eco_scatterv(2, test_vs_s, 0, 1, &i, &i,
		   comp_vs_s, &my_length, 2, i
#ifndef __cplusplus
, Eco_Double
#endif
);


    if((my_length != 2)||(comp_vec_s[0]!=i)||(comp_vec_s[2]!=i)||
       (comp_vec_s[1]!=-1)||(comp_vec_s[3]!=-1) ||
       (comp_vec_s2[0]!=5*i)||(comp_vec_s2[2]!=5*i)||
       (comp_vec_s2[1]!=-1)||(comp_vec_s2[3]!=-1))
      printf ("scatterv(s) failed (p=%i), root = %i\n", p_i, i);
  }

  printf ("scatterv(s) tests complete\n");


  /* reduce*/
  for(i=0;i<P;i++) {
    test_vec[0] = (i+1)*(p_i+1);
    test_vec[1] = (i+1)*(p_i+1)+1;
    eco_reduce(test_vec, 2, 1, comp_vec, ECO_OP_ADD, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

    if(p_i==i) {
      int t_sum=0;

      for(j=0;j<P;j++)
	t_sum += (i+1)*(j+1);
      if((comp_vec[0] != t_sum)||(comp_vec[1] != t_sum+P))
	printf ("error in reduce root=%i\n", p_i);
    }
  }
	  
  i=ECO_ALL;
  test_vec[0] = (i+1)*(p_i+1);
  test_vec[1] = (i+1)*(p_i+1)+1;
  eco_reduce(test_vec, 2, 1, comp_vec, ECO_OP_ADD, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

  {
    int t_sum=0;
    
    for(j=0;j<P;j++)
      t_sum += (i+1)*(j+1);
    if((comp_vec[0] != t_sum)||(comp_vec[1] != t_sum+P))
      printf ("error in reduce root=ALL\n");
  }

  printf ("reduce tests complete\n");
  fflush(stdout);
  fflush(stderr);


  /* reduce+s*/
  for(i=0;i<P;i++) {
    test_vec_s[0] = (i+1)*(p_i+1);
    test_vec_s[1] = -1;
    test_vec_s[2] = (i+1)*(p_i+1)+1;
    test_vec_s[3] = -1;
    eco_reduce(test_vec_s, 2, 2, comp_vec_s, ECO_OP_ADD, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

    if(p_i==i) {
      int t_sum=0;

      for(j=0;j<P;j++)
	t_sum += (i+1)*(j+1);
      if((comp_vec_s[0] != t_sum)||(comp_vec_s[2] != t_sum+P))
	printf ("error in reduce(s) root=%i\n", p_i);
    }
  }
	  
  i=ECO_ALL;
  test_vec_s[0] = (i+1)*(p_i+1);
  test_vec_s[1] = -1;
  test_vec_s[2] = (i+1)*(p_i+1)+1;
  test_vec_s[3] = -1;
  eco_reduce(test_vec_s, 2, 2, comp_vec_s, ECO_OP_ADD, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

  {
    int t_sum=0;
    
    for(j=0;j<P;j++)
      t_sum += (i+1)*(j+1);
    if((comp_vec_s[0] != t_sum)||(comp_vec_s[2] != t_sum+P))
      printf ("error in reduce(s) root=ALL\n");
  }

  printf ("reduce(s) tests complete\n");
  fflush(stdout);
  fflush(stderr);


  /* reducev*/
  for(i=0;i<P;i++) {
    test_vec[0] = (i+1)*(p_i+1);
    test_vec[1] = (i+1)*(p_i+1)+1;
    test_vec2[0] = 5*(i+1)*(p_i+1);
    test_vec2[1] = 5*(i+1)*(p_i+1)+1;
    eco_reducev(2,test_vs, 2, 1, comp_vs, ECO_OP_ADD, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

    if(p_i==i) {
      int t_sum=0;

      for(j=0;j<P;j++)
	t_sum += (i+1)*(j+1);
      if((comp_vec[0] != t_sum)||(comp_vec[1] != t_sum+P)||
	 (comp_vec2[0] != 5*t_sum)||(comp_vec2[1] != 5*t_sum+P))	
	printf ("error in reducev root=%i\n", p_i);
    }
  }
	  
  i=ECO_ALL;
  test_vec[0] = (i+1)*(p_i+1);
  test_vec[1] = (i+1)*(p_i+1)+1;
  test_vec2[0] = 5*(i+1)*(p_i+1);
  test_vec2[1] = 5*(i+1)*(p_i+1)+1;
  eco_reducev(2,test_vs, 2, 1, comp_vs, ECO_OP_ADD, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

  {
    int t_sum=0;
    
    for(j=0;j<P;j++)
      t_sum += (i+1)*(j+1);
    if((comp_vec[0] != t_sum)||(comp_vec[1] != t_sum+P)||
       (comp_vec2[0] != 5*t_sum)||(comp_vec2[1] != 5*t_sum+P))	
      printf ("error in reducev root=ALL\n");
  }

  printf ("reducev tests complete\n");
  fflush(stdout);
  fflush(stderr);


  /* reducev+s*/
  for(i=0;i<P;i++) {
    test_vec_s[0] = (i+1)*(p_i+1);
    test_vec_s[1] = -1;
    test_vec_s[2] = (i+1)*(p_i+1)+1;
    test_vec_s[3] = -1;
    test_vec_s2[0] = 5*(i+1)*(p_i+1);
    test_vec_s2[1] = -1;
    test_vec_s2[2] = 5*(i+1)*(p_i+1)+1;
    test_vec_s2[3] = -1;
    eco_reducev(2,test_vs_s, 2, 2, comp_vs_s, ECO_OP_ADD, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

    if(p_i==i) {
      int t_sum=0;

      for(j=0;j<P;j++)
	t_sum += (i+1)*(j+1);
      if((comp_vec_s[0] != t_sum)||(comp_vec_s[2] != t_sum+P)||
	 (comp_vec_s2[0] != 5*t_sum)||(comp_vec_s2[2] != 5*t_sum+P))
	printf ("error in reducev(s) root=%i\n", p_i);
    }
  }
	  
  i=ECO_ALL;
  test_vec_s[0] = (i+1)*(p_i+1);
  test_vec_s[1] = -1;
  test_vec_s[2] = (i+1)*(p_i+1)+1;
  test_vec_s[3] = -1;
  test_vec_s2[0] = 5*(i+1)*(p_i+1);
  test_vec_s2[1] = -1;
  test_vec_s2[2] = 5*(i+1)*(p_i+1)+1;
  test_vec_s2[3] = -1;
  eco_reducev(2,test_vs_s, 2, 2, comp_vs_s, ECO_OP_ADD, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

  {
    int t_sum=0;
    
    for(j=0;j<P;j++)
      t_sum += (i+1)*(j+1);
    if((comp_vec_s[0] != t_sum)||(comp_vec_s[2] != t_sum+P)||
       (comp_vec_s2[0] != 5*t_sum)||(comp_vec_s2[2] != 5*t_sum+P))
      printf ("error in reducev(s) root=ALL\n");
  }

  printf ("reducev(s) tests complete\n");
  fflush(stdout);
  fflush(stderr);



  /* reducev+s with user*/
  my_add = eco_register_function(user_add);
  for(i=0;i<P;i++) {
    test_vec_s[0] = (i+1)*(p_i+1);
    test_vec_s[1] = -1;
    test_vec_s[2] = (i+1)*(p_i+1)+1;
    test_vec_s[3] = -1;
    test_vec_s2[0] = 5*(i+1)*(p_i+1);
    test_vec_s2[1] = -1;
    test_vec_s2[2] = 5*(i+1)*(p_i+1)+1;
    test_vec_s2[3] = -1;
    eco_reducev(2,test_vs_s, 2, 2, comp_vs_s, my_add, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

    if(p_i==i) {
      int t_sum=0;

      for(j=0;j<P;j++)
	t_sum += (i+1)*(j+1);
      if((comp_vec_s[0] != t_sum)||(comp_vec_s[2] != t_sum+P)||
	 (comp_vec_s2[0] != 5*t_sum)||(comp_vec_s2[2] != 5*t_sum+P))
	printf ("error in reducev(s) (user) root=%i\n", p_i);
    }
  }
	  
  i=ECO_ALL;
  test_vec_s[0] = (i+1)*(p_i+1);
  test_vec_s[1] = -1;
  test_vec_s[2] = (i+1)*(p_i+1)+1;
  test_vec_s[3] = -1;
  test_vec_s2[0] = 5*(i+1)*(p_i+1);
  test_vec_s2[1] = -1;
  test_vec_s2[2] = 5*(i+1)*(p_i+1)+1;
  test_vec_s2[3] = -1;
  eco_reducev(2,test_vs_s, 2, 2, comp_vs_s, my_add, i
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

  {
    int t_sum=0;
    
    for(j=0;j<P;j++)
      t_sum += (i+1)*(j+1);
    if((comp_vec_s[0] != t_sum)||(comp_vec_s[2] != t_sum+P)||
       (comp_vec_s2[0] != 5*t_sum)||(comp_vec_s2[2] != 5*t_sum+P))
      printf ("error in reducev(s) (user) root=ALL\n");
  }
  eco_delete_function(my_add);

  printf ("reducev(s) (user)tests complete\n");
  fflush(stdout);
  fflush(stderr);


  /* scan*/
  test_vec[0] = p_i;
  test_vec[1] = p_i*2;
  eco_scan(test_vec, 2, 1, comp_vec, ECO_OP_ADD
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
  test_vec[0] = test_vec[1] = 0;
  for(i=0;i<=p_i;i++)
    test_vec[0] += i;
  if(test_vec[0]!=comp_vec[0] || test_vec[0]*2 != comp_vec[1])
    printf ("error in scan on p_i=%i, %lf!=%lf, %lf!=%lf\n", p_i,
	    test_vec[0], comp_vec[0], test_vec[0]*2, comp_vec[1]);


  printf ("scan test completed\n");
  fflush(stdout);
  fflush(stderr);


  /* scan+s*/
  test_vec_s[0] = p_i;
  test_vec_s[1] = -1;
  test_vec_s[2] = p_i*2;
  test_vec_s[3] = -1;
  eco_scan(test_vec_s, 2, 2, comp_vec_s, ECO_OP_ADD
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
  test_vec_s[0] = test_vec_s[1] = 0;
  for(i=0;i<=p_i;i++)
    test_vec_s[0] += i;
  if(test_vec_s[0]!=comp_vec_s[0] || test_vec_s[0]*2 != comp_vec_s[2])
    printf ("error in scan(s) on p_i=%i, %lf!=%lf, %lf!=%lf\n", p_i,
	    test_vec_s[0], comp_vec_s[0], test_vec_s[0]*2, comp_vec_s[2]);


  printf ("scan(s) test completed\n");
  fflush(stdout);
  fflush(stderr);




  /* scanv*/
  test_vec[0] = (p_i+1);
  test_vec[1] = (p_i+1)*2;
  test_vec2[0] = 5*(p_i+1);
  test_vec2[1] = 5*2*(p_i+1);
  eco_scanv(2, test_vs, 2, 1, comp_vs, ECO_OP_ADD
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
  test_vec[0] = test_vec[1] = 0;
  for(i=0;i<=p_i;i++)
    test_vec[0] += i+1;
  if(test_vec[0]!=comp_vec[0] || test_vec[0]*2 != comp_vec[1] ||
     test_vec[0]*5!=comp_vec2[0] || test_vec[0]*5*2!=comp_vec2[1])
    printf ("error in scanv on p_i=%i, %lf!=%lf, %lf!=%lf\n", p_i,
	    test_vec[0], comp_vec[0], test_vec[0]*2, comp_vec[1]);


  printf ("scanv test completed\n");
  fflush(stdout);
  fflush(stderr);


  /* scanv+s*/
  test_vec_s[0] = p_i+1;
  test_vec_s[1] = -1;
  test_vec_s[2] = (p_i+1)*2;
  test_vec_s[3] = -1;
  test_vec_s2[0] = 5*(p_i+1);
  test_vec_s2[1] = -1;
  test_vec_s2[2] = 5*(p_i+1)*2;
  test_vec_s2[3] = -1;
  eco_scanv(2,test_vs_s, 2, 2, comp_vs_s, ECO_OP_ADD
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
  test_vec_s[0] = test_vec_s[1] = 0;
  for(i=0;i<=p_i;i++)
    test_vec_s[0] += i+1;
  if(test_vec_s[0]!=comp_vec_s[0] || test_vec_s[0]*2 != comp_vec_s[2]||
     test_vec_s[0]*5!=comp_vec_s2[0] || test_vec_s[0]*5*2!=comp_vec_s2[2])
    printf ("error in scanv(s) on p_i=%i, %lf!=%lf, %lf!=%lf\n", p_i,
	    test_vec_s[0], comp_vec_s[0], test_vec_s[0]*2, comp_vec_s[2]);


  printf ("scanv(s) test completed\n");
  fflush(stdout);
  fflush(stderr);




  /* scanv+s (user)*/
  my_add = eco_register_function(user_add);
  test_vec_s[0] = p_i+1;
  test_vec_s[1] = -1;
  test_vec_s[2] = (p_i+1)*2;
  test_vec_s[3] = -1;
  test_vec_s2[0] = 5*(p_i+1);
  test_vec_s2[1] = -1;
  test_vec_s2[2] = 5*(p_i+1)*2;
  test_vec_s2[3] = -1;
  eco_scanv(2,test_vs_s, 2, 2, comp_vs_s, my_add
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);
  test_vec_s[0] = test_vec_s[1] = 0;
  for(i=0;i<=p_i;i++)
    test_vec_s[0] += i+1;
  if(test_vec_s[0]!=comp_vec_s[0] || test_vec_s[0]*2 != comp_vec_s[2]||
     test_vec_s[0]*5!=comp_vec_s2[0] || test_vec_s[0]*5*2!=comp_vec_s2[2])
    printf ("error in scanv(s) (user) on p_i=%i, %lf!=%lf, %lf!=%lf, %lf!=%lf, %lf!=%lf\n", p_i,
	    test_vec_s[0], comp_vec_s[0], test_vec_s[0]*2, comp_vec_s[2],
	    test_vec_s[0]*5, comp_vec_s2[0], test_vec_s[0]*5*2,
	    comp_vec_s2[2]);

  eco_delete_function(my_add);

  printf ("scanv(s) (user)  test completed\n");
  fflush(stdout);
  fflush(stderr);




  /* all to all*/
  {
    double dest_vec[P];
    int v_loc[P];
    int v_ones[P];

    for(i=0;i<P;i++){
      test_vec[i] = p_i+i+100;
      v_loc[i]=i;
      v_ones[i]=1;
    }

    eco_alltoall(test_vec, P, 1, v_ones, v_loc,
	dest_vec, P, 1, v_ones, v_loc
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

    for(i=0;i<P;i++)
      if (dest_vec[i] != i+p_i+100) {
	printf ("error in all to all at p=%i:", p_i);
	for(j=0;j<P;j++)
	  printf (" %3lf", dest_vec[j]);
	printf("\n");
	break;
      }
  }
  printf ("finished all to all\n");
  fflush(stdout);
  fflush(stderr);


  /* all to all+s*/
  {
    double test_vec[P*4];
    double dest_vec[P*4];
    int v_loc[P];
    int v_length[P];

    for(i=0;i<P;i++){
      test_vec[i*4] = p_i+i+100;
      test_vec[i*4+2] = p_i+i+101;
      v_loc[i]=i*4;
      v_length[i]=2;
    }

    eco_alltoall(test_vec, P, 2, v_length, v_loc,
	dest_vec, P, 2, v_length, v_loc
#ifndef __cplusplus
, Eco_Double
#endif
);
    sleep(3);

    for(i=0;i<P;i++)
      if ((dest_vec[i*4] != (i+p_i+100))||
	  (dest_vec[i*4+2] != (i+p_i+101))) {
	printf ("error in all to all(s) at p=%i:", p_i);
	for(j=0;j<P;j++)
	  printf (" %3lf, %3lf", dest_vec[j*4], dest_vec[j*4+2]);
	printf("\n");
	break;
      }
  }
  printf ("finished all to all(s)\n");
  fflush(stdout);
  fflush(stderr);

  




  if(pvm_parent() != PvmNoParent){
    pvm_initsend(PvmDataDefault);
    pvm_send(pvm_parent(), 1000);
    pvm_recv(pvm_parent(), 1000);
  }
  else {
    pvm_initsend(PvmDataDefault);
    for(i=1;i<P;i++)
      pvm_recv(tids[i], 1000);
    for(i=1;i<P;i++)
      pvm_send(tids[i], 1000);
  }



}


void user_add(void* In, void* Out, int length, int* info)
{
  double* a= (double*)Out;
  double* b= (double*)In;
  int i;

  for(i=0;i<length;i++)
    a[i]+=b[i];
}

