E_M4WARNING

/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided ``as is'' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */


ifdef(`E_EXTERNSTDINCLUDES',`extern "C"{')
#include <stdio.h>
#include <stdlib.h>
ifdef(`E_EXTERNSTDINCLUDES',`}')

#include "eco.h"


ifdef(`E_CPLUSPLUS',
`extern "C" {')
#include <pvm3.h>
ifdef(`E_CPLUSPLUS',
`}')

#ifndef max
#define max(a,b)  ((a)>(b)?(a):(b))
#define min(a,b)  ((a)<(b)?(a):(b))
#endif


static int* node_c_count;
static int* best_c_count;
static int* best_nodes;
static double best_cost;


typedef struct {
  int id;        /* identifier of this element in global context 
		    task == actual tid
		    machine == pvm machine rep
		    subnet == position in global subnet data array */
  int* members;
  int n_members;
  int* parent;
  int** children;
  int* n_children;
  int subnet_id;
  int subnet_index;
  int machine_id;
  int machine_index;
} eco_hier;


#define O_FRAC 0.25

void eco_pattern_gen(int p_i, int p, int* tids);
void brute_generate_perm(int n, int* nodes, int index, int* perm,
			 int* chosen);
void brute_generate_tree(int n, int* nodes, int index, int taken);
void brute_eval_pattern(int n, int* nodes);

void map_tids_to_machines(eco_hier* tasks, int n_tasks, eco_hier** machines, 
			  int* n_machines);
void map_subnets_to_machines(eco_hier* subnets, int n_subnets,
			     eco_hier* machines, int n_machines);
void map_machines_to_subnets(eco_hier* machines, int n_machines,
			     eco_hier** subnets, int* n_subnets);
void map_machines_to_tasks(eco_hier* machines, int n_machines,
			     eco_hier* tasks, int n_tasks);
void generate_inter_subnet_pattern(eco_hier* subnets, int n_subnets,
				   int target_subnet);
void brute_generate_pattern(int n, int* nodes);
void add_simple_tree(eco_hier* level, int n_level, int iam_level, int degree,
		     eco_hier* prev, int n_prev, int iam_prev);


static int mach_root; /* tid index of machine root process */
static int subnet_root; /* tid index of subnet root process */
static int iam_task; /* index of process in task array */
static int iam_machine; /* index of task's machine in machine array */
static int iam_subnet; /* index of tasks's subnet in subnet array */

int eco_pattern_init(int p_i, int p, int* tids)
{
  int i,j, root;
  int base_tree_c_c, assign_index;
  int subnet_start;
  int desc_id;


  /* allocate space for communication */
  ECO_tree_parent = (int*) malloc ((p+1) * sizeof(int));
  ECO_tree_child_count = (int*) malloc ((p+1) * sizeof(int));
  ECO_tree_children = (int**) malloc ((p+1) * sizeof(int*));
  ECO_tree_desc_info = (int**) malloc ((p+1)*sizeof(int*));
  for(i=0;i<p+1;i++)
    ECO_tree_desc_info[i] = (int*) malloc (p*sizeof(int));
  ECO_tree_desc_max = (int**) malloc ((p+1)*sizeof(int*));

  eco_pattern_gen(p_i, p, tids);

  /* copy information from root=0 to root=ALL */
  ECO_tree_parent[ECO_ALL] = ECO_tree_parent[0];
  ECO_tree_child_count[ECO_ALL] = ECO_tree_child_count[0];
  ECO_tree_children[ECO_ALL] = (int*) malloc (ECO_tree_child_count[ECO_ALL] *
					   sizeof(int));
  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    ECO_tree_children[ECO_ALL][i] = ECO_tree_children[0][i];

  /* transfer descendant information */
  for(root=0;root<p;root++) {
    if(ECO_tree_parent[root] != -1)
      pvm_recv(ECO_tree_parent[root], ECO_BEGIN_DESC);
    pvm_initsend(PvmDataDefault);
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i], ECO_BEGIN_DESC);

    /* initialize all pointers to default that links are above us */
    for(i=0;i<p;i++)
      ECO_tree_desc_info[root][i] = ECO_tree_child_count[root];

    for(i=0;i<ECO_tree_child_count[root];i++) {
      pvm_recv(ECO_tree_children[root][i], ECO_DESC_INFO);

      pvm_upkint(&desc_id, 1, 1);
      while (desc_id != -1) {
	ECO_tree_desc_info[root][desc_id] = i;
	pvm_upkint(&desc_id, 1, 1);
      }
    }

    if(ECO_tree_parent[root] != -1) {
      pvm_initsend(PvmDataDefault);
      for(i=0;i<p;i++)
	if((i== ECO_myid) ||
	   (ECO_tree_desc_info[root][i] != ECO_tree_child_count[root]))
	  pvm_pkint(&i, 1, 1);
      i=-1;
      pvm_pkint(&i,1,1);

      pvm_send(ECO_tree_parent[root], ECO_DESC_INFO);
    }

    /* send finish code */
    if(ECO_tree_parent[root] != -1)
      pvm_recv(ECO_tree_parent[root], ECO_DESC_FINISH);
    pvm_initsend(PvmDataDefault);
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i], ECO_DESC_FINISH);
  }


  for(root=0;root<p;root++){
    ECO_tree_desc_max[root] = (int*) malloc((ECO_tree_child_count[root]+1)*
					sizeof(int));
    for(i=0;i<=ECO_tree_child_count[root];i++)
      ECO_tree_desc_max[root][i] = -1;
      
    for(j=0;j<p;j++)
      if(ECO_tree_desc_max[root][ECO_tree_desc_info[root][j]] < j)
	ECO_tree_desc_max[root][ECO_tree_desc_info[root][j]] = j;
  }

      

  for(i=0;i<p;i++)
    ECO_tree_desc_info[p][i] = ECO_tree_desc_info[0][i];
  ECO_tree_desc_max[p] =
    (int*) malloc((ECO_tree_child_count[0]+1)*sizeof(int));
  for(i=0;i<=ECO_tree_child_count[0];i++)
    ECO_tree_desc_max[p][i] = ECO_tree_desc_max[0][i];

#ifdef PATTERN_PRINT
  printf ("iam=%x\n", pvm_mytid());
  for(root=0;root<p;root++) {
    printf ("parent= %x\n", ECO_tree_parent[root]);
    printf ("c_c = %i\n", ECO_tree_child_count[root]);
    for(i=0;i<ECO_tree_child_count[root];i++)
      printf ("child %i:%x\n", i,ECO_tree_children[root][i]);
    for(i=0;i<p;i++)
      printf ("%1i", ECO_tree_desc_info[root][i]);
    printf ("\n");
    for(i=0;i<=ECO_tree_child_count[root];i++)
      printf ("%3i", ECO_tree_desc_max[root][i]);
    printf ("\n");
  }
  fflush(NULL);
#endif

  
  return 0;
}



void eco_pattern_gen(int p_i, int p, int* tids)
{
  eco_hier* tasks;
  eco_hier* machines;
  eco_hier* subnets;
  
  int i,j,k;
  
  int n_machines;
  int n_subnets;
  int n_tasks = p;
  
  iam_task = p_i;

  node_c_count = (int*) malloc(p*sizeof(int));
  best_c_count = (int*) malloc(p*sizeof(int));
  best_nodes = (int*) malloc(p*sizeof(int));
  
  /* initialize so we can set the first time we encounter a 
     subnet or machine */
  subnet_root = -1;
  mach_root=-1;
  
  tasks = (eco_hier*) malloc(p*sizeof(eco_hier));
  for(i=0;i<p;i++){
    tasks[i].id = tids[i];
    tasks[i].n_members = 0;
    tasks[i].members=0x0; /* debugging... */
    tasks[i].parent = (int*) malloc(p*sizeof(int));
    tasks[i].n_children=(int*) malloc(p*sizeof(int));
    tasks[i].children=(int**) malloc(p*sizeof(int*));
    for(j=0;j<p;j++){
      tasks[i].parent[j] = -1;
      tasks[i].n_children[j] = 0;
    }
    tasks[i].subnet_id = subnet_map[i];
    if((subnet_map[i] == subnet_map[iam_task]) && (subnet_root==-1))
      subnet_root = i;
    tasks[i].machine_id = pvm_tidtohost(tids[i]);
    if ((mach_root==-1) &&
	(tasks[i].machine_id == pvm_tidtohost(tids[iam_task])))
      mach_root = i;
  }

  /* takes list of tids, maps to machines and returns list of (unique)
     machines */
  map_tids_to_machines(tasks, p, &machines, &n_machines);

  map_machines_to_subnets(machines, n_machines, &subnets, &n_subnets);

  if(subnet_root == iam_task) {
    generate_inter_subnet_pattern(subnets, n_subnets, iam_subnet);
    
    /* now distribute the results among the other tasks */
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&iam_subnet,1,1);
    for(i=0;i<n_subnets;i++){
      pvm_pkint(&(subnets[i].parent[iam_subnet]),1,1);
      pvm_pkint(&(subnets[i].n_children[iam_subnet]), 1, 1);
      if(subnets[i].n_children[iam_subnet]>0)
	pvm_pkint(subnets[i].children[iam_subnet],
		  subnets[i].n_children[iam_subnet],1);
    }
    for(i=0;i<n_tasks;i++)
      if(i!=iam_task)
	pvm_send(tids[i], ECO_SN_INIT);
  }

  for(i=0;i<n_subnets;i++)
    if(!((iam_subnet==i)&&(subnet_root==iam_task))){
      pvm_recv(-1,ECO_SN_INIT);
      pvm_upkint(&k,1,1);
      for(j=0;j<n_subnets;j++){
	pvm_upkint(&(subnets[j].parent[k]),1,1);
	pvm_upkint(&(subnets[j].n_children[k]), 1, 1);
	if(subnets[j].n_children[k] > 0){
	  subnets[j].children[k] = (int*)
	    malloc(subnets[j].n_children[k]*sizeof(int));
	  pvm_upkint(subnets[j].children[k],
		     subnets[j].n_children[k],1);
	}
      }
    }

  if(mach_root == iam_task){
    map_subnets_to_machines(subnets, n_subnets, machines, n_machines);
  
    add_simple_tree(machines, n_machines, iam_machine, 2, 
		    subnets, n_subnets, iam_subnet);
    if(machines[iam_machine].n_members > 1) {
      pvm_initsend(PvmDataDefault);
      pvm_pkint(machines[iam_machine].parent,n_machines,1);
      pvm_pkint(machines[iam_machine].n_children,n_machines,1);
      for(i=0;i<n_machines;i++)
	if(machines[iam_machine].n_children[i]>0)
	  pvm_pkint(machines[iam_machine].children[i], 
		    machines[iam_machine].n_children[i],1);
      for(i=1;i<machines[iam_machine].n_members;i++)
	pvm_send(tids[machines[iam_machine].members[i]], ECO_MC_INIT);
    }
  }
  else {
    pvm_recv(tids[machines[iam_machine].members[0]], ECO_MC_INIT);
    pvm_upkint(machines[iam_machine].parent,n_machines,1);
    pvm_upkint(machines[iam_machine].n_children,n_machines,1);
    for(i=0;i<n_machines;i++)
      if(machines[iam_machine].n_children[i]>0){
	machines[iam_machine].children[i] = (int*)
	  malloc(sizeof(int)*machines[iam_machine].n_children[i]);
	pvm_upkint(machines[iam_machine].children[i], 
		  machines[iam_machine].n_children[i],1);
      }
  }

  /* map machines back to tids and transfer patterns to first tidon
     listed machine
     */
  map_machines_to_tasks(machines, n_machines, tasks, n_tasks);
  
  add_simple_tree(tasks, n_tasks, iam_task, 2,
		  machines, n_machines, iam_machine);

  /* convert tid-index info into straight tid info */
  for(i=0;i<n_tasks;i++){
    if(tasks[iam_task].parent[i] != -1)
      tasks[iam_task].parent[i] = tids[tasks[iam_task].parent[i]];
    for(j=0;j<tasks[iam_task].n_children[i];j++)
      tasks[iam_task].children[i][j] = tids[tasks[iam_task].children[i][j]];
  }


  /* copy patterns into regular data structure */
  for(i=0;i<n_tasks;i++) {
    ECO_tree_parent[i] = tasks[iam_task].parent[i];
    ECO_tree_child_count[i] = tasks[iam_task].n_children[i];
    if(tasks[iam_task].n_children[i]>0){
      ECO_tree_children[i] = 
	(int*) malloc(tasks[iam_task].n_children[i]*sizeof(int));
      for(j=0;j<tasks[iam_task].n_children[i];j++)
	ECO_tree_children[i][j] = tasks[iam_task].children[i][j];
    }
  }
  

  /* free memory */
  for(i=0;i<n_subnets;i++){
    for(j=0;j<n_subnets;j++)
      if(subnets[i].n_children[j] != 0)
	free(subnets[i].children[j]);
    free(subnets[i].members);
    free(subnets[i].parent);
    free(subnets[i].n_children);
    free(subnets[i].children);
  }
  free(subnets);
  for(i=0;i<n_machines;i++){
    for(j=0;j<n_machines;j++)
      if(machines[i].n_children[j] != 0)
	free(machines[i].children[j]);
    free(machines[i].members);
    free(machines[i].parent);
    free(machines[i].n_children);
    free(machines[i].children);
  }
  free(machines);
  for(i=0;i<n_tasks;i++){
    for(j=0;j<n_tasks;j++)
      if(tasks[i].n_children[j] != 0)
	free(tasks[i].children[j]);
    /*free(tasks[i].members);*/
    free(tasks[i].parent);
    free(tasks[i].n_children);
    free(tasks[i].children);
  }
  free(tasks);

  free(best_c_count);
  free(node_c_count);
  free(best_nodes);

}
  
  
void map_tids_to_machines(eco_hier* tasks, int n_tasks, eco_hier** machines, 
			  int* n_machines)
{
  int i,j,k;
  int n_members;
  *n_machines=0;

  for(i=0;i<n_tasks;i++){
    for(j=0;j<i&&(tasks[j].machine_id!=tasks[i].machine_id);j++);
    if(j==i)
      (*n_machines)++;
  }

  *machines = (eco_hier*) malloc(*n_machines*sizeof(eco_hier));

  k=0;
  for(i=0;i<n_tasks;i++){
    for(j=0;j<i&&(tasks[j].machine_id!=tasks[i].machine_id);j++);
    if(j==i){
      (*machines)[k].id = tasks[i].machine_id;
      (*machines)[k].subnet_id = tasks[i].subnet_id;
      (*machines)[k].machine_id = tasks[i].machine_id;
      (*machines)[k].parent = (int*) malloc(*n_machines*sizeof(int));
      (*machines)[k].n_children=(int*)malloc(*n_machines*sizeof(int));
      (*machines)[k].children = (int**)malloc(*n_machines*sizeof(int*));
      k++;
    }
  }

  for(i=0;i<*n_machines;i++) {
    (*machines)[i].machine_index=i;
    n_members = 0;
    for(j=0;j<*n_machines;j++)
      (*machines)[i].n_children[j]=0;
    for(j=0;j<n_tasks;j++)
      if(tasks[j].machine_id == (*machines)[i].id){
	n_members++;
	tasks[j].machine_index = i;
      }
    (*machines)[i].n_members = n_members;
    (*machines)[i].members = (int*) malloc(n_members*sizeof(int));
    k=0;
    for(j=0;j<n_tasks;j++)
      if(tasks[j].machine_id == (*machines)[i].id){
	(*machines)[i].members[k++] = j;
	if(j==iam_task)
	  iam_machine = i;
      }
  }

}
  

void map_machines_to_subnets(eco_hier* machines, int n_machines,
			     eco_hier** subnets, int* n_subnets)
{
  int n_members;
  int i,j,k;
  *n_subnets=0;

  for(i=0;i<n_machines;i++){
    for(j=0;j<i&&(machines[j].subnet_id!=machines[i].subnet_id);j++);
    if(j==i)
      (*n_subnets)++;
  }

  *subnets = (eco_hier*) malloc(*n_subnets*sizeof(eco_hier));

  k=0;
  for(i=0;i<n_machines;i++){
    for(j=0;j<i&&(machines[j].subnet_id!=machines[i].subnet_id);j++);
    if(j==i){
      (*subnets)[k].id = machines[i].subnet_id;
      (*subnets)[k].subnet_id = machines[i].subnet_id; 
      (*subnets)[k].parent = (int*) malloc(*n_subnets*sizeof(int));
      (*subnets)[k].n_children=(int*)malloc(*n_subnets*sizeof(int));
      (*subnets)[k].children = (int**)malloc(*n_subnets*sizeof(int*));
      k++;
    }
  }

  for(i=0;i<*n_subnets;i++) {
    (*subnets)[i].subnet_index = i;
    n_members = 0;
    for(j=0;j<(*n_subnets);j++)
      (*subnets)[i].n_children[j]=0;
    for(j=0;j<n_machines;j++)
      if(machines[j].subnet_id == (*subnets)[i].id){
	n_members++;
	machines[j].subnet_index = i;
	if(n_members==1)
	  (*subnets)[i].machine_index = j;
      }
    (*subnets)[i].n_members = n_members;
    (*subnets)[i].members = (int*) malloc(n_members*sizeof(int));
    k=0;
    for(j=0;j<n_machines;j++)
      if(machines[j].subnet_id == (*subnets)[i].id){
	(*subnets)[i].members[k++] = j;
	if(j==iam_machine)
	  iam_subnet = i;
      }
  }

}
  

void map_subnets_to_machines(eco_hier* subnets, int n_subnets,
			     eco_hier* machines, int n_machines)
{
  int i,j;
  int root;

  for(root=0;root<n_machines;root++){
    if(machines[root].subnet_index == iam_subnet){
      if(iam_machine == root){
	machines[root].n_children[root] = 
	  subnets[machines[root].subnet_index].n_children[machines[root].subnet_index];
	machines[root].children[root] = 
	  (int*) malloc(machines[root].n_children[root]*sizeof(int));
	for(i=0;i<machines[root].n_children[root];i++)
	  machines[root].children[root][i] =
	    subnets[subnets[machines[root].subnet_index].children[machines[root].subnet_index][i]].members[0];
	machines[root].parent[root]=-1;
      }
      else { /* I am in subnet but not the root */ 
	machines[iam_machine].parent[root] = root;
	machines[iam_machine].n_children[root] = 0;
      }
    }
    else { /* not in subnet with root */
      if(iam_machine == subnets[iam_subnet].members[0]) {
	/* i am root for this subnet */
	machines[iam_machine].n_children[root] = 
	  subnets[iam_subnet].n_children[machines[root].subnet_index];
	machines[iam_machine].children[root] = 
	  (int*) malloc(machines[iam_machine].n_children[root]*sizeof(int));
	for(i=0;i<machines[iam_machine].n_children[root];i++)
	  machines[iam_machine].children[root][i] = 
	    subnets[subnets[iam_subnet].children[machines[root].subnet_index][i]].members[0];

	if(machines[root].subnet_index == 
	   subnets[iam_subnet].parent[machines[root].subnet_index])
	  machines[iam_machine].parent[root]=root;
	else
	  machines[iam_machine].parent[root] = 
	    subnets[subnets[iam_subnet].parent[machines[root].subnet_index]].members[0];
      }
      else { /* in subnet, but not root */
	machines[iam_machine].parent[root] = subnet_root;
	machines[iam_machine].n_children[root] = 0;
      }
    }
  }
}




void map_machines_to_tasks(eco_hier* machines, int n_machines,
			     eco_hier* tasks, int n_tasks)
{
  int i,j;
  int root;

  for(root=0;root<n_tasks;root++){
    if(tasks[root].machine_index == iam_machine){
      if(iam_task == root){
	tasks[root].n_children[root] = 
	  machines[tasks[root].machine_index].n_children[tasks[root].machine_index];
	tasks[root].children[root] = 
	  (int*) malloc(tasks[root].n_children[root]*sizeof(int));
	for(i=0;i<tasks[root].n_children[root];i++)
	  tasks[root].children[root][i] =
	    machines[machines[tasks[root].machine_index].children[tasks[root].machine_index][i]].members[0];
	tasks[root].parent[root]=-1;
      }
      else { /* I am in subnet but not the root */ 
	tasks[iam_task].parent[root] = root;
	tasks[iam_task].n_children[root] = 0;
      }
    }
    else { /* not in subnet with root */
      if(iam_task == machines[iam_machine].members[0]) {
	/* i am root for this subnet */
	tasks[iam_task].n_children[root] = 
	  machines[iam_machine].n_children[tasks[root].machine_index];
	tasks[iam_task].children[root] = 
	  (int*) malloc(tasks[iam_task].n_children[root]*sizeof(int));
	for(i=0;i<tasks[iam_task].n_children[root];i++)
	  tasks[iam_task].children[root][i] = 
	    machines[machines[iam_machine].children[tasks[root].machine_index][i]].members[0];

	if(tasks[root].machine_index ==
	   machines[iam_machine].parent[tasks[root].machine_index])
	  tasks[iam_task].parent[root] = root;
	else
	  tasks[iam_task].parent[root] = 
	    machines[machines[iam_machine].parent[tasks[root].machine_index]].members[0];
      }
      else { /* in subnet, but not root */
	tasks[iam_task].parent[root] = mach_root;
	tasks[iam_task].n_children[root] = 0;
      }
    }
  }
}



void add_simple_tree(eco_hier* level, int n_level, int iam_level, int degree,
		     eco_hier* prev, int n_prev, int iam_prev)
{
  int i,j;
  int root, parent, taken, n_to_take;

  for(root=0;root<n_level;root++) {
    /* check if root is in my subnet */
    for(i=0;(prev[iam_prev].members[i]!=root) && 
	  (i<prev[iam_prev].n_members) ;i++);
    if (i<prev[iam_prev].n_members){
      /* root is in my subnet */
      int reordered[prev[iam_prev].n_members];
      for(j=0;j<prev[iam_prev].n_members;j++)
	reordered[j] = prev[iam_prev].members[j];
      reordered[i] = reordered[0];
      reordered[0] = prev[iam_prev].members[i];
      taken = 1;
      parent=0;
      while (taken < prev[iam_prev].n_members) {
	/* if I'm the node, allocate space (additional if nec */
	if(reordered[parent] == iam_level) {
	  if (level[iam_level].n_children[root] > 0)
	    level[iam_level].children[root] = (int*)
	      realloc(level[iam_level].children[root], 
		      sizeof(int)*(level[iam_level].n_children[root]+
		      min(degree,  prev[iam_prev].n_members-taken)));
	  else
	    level[iam_level].children[root] = (int*)
	      malloc(sizeof(int)*min(degree, prev[iam_prev].n_members-taken));
	}
	/* increment taken one step at a time */
	n_to_take = min(degree, prev[iam_prev].n_members-taken);
	for(i=0;i<n_to_take;i++) {
	  /* if parent, add to children */
	  if(reordered[parent] == iam_level)
	    level[iam_level].children[root][level[iam_level].n_children[root]++] = 
	      reordered[taken];
	  /* if child, set parent */
	  if(iam_level==reordered[taken])
	    level[iam_level].parent[root] = reordered[parent];
	  taken++;
	}
	parent++;
      }
      
    }
    else{
      /* don't need to worry about root in my subnet */
      taken = 1;
      parent=0;
      while (taken < prev[iam_prev].n_members) {
	/* if I'm the node, allocate space (additional if nec */
	if(prev[iam_prev].members[parent] == iam_level) {
	  if (level[iam_level].n_children[root] > 0)
	    level[iam_level].children[root] =(int*)
	      realloc(level[iam_level].children[root], 
		      sizeof(int)*(level[iam_level].n_children[root]+
		      min(degree,  prev[iam_prev].n_members-taken)));
	  else
	    level[iam_level].children[root] = (int*)
	      malloc(sizeof(int)*min(degree, prev[iam_prev].n_members-taken));
	}
	/* increment taken one step at a time */
	n_to_take = min(degree, prev[iam_prev].n_members-taken);
	for(i=0;i<n_to_take;i++) {
	  /* if parent, add to children */
	  if(prev[iam_prev].members[parent] == iam_level)
	    level[iam_level].children[root][level[iam_level].n_children[root]++] = 
	      prev[iam_prev].members[taken];
	  /* if child, set parent */
	  if(iam_level==prev[iam_prev].members[taken])
	    level[iam_level].parent[root] = prev[iam_prev].members[parent];
	  taken++;
	}
	parent++;
      }
      
      
    }
  }
}  

void generate_inter_subnet_pattern(eco_hier* subnets, int n_subnets,
				   int target_subnet)
{
  int* nodelist;
  int i,j,k,l;
  int child_index = 1;

  best_cost = 1e10;
  /* copy subnet id's into array so we need to shovel less data around
     in the generating calls */
  nodelist = (int*) malloc(n_subnets*sizeof(int));
  for(i=1;i<n_subnets;i++)
    if(i!= target_subnet)
      nodelist[i] = subnets[i].subnet_id;
    else
      nodelist[0] = subnets[i].subnet_id;
  nodelist[target_subnet] = subnets[0].subnet_id;

  brute_generate_pattern(n_subnets, nodelist);
  
  subnets[target_subnet].parent[target_subnet] = -1;
  for(i=0;i<n_subnets;i++){
    for(j=0;best_nodes[i]!= subnets[j].subnet_id&&j<n_subnets;j++);
    if(j==n_subnets)
      fprintf(stderr, "what???\n");
    subnets[j].n_children[target_subnet] = best_c_count[i];
    if(best_c_count[i] > 0) {
      subnets[j].children[target_subnet] =
	(int*) malloc(best_c_count[i]*sizeof(int));
      for(k=0;k<best_c_count[i];k++){
	for(l=0;nodelist[child_index]!=subnets[l].subnet_id;l++);
	subnets[j].children[target_subnet][k] = l;
	subnets[l].parent[target_subnet] = j;
	child_index++;
      }
    }
  }
  free(nodelist);
}

void brute_generate_pattern(int n, int* nodes)
{
  int i;

  int *perm;
  int *chosen;

  perm = (int*) malloc(n*sizeof(int));
  chosen = (int*) malloc(n*sizeof(int));

  perm[0]=nodes[0];
  chosen[0]=1;
  for(i=1;i<n;i++)
    chosen[i] = 0;

  brute_generate_perm(n, nodes, 1, perm, chosen);
  free(perm);
  free(chosen);
}


void brute_generate_perm(int n, int* nodes, int index, int* perm,
			 int* chosen)
{
  int i;

  /*printf ("bgp %i\n", index);*/
  if (index <n) {
    for(i=1;i<n;i++) 
      if(chosen[i] == 0) {
	chosen[i] = 1;
	perm[index] = nodes[i];

	brute_generate_perm(n,nodes,index+1,perm,chosen);
	chosen[i]=0;
      }
  }
  else {
    for (i=0;i<n;i++)
      node_c_count[i] = 0;

    brute_generate_tree( n, perm, 0, 1);
  }
}

void brute_generate_tree(int n, int* nodes, int index, int taken)
{
  int i;

  /*printf ("bgt %i %i\n", index, taken);*/
  if(taken == n) {
    /* we made it, this is a functional pattern */
    brute_eval_pattern(n, nodes);
    return;
  }

  if (index  < taken) {
    for(i=0;i<=(n-taken);i++) {
      node_c_count[index] = i;
      brute_generate_tree(n, nodes, index+1, taken+i);
    }
    node_c_count[index] = 0;
  }
}



void brute_eval_pattern(int n, int* nodes)
{
  static double *time_to=NULL;
  static double *overhead_accum=NULL;
  static n_alloc = 0;
  int i,j,k;
  double max_time=0;
  double temp;
  int itemp;

  if(n>n_alloc){
    if(time_to == NULL){
      time_to = (double*)malloc(n*sizeof(double));
      overhead_accum = (double*)malloc(n*sizeof(double));
    }
    else {
      time_to = (double*)realloc(time_to,
				 n*sizeof(double));
      overhead_accum = (double*)realloc(overhead_accum,
					n*sizeof(double));
    }
    n_alloc = n;
  }

  for(i=0;i<n;i++){
    time_to[i] = 0;
    overhead_accum[i] = 0;
  }

  k=0;
  for(i=0;i<n&&max_time< best_cost;i++)
    for(j=0;j<node_c_count[i]&&max_time < best_cost;j++){
      k++;
      overhead_accum[i] += O_FRAC*
	inter_subnet_times[min(nodes[i],nodes[k])][max(nodes[i],nodes[k])];
      time_to[k]=time_to[i]+overhead_accum[i]+
	(1-O_FRAC)*
	inter_subnet_times[min(nodes[i],nodes[k])][max(nodes[i],nodes[k])];
      max_time = max(time_to[k],max_time);
    }

  /*for(i=0;i<n;i++)
   if(time_to[i]>max_time)
   max_time = time_to[i];*/

  if(max_time < best_cost) {
    best_cost = max_time;
    for(i=0;i<n;i++){
      best_nodes[i]=nodes[i];
      best_c_count[i] = node_c_count[i];
    }
  }
}
