E_M4WARNING

/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided ``as is'' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */

#ifndef ECO_ALG_H
#define ECO_ALG_H


ifdef(`E_CPLUSPLUS',`#pragma interface',`#include "eco.h"')


#undef min
#undef max
#define max(a,b)  ((a)>(b)?(a):(b))
#define min(a,b)  ((a)<(b)?(a):(b))


define(E_PRE, ifdef(`E_CPLUSPLUS',`template <class T>',`'))
define(E_DEF_TYPE, ifdef(`E_CPLUSPLUS',`T',`void'))
define(E_OP_TYPE, ifdef(`E_CPLUSPLUS',`int',`int'))
define(E_TYPE_ARG, ifdef(`E_CPLUSPLUS',`',``, int Arg_Type''))
define(E_TYPE_STORAGE,ifdef(`E_CPLUSPLUS',`T $1[$2]',
	`double $1t[$2]; void* $1 = $1t'))
define(E_TYPE_COPY, ifdef(`E_CPLUSPLUS',`$1[$2] = $3[$4]',
     `
switch(Arg_Type){
case Eco_Int:
  ((int*)$1)[$2] = ((int*)$3)[$4];
  break;
case Eco_Long:
  ((long*)$1)[$2] = ((long*)$3)[$4];
  break;
case Eco_Float:
  ((float*)$1)[$2] = ((float*)$3)[$4];
  break;
case Eco_Double:
  ((double*)$1)[$2] = ((double*)$3)[$4];
  break;
case Eco_Char:
  ((char*)$1)[$2] = ((char*)$3)[$4];
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
'))

define(E_PVM_PK,ifdef(`E_CPLUSPLUS',`pvm_pk($1,$2,$3)',
`
switch(Arg_Type) {
case Eco_Int:
  pvm_pkint((int*)$1,$2,$3);
  break;
case Eco_Long:
  pvm_pklong((long*)$1,$2,$3);
  break;
case Eco_Float:
  pvm_pkfloat((float*)$1,$2,$3);
  break;
case Eco_Double:
  pvm_pkdouble((double*)$1,$2,$3);
  break;
case Eco_Char:
  pvm_pkbyte((char*)$1,$2,$3);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
'))
define(E_PVM_PK_I,ifdef(`E_CPLUSPLUS',`pvm_pk($1+$2,$3,$4)',`
switch (Arg_Type) {
case Eco_Int:
  pvm_pkint(((int*)$1)+$2,$3,$4);
  break;
case Eco_Long:
  pvm_pklong(((long*)$1)+$2,$3,$4);
  break;
case Eco_Float:
  pvm_pkfloat(((float*)$1)+$2,$3,$4);
  break;
case Eco_Double:
  pvm_pkdouble(((double*)$1)+$2,$3,$4);
  break;
case Eco_Char:
  pvm_pkbyte(((char*)$1)+$2,$3,$4);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
'))
define(E_PVM_UPK,ifdef(`E_CPLUSPLUS',`pvm_upk($1,$2,$3)',`
switch(Arg_Type) {
case Eco_Int:
  pvm_upkint((int*)$1,$2,$3);
  break;
case Eco_Long:
  pvm_upklong((long*)$1,$2,$3);
  break;
case Eco_Float:
  pvm_upkfloat((float*)$1,$2,$3);
  break;
case Eco_Double:
  pvm_upkdouble((double*)$1,$2,$3);
  break;
case Eco_Char:
  pvm_upkbyte((char*)$1,$2,$3);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
'))


define(E_PVM_UPK_I, ifdef(`E_CPLUSPLUS', `pvm_upk($1+$2,$3,$4)',`
switch (Arg_Type) {
case Eco_Int:
  pvm_upkint(((int*)$1)+$2,$3,$4);
  break;
case Eco_Long:
  pvm_upklong(((long*)$1)+$2,$3,$4);
  break;
case Eco_Float:
  pvm_upkfloat(((float*)$1)+$2,$3,$4);
  break;
case Eco_Double:
  pvm_upkdouble(((double*)$1)+$2,$3,$4);
  break;
case Eco_Char:
  pvm_upkbyte(((char*)$1)+$2,$3,$4);
  break;
default:
  fprintf (stderr, "unknown type\n");
  abort();
}
'))


ifdef(`E_CPLUSPLUS',`',define(E_REDU_OP,
	`switch ($1) {
	case ECO_OP_ADD:
	  for($2=0;$2<$3;$2++)
	    (($8*)$4)[$5]+=(($8*)$6)[$7];
	  break;
	case ECO_OP_MULT:
	  for($2=0;$2<$3;$2++)
	    (($8*)$4)[$5]*=(($8*)$6)[$7];
	    break;
	case ECO_OP_MAX:
	  for($2=0;$2<$3;$2++)
	    (($8*)$4)[$5]=max((($8*)$6)[$7], (($8*)$4)[$5]);
	  break;
	case ECO_OP_MIN:
	  for($2=0;$2<$3;$2++)
	    (($8*)$4)[$5]=min((($8*)$6)[$7],(($8*)$4)[$5]);
	  break;
	default:
          eco_oper_list[$1]($6,$4,$3,&($2));
	  break;
	}'))

ifelse(`E_REDUCTION  args
operation, i(iteration variable), length, a, i_a(a iteration variable),
	b, i_b(b iteration variable))
a[i_a]oper=b[i_b]')
define(E_REDUCTION,ifdef(`E_CPLUSPLUS',`
	switch ($1) {
	case ECO_OP_ADD:
	  for($2=0;$2<$3;$2++)
	    $4[$5]+=$6[$7];
	  break;
	case ECO_OP_MULT:
	  for($2=0;$2<$3;$2++)
	    $4[$5]*=$6[$7];
	    break;
	case ECO_OP_MAX:
	  for($2=0;$2<$3;$2++)
	    $4[$5]=max($6[$7], $4[$5]);
	  break;
	case ECO_OP_MIN:
	  for($2=0;$2<$3;$2++)
	    $4[$5]=min($6[$7],$4[$5]);
	  break;
	default:
          eco_oper_list[$1]($6,$4,$3,&($2));
	  break;
	}',`
switch(Arg_Type) {
	case Eco_Int:
		E_REDU_OP($1,$2,$3,$4,$5,$6,$7,int);
		break;
	case Eco_Long:
		E_REDU_OP($1,$2,$3,$4,$5,$6,$7, long);
		break;
	case Eco_Double:
		E_REDU_OP($1,$2,$3,$4,$5,$6,$7, double);
		break;
	case Eco_Float:
		E_REDU_OP($1,$2,$3,$4,$5,$6,$7, float);
		break;
	case Eco_Char:
		E_REDU_OP($1,$2,$3,$4,$5,$6,$7, char);
		break;
	default:
		fprintf (stderr, "unknown type\n");
		abort();
}'))

ifdef(`E_CPLUSPLUS',`#include "pvm3pack.h"')
ifdef(`E_EXTERNSTDINCLUDES',`extern "C"{')
#include <stdio.h>
#include <stdlib.h>
#include <pvm3.h>
ifdef(`E_EXTERNSTDINCLUDES',`}')

/* eco_gather (IN send_vector[], IN int send_length, IN int send_stride, */
/* 	    IN int send_offset, */
/* 	    OUT recv_vector[], IN int recv_length, IN int recv_stride, */
/* 	    IN int root, IN TYPE) */

/* send_vector: vector with data to be gathered */
/* send_length: number of data elements in send_vector */
/* send_stride: stride for data in send_vector */
/* send_offset: position of send_vector in recv_vector */
/* recv_vector: resulting vector (root) */
/* recv_len: size of recv_vector (in terms of data elements) (root) */
/* recv_stride: stride of data in recv_vector (root) */
/* root: gathering process or ECO_ALL */

/* gather takes all send vectors contributed by processes and combines them */
/* to form recv_vector, which is only used at root, unless root=ECO_ALL, in  */
/* which case all processes receive the recv_vector.  Overlapping send */
/* ranges will produce unpredictable results. */

/* send_offset should specify the destination address with recv_stride already */
/* accounted for.  Note that length parameters should not include stride */

E_PRE int eco_gather(E_DEF_TYPE* send_vect, int send_len, int send_stride,
		     int send_offset,
		     E_DEF_TYPE* recv_vect, int recv_len, int recv_stride,
		     int root E_TYPE_ARG)
{
  int i,j;
  int r_loc, r_len;
  ECO_NEW_MTAG;

  if(ECO_tree_parent[root] != -1){
    pvm_initsend(PvmDataDefault);
  }
  else 
    for(i=0;i<send_len;i++)
      E_TYPE_COPY(recv_vect,send_offset+i*recv_stride,send_vect,
		  i*send_stride);
      
  /*fprintf (stderr, "root= %i\n", root);*/

  for (i=0;i<ECO_tree_child_count[root];i++) {
    pvm_recv(-1,ECO_GATHER_UP);
    pvm_upkint(&r_loc,1,1);
    while(r_loc != -1) {
      pvm_upkint(&r_len, 1, 1);
      if((root==ECO_ALL)||(root==ECO_myid)) {
	/*printf ("loc %i, len %i (%i,%i)\n", r_loc, r_len,
		recv_len, recv_stride);*/
	if(r_loc+(r_len-1)*recv_stride <= recv_len*recv_stride) {
	  /*printf ("before:");
	  for(j=0;j<recv_len*recv_stride;j++)
	    printf ("%4.1lf ", recv_vect[j]);
	  printf ("\n");*/
	  E_PVM_UPK_I(recv_vect, r_loc, r_len, recv_stride);
	  /*printf ("after:");
	  for(j=0;j<recv_len*recv_stride;j++)
	    printf ("%4.1lf ", recv_vect[j]);
	  printf ("\n");*/
	  
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&r_loc,1,1);
	    pvm_pkint(&r_len,1,1);
	    E_PVM_PK_I(recv_vect, r_loc, r_len, recv_stride);
	  }
	}
	else {
	  int len1, len2, loc2;
	  fprintf(stderr, "AAAARRRRRRGGGGGHHHH unwrapping!\n");
	  len1 = r_loc+r_len - recv_len*recv_stride;
	  E_PVM_UPK_I(recv_vect, r_loc, len1, recv_stride);
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&r_loc,1,1);
	    pvm_pkint(&len1, 1, 1);
	    E_PVM_PK_I(recv_vect, r_loc, len1, recv_stride);
	  }
	  
	  loc2 = 0;
	  len2 = r_len - len1;
	  E_PVM_UPK(((E_DEF_TYPE*) recv_vect), len2, recv_stride);
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&loc2,1,1);
	    pvm_pkint(&len2, 1, 1);
	    E_PVM_PK(((E_DEF_TYPE*) recv_vect), len2, recv_stride);
	  }
	}
      }
      else {
	E_TYPE_STORAGE(tmp_data, r_len);
	
	E_PVM_UPK(((E_DEF_TYPE*) tmp_data), r_len, 1);
	pvm_pkint(&r_loc,1,1);
	pvm_pkint(&r_len,1,1);
	E_PVM_PK(((E_DEF_TYPE*) tmp_data), r_len, 1);
      }
      pvm_upkint(&r_loc, 1, 1);
    }
  }

  if(ECO_tree_parent[root] != -1) {
    /*printf ("%i packing %i %i(%i):", ECO_myid, send_offset, send_len,
	    send_stride);
    for(i=0;i<send_len*send_stride;i++)
      printf ("%4.1lf ", send_vect[i]);
    printf("\n");*/
    pvm_pkint(&send_offset, 1, 1);
    pvm_pkint(&send_len, 1, 1);
    E_PVM_PK(send_vect, send_len, send_stride);

    i=-1;
    pvm_pkint(&i,1,1);
    pvm_send(ECO_tree_parent[root], ECO_GATHER_UP);
  
  }

  if(root == ECO_ALL) {
    if(ECO_tree_parent[ECO_ALL] != -1) {
      pvm_recv(ECO_tree_parent[root], ECO_GATHER_DOWN);
      pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
    }
    else {
      pvm_initsend(PvmDataDefault);
      E_PVM_PK(recv_vect, recv_len,recv_stride);
    }

    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i],ECO_GATHER_DOWN);
    
    if(ECO_tree_parent[ECO_ALL] != -1) {
      pvm_freebuf(pvm_setrbuf(pvm_getsbuf()));
      E_PVM_UPK(recv_vect, recv_len, recv_stride);
    }
  }
  
  return 0;
}

E_PRE int eco_gatherv(int num_vect, 
		      E_DEF_TYPE** send_vect, int send_len, int send_stride,
		     int send_offset,
		     E_DEF_TYPE** recv_vect, int recv_len, int recv_stride,
		     int root E_TYPE_ARG)
{
  int i,j,v;
  int r_loc, r_len;
  ECO_NEW_MTAG;

  if(ECO_tree_parent[root] != -1){
    pvm_initsend(PvmDataDefault);
  }
  else 
    for(v=0;v<num_vect;v++)
      for(i=0;i<send_len;i++)
	E_TYPE_COPY(recv_vect[v],send_offset+i*recv_stride,send_vect[v],
		    i*send_stride);
      
  /*fprintf (stderr, "root= %i\n", root);*/

  for (i=0;i<ECO_tree_child_count[root];i++) {
    pvm_recv(-1,ECO_GATHER_UP);
    pvm_upkint(&r_loc,1,1);
    while(r_loc != -1) {
      pvm_upkint(&r_len, 1, 1);
      if((root==ECO_ALL)||(root==ECO_myid)) {
	/*printf ("loc %i, len %i (%i,%i)\n", r_loc, r_len,
		recv_len, recv_stride);*/
	if(r_loc+(r_len-1)*recv_stride <= recv_len*recv_stride) {
	  /*printf ("before:");
	  for(j=0;j<recv_len*recv_stride;j++)
	    printf ("%4.1lf ", recv_vect[j]);
	  printf ("\n");*/
	  for(v=0;v<num_vect;v++)
	    E_PVM_UPK_I(recv_vect[v], r_loc, r_len, recv_stride);
	  /*printf ("after:");
	  for(j=0;j<recv_len*recv_stride;j++)
	    printf ("%4.1lf ", recv_vect[j]);
	  printf ("\n");*/
	  
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&r_loc,1,1);
	    pvm_pkint(&r_len,1,1);
	    for(v=0;v<num_vect;v++)
	      E_PVM_PK_I(recv_vect[v], r_loc, r_len, recv_stride);
	  }
	}
	else {
	  int len1, len2, loc2;
	  fprintf(stderr, "AAAARRRRRRGGGGGHHHH unwrapping!\n");
	  len1 = r_loc+r_len - recv_len*recv_stride;
	  for(v=0;v<num_vect;v++)
	    E_PVM_UPK_I(recv_vect[v], r_loc, len1, recv_stride);
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&r_loc,1,1);
	    pvm_pkint(&len1, 1, 1);
	    for(v=0;v<num_vect;v++)
	      E_PVM_PK_I(recv_vect[v], r_loc, len1, recv_stride);
	  }
	  
	  loc2 = 0;
	  len2 = r_len - len1;
	  for(v=0;v<num_vect;v++)
	    E_PVM_UPK(((E_DEF_TYPE*) recv_vect[v]), len2, recv_stride);
	  if(ECO_tree_parent[root] != -1) {
	    pvm_pkint(&loc2,1,1);
	    pvm_pkint(&len2, 1, 1);
	    for(v=0;v<num_vect;v++)
	      E_PVM_PK(((E_DEF_TYPE*) recv_vect[v]), len2, recv_stride);
	  }
	}
      }
      else {
	E_TYPE_STORAGE(tmp_data, r_len);
	pvm_pkint(&r_loc,1,1);
	pvm_pkint(&r_len,1,1);

	for(v=0;v<num_vect;v++){
	  E_PVM_UPK(((E_DEF_TYPE*) tmp_data), r_len, 1);
	  E_PVM_PK(((E_DEF_TYPE*) tmp_data), r_len, 1);
	}
      }
      pvm_upkint(&r_loc, 1, 1);
    }
  }

  if(ECO_tree_parent[root] != -1) {
    /*printf ("%i packing %i %i(%i):", ECO_myid, send_offset, send_len,
	    send_stride);
    for(i=0;i<send_len*send_stride;i++)
      printf ("%4.1lf ", send_vect[i]);
    printf("\n");*/
    pvm_pkint(&send_offset, 1, 1);
    pvm_pkint(&send_len, 1, 1);
    for(v=0;v<num_vect;v++)
      E_PVM_PK(send_vect[v], send_len, send_stride);

    i=-1;
    pvm_pkint(&i,1,1);
    pvm_send(ECO_tree_parent[root], ECO_GATHER_UP);
  
  }

  if(root == ECO_ALL) {
    if(ECO_tree_parent[ECO_ALL] != -1) {
      pvm_recv(ECO_tree_parent[root], ECO_GATHER_DOWN);
      pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
    }
    else {
      pvm_initsend(PvmDataDefault);
      for(v=0;v<num_vect;v++)
	E_PVM_PK(recv_vect[v], recv_len,recv_stride);
    }

    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i],ECO_GATHER_DOWN);
    
    if(ECO_tree_parent[ECO_ALL] != -1) {
      pvm_freebuf(pvm_setrbuf(pvm_getsbuf()));
      for(v=0;v<num_vect;v++)
	E_PVM_UPK(recv_vect[v], recv_len, recv_stride);
    }
  }
  
  return 0;
}



/* eco_scatter(IN send_vector[], IN int send_length, IN int send_stride, */
/* 	IN int lengths[], IN int offsets[], */
/* 	OUT recv_vector[], IN int recv_length, IN int recv_stride, */
/* 	IN int root, IN TYPE) */

/* send_vector: data to be scattered (root) */
/* send_length: number of data items (root) */
/* send_stride: stride of data in send_vector (root) */
/* lengths: number of items process i should receive (root) */
/* offsets: offset of data process i should receive (root) */
/* recv_vector: part of data for process  */
/* recv_length: length of data for process  */
/* recv_stride: stride of data in recv_vector */
/* root: scattering process */

/* scatter divides data input on root and distributes one chunk to each process */
/* (including the root process).  It does check that output_vector is large */
/* enough to store what is passed to it, although overlaps within send_vector */
/* are not checked for. */

/* Note that offsets should specify the source address with stride already */
/* accounted for.  length parameters should not include stride */
E_PRE int eco_scatter(E_DEF_TYPE* send_vector, int send_length,int send_stride,
		       int* length, int* offset, 
		       E_DEF_TYPE* recv_vector, int* recv_length,
		      int recv_stride, 
		       int root E_TYPE_ARG)
{
  int i,j;
  int dummy_int[2];
  E_TYPE_STORAGE(dummy_t, 2);
  int my_offset;
  int unstrided_offsets[ECO_p];
  
  ECO_NEW_MTAG;

  if(ECO_myid == root) {
    for(i=0;(i<ECO_p) && ((offset[i]+(length[i]-1)*send_stride)<=
			  send_length*send_stride);i++);
    if (i==ECO_p) {
      for(j=0;j<ECO_p;j++)
	unstrided_offsets[j] = offset[j]/send_stride;
      pvm_initsend(PvmDataDefault);
      pvm_pkint(length, ECO_p, 1);
      pvm_pkint(unstrided_offsets, ECO_p, 1);
      E_PVM_PK(send_vector, send_length, send_stride);
      for(i=0;i<ECO_tree_child_count[root];i++)
	pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
    }
    else /* oh great, we have to unwrap it */  {
      int wrap_offset = offset[i];
      int wrap_length = length[i];
      int wrapped = wrap_offset+wrap_length - send_length;
      int unwrap_offset[ECO_p];
      E_TYPE_STORAGE(unwrap_data, send_length);
      printf ("OH NO!  Not unwrapping!\n");
      for(i=0;i<ECO_p;i++)
	unwrap_offset[i] = offset[i]-wrapped;
      
      for(i=0;i<(send_length-wrapped);i++)
	E_TYPE_COPY(unwrap_data, i, send_vector, wrapped+i);
      for(i=0;i<wrapped;i++)
	E_TYPE_COPY(unwrap_data, (send_length-wrapped)+i, 
		    send_vector, i);

#if 0
      memcpy(unwrap_data, &(send_vector[wrapped]),
	     (send_length - wrapped)*
	     sizeof(E_DEF_TYPE));
      memcpy(&(unwrap_data[send_length - wrapped]),
	     send_vector, wrapped*
	     sizeof(E_DEF_TYPE));
#endif
      
      pvm_initsend(PvmDataDefault);
      pvm_pkint(length, ECO_p, 1);
      pvm_pkint(unwrap_offset, ECO_p, 1);
      E_PVM_PK(unwrap_data, send_length, send_stride);
      for(i=0;i<ECO_tree_child_count[root];i++)
	pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
    }
    
  }
  else {
    pvm_recv(ECO_tree_parent[root], ECO_BCAST_MSG);
    pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
  }


  pvm_setrbuf(pvm_getsbuf());

  for(i=0;i<ECO_myid;i++)
    pvm_upkint(dummy_int,1,1);
  pvm_upkint(recv_length, 1, 1);
  for(i=ECO_myid+1;i<ECO_p;i++)
    pvm_upkint(dummy_int,1,1);
  for(i=0;i<ECO_myid;i++)
    pvm_upkint(dummy_int,1,1);
  pvm_upkint(&my_offset, 1, 1);
  for(i=ECO_myid+1;i<ECO_p;i++)
    pvm_upkint(dummy_int,1,1);
  for(i=0;i<my_offset;i++)
    E_PVM_UPK(dummy_t,1,1);

  E_PVM_UPK(recv_vector, *recv_length, recv_stride);
  return 0;
  
}

E_PRE int eco_scatterv(int num_vect,
		       E_DEF_TYPE** send_vector, int send_length,int send_stride,
		       int* length, int* offset, 
		       E_DEF_TYPE** recv_vector, int* recv_length,
		      int recv_stride, 
		       int root E_TYPE_ARG)
{
  int i,j,v;
  int dummy_int[2];
  E_TYPE_STORAGE(dummy_t, 2);
  int my_offset;
  int unstrided_offsets[ECO_p];
  
  ECO_NEW_MTAG;

  if(ECO_myid == root) {
    for(i=0;(i<ECO_p) && ((offset[i]+(length[i]-1)*send_stride)<=
			  send_length*send_stride);i++);
    if (i==ECO_p) {
      for(j=0;j<ECO_p;j++)
	unstrided_offsets[j] = offset[j]/send_stride;
      pvm_initsend(PvmDataDefault);
      pvm_pkint(&send_length, 1,1);
      pvm_pkint(length, ECO_p, 1);
      pvm_pkint(unstrided_offsets, ECO_p, 1);
      for(v=0;v<num_vect;v++)
	E_PVM_PK(send_vector[v], send_length, send_stride);
      for(i=0;i<ECO_tree_child_count[root];i++)
	pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
    }
    else /* oh great, we have to unwrap it */  {
      int wrap_offset = offset[i];
      int wrap_length = length[i];
      int wrapped = wrap_offset+wrap_length - send_length;
      E_TYPE_STORAGE(unwrap_data, send_length);
      int unwrap_offset[ECO_p];
      printf ("OH NO!  Not unwrapping!\n");
      for(i=0;i<ECO_p;i++)
	unwrap_offset[i] = offset[i]-wrapped;

      for(v=0;v<num_vect;v++) {
	for(i=0;i<(send_length-wrapped);i++)
	  E_TYPE_COPY(unwrap_data, i, send_vector[v], wrapped+i);
	for(i=0;i<wrapped;i++)
	  E_TYPE_COPY(unwrap_data, (send_length-wrapped)+i, 
		      send_vector[v], i);
      }

      pvm_initsend(PvmDataDefault);
      pvm_pkint(length, ECO_p, 1);
      pvm_pkint(unwrap_offset, ECO_p, 1);
      E_PVM_PK(unwrap_data, send_length, send_stride);
      for(i=0;i<ECO_tree_child_count[root];i++)
	pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
    }
    
  }
  else {
    pvm_recv(ECO_tree_parent[root], ECO_BCAST_MSG);
    pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i], ECO_BCAST_MSG);
  }


  pvm_setrbuf(pvm_getsbuf());

  pvm_upkint(&send_length,1,1);
  for(i=0;i<ECO_myid;i++)
    pvm_upkint(dummy_int,1,1);
  pvm_upkint(recv_length, 1, 1);
  for(i=ECO_myid+1;i<ECO_p;i++)
    pvm_upkint(dummy_int,1,1);
  for(i=0;i<ECO_myid;i++)
    pvm_upkint(dummy_int,1,1);
  pvm_upkint(&my_offset, 1, 1);
  for(i=ECO_myid+1;i<ECO_p;i++)
    pvm_upkint(dummy_int,1,1);
  for(v=0;v<num_vect;v++) {
    for(i=0;i<my_offset;i++)
      E_PVM_UPK(dummy_t,1,1);

    E_PVM_UPK(recv_vector[v], *recv_length, recv_stride);
    for(i=my_offset+*recv_length;i<send_length;i++)
      E_PVM_UPK(dummy_t,1,1);
  }

  return 0;
}



/* eco_alltoall(IN send_vector[], IN int send_length, IN int send_stride, */
/* 	IN int send_lengths[], IN int send_offsets[], */
/* 	OUT recv_vector[], IN int recv_length, IN int recv_stride, */
/* 	IN int recv_lengths[], IN int recv_offsets[], TYPE) */

/* send_vector: data to be scattered */
/* send_length: number of data items in send_vector of send_vector */
/* send_lengths: number of items process i should receive */
/* send_offsets: offset of data process i should receive */
/* recv_vector: data to be gathered */
/* recv_length: number of data items to be gathered */
/* recv_lengths: number of items to be received from process i */
/* recv_offsets: offset in recv_vector at which to store data from process i */

/* alltoall is essentially a combined scatter/gather where each process */
/* sends distinct data to each other process. */

/* Note that offsets should specify the source address with stride already */
/* accounted for.  length parameters should not include stride */
E_PRE int eco_alltoall(E_DEF_TYPE* send_vector, int send_length, 
		       int send_stride,
	int* send_lens, int* send_offset,
	E_DEF_TYPE* recv_vector, int recv_length, int recv_stride,
	int* recv_lens, int* recv_offset E_TYPE_ARG)
{
  int i,j;
  int recip, d_length, sender;
  int buffers[ECO_tree_child_count[ECO_ALL]+1];
  ECO_NEW_MTAG;

  for(i=0;i<=ECO_tree_child_count[ECO_ALL];i++)
    buffers[i] = pvm_mkbuf(PvmDataDefault);

  for(i=0;i<ECO_p;i++) {
    if(i!= ECO_myid) {
      pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][i]]);
      pvm_pkint(&i,1,1);
      pvm_pkint(&ECO_myid, 1, 1);
      pvm_pkint(send_lens+i, 1,1);
      E_PVM_PK_I(send_vector, send_offset[i], send_lens[i],send_stride);
    } 
    else /* i == ECO_myid*/ 
      for(j=0;j<recv_lens[i];j++)
	E_TYPE_COPY(recv_vector,recv_offset[i]+j*recv_stride,
		    send_vector,send_offset[i]+j*send_stride);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_recv(-1, ECO_ALL2ALL_UP);
    pvm_upkint(&recip, 1, 1);
    while(recip!=-1){
      pvm_upkint(&sender, 1, 1);
      pvm_upkint(&d_length,1,1);
      if ( recip != ECO_myid) {
	E_TYPE_STORAGE(tmp, d_length);
	
	E_PVM_UPK(tmp, d_length, 1);
	pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][recip]]);
	pvm_pkint(&recip, 1, 1);
	pvm_pkint(&sender, 1, 1);
	pvm_pkint(&d_length, 1, 1);
	E_PVM_PK(tmp, d_length, 1);
      }
      else /* I am recip */
	E_PVM_UPK_I(recv_vector, recv_offset[sender],recv_lens[sender],
		    recv_stride);
      
      pvm_upkint(&recip, 1, 1);
    }
  }
      
  if(ECO_tree_parent[ECO_ALL] != -1) {
    pvm_setsbuf(buffers[ECO_tree_child_count[ECO_ALL]]);
    i=-1;
    pvm_pkint(&i,1,1);
    pvm_send(ECO_tree_parent[ECO_ALL], ECO_ALL2ALL_UP);
    pvm_freebuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    pvm_recv(ECO_tree_parent[ECO_ALL], ECO_ALL2ALL_DOWN);

    pvm_upkint(&recip, 1, 1);
    while(recip!=-1){
      if(ECO_tree_desc_info[ECO_ALL][recip] == ECO_tree_child_count[ECO_ALL]
	 && recip!=ECO_myid) {
	printf ("error in routing\n");
	break;
      }
      pvm_upkint(&sender, 1, 1);
      pvm_upkint(&d_length,1,1);
      if ( recip != ECO_myid) {
	E_TYPE_STORAGE(tmp, d_length);
	
	E_PVM_UPK(tmp, d_length, 1);
	pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][recip]]);
	pvm_pkint(&recip, 1, 1);
	pvm_pkint(&sender, 1, 1);
	pvm_pkint(&d_length, 1, 1);
	E_PVM_PK(tmp, d_length, 1);
      }
      else /* I am recip */
	E_PVM_UPK_I(recv_vector, recv_offset[sender], recv_lens[sender],
		    recv_stride);
     

      pvm_upkint(&recip, 1, 1);
    }
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_setsbuf(buffers[i]);
    recip=-1;
    pvm_pkint(&recip, 1, 1);
    pvm_send(ECO_tree_children[ECO_ALL][i], ECO_ALL2ALL_DOWN);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    pvm_freebuf(buffers[i]);

  return 0;
}

E_PRE int eco_alltoallv(int num_vect,
			E_DEF_TYPE** send_vector, int send_length, 
		       int send_stride,
	int* send_lens, int* send_offset,
	E_DEF_TYPE** recv_vector, int recv_length, int recv_stride,
	int* recv_lens, int* recv_offset E_TYPE_ARG)
{
  int i,j,v;
  int recip, d_length, sender;
  int buffers[ECO_tree_child_count[ECO_ALL]+1];
  ECO_NEW_MTAG;

  for(i=0;i<=ECO_tree_child_count[ECO_ALL];i++)
    buffers[i] = pvm_mkbuf(PvmDataDefault);

  for(i=0;i<ECO_p;i++) {
    if(i!= ECO_myid) {
      pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][i]]);
      pvm_pkint(&i,1,1);
      pvm_pkint(&ECO_myid, 1, 1);
      pvm_pkint(send_lens+i, 1,1);
      for(v=0;v<num_vect;v++)
	E_PVM_PK_I(send_vector[v], send_offset[i], send_lens[i],send_stride);
    } 
    else /* i == ECO_myid*/ 
      for(v=0;v<num_vect;v++)
	for(j=0;j<recv_lens[i];j++)
	  E_TYPE_COPY(recv_vector[v],recv_offset[i]+j*recv_stride,
		      send_vector[v],send_offset[i]+j*send_stride);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_recv(-1, ECO_ALL2ALL_UP);
    pvm_upkint(&recip, 1, 1);
    while(recip!=-1){
      pvm_upkint(&sender, 1, 1);
      pvm_upkint(&d_length,1,1);
      if ( recip != ECO_myid) {
	E_TYPE_STORAGE(tmp, d_length);

	pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][recip]]);
	pvm_pkint(&recip, 1, 1);
	pvm_pkint(&sender, 1, 1);
	pvm_pkint(&d_length, 1, 1);

	for(v=0;v<num_vect;v++) {
	  E_PVM_UPK(tmp, d_length, 1);
	  E_PVM_PK(tmp, d_length, 1);
	}
      }
      else /* I am recip */
	for(v=0;v<num_vect;v++)
	  E_PVM_UPK_I(recv_vector[v], recv_offset[sender],recv_lens[sender],
		      recv_stride);
      
      pvm_upkint(&recip, 1, 1);
    }
  }
      
  if(ECO_tree_parent[ECO_ALL] != -1) {
    pvm_setsbuf(buffers[ECO_tree_child_count[ECO_ALL]]);
    i=-1;
    pvm_pkint(&i,1,1);
    pvm_send(ECO_tree_parent[ECO_ALL], ECO_ALL2ALL_UP);
    pvm_freebuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    pvm_recv(ECO_tree_parent[ECO_ALL], ECO_ALL2ALL_DOWN);

    pvm_upkint(&recip, 1, 1);
    while(recip!=-1){
      if(ECO_tree_desc_info[ECO_ALL][recip] == ECO_tree_child_count[ECO_ALL]
	 && recip!=ECO_myid) {
	printf ("error in routing\n");
	break;
      }
      pvm_upkint(&sender, 1, 1);
      pvm_upkint(&d_length,1,1);
      if ( recip != ECO_myid) {
	E_TYPE_STORAGE(tmp, d_length);
	pvm_setsbuf(buffers[ECO_tree_desc_info[ECO_ALL][recip]]);
	pvm_pkint(&recip, 1, 1);
	pvm_pkint(&sender, 1, 1);
	pvm_pkint(&d_length, 1, 1);

	for(v=0;v<num_vect;v++) {
	  E_PVM_UPK(tmp, d_length, 1);
	  E_PVM_PK(tmp, d_length, 1);
	}
      }
      else /* I am recip */
	for(v=0;v<num_vect;v++)
	  E_PVM_UPK_I(recv_vector[v], recv_offset[sender], recv_lens[sender],
		      recv_stride);
     

      pvm_upkint(&recip, 1, 1);
    }
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_setsbuf(buffers[i]);
    recip=-1;
    pvm_pkint(&recip, 1, 1);
    pvm_send(ECO_tree_children[ECO_ALL][i], ECO_ALL2ALL_DOWN);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    pvm_freebuf(buffers[i]);

  return 0;
}
  
    
    
    



/* eco_reduce(IN send_vector[], IN int length, IN int stride, */
/* 	   OUT recv_vector[],  */
/* 	   IN OP_TYPE operation, IN int root, TYPE) */

/* send_vector: local contribution of data */
/* length: number of data items in send_vector and recv_vector */
/* stride: stride of send_vector and recv_vector */
/* recv_vector: result (root) */
/* operation: operation type */
/* root: receiving process or ALL */

/* reduce does operation across all copies of send_vector.  This operation is */
/* elementwise, so recv_vector[i] = OPERATION across all send_vector[i]. */

/* the length parameter should not reflect stride */

E_PRE int eco_reduce(E_DEF_TYPE* send_vect, int length, int stride,
		      E_DEF_TYPE* recv_vect, E_OP_TYPE red_opr, int root
		      E_TYPE_ARG)
{
  int i,j;
  E_TYPE_STORAGE(tmp_data_a, length*stride);
  E_TYPE_STORAGE(buffer, length*stride);
  E_DEF_TYPE* tmp_data = tmp_data_a;
  ECO_NEW_MTAG;
  
  if((root == ECO_myid) || (root == ECO_ALL)) 
    tmp_data = recv_vect;
  
  if (send_vect != tmp_data)
    for(i=0;i<length;i++)
      E_TYPE_COPY(tmp_data,i*stride,send_vect,i*stride);
  
  for (i=0;i<ECO_tree_child_count[root];i++) {
    pvm_recv(-1,ECO_RV_UP);
    E_PVM_UPK(buffer, length, stride);
    
    
    if(red_opr<ECO_user_func_start || stride==1){
	    E_REDUCTION(red_opr, j, length, tmp_data, j*stride, buffer,j*stride);
    }
	  else{
	    E_TYPE_STORAGE(tmp1, length);
	    E_TYPE_STORAGE(tmp2, length);

	    for(j=0;j<length;j++){
	      E_TYPE_COPY(tmp1,j,tmp_data,j*stride);
	      E_TYPE_COPY(tmp2,j,buffer,j*stride);
            }

	    E_REDUCTION(red_opr,j,length,tmp1,j,tmp2,j);
           
            for(j=0;j<length;j++)
	      E_TYPE_COPY(tmp_data,j*stride,tmp1,j);

	  }


  }
  
  
  if(ECO_tree_parent[root] != -1) {
    pvm_initsend(PvmDataDefault);
    E_PVM_PK(tmp_data,length,stride);
    
    pvm_send(ECO_tree_parent[root], ECO_RV_UP);
  }
  
  if(root == ECO_ALL) {
    if(ECO_tree_parent[root] != -1) {
      pvm_recv(ECO_tree_parent[root], ECO_RV_DOWN);
      pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
      
      
    }
    else {
      pvm_initsend(PvmDataDefault);
      E_PVM_PK(recv_vect, length, stride);
    }
    
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i],ECO_RV_DOWN);
    
    if(ECO_tree_parent[root] != -1) {
      pvm_freebuf(pvm_setrbuf(pvm_getsbuf()));
      E_PVM_UPK(recv_vect,length,stride);
    }
    
    
  }
  
  return 0;
}


E_PRE int eco_reducev(int num_vect,
		      E_DEF_TYPE** send_vect, int length, int stride,
		      E_DEF_TYPE** recv_vect, E_OP_TYPE red_opr, int root
		      E_TYPE_ARG)
{
  int i,j,v;
  E_TYPE_STORAGE(buffer, length*stride);
ifdef(`E_CPLUSPLUS',
`T **tmp_data;T **tmp_datat;
  tmp_data = (T**)malloc(num_vect*sizeof(T*));
  for(i=0;i<num_vect;i++)
    tmp_data[i]=(T*)malloc(length*stride*sizeof(T));
  tmp_datat=tmp_data;',
` void** tmp_data;void**tmp_datat;
  tmp_data = (void**)malloc(num_vect*sizeof(void*));
  for(i=0;i<num_vect;i++)
    tmp_data[i]=(void*)malloc(length*stride*sizeof(double));
  tmp_datat=tmp_data;')

  ECO_NEW_MTAG;
  
  if((root == ECO_myid) || (root == ECO_ALL)) 
    tmp_data = recv_vect;
  
  if (send_vect != tmp_data)
    for(v=0;v<num_vect;v++)
      for(i=0;i<length;i++)
	E_TYPE_COPY(tmp_data[v],i*stride,send_vect[v],i*stride);
  
  for (i=0;i<ECO_tree_child_count[root];i++) {
    pvm_recv(-1,ECO_RV_UP);

    for(v=0;v<num_vect;v++) {
      E_PVM_UPK(buffer, length, stride);
    
	  if((red_opr<ECO_user_func_start) || (stride==1)){
	    E_REDUCTION(red_opr, j, length, tmp_data[v], j*stride, buffer, 
                        j*stride);
          }
	  else{
	    E_TYPE_STORAGE(tmp1, length);
	    E_TYPE_STORAGE(tmp2, length);

	    for(j=0;j<length;j++){
	      E_TYPE_COPY(tmp1,j,tmp_data[v],j*stride);
	      E_TYPE_COPY(tmp2,j,buffer,j*stride);
            }

	    E_REDUCTION(red_opr,j,length,tmp1,j,tmp2,j);
           
            for(j=0;j<length;j++)
	      E_TYPE_COPY(tmp_data[v],j*stride,tmp1,j);

	  }
    }
  }

  
  
  if(ECO_tree_parent[root] != -1) {
    pvm_initsend(PvmDataDefault);
    for(v=0;v<num_vect;v++)
      E_PVM_PK(tmp_data[v],length,stride);
    
    pvm_send(ECO_tree_parent[root], ECO_RV_UP);
  }
  
  if(root == ECO_ALL) {
    if(ECO_tree_parent[root] != -1) {
      pvm_recv(ECO_tree_parent[root], ECO_RV_DOWN);
      pvm_freebuf(pvm_setsbuf(pvm_getrbuf()));
      
      
    }
    else {
      pvm_initsend(PvmDataDefault);
      for(v=0;v<num_vect;v++)
	E_PVM_PK(recv_vect[v], length, stride);
    }
    
    for(i=0;i<ECO_tree_child_count[root];i++)
      pvm_send(ECO_tree_children[root][i],ECO_RV_DOWN);
    
    if(ECO_tree_parent[root] != -1) {
      pvm_freebuf(pvm_setrbuf(pvm_getsbuf()));
      for(v=0;v<num_vect;v++)
	E_PVM_UPK(recv_vect[v],length,stride);
    }
    
    
  }

  for(i=0;i<num_vect;i++)
    free(tmp_datat[i]);
  free(tmp_datat);
  
  return 0;
}


/*    eco_scan(IN send_vector[], IN int length, IN int stride */
/*    OUT recv_vector[], IN OP_TYPE operation, TYPE) */
   
/*    send_vector: local contribution of data */
/*    length: number of data items in send_vector and recv_vector */
/*    stride: stride of send_vector and recv_vector */
/*    recv_vector: operation performed on first 0..i contributions */
/*    operation: operation to do on send_vector */
   
/*    scan implements an inclusive scan, such that the vector returned to  */
/*    process i is the result of applying operation to send_vector from */
/*    processes 0..i.   */
E_PRE int eco_scan(E_DEF_TYPE* send_vector, int length, int stride,
		    E_DEF_TYPE* recv_vector, E_OP_TYPE oper E_TYPE_ARG)
{
  int i,j;
  int from;
  E_TYPE_STORAGE(tmp, length*stride);
  int buffers[ECO_tree_child_count[ECO_ALL]+1];
  ECO_NEW_MTAG;

  for(i=0;i<=ECO_tree_child_count[ECO_ALL];i++)
    buffers[i] = pvm_mkbuf(PvmDataDefault);

      
  for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
    if(ECO_myid < ECO_tree_desc_max[ECO_ALL][j]) {
      pvm_setsbuf(buffers[j]);
      pvm_pkint(&ECO_myid, 1, 1);
      E_PVM_PK(send_vector, length, stride);
    }

  if(recv_vector != send_vector)
    for(i=0;i<length;i++)
      E_TYPE_COPY(recv_vector,i*stride,send_vector,i*stride);

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++){
    pvm_recv(ECO_tree_children[ECO_ALL][i], ECO_SCAN_UP);

    pvm_upkint(&from, 1, 1);

    while(from != -1) {
      E_PVM_UPK(tmp, length, 1);
      
    if(from < ECO_myid){
      if(oper<ECO_user_func_start || stride==1){
         E_REDUCTION(oper, j, length, recv_vector, j*stride, tmp, j);
         }
	  else{
	    E_TYPE_STORAGE(tmp2, length);

	    for(j=0;j<length;j++)
              E_TYPE_COPY(tmp2,j,recv_vector,j*stride);

	    E_REDUCTION(oper,j,length,tmp2,j,tmp,j);

	    for(j=0;j<length;j++)
              E_TYPE_COPY(recv_vector,j*stride,tmp2,j);
	  }
      }
      
       for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
	if((from < ECO_tree_desc_max[ECO_ALL][j]) &&
	   (ECO_tree_desc_info[ECO_ALL][from] != j)){
	  pvm_setsbuf(buffers[j]);
	  pvm_pkint(&from, 1, 1);
	  E_PVM_PK(tmp, length, 1);
	}
      
      pvm_upkint(&from, 1, 1);

    }
  }

  if(ECO_tree_parent[ECO_ALL]!=-1) {
    pvm_setsbuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    from = -1;
    pvm_pkint(&from,1,1);

    pvm_send(ECO_tree_parent[ECO_ALL], ECO_SCAN_UP);
    pvm_freebuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    pvm_recv(ECO_tree_parent[ECO_ALL], ECO_SCAN_DOWN);

    pvm_upkint(&from, 1, 1);

    while(from != -1) {
      E_PVM_UPK(tmp, length, 1);
      
      if(from < ECO_myid) {

	  if(oper<ECO_user_func_start || stride==1){
	    E_REDUCTION(oper, j, length, recv_vector, j*stride, tmp, j);
          }
	  else{
	    E_TYPE_STORAGE(tmp2, length);

	    for(j=0;j<length;j++)
              E_TYPE_COPY(tmp2,j,recv_vector,j*stride);

	    E_REDUCTION(oper,j,length,tmp2,j,tmp,j);

	    for(j=0;j<length;j++)
              E_TYPE_COPY(recv_vector,j*stride,tmp2,j);
	  }
      }

      for(j=0;j<ECO_tree_child_count[ECO_ALL];j++)
	if(from < ECO_tree_desc_max[ECO_ALL][j]) {
	  pvm_setsbuf(buffers[j]);
	  pvm_pkint(&from, 1, 1);
	  E_PVM_PK(tmp, length, 1);
	}
      
      pvm_upkint(&from, 1, 1);
    }
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_setsbuf(buffers[i]);
    from = -1;
    pvm_pkint(&from,1,1);
    pvm_send(ECO_tree_children[ECO_ALL][i], ECO_SCAN_DOWN);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    pvm_freebuf(buffers[i]);

  return 0;

}

E_PRE int eco_scanv(int num_vect,
		    E_DEF_TYPE** send_vector, int length, int stride,
		    E_DEF_TYPE** recv_vector, E_OP_TYPE oper E_TYPE_ARG)
{
  int i,j,v;
  int from;
  E_TYPE_STORAGE(tmp, length*stride);
  int buffers[ECO_tree_child_count[ECO_ALL]+1];
  ECO_NEW_MTAG;

  for(i=0;i<=ECO_tree_child_count[ECO_ALL];i++)
    buffers[i] = pvm_mkbuf(PvmDataDefault);

      
  for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
    if(ECO_myid < ECO_tree_desc_max[ECO_ALL][j]) {
      pvm_setsbuf(buffers[j]);
      pvm_pkint(&ECO_myid, 1, 1);
      for(v=0;v<num_vect;v++)
	E_PVM_PK(send_vector[v], length, stride);
    }

  if(recv_vector != send_vector)
    for(v=0;v<num_vect;v++)
      for(i=0;i<length;i++)
	E_TYPE_COPY(recv_vector[v],i*stride,send_vector[v],i*stride);

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++){
    pvm_recv(ECO_tree_children[ECO_ALL][i], ECO_SCAN_UP);

    pvm_upkint(&from, 1, 1);

    while(from != -1) {
      for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
	if((from < ECO_tree_desc_max[ECO_ALL][j]) &&
	   (ECO_tree_desc_info[ECO_ALL][from] != j)){
	  pvm_setsbuf(buffers[j]);
	  pvm_pkint(&from, 1, 1);
	}

      for(v=0;v<num_vect;v++) {
	E_PVM_UPK(tmp, length, 1);
	
	if(from < ECO_myid){
	  if(oper<ECO_user_func_start || stride==1){
	    E_REDUCTION(oper, j, length, recv_vector[v], j*stride, tmp, j);
          }
	  else{
	    E_TYPE_STORAGE(tmp2, length);

	    for(j=0;j<length;j++)
              E_TYPE_COPY(tmp2,j,recv_vector[v],j*stride);

	    E_REDUCTION(oper,j,length,tmp2,j,tmp,j);

	    for(j=0;j<length;j++)
              E_TYPE_COPY(recv_vector[v],j*stride,tmp2,j);
	  }
	}
	
	for(j=0;j<=ECO_tree_child_count[ECO_ALL];j++)
	  if((from < ECO_tree_desc_max[ECO_ALL][j]) &&
	     (ECO_tree_desc_info[ECO_ALL][from] != j)){
	    pvm_setsbuf(buffers[j]);
	    E_PVM_PK(tmp, length, 1);
	  }
      }
      pvm_upkint(&from, 1, 1);

    }
  }

  if(ECO_tree_parent[ECO_ALL]!=-1) {
    pvm_setsbuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    from = -1;
    pvm_pkint(&from,1,1);

    pvm_send(ECO_tree_parent[ECO_ALL], ECO_SCAN_UP);
    pvm_freebuf(buffers[ECO_tree_child_count[ECO_ALL]]);

    pvm_recv(ECO_tree_parent[ECO_ALL], ECO_SCAN_DOWN);

    pvm_upkint(&from, 1, 1);

    while(from != -1) {
      for(j=0;j<ECO_tree_child_count[ECO_ALL];j++)
	if(from < ECO_tree_desc_max[ECO_ALL][j]) {
	  pvm_setsbuf(buffers[j]);
	  pvm_pkint(&from, 1, 1);
	}

      for(v=0;v<num_vect;v++) {
	E_PVM_UPK(tmp, length, 1);
      
	if(from < ECO_myid) {

		
	  if(oper<ECO_user_func_start || stride==1){
	    E_REDUCTION(oper, j, length, recv_vector[v], j*stride, tmp, j);
	  }
	  else{
	    E_TYPE_STORAGE(tmp2, length);

	    for(j=0;j<length;j++)
              E_TYPE_COPY(tmp2,j,recv_vector[v],j*stride);

	    E_REDUCTION(oper,j,length,tmp2,j,tmp,j);

	    for(j=0;j<length;j++)
              E_TYPE_COPY(recv_vector[v],j*stride,tmp2,j);
	  }
	}

	for(j=0;j<ECO_tree_child_count[ECO_ALL];j++)
	  if(from < ECO_tree_desc_max[ECO_ALL][j]) {
	    pvm_setsbuf(buffers[j]);
	    E_PVM_PK(tmp, length, 1);
	  }
      }
      pvm_upkint(&from, 1, 1);
    }
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++) {
    pvm_setsbuf(buffers[i]);
    from = -1;
    pvm_pkint(&from,1,1);
    pvm_send(ECO_tree_children[ECO_ALL][i], ECO_SCAN_DOWN);
  }

  for(i=0;i<ECO_tree_child_count[ECO_ALL];i++)
    pvm_freebuf(buffers[i]);

  return 0;

}

#endif ECO_ALG_H
