E_M4WARNING

/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided ``as is'' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */


/* a load balanced: spawn alb_spawn(char *comp, char **args, ntids, tids[])
 * this call will spawn the component on the next machine in the hostfile
 * after the one it is currently running on and continue from there
 * if you call it repeatedly, each call will start with the next machine
 * in the hostlist, for real load balancing you should only call this once.
 *
 * Adam Beguelin 
 * adamb@cs.cmu.edu
 * Jun 9, 1993
 *
 */

ifdef(`E_EXTERNSTDINCLUDES',`extern "C"{')
#include <stdio.h>
#include <string.h>
ifdef(`E_EXTERNSTDINCLUDES',`}')
ifdef(`E_CPLUSPLUS',
`#include <stdlib.h>
#include <stream.h>
extern "C" {
#include <pvm3.h>
}
',`#include <pvm3.h>')


#include "spawn_mpp.h"

extern int pvm_errno;

ifdef(`E_CPLUSPLUS',
`int alb_spawn(char *comp, char **args, int ntids, int *tids,
	  mpp_info *mpp_hostinfo, int mpp_host_count,
	  int pvm_flags)',
`int alb_spawn(comp, args, ntids, tids,
	  mpp_hostinfo, mpp_host_count, pvm_flags)
char *comp;
char **args;
int ntids, *tids;
mpp_info* mpp_hostinfo;
int mpp_host_count;
int pvm_flags;')
{
	int cc, rc, mytid, t, i;
	int nhosts, narchs;
	struct pvmhostinfo *hostlist = 0;
	int ntasks;
	struct pvmtaskinfo *tasklist = 0;
	int curhost;



	
	mytid = pvm_mytid();

		/* find out about the hosts */
		if ((cc = pvm_config(&nhosts, &narchs, &hostlist)) < 0) {
			pvm_perror("alb_spawn:");
			return(cc);
			}
		/* figure out which host I'm on */
		if ((cc = pvm_tasks(0, &ntasks, &tasklist)) < 0) {
			pvm_perror("alb_spawn:");
			return(cc);
			}
		for(t = 0; t < ntasks; t++) {
			/* if it's not me, I don't care */
			if(tasklist[t].ti_tid != mytid) continue;
			for(curhost = 0; curhost < nhosts; curhost++ ) 
				/* if it's my host */
				if(hostlist[curhost].hi_tid == tasklist[t].ti_host) goto found;
			}
found:
		if ((curhost == nhosts) && (t == ntasks)) {
ifdef(`E_CPLUSPLUS',
			`cerr << "alb_spawn: shouldn't happen\n";',
			`fprintf(stderr, "alb_spawn: should not happen\n");')
			return(-1);
			}
	for(i=0,rc=ntids; i<ntids;) {
	  /*for(i = 0, rc = ntids; i < ntids; i++) {*/
	  int j,n;

	  curhost = (curhost+1) % nhosts;
	  n=1;
	  
	  for(j=0;j<mpp_host_count;j++)
	    if(strncmp(mpp_hostinfo[j].hostname,
		       hostlist[curhost].hi_name,
		       strlen(mpp_hostinfo[j].hostname)) == 0)
	      break;
	  if(j<mpp_host_count) {
	    if(mpp_hostinfo[j].n_assigned >= mpp_hostinfo[j].processors)
	      n = 0;
	    else 
	      if ((mpp_hostinfo[j].processors-mpp_hostinfo[j].n_assigned)<
		  (ntids-i)) {
		n=mpp_hostinfo[j].processors-mpp_hostinfo[j].n_assigned;
		mpp_hostinfo[j].n_assigned+=n;
	      }
	      else {
		n=ntids-i;
		mpp_hostinfo[j].n_assigned+=n;
	      }
	  }
	    
	  if(n>0)
	    if((cc = pvm_spawn(comp, args, PvmTaskHost|
			       pvm_flags,
			       hostlist[curhost].hi_name,
			       n, tids+i)) != n) {
	      pvm_errno = tids[i];
	      pvm_perror("alb_spawn::");
	      rc-=n;
	    }
	  i+=n;
	}
	return (rc);
      }
