/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided `as is' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */


#ifndef ECO_H
#define ECO_H

#define DEFAULT_NETWORK_DATA_FILENAME "your/path/here"

int eco_init (int* p_i, int p, int* tids, char* data_filename,
	      int topology, void* topology_foo);

#define Eco_Double 1
#define Eco_Int 2
#define Eco_Float 3
#define Eco_Long 4
#define Eco_Char 5

#define ECO_DEFAULT_TOPOLOGY 0
#define ECO_RING_TOPOLOGY 1


typedef void (*ECO_user_function)(void* In, void* InOut, 
                                  int length, int* info);


void eco_ring_topology(int* tids_in, int* tids_out, int p);
int eco_barrier(void);
int eco_bcast(int root);
int eco_register_function( ECO_user_function operation);
int eco_delete_function(int function_id);
int eco_pattern_init(int p_i, int p, int* tids);

#define ECO_MAX_FUNCS 100


extern int* ECO_tree_parent; /* parent in tree communication pattern rooted at []*/
extern int* ECO_tree_child_count; /* number of checoildren in tree comm pattern */
extern int** ECO_tree_children; /* list of children for each rooted tree */
extern int ECO_myid; /* index of this process in group list */
extern int ECO_p; /* number of processes in group */
extern int* ECO_tids; /* list of tids in group list */
extern int ECO_opt_tree;
extern int ECO_ALL; /* index representing all for root */
extern int** ECO_tree_desc_info; /* information on descendants and ancestors(p) */
extern int** ECO_tree_desc_max;
extern int ECO_cur_mtag;
/* current network setup */
extern int* subnet_map; /* tids[i] is in subnet subnet_map[i] */
extern double** inter_subnet_times;
#define ECO_user_func_start 10
extern ECO_user_function eco_oper_list[ECO_MAX_FUNCS];


#define ECO_BEGIN_DESC 0x50a
#define ECO_DESC_INFO 0x50b
#define ECO_DESC_FINISH 0x50c
#define ECO_SN_INIT 0x50d
#define ECO_MC_INIT 0x50e

#define ECO_NET_DATA ECO_cur_mtag
#define ECO_GATHER_UP ECO_cur_mtag
#define ECO_GATHER_DOWN ECO_cur_mtag
#define ECO_RV_UP ECO_cur_mtag
#define ECO_RV_DOWN ECO_cur_mtag
#define ECO_RD_UP ECO_cur_mtag
#define ECO_RD_DOWN ECO_cur_mtag
#define ECO_BARRIER ECO_cur_mtag
#define ECO_BCAST_MSG ECO_cur_mtag
#define ECO_SCAN_UP ECO_cur_mtag
#define ECO_SCAN_DOWN ECO_cur_mtag
#define ECO_ALL2ALL_UP ECO_cur_mtag
#define ECO_ALL2ALL_DOWN ECO_cur_mtag


#define ECO_NEW_MTAG {ECO_cur_mtag++;if(ECO_cur_mtag>0x6ff)ECO_cur_mtag=0x600;}



#define ECO_OP_ADD 1
#define ECO_OP_MULT 3
#define ECO_OP_MAX 5
#define ECO_OP_MIN 6



#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif








 int eco_gather(void* send_vect, int send_len, int send_stride,
		     int send_offset,
		     void* recv_vect, int recv_len, int recv_stride,
		     int root ,int Arg_Type);
 int eco_gatherv(int num_vect, 
		      void** send_vect, int send_len, int send_stride,
		     int send_offset,
		     void** recv_vect, int recv_len, int recv_stride,
		     int root ,int Arg_Type);
 int eco_scatter(void* send_vector, int send_length,int send_stride,
		       int* length, int* offset, 
		       void* recv_vector, int* recv_length,
		      int recv_stride, 
		       int root ,int Arg_Type);
 int eco_scatterv(int num_vect,
		       void** send_vector, int send_length,int send_stride,
		       int* length, int* offset, 
		       void** recv_vector, int* recv_length,
		      int recv_stride, 
		       int root ,int Arg_Type);
 int eco_alltoall(void* send_vector, int send_length, 
		       int send_stride,
	int* send_lens, int* send_offset,
	void* recv_vector, int recv_length, int recv_stride,
	int* recv_lens, int* recv_offset ,int Arg_Type);
 int eco_alltoallv(int num_vect,
			void** send_vector, int send_length, 
		       int send_stride,
	int* send_lens, int* send_offset,
	void** recv_vector, int recv_length, int recv_stride,
	int* recv_lens, int* recv_offset ,int Arg_Type);
 int eco_reduce(void* send_vect, int length, int stride,
		      void* recv_vect, int red_opr, int root
		      ,int Arg_Type);
 int eco_reducev(int num_vect,
		      void** send_vect, int length, int stride,
		      void** recv_vect, int red_opr, int root
		      ,int Arg_Type);
 int eco_scan(void* send_vector, int length, int stride,
		    void* recv_vector, int oper ,int Arg_Type);
 int eco_scanv(int num_vect,
		    void** send_vector, int length, int stride,
		    void** recv_vector, int oper ,int Arg_Type);



#endif
