/*
 * 	ECO: Efficient Collective Operations
 * 	Beta release 0.1b
 * 	Bruce Lowekamp and Adam Beguelin	
 * 	School of Computer Science
 * 	Carnegie Mellon University
 * 	Pittsburgh, PA 15213
 * 
 * 	(C) 1996 All Rights Reserved
 * 
 * NOTICE:
 * 
 *  Permission to use, copy, modify, and distribute this software and
 *  its documentation for any purpose and without fee is hereby granted
 *  provided that the above copyright notice appear in all copies and
 *  that both the copyright notice and this permission notice appear in
 *  supporting documentation.
 * 
 *  Neither Carnegie Mellon University nor the Authors make any
 *  representations about the suitability of this software for any
 *  purpose.  This software is provided ``as is'' without express or
 *  implied warranty.
 * 
 *  This research is sponsored in part by the Department of Defense
 *  Advanced Research Projects Agency and the National Science
 *  Foundation.
 */


#include<stdio.h>
#include<pvm3.h>
#include<eco.h>

#define P 4

main()
{
  int tids[P];
  int p_i;
  int i;

  pvm_mytid();

  /* standard PVM spawn code */
  if(pvm_parent() == PvmNoParent) {
    tids[0] = pvm_mytid();

    p_i = 0;
    printf ("root spawned %i\n", 
	    pvm_spawn("minimal", NULL,PvmTaskDefault,
		      NULL, P-1, tids+1));
    pvm_initsend(PvmDataDefault);
    pvm_pkint(tids, P, 1);
    for(i=1;i<P;i++)
      pvm_send(tids[i], 1);
  }
  else {
    pvm_recv(pvm_parent(), 1);
    pvm_upkint(tids, P, 1);
    for(p_i=1;tids[p_i] != pvm_mytid();p_i++);
  }

  /* ECO initialization */
  eco_init (&p_i, P, tids, NULL, ECO_DEFAULT_TOPOLOGY, NULL);

  printf ("i have tid %x\n", pvm_mytid());

  /* barrier synchronize */
  eco_barrier();

  /* broadcast of root's tid from root */
  if(p_i==0){
    pvm_initsend(PvmDataDefault);
    pvm_pkint(tids, 1,1);
  }
  eco_bcast(0);

  pvm_upkint(&i,1,1);
  printf ("root has tid %x\n", i);

  /* compute sum of tids */
  eco_reduce(&(tids[p_i]), 1, 1, &i, ECO_OP_ADD, ECO_ALL, Eco_Int);
  printf ("sum of tids is %x\n", i);

  /* barrier before exiting */
  eco_barrier();
}

  
