/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/lib/RCS/btr1.c,v 2.13 1993/07/02 14:34:22 rr2b Exp $";
#endif

/* ************************************************************ *\
	btr1.c
	More library routines for reading B-trees.
	Include file ``bt.h'' declares the procedures for clients.
	Include file ``btint.h'' declares common structures for the implementation modules.
\* ************************************************************ */

#include <andrewos.h>	/* file, time, strings */
#include <errno.h>
#include <truth.h> /* itc.h -> truth.h DMT */
#include <sys/stat.h>
#include <netinet/in.h>
#include <util.h>
#ifdef WHITEPAGES_ENV  /* avoid makedepend "errors" */
#include <btint.h>
#endif /* WHITEPAGES_ENV   */

extern int errno;

extern int br_Debugging;

/* Advance the cursor to the next key-value pair.
Declaration:
	extern bt_ErrorCode bt_NextCursor(curs);
	struct btCursor *curs;
*/
bt_ErrorCode bt_NextCursor(curs)
struct btCursor *curs;
{
    struct btC *bC = (struct btC *) curs;
    int Idx, Exact, Flags, RootNameLength, ThisByte;
    unsigned int ValueLength;
    bt_ErrorCode RetVal;
    auto char NodeFileName[MAXPATHLEN+1];
    char *NFNEnd, *NFNPtr;
    unsigned char *OldKey;
    struct btFile *bF;

    if (bC == NULL || bC->Tag != btCTag
	 || bC->Tree == NULL || bC->Tree->Tag != BTrTag)
	return bterr_CursorTreeDamaged;
    if (bC->State == UnInitialized) return bterr_UninitializedCursor;
    if (bC->FP == NULL || bC->FP->Tag != btFileTag) return bterr_CursorTreeDamaged;
    if (bC->FP->Head.BTDepth != 0) return bterr_NotAtKey;
    switch (bC->State) {
	case Null: return bterr_EmptyTree;
	case BeforeFirst: {
	    /*			if (bC->FP->IndexNum == 0)
	    {bC->State = Null; return bterr_EmptyTree;} */
	    Idx = 0;
	    break;
	    }
	case AfterLast: return bterr_NoNextKey;
	default: {Idx = bC->IndexPos + 1; break;}
    }
    if (Idx < bC->FP->IndexNum) {   /* the typical case: see if next key is a brother link */
	RetVal = b_GetFlags(bC->FP, Idx, &Flags);
	if (RetVal != bterr_NoError) return RetVal;
	if ((Flags & BTIsBrotherLink) == 0) {
	    bC->IndexPos = Idx;
	    bC->State = AtKey;
	    return bterr_NoError;
	}
    } else {			/* see if the old (current) key was a brother link */
	--Idx;
	RetVal = b_GetFlags(bC->FP, Idx, &Flags);
	if (RetVal != bterr_NoError) return RetVal;
	if ((Flags & BTIsBrotherLink) == 0) {
	    bC->State = AfterLast;	/* was no brother link */
	    return bterr_NoNextKey;
	}
    }
    /* OK, follow the brother link.  First we copy the key for the brother link. */
    bC->State = AtKey; bC->IndexPos = Idx;	/* Get the brother-link key */
    RetVal = bt_GetCursorKey(curs, &OldKey);	/* copy key for searching next node */
    if (RetVal != bterr_NoError) return RetVal;
    /* Follow a right-brother link */
    strcpy(NodeFileName, bC->Tree->Root->FileName);
    RootNameLength = strlen(NodeFileName);
    NFNEnd = &NodeFileName[RootNameLength];
    *NFNEnd++ = '.';
    for (;;) {
	RetVal = b_GetValueLength(bC->FP, Idx, &ValueLength);
	if (RetVal != bterr_NoError) {free(OldKey); return RetVal;}
	if (ValueLength <= 0) {free(OldKey); return bterr_BTreeDamaged;}
	if (ValueLength + RootNameLength >= MAXPATHLEN)
	{free(OldKey); return bterr_IntermediateNameTooLong;}
	NFNPtr = NFNEnd;
	while ((--ValueLength) >= 0) {
	    ThisByte = fgetc(bC->FP->File);
	    if (ThisByte == EOF) {free(OldKey); return bterr_BTreeDamaged;}
	    *NFNPtr++ = ThisByte;
	}
	*NFNPtr = '\0';		/* terminate it */
	bF = b_NewbtFileStr();
	if (bF == NULL) {free(OldKey); return bterr_OutOfMemory;}
	bF->RefCount = 1;		/* preset the ref count */
	RetVal = b_ReadbtFile(bF, NodeFileName, FALSE);
	if (RetVal != bterr_NoError) {free(bF); free(OldKey); return RetVal;}
	if (bF->Head.BTDepth != 0)
	{b_DecrRefCount(&bF); free(OldKey); return bterr_BTreeDamaged;}
	b_StoreFilePtr(&bC->FP, bF);
	b_DecrRefCount(&bF);	/* and decrement it when safe */
	RetVal = b_ScanNode(bC->FP, OldKey, &Idx, &Exact, &Flags);
	if (RetVal != bterr_NoError) {free(OldKey); return RetVal;}
	if (Exact == 0) {	/* we landed between keys; advance. */
	    if ((Idx+1) < bC->FP->IndexNum) {	/* not looking past last entry */
		++Idx;
		RetVal = b_GetFlags(bC->FP, Idx, &Flags);
		if (RetVal != bterr_NoError) {free(OldKey); return RetVal;}
	    } else {
		if ((Flags & BTIsBrotherLink) == 0) {
		    bC->State = AfterLast;
		    free(OldKey);
		    return bterr_NoNextKey;
		}
	    }
	}
	if (Idx < 0 || (Flags & BTIsBrotherLink) == 0) {
	    bC->IndexPos = Idx;
	    if (bC->IndexPos < 0) bC->IndexPos = 0;
	    bC->State = AtKey;
	    free(OldKey);
	    if (Idx >= 0 && (Flags & BTIsLeafPair) == 0)
		return bterr_BTreeDamaged;
	    else return bterr_NoError;
	} /* else is another brother link--search it, too. */
    }
}
