/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/util/hdrs/RCS/genhdr.c,v 1.7 1994/04/28 19:34:30 rr2b Exp $";
#endif

#include <stdio.h>

#define	OFILENAME   "andrdir.h"

/**
 **
 **  Create the file andrdir.h which gives the defined
 **  QUOTED_DEFAULT_XBASEDIR_ENV
 **  QUOTED_DEFAULT_XLIBDIR_ENV
 **  QUOTED_DEFAULT_ANDREWDIR_ENV and possibly the 
 **  QUOTED_DEFAULT_LOCALDIR_ENV.
 **  Also, define QUOTED_DEFAULT_ANDREWDIR_ANDREWSETUP.
 **
 **/
int
main(argc, argv)

int argc;
char *argv[];

{
    /*
     * Check command line.
     */
    if (argc<2 || argc>5) {
	(void) fprintf(stderr, "\ngenhdr:  genhdr [,XLIBDIR [,XBASEDIR]] ANDREWDIR [LOCALDIR] \n");
	exit(1);
    }

    if(argv[1][0]==',') {
	printf("\n");
	printf("#define QUOTED_DEFAULT_XLIBDIR_ENV \"%s\"\n", argv[1]+1);
	argv++;
	argc--;
    }
    
    if(argv[1][0]==',') {
	printf("\n");
	printf("#define QUOTED_DEFAULT_XBASEDIR_ENV \"%s\"\n", argv[1]+1);
	argv++;
	argc--;
    }

    /*
     * Write out the #defines.
     */
    (void) printf(" \n");
    (void) printf("#define QUOTED_DEFAULT_ANDREWDIR_ENV \"%s\"\n", argv[1]);
    if (argc == 3) {
	(void) printf("#define QUOTED_DEFAULT_LOCALDIR_ENV \"%s\"\n", argv[2]);
    }
    (void) printf("#define QUOTED_DEFAULT_ANDREWDIR_ANDREWSETUP \"%s/etc/AndrewSetup\"\n", argv[1]);
    (void) printf(" \n");


    /*
     * We must check flush because flushs can fail with remote filesystems.
     */
    if (0 != fflush(stdout)) {
	(void) fprintf(stderr, "\ngenhdr:  error fflush'ing stdout\n");
	exit(1);
    }

    /*
     * All done!
     */
    exit(0);

}
