/* ********************************************************************** *\
 *         Copyright IBM Corporation 1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/






/* In routine f the statement
	GETCALLER(a, x)
   where a is the first parater to f and x is of type (char *)
   will store in x the return address within the caller of f.  
   This cannot be guaranteed to always work,
   so it cannot be recommended for anything other than diagnostic infomation.
*/


#ifndef _GETCALLR_
#define _GETCALLR_


#ifdef ibm032
#define RETADDROFF (6)
#else /* ! ibm032 */

#ifdef _IBMR2

#define RETADDROFF (4)

#else	/* ! _IBMR2  &&  ! ibm032 */

#define RETADDROFF (1)

#endif /* ! _IBMR2 */
#endif /* ! ibm032 */


#if (defined(sun4) || defined(sparc))

	/* the sun4 requires an assembler routine to find the caller of the caller */

#define GETCALLER(a, x) 	{extern char *getcaller(); x = getcaller();}

#else /* (defined(sun4) || defined(sparc)) */
#if (defined(mips) || defined(pmax))

#define GETCALLER(a, x)    {extern char *store_return_address; x = store_return_address;}

#else  /* defined(mips) || defined(pmax) */

	/* the vax compilers require the extra variable 'addrloc'
	others do not, but there is no great advantage in making a third case.  */

#define GETCALLER(a, x) 	{  \
	register char **addrloc;  \
	addrloc = (((char **)&a) - RETADDROFF);  \
	x = *addrloc;  \
}

#endif /* defined(mips) || defined(pmax) */
#endif /* (defined(sun4) || defined(sparc)) */

#if (defined(mips) || defined(pmax))
#if __STDC__
#define procdef(procname) procname##_sidedoor
#else
#define procdef(procname) procname/**/_sidedoor
#endif
#else /* (defined(mips) || defined(pmax)) */
#define procdef(procname) procname
#endif /* (defined(mips) || defined(pmax)) */


#endif  /* _GETCALLR_ */

