/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/mail/lib/RCS/amsconf.c,v 2.9 1993/05/20 04:54:41 gk5g Exp $";
#endif

/* amsconf.c -- Uses the /AndrewSetup file to see if all programs
	in the Andrew Message System should be run from an experimental
	binary directory 
*/

#include <andrewos.h>
#include <stdio.h>
#include <sys/param.h>
#include <errprntf.h>

#define CALLMEMADAM "__AMS__EXP__"
#define LOOKFOR "AMS-Binaries"

amsconfig(argc, argv, name)
int argc;
char **argv, *name;
{
    char *s, ExpDir[1+MAXPATHLEN], NewName[100];

    CheckAMSConfiguration();
    if (!strncmp(argv[0], CALLMEMADAM, sizeof(CALLMEMADAM) -1)) {
	return(0); /* Do not recurse */
    }
    if ((s = (char *) GetConfiguration(LOOKFOR)) == NULL) {
	return(1);
    }
    if (!*s) {
	return(0);
    }
    /* There really is an entry in the configuration file */
#if 0
    errprintf(name, ERR_WARNING, 0, 0, "Running experimental %s from %s", name, s);
#endif
    sprintf(ExpDir, "%s/%s", s, name);
    sprintf(NewName, "%s%s", CALLMEMADAM, name);
    argv[0] = NewName;
    execv(ExpDir, argv);
#if 0
    errprintf(name, ERR_WARNING, 0, 0, "Exec failed -- running wrong version");
#endif
    return(2);
}

