%{
#include "refs.h"
%}
%%
struct[^A-Z0-9a-z_]		return(refs_TokUnput(refs_Class));
class[^A-Z0-9a-z_]		return(refs_TokUnput(refs_Class));
public[^A-Z0-9a-z_]		return(refs_TokUnput(refs_Inheritance));
private[^A-Z0-9a-z_]		return(refs_TokUnput(refs_Inheritance));
protected[^A-Z0-9a-z_]		return(refs_TokUnput(refs_Inheritance));
virtual[^A-Z0-9a-z_]		return(refs_TokUnput(refs_Inheritance));
#define[^A_Z0-9a-z_]		return(refs_TokUnput(refs_Define));
#include[^A-Z0-9a-z_]		return(refs_TokUnput(refs_Include));
ATKdefineRegistry[^A-Z0-9a-z_]			return(refs_TokUnput(refs_ATKdefineRegistry));
extern[^A-Z0-9a-z_]		return(refs_TokUnput(refs_Extern));
ATKregistryEntry[^A-Z0-9a-z_]			return(refs_TokUnput(refs_ATKregistryEntry));
[A-Za-z][0-9A-Za-z]*_ATKregistry_[^A-Z0-9a-z_]	return(refs_TokUnput(refs_ATKregistry_));
\/\*				return(refs_TokComment());
\"				return(refs_TokString());
\'				return(refs_TokCharacter());
\/\/				return(refs_TokLineComment());
\000				return(refs_EOF);
";"				return(refs_Semi);
","				return(refs_Comma);
"="				return(refs_Equal);
":"				return(refs_Colon);
"("				return(refs_LeftParen);
")"				return(refs_RightParen);
"{"				return(refs_LeftBrace);
"}"				return(refs_RightBrace);
"<"				return(refs_LessThan);
">"				return(refs_GreaterThan);
\\\n				return(refs_TokWhitespace());
[ \n\t\r]*				return(refs_TokWhitespace());
[A-Za-z_][0-9A-Za-z_]*		return(refs_Name);

.				return(refs_Other);
%%
#ifndef NORCSID
static char rcsid[] = "$Header: /usr/user/auis-7.2/overhead/grefs/RCS/refs.lex,v 1.1 1994/04/28 19:34:30 rr2b Exp $";
#endif

int refs_TokUnput(tok)
int tok;
{
    unput(yytext[--yyleng]);
    yytext[yyleng]='\0';
    return tok;
}

int refs_TokWhitespace()
{
    /* convert an escaped newline into a space */	
    if(yytext[0]=='\\'){
	yytext[0]=' ';
	yytext[1]='\0';
    }

    return (refs_WhiteSpace);
}

int refs_TokComment() {
    /* must search to the end of the comment */
    /* attempt to return it in str - up to the point that fits */

    int i = 2, c, SawStar = 0;
    yytext[YYLMAX-3] = '*';
    yytext[YYLMAX-2] = '/';
    yytext[YYLMAX-1] = '\0';
    while ((c = input()) > 0)  {
	if (i < YYLMAX - 3) yytext[i] = c;
	i += 1;
	if (SawStar && c == '/') break;
	SawStar = (c == '*');
    }
    if (i < (YYLMAX - 3)) yytext[i] = '\0';
    return (refs_WhiteSpace);
}

int refs_TokLineComment() {
    /* must search to the end of the comment */
    /* attempt to return it in str - up to the point that fits */

    int i = 2, c;
    
    yytext[YYLMAX-1] = '\0';
    
    while ((c = input()) > 0)  {
	if (i < YYLMAX - 1) yytext[i] = c;
	i += 1;
	if ( c == '\n') break;
    }
    if (i < (YYLMAX - 1)) yytext[i] = '\0';
    return (refs_WhiteSpace);
}

int refs_TokString() {
    int i = 1, c, SawBackSlash = 0;
    
    yytext[YYLMAX-2] = '"';
    yytext[YYLMAX-1] = '0';
    
    while ((c = input()) > 0)  {
	if (i < YYLMAX - 2) yytext[i] = c;
	i += 1;
	if (! SawBackSlash && c == '"') break;
	if(c == '\\') SawBackSlash=!SawBackSlash;
	else SawBackSlash=0;
    }
    if (i < (YYLMAX - 2)) yytext[i] = '\0';
  /*  if (i > (YYLMAX - 2))  {
	fprintf(stderr, "String Constant too long - truncated\n");
    }*/
    return (refs_String);
}

int refs_TokCharacter() {
    int i = 1, c, SawBackSlash=0;
    yytext[YYLMAX-2] = '\'';
    yytext[YYLMAX-1] = '0';
	while ((c = input()) > 0)  {
	if (i < YYLMAX - 2) yytext[i] = c;
	i += 1;
	if (! SawBackSlash && c == '\'') break;
	if(c == '\\') SawBackSlash=!SawBackSlash;
	else SawBackSlash=0;
    }
}
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */
/* Copyright 1993 Carnegie Mellon University All rights reserved.
  $Disclaimer: This software is part of version 7.2 of the 
# Andrew User Interface System and is the 
# property of IBM, Carnegie Mellon University, 
# and the other copyright holders.  The source 
# code of this version is for the sole use of 
# members of the Andrew Consortium with 
# memberships extending into calendar year 
# 1994.  This source code is not to be distributed 
# to non-members of the consortium nor beyond 
# a fifty-mile radius from the membership address.  
# Binary object code compiled or derived from 
# these sources is not to be distributed to non-
# members.  Members may have additional 
# distribution rights granted by prior written 
# permission of Carnegie Mellon University.
# 
# IBM, CARNEGIE MELLON UNIVERSITY, 
# AND THE OTHER COPYRIGHT HOLDERS
#  DISCLAIM ALL WARRANTIES WITH 
# REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANT-
# ABILITY AND FITNESS. IN 
# NO EVENT SHALL  IBM, CARNEGIE 
# MELLON UNIVERSITY, OR ANY OTHER 
# COPYRIGHT HOLDER BE LIABLE FOR 
# ANY SPECIAL, INDIRECT OR CONSE-
# QUENTIAL DAMAGES OR ANY DAMAGES 
# WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT 
# OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#  $ */
%%