/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/errors/RCS/errprntf.c,v 2.19 1993/06/16 17:33:38 rr2b Exp $";
#endif


/* *************************************************************** 

 errprntf.c:  Routine for printing Andrew-standard errors.

		********************************************
		**** For documentation, see errprntf.h **** 
		********************************************

*/
#include <andrewos.h>
#include <stdio.h>
#include "errprntf.h"

#define CONTROLMAX 1000  /* Longest printf control string */


#ifndef ANSI_COMPILER
int safefprintf(va_alist)
va_dcl
{
    FILE *fp;
    char *control, *rest;
    va_list ap;

    va_start(ap);
    fp = va_arg(ap, FILE *);
    control = va_arg(ap, char *);
    vfprintf(fp, control, ap);
    va_end(ap);
    fflush(fp);
    if (ferror(fp)) {
	va_start(ap);
	fp = va_arg(ap, FILE *);
	control = va_arg(ap, char *);
	fp = freopen("/dev/console", "w", fp);
	if (fp == NULL) return(-1);
	vfprintf(fp, control, ap);
	va_end(ap);
	fflush(fp);
	if (ferror(fp)) {
	    return(-1);
	}
    }
    return(0);
}


static char formatstr[]="<%s%s%s%s%s%s%s>";

int
errprintf(va_alist)
va_dcl
{
    char *application;
    va_list ap;
    char *log, *id, *format;
    int type;
    char ControlString[CONTROLMAX], *typestr;
    int numfields, ret;
    static FILE *fp=stderr;
    
    va_start(ap);
    application = va_arg(ap, char *);
    type = va_arg(ap, int);
    log = va_arg(ap, char *);
    id = va_arg(ap, char *);
    format = va_arg(ap, char *);
    if (type < 0 || type > 9) type = 0;
    numfields = 1;
    if (application) numfields = 2;
    if (log) numfields = 3;
    if (id) numfields = 4;
    if (type == ERR_CRITICAL) {
	typestr = "critical";
    } else if (type <= ERR_WARNING) {
	typestr = "warning";
    } else if (type <= ERR_MONITOR) {
	typestr = "monitor";
    } else {
	typestr = "debug";
    }
    fprintf(fp, formatstr, typestr, 
	(numfields > 1) ? ":" : "",
	application ? application : "",
	(numfields > 2) ? ":" : "",
	log ? log : "",
	(numfields > 3) ? ":" : "",
	    id ? id : "");
    if(ferror(fp)) {
	fp=freopen("/dev/console", "w", fp);
	if(fp==NULL) {
	    va_end(ap);
	    return -1;
	}
	fprintf(fp, formatstr, typestr, 
	(numfields > 1) ? ":" : "",
	application ? application : "",
	(numfields > 2) ? ":" : "",
	log ? log : "",
	(numfields > 3) ? ":" : "",
	    id ? id : "");
    }
    vfprintf(fp, format, ap);
    va_end(ap);
    if(ferror(fp)) {
	printf("here...\n");
	fp=freopen("/dev/console", "w", fp);
	if(fp==NULL) {
	    return -1;
	}
	va_start(ap);
	application = va_arg(ap, char *);
	type = va_arg(ap, int);
	log = va_arg(ap, char *);
	id = va_arg(ap, char *);
	format = va_arg(ap, char *);
	vfprintf(fp, format, ap);
	va_end(ap);
    }
    fprintf(fp, "\n");
    if(ferror(fp)) {
	fp=freopen("/dev/console", "w", fp);
	if(fp==NULL) {
	    return -1;
	}
	fprintf(fp, "\n");
    }
    fflush(fp);
    return ferror(fp);
}

#else

int safefprintf(FILE *fp, ...)
{
    char *control, *rest;
    va_list ap;

    va_start(ap, fp);
    control = va_arg(ap, char *);
    vfprintf(fp, control, ap);
    va_end(ap);
    
    fflush(fp);
    if (ferror(fp)) {
	fp = freopen("/dev/console", "w", fp);
	if (fp == NULL) return(-1);
	
	va_start(ap, fp);
	control = va_arg(ap, char *);
	vfprintf(fp, control, ap);
	va_end(ap);
	
	fflush(fp);
	if (ferror(fp)) {
	    return(-1);
	}
    }
    return(0);
}
static char formatstr[]="<%s%s%s%s%s%s%s>";

int
errprintf(char *application, ...)
{
    va_list ap;
    char *log, *id, *format;
    int type;
    char ControlString[CONTROLMAX], *typestr;
    int numfields, ret;
    static FILE *fp=stderr;
    
    va_start(ap, application);
    type = va_arg(ap, int);
    log = va_arg(ap, char *);
    id = va_arg(ap, char *);
    format = va_arg(ap, char *);
    if (type < 0 || type > 9) type = 0;
    numfields = 1;
    if (application) numfields = 2;
    if (log) numfields = 3;
    if (id) numfields = 4;
    if (type == ERR_CRITICAL) {
	typestr = "critical";
    } else if (type <= ERR_WARNING) {
	typestr = "warning";
    } else if (type <= ERR_MONITOR) {
	typestr = "monitor";
    } else {
	typestr = "debug";
    }
    fprintf(fp, formatstr, typestr, 
	(numfields > 1) ? ":" : "",
	application ? application : "",
	(numfields > 2) ? ":" : "",
	log ? log : "",
	(numfields > 3) ? ":" : "",
	    id ? id : "");
    if(ferror(fp)) {
	fp=freopen("/dev/console", "w", fp);
	if(fp==NULL) {
	    va_end(ap);
	    return -1;
	}
	fprintf(fp, formatstr, typestr, 
	(numfields > 1) ? ":" : "",
	application ? application : "",
	(numfields > 2) ? ":" : "",
	log ? log : "",
	(numfields > 3) ? ":" : "",
	    id ? id : "");
    }
    vfprintf(fp, format, ap);
    va_end(ap);
    if(ferror(fp)) {
	fp=freopen("/dev/console", "w", fp);
	if(fp==NULL) {
	    return -1;
	}
	va_start(ap, application);
	type = va_arg(ap, int);
	log = va_arg(ap, char *);
	id = va_arg(ap, char *);
	format = va_arg(ap, char *);
	vfprintf(fp, format, ap);
	va_end(ap);
    }
    fprintf(fp, "\n");
    if(ferror(fp)) {
	fp=freopen("/dev/console", "w", fp);
	if(fp==NULL) {
	    return -1;
	}
	fprintf(fp, "\n");
    }
    fflush(fp);
    return ferror(fp);
}

#endif
