/* Copyright 1994 Carnegie Mellon University All rights reserved.
  $Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

 // ATKDynImpl: the system specific code to adapt the link line for a dynamic object.

#include <ATKOLinkI.H>
#include <fstream.h>

ATKOLinkI::ATKOLinkI() {
    ast=new ATKSymTab;
    if(ast==NULL) {
	cerr<<"ATKOLinkI: Couldn't create new symtab."<<endl;
	exit(-1);
    }
}

ATKOLinkI::~ATKOLinkI() {
    delete ast;
}

void ATKOLinkI::ProcessArgument(char *arg) {
    char buf[MAXPATHLEN];
    if(strlen(arg)>sizeof(buf)-3) {
	cerr<<"Argument too long, ignored..."<<endl<<arg<<endl;
	return;
    }
    strcpy(buf, arg);

    char *q=strrchr(buf, '/');
    if(q==NULL) q=buf;
    else q++;

    char *r=strrchr(q, '.');
    if(r && r[1]=='+') {
	    char abuf[MAXPATHLEN];
	    *r='\0';
	    sprintf(abuf,"-Wl,-u,_%s_ATKregistry_",q);
	    InsertArguments(abuf);
	    *r='.';
    } else {
	if(strncmp(q, "lib", 3)!=0) {
	    InsertArguments(arg);
	    return;
	}
	strcpy(q, q+3);
    }
    char *p=strrchr(buf, '.');
    if(p==NULL) {
	InsertArguments(arg);
	return;
    }
    
    strcpy(p, ".exp");

    if(access(buf, R_OK)!=0) {
	InsertArguments(arg);
	return;
    }
    
    ifstream in(buf);
    if(!in.is_open()) {
	cerr<<"ATKOLinkI: Warning: Couldn't open "<<buf<<'.';
    }
    while(!in.eof()) {
	in.getline(buf, sizeof(buf));
	if(!in.eof()) {
	    if(!ast->AddSymbol(buf)) {
		cerr<<"ATKOLinkI: Couldn't add symbol to the symbol table."<<endl;
		exit(-1);
	    }
	}
    }   
}

boolean ATKOLinkI::FindSymbol(const char *sym)
{
    return ast?(ast->FindSymbol(sym)?TRUE:FALSE):FALSE;
}

void ATKOLinkI::ArgumentsDone() {
    printf("comm:%s\n",SystemString(FALSE));
}

extern char *ATKDoFix(char *path);
int ATKOLinkI::Test() {
    char *p, *base;
    long len;
    char buf[MAXPATHLEN+1];
    ResetIterator();
    while(p=NextArgument()) {
	if(p[0]=='-' && p[1]=='o' && p[2]=='\0') {
	    p=NextArgument();
	    break;
	}
    }
    if(p==NULL) {
	cout<<"ATKOLinkI: couldn't find object filename on the link line."<<endl;
	return 1;
    }

    p=ATKDoFix(p);
    if(p==NULL) {
	cout<<"ATKOLinkI: couldn't fix object file for dynamic loading."<<endl;
	return 2;
    }

    return 0;
}

