/* Copyright 1994, Carnegie Mellon University, All rights reserved.
 $Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
 */

// ATKDynLink: the machine independent part of constructing a link line for dynamic objects.

#include <ATKOLinkI.H>
#include <iostream.h>

void ATKOLink::ProcessArgument(char *arg) {
    InsertArguments(arg);
}

void ATKOLink::ArgumentsDone() {
} 

int ATKOLink::Test() {
    return 0;
}

int main(int argc, char **argv) {
    char *cmd;
    ATKOLink *adl=new ATKOLinkI;
    if(adl==NULL) {
	cerr<<"adynlink: Couldn't create argument list."<<endl;
	exit(-1);
    }
    argc--;
    argv++;
    for(int i=0;i<argc;i++) {
	adl->ProcessArgument(argv[i]);
    }
    adl->ArgumentsDone();
    cmd=adl->SystemString();
    if(cmd==NULL) {
	cerr<<"adynlink: Couldn't create command to link dynamic object."<<endl;
	exit(-1);
    }
    int result=system(cmd);
    if(result!=0) {
	cerr<<"adynlink: Link command failed with error code "<<result<<"."<<endl;
	exit(result);
    }
    result=adl->Test();
    if(result!=0) {
	cerr<<"adynlink: Dynamic object test failed with error code "<<result<<"."<<endl;
	exit(result);
    }
    exit(0);
}
    
    
	
