/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

/*
 * dired.H
 *
 * This object is a subclass of text whose purpose is to
 * read a specified directory and keep a list of the files in
 * a text object.
 *
 * Allows each file in the list to be marked or unmarked.  Marked
 * files are wrapped in a highlighting style.  A way is provided to
 * enumerate through all files or just the marked ones.
 *
 * The fileinfo structure associates information with each file.
 * Pointers to fileinfo structures are used for data values in a list.
 */

struct fileinfo {
    char *fileName, *dispName;
    long pos, len;              /* Where in text */
    struct environment *env;    /* NULL if not marked */
};

class dired: text {

classprocedures:
    InitializeObject(struct dired *self) returns boolean;
    FinalizeObject(struct dired *self);

overrides:
    GetModified() returns long;
    SetAttributes(struct attributes *attributes);

methods:
    SetDir(char *dname) returns long;
    GetDir() returns char *;            /* Null if none */

    Locate(long pos) returns char *;    /* Filename */

    Mark(char *fname);
    Unmark(char *fname);
    IsMarked(char *fname) returns boolean;
    AnythingMarked() returns boolean;

    EnumerateAll(procedure proc, long rock) returns char *;
    EnumerateMarked(procedure proc, long rock) returns char *;

macromethods:
    SetLongMode(boolean on) ((self)->longMode = (on))
    GetLongMode() ((self)->longMode)
    SetDotFiles(boolean on) ((self)->dotFiles = (on))
    GetDotFiles() ((self)->dotFiles)

data:
    struct style *markedStyle;

    char *dir;                  /* Being edited */
    struct list *flist;         /* List of struct fileinfo */

    boolean longMode, dotFiles;
};
