/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/
#ifndef	SYSTEM_H
#define	SYSTEM_H

/* Get common definitions
 *
 * NOTE:
 * define CFRONT_ENV or IBMCSET_ENV in presite.h for the AT&T C++ compiler
 * or the IBM CSet++ (xlC++) compiler, respectively.  The default is g++.
 */
#include <presite.h>

#if !defined(In_Imake) && defined(IBMCSET_ENV)
/* We run the CSet++ compiler in "extended" mode to allow non-standard C++
 * code to compile.  Thus, __STDC__ is not defined.  So we manually set
 * ANSI_CPP so things defined in aconcat.h and such will still work.
 */
#define ANSI_CPP 1
#endif

#include <allsys.h>
 
#define	OPSYSNAME	"risc_aix3"
#define	sys_rt_aix3	1
#define	SYS_NAME	"rs_aix3"

#define ANSI_COMPILER 1

#ifndef _IBMR2
#define _IBMR2 1
#endif /* _IBMR2 */ 

#define HAVE_DYNAMIC_LOADING 1
#define HAVE_DYNAMIC_INTERLINKING 1
#define HAVE_SHARED_LIBRARIES 1
#ifdef In_Imake
#define INSTALL_SHLIB_SUPPORT() @@\
InstallFileToFile(rs_aix3/mkatkshlib, $(INSTPROGFLAGS), $(DESTDIR)/etc) @@\
InstallFileToFile(rs_aix3/exp.csh, $(INSTPROGFLAGS), $(DESTDIR)/etc) @@\
InstallFileToFile(rs_aix3/exp.awk, $(INSTPROGFLAGS), $(DESTDIR)/etc)
#endif
#define DynamicPreLinkCommand(dobj,extraclasses,objs,libs,syslibs) $(BASEDIR)/etc/exp.csh dobj.exp $(BASEDIR) objs;
#define PreDynFlags(dobj,extraclasses,objs,libs,syslibs) -Wl,-e,main -Wl,-bM:SRE -Wl,-bE:dobj.exp

/* These are here for AIX support. */
 
#undef SY_AIX3
#define SY_AIX3 1	/* define for AIX 3.1 */
#undef POSIX_ENV
#define POSIX_ENV 1	/* This is a Posix system. */

#ifndef In_Imake
#include <atkproto.h>

#ifdef CFRONT_ENV
#define vsprintf __vsprintf 
#define wait3 __wait3 
#define setpgrp __setpgrp 
#define ecvt __ecvt 
#define fcvt __fcvt 
#define gcvt __gcvt 
#include <stdlib.h> 
#undef ecvt 
#undef fcvt 
#undef gcvt
BEGINCPLUSPLUSPROTOS
char *ecvt(double Value,  int NumberOfDigits, int *DecimalPointer, int
*Sign); 
char *fcvt(double Value,  int NumberOfDigits, int *DecimalPointer, int
*Sign); 
char *gcvt (double Value, int NumberOfDigits, char *Buffer);
ENDCPLUSPLUSPROTOS
#endif /* CFRONT_ENV */
 
#ifdef IBMCSET_ENV
/* IBM CSet++ compiler (tested with version 2.1) */

#undef QSORTFUNC
#undef SCANDIRCOMPFUNC
#undef SCANDIRSELFUNC
#undef SCANDIRSELARG_TYPE
#define QSORTFUNC(x) (int (*)(const void *,const void *))(x)
#define SCANDIRCOMPFUNC(x) ((int (*)(struct dirent **, struct dirent **))x)
#define SCANDIRSELFUNC(x) ((int (*)(struct dirent *))x)
#define SCANDIRSELARG_TYPE struct dirent

#include <stdlib.h> 
/* Use mem* routines to avoid pointer conv problems. */
#define bzero(p, n) memset(p, 0, n)
#define bcopy(s, d, n) memcpy(d, s, n)
#define bcmp(s1, s2, n) memcmp(s1, s2, n)

#endif /* IBMCSET_ENV */

#include <sys/types.h>
#define fchmod fchmod_hidden_
#include <sys/stat.h>
#undef fchmod
#include <sys/access.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>
#if defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus) || defined(ANSI_COMPILER)
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <stdio.h>
#include <dirent.h>


#include <sys/wait.h>
 
/* Get open(2) constants */
#include <sys/file.h>


/* Get struct timeval */
#include <sys/time.h>
#include <sys/times.h>
#include <time.h>

/* include path for syslog.h */
#include <sys/syslog.h>

#ifdef __GNUG__
/* Hack around SignalHandler typedef provided by
 GNU for Interviews compatibility, it conflicts
 with a method called SignalHandler. */
#define SignalHandler G_SignalHandler
#include <signal.h>
#undef SignalIgnore
#undef SignalBad
#undef SignalDefault
#define SignalDefault ((G_SignalHandler)0)
#define SignalIgnore ((G_SignalHandler)1)
#define SignalBad ((G_SignalHandler)-1)
#undef SignalHandler
#else
#include <signal.h>
#endif

#include <sys/select.h>

#include <ctype.h>

#define OSI_HAS_SYMLINKS 1
/* If OSI_HAS_SYMLINKS is not defined, osi_readlink is present in libutil. */
#define osi_readlink(PATH,BUF,SIZE) readlink((PATH),(BUF),(SIZE))
#include <sys/lockf.h>
#include <sys/flock.h>
#define osi_ExclusiveLockNoBlock(fid)	lockf((fid), F_TLOCK, 0)
#define osi_UnLock(fid)			lockf((fid), F_ULOCK, 0)

#define osi_O_READLOCK			O_RDWR
#define osi_F_READLOCK			"r+"

/* handle (BSD) vfork for (AIX) which only knows fork */
#define	osi_vfork()			fork()

/* Handle the absence of _setjmp and _longjmp on AIX. */
#define	osi_setjmp  setjmp
#define	osi_longjmp longjmp

/* Make a time standard. */
struct osi_Times {unsigned long int Secs; unsigned long int USecs;};
/* Set one of the above with a call to osi_GetTimes(&foo) */
#define osi_GetSecs() time((long int *) 0)
#define osi_SetZone() tzset()
#define osi_ZoneNames tzname
#define osi_SecondsWest timezone
#define osi_IsEverDaylight daylight

#if 1
/* More BSD-isms */
#define setlinebuf(file) setvbuf(file, NULL, _IOLBF, BUFSIZ)
#endif

#ifdef FDTABLESIZE
#undef FDTABLESIZE
#endif
#define FDTABLESIZE() getdtablesize()
/*
 * Put system-specific definitions here
 */
#define HAS_SYSEXITS 1
#define BIT_ZERO_ON_LEFT 1

#define setreuid(r,e) atk_setuid(r)

#ifndef IBMCSET_ENV
#undef QSORTFUNC
#undef SCANDIRCOMPFUNC
#undef SCANDIRSELFUNC
#undef SCANDIRSELARG_TYPE
#define QSORTFUNC(x) (int (*)(void *,void *))(x)
#define SCANDIRCOMPFUNC(x) ((int (*)(struct dirent **, struct dirent **))x)
#define SCANDIRSELFUNC(x) ((int (*)(struct dirent *))x)
#define SCANDIRSELARG_TYPE struct dirent

#define bzero(x,y) memset(x, 0, y)
#define bcopy(x,y,z) memmove(y,x,z)
#endif


BEGINCPLUSPLUSPROTOS
 

/* Prototypes missing from the system header files. */
extern int  fchmod(int fd, int mode);
extern int scandir (char *DirectoryName, struct dirent *(*NameList[]), int (*Select)(struct dirent *), int (*Compare)(struct dirent **, struct dirent **));
int alphasort(struct dirent **, struct dirent **);
extern int killpg(int pid, int sig);
struct sockaddr;
extern int recvfrom(int fd, char *buf, int length, int flags, struct sockaddr *from, int *flen);

extern long random(); 
extern char *initstate(unsigned int Seed, char *State, int Number);
int gethostname (char *, int);

#ifndef IBMCSET_ENV
extern char  *getwd(char *foo);
extern int lockf(int fd, int req, off_t size);
struct sockaddr;
extern int recvfrom(int fd, char *buf, int length, int flags, struct sockaddr *from, int *flen);

#ifdef CFRONT_ENV
extern int sigvec(int sig, struct sigvec *,struct sigvec *);
extern char *mktemp(char *name); 
extern int ftruncate(int fd, size_t len); 
extern int readlink(const char *p, char *buf, size_t len); 
extern int setsockopt(int fd, int opttype, int opt, char *buf, size_t bufsize);
#undef wait3
#undef setpgrp
#undef vsprintf
extern int vsprintf(char *buf, const char *msg, va_list va);
struct rusage;
extern int wait3(int *status, int flags, struct rusage *r); 
extern int setpgrp();
#endif /* CFRONT_ENV */
#endif /* !IBMCSET_ENV */

/* End of prototypes missing from the system header files. */

extern int osi_GetTimes(struct osi_Times *p);

ENDCPLUSPLUSPROTOS

#endif /* !In_Imake */

#define GETDOMAIN_ENV 1
#undef ANDREW_MALLOC_ENV


/* Now follow the site-specific customizations. */
 
#include <site.h>

#endif	/* SYSTEM_H */
 
