/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/msclients/cui/RCS/morprntf.c,v 2.10 1992/12/15 21:22:34 rr2b R6tape $";
#endif


 

#include <cui.h>
#include <hdrparse.h>
#include <errprntf.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#include <andrewos.h> /* sys/file.h sys/time.h */
#define CUI_SOURCE_CUIFNS_C
#include <cuimach.h>

extern int CUI_SnapIsRunning;
extern char *GetLine();

int LinesOnTerminal = 24, LinesSincePause = 3,
    CharsOnLine = 1, TerminalLineWidth = 80;

NoMore() {
    LinesSincePause = 3;
    CharsOnLine = 1;
}

SetTerminalParams(h, w)
int h, w;
{
    LinesOnTerminal = h;
    TerminalLineWidth = w;
}

/* VARARGS */
moreprintf(format, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20)
char *format;
long a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12,
     a13, a14, a15, a16, a17, a18, a19, a20;
{
    char    EnormousLine[10+MAXBODY],
	   *s,
	   *t;

    sprintf(EnormousLine, format, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
    for (s = t = EnormousLine; s && *t;) {
	s = strchr(t, '\n');
	if (s) {
	    if (SpitOutChars(t, s-t+1) == MORE_NO_MORE) return(MORE_NO_MORE);
	    t = s + 1;
	} else {
	    if (SpitOutChars(t, strlen(t)) == MORE_NO_MORE) return(MORE_NO_MORE);
	}
    }
    return(0);
}

SpitOutChars(t, len)
char *t;
int len;
{
    char *myline;
    int newlen;

    while (CharsOnLine+len > TerminalLineWidth) {
	newlen = TerminalLineWidth - CharsOnLine -1;
	fwrite(t, sizeof(char), newlen, stdout);
	fputc('\n', stdout);
	if (LinesOnTerminal && ++LinesSincePause > (LinesOnTerminal)) {
	    safefprintf(stdout, "-- More -- Press Enter to continue or 'q' to quit: ");
	    myline = GetLine();
	    if (myline == (char *) - 1) {
		clearerr(stdin);
	    } else {
		if (*myline == 'q' || *myline == 'Q' || *myline == 'n' || *myline == 'N') {
		    return(MORE_NO_MORE);
		} else if (*myline == 'c' || *myline == 'C') {
		    SetTerminalParams(0,80);
		}
	    }
	}
	CharsOnLine = 0;
	len -= newlen;
	t += newlen;
    }
    fwrite(t, sizeof(char), len, stdout);
    fflush(stdout);
    CharsOnLine += len;
    if (t[len-1] == '\n') {
	if (LinesOnTerminal && ++LinesSincePause > LinesOnTerminal) {
	    safefprintf(stdout, "-- More -- Press Enter to continue or 'q' to quit: ");
	    myline = GetLine();
	    if (myline == (char *) - 1) {
		clearerr(stdin);
	    } else if (*myline == 'q' || *myline == 'Q' || *myline == 'n' || *myline == 'N') {
		return(MORE_NO_MORE);
	    } else if (*myline == 'c' || *myline == 'C') {
		SetTerminalParams(0,80);
	    }
	}
	CharsOnLine = 0;
    }
    return(0);
}
