/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/logging.c,v 2.11 1992/12/15 21:20:00 rr2b R6tape $";
#endif

#include <andrewos.h>
#include <ms.h>
#include <stdio.h>
#include <sys/stat.h>

extern int IsLoggingMailStats;
extern char MAILLOGSTATFILE[];
extern char home[], Me[];

ConsiderLoggingRead(FileName)
char *FileName;
{
    char LineBuf[1000], *s;
    int size = 0;
    FILE *fp, *logfp;
    struct stat statbuf;

    if (!IsLoggingMailStats) return;
    logfp = fopen(MAILLOGSTATFILE, "a");
    if (!logfp) return;
#ifdef M_UNIX
    chmod(MAILLOGSTATFILE, 0600);
#else
    fchmod(fileno(logfp), 0600);
#endif

    fp = fopen(FileName, "r");
    if (!fp &&
	(RetryBodyFileName(FileName) < 0 || !(fp = fopen(FileName, "r")))) {
	fclose(logfp);
	return;
    }
    if (fstat(fileno(fp), &statbuf)) {
	fclose(logfp);
	return;
    }
    fputc('\n', logfp);
    while (fgets(LineBuf, sizeof(LineBuf), fp) && LineBuf[0] != '\n') {
	fputs(LineBuf, logfp);
	size += strlen(LineBuf);
    }
    fclose(fp);
    s = strrchr(FileName, '/');
    if (s) *s = '\0';
    fprintf(logfp, "X-StatTrace: %s READ %d bytes %s %s ; %s", Me, statbuf.st_size - size, strncmp(FileName, home, strlen(home)) ? "BBOARD" : "MAIL", FileName, arpadate());
    if (s) *s = '/';
    fclose(logfp);
}
