/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/getfile.c,v 2.10 1993/07/02 22:37:57 rr2b Exp $";
#endif

#include <andrewos.h> /* sys/file.h */
#include <ms.h>
#include <sys/stat.h>

MS_GetPartialFile(FileName, Buf, BufLim, offset, remaining, ct)
char *FileName, *Buf;
int BufLim, offset, *remaining, *ct;
{
    int fd;
    struct stat statbuf;

    debug(1, ("MS_GetPartialFile %s\n", FileName));
    *remaining = 0;
    *ct = 0;
    if ((fd = open(FileName, O_RDONLY, 0)) < 0
	&& (RetryBodyFileName(FileName) < 0
	    || (fd = open(FileName, O_RDONLY, 0)) < 0)) {
	AMS_RETURN_ERRCODE(errno, EIN_OPEN, EVIA_GETPARTIALFILE);
    }
    if (fstat(fd, &statbuf) != 0) {
	close(fd);
	AMS_RETURN_ERRCODE(errno, EIN_FSTAT, EVIA_GETPARTIALFILE);
    }
    if (offset > 0 && lseek(fd, offset, SEEK_SET) < 0) {
	close(fd);
	AMS_RETURN_ERRCODE(errno, EIN_LSEEK, EVIA_GETPARTIALFILE);
    }
    if ((*ct = read(fd, Buf, BufLim)) < 0) {
	close(fd);
	AMS_RETURN_ERRCODE(errno, EIN_READ, EVIA_GETPARTIALFILE);
    }
    *remaining = statbuf.st_size -offset - *ct;
    if (*ct < BufLim) Buf[*ct] = '\0';  /* Be nice to clients */
    close(fd);
    return(0);
}
