/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/freemsg.c,v 2.8 1992/12/15 21:19:11 rr2b R6tape $";
#endif

#include <ms.h>
#include <hdrparse.h>

/* 2 routines for backward compatibility */

FreeMessage(Msg, FreeSnapshot)
struct MS_Message *Msg;
Boolean FreeSnapshot;
{
    debug(1, ("FreeMessage\n"));
    if (Msg) {
	if (Msg->OpenFD >= 0) {
	    if (Msg->OpenFD == 0) {
		CriticalBizarreError("Warning!  FreeMessage is closing file descriptor zero, which is *probably* a mistake!");
	    }
	    close(Msg->OpenFD);
	    Msg->OpenFD = -1; /* Just for sheer paranoia */
	}
	FreeMessageContents(Msg, FreeSnapshot);
	if (Msg->AuthCell) free(Msg->AuthCell);
	if (Msg->AuthName) free(Msg->AuthName);
	free(Msg);
    }
    return(0);
}

FreeMessageContents(Msg, FreeSnapshot)
struct MS_Message *Msg;
Boolean FreeSnapshot;
{
    if (!Msg) return(0);
    if (FreeSnapshot && Msg->Snapshot) {free (Msg->Snapshot); Msg->Snapshot = NULL;}
    if (Msg->RawBits) {free (Msg->RawBits); Msg->RawBits = NULL;}
    if (Msg->ReplyTo) {free (Msg->ReplyTo); Msg->ReplyTo = NULL;}
    if (Msg->WideReply) {free (Msg->WideReply); Msg->WideReply = NULL;}
    FreeParsedStuff(Msg);
    return(0);
}

FreeParsedStuff(Msg)
struct MS_Message *Msg;
{
    int i;
    if (Msg->ParsedStuff) {
	for (i = HP_END_PREDEFINED; Msg->ParsedStuff->HeadName[i]; ++i) {
	    free(Msg->ParsedStuff->HeadName[i]);
	}
	free(Msg->ParsedStuff->HeadName);
	free(Msg->ParsedStuff->HeadBody);
	free(Msg->ParsedStuff->HeadBodyLen);
	free(Msg->ParsedStuff->IsDuplicated);
	free (Msg->ParsedStuff);
	Msg->ParsedStuff = NULL;
    }
    return(0);
}

