ATK_INTER
#ifndef _keystate_H_
#define _keystate_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 

/* keystate.ch -- A class that keep track of partially evaluated sequences of keystrokes.
December, 1986 */


#define keystate_VERSION	1

/* Return values from ApplyKey: */

enum keystate_ApplyKeyValues  {
    keystate_ProcFound,		/* pe has an entry */
    keystate_NoBinding,		/* key is undefined */
    keystate_Pending		/* keep feeding chars */
};

/* Return values from DoProc: */

enum keystate_DoProcValues {
    keystate_ProcCalled,	/* success */
    keystate_TypeMismatch,	/* couldn't find object of correc type */
    keystate_NoProc		/* couldn't load proc */
};

#include <keymap.H>

#include <ATK.H>

    typedef enum keymap_Types (*keystate_fptr)(long fdata, long key, struct proctable_Entry **p, long *rock);

class keystate : public ATK  {
public:
	virtual ATKregistryEntry *ATKregistry();
    inline ATK  * GetObject() { return (this->object); }

    virtual void SetObject(ATK  *object);
    virtual class keystate * AddBefore(class keystate *ks)  ;
    virtual class keystate * AddAfter(class keystate *ks)  ;
    /* Routines for playing keystokes. */
    virtual void Reset();	/* inits whole chain and clears arg junk */
    virtual enum keystate_ApplyKeyValues ApplyKey(char key, struct proctable_Entry **ppe, long *rockP, ATK  **pobject)  ;
    virtual enum keystate_DoProcValues DoProc(struct proctable_Entry *pe, long rock, ATK  *object)  ;
    /* Zap a chain of keystates. */
    virtual void FreeChain();	/* Calls destroy on each keystate object */
    virtual void SetOverride(keystate_fptr function, long functionData);
    virtual void GetOverride(keystate_fptr *function, long *functionData);

    keystate();
	static class keystate * Create(ATK  *object, class keymap *keymap)  ;
    /* These are internal to the implementation. */
    static class keystate * Allocate()  ;
    static void Deallocate(class keystate *ks);


    class keystate *next;	/* links together keymaps */
    class keymap *orgMap;	/* keymap to use */
    class keymap *curMap;	/* where we are in traversal */
    ATK  *object;	/* first argument to function */
    keystate_fptr function; /* Override function to trap keystrokes. */
    long functionData; /* Rock for the override function. */
};


#endif /* _keystate_H_ */
