ATK_INTER
#ifndef _bufferlist_H_
#define _bufferlist_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 

#include <observable.H>

typedef boolean (*bufferlist_efptr)(class buffer *b, long d);
typedef boolean (*bufferlist_sfptr)(class buffer *a, class buffer *b);

class bufferlist : public  observable {
public:
	virtual ATKregistryEntry *ATKregistry();
	 void ObservedChanged (class observable *changed, long value);
    
        virtual void AddBuffer(class buffer *buffer);
        virtual void RemoveBuffer(class buffer *buffer);
        virtual class buffer * Enumerate(bufferlist_efptr mapFunction, long functionData)  ;
        virtual class buffer * CreateBuffer(char *bufferName, char *fileName, char *objetName, class dataobject *data)  ;
	
/* Lookup functions */
        virtual class buffer * FindBufferByName(char *bufferName)  ;
        virtual class buffer * FindBufferByFile(char *filename)  ;
        virtual class buffer * FindBufferByData(class dataobject *data)  ;

/* File functions. */
        virtual class buffer * GetBufferOnFile(char *filename, long flags)  ;
        virtual void GuessBufferName( char *filename, char *bufferName, int nameSize);
        virtual void GetUniqueBufferName( char *proposedBufferName, char *bufferName, int nameSize);
        virtual void SetDefaultObject(char *objectname);

/* Sorting the buffer list. */
	virtual void Sort(bufferlist_sfptr compareRoutine);
    
        
	virtual ~bufferlist();
        
	bufferlist();
    
	struct listentry *head;
};


#endif /* _bufferlist_H_ */
