ATK_INTER
#ifndef _stringtbl_H_
#define _stringtbl_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 

/*
stringtbl.H

String table data object

	This module supports storage for a set of string values.  (At most 32 strings)
	A bit vector associated with the set specifies which are "selected" (0, 1, or many)
	Strings are checked for backslash and brackets and they are deleted.
	Strings are truncated to 255 character.
	All operations are case sensitive.
	(AddString checks for length and backslash, but the others do not.  Thus
		a string may be added and then not found.)

	An "accession number" is associated with each string.  This will be a small integer;
	counting restarts each time the table is cleared.  The functions with OfEntry in their
	names have the accession number as argument.

	The character string arguments to the functions are tested for NULL or '\0' and
	ignored if so.   In this case, AddString returns 0;  it also returns zero if the table is full.

*/

#define  stringtbl_PROGRAMMERVERSION    1

/* XXX ??? I think there is as yet no way to say I want these only in .eh */
#define MAXSTRINGSINTABLE 32
#define MAXSTRINGENTRYLENGTH 255

#define stringtbl_STRINGSCHANGED 1
#define stringtbl_BITSCHANGED 2

#include <dataobject.H>

class stringtbl : public  dataobject {
public:
	virtual ATKregistryEntry *ATKregistry();




	 long Read( /* struct stringtbl *self, */ FILE *file, long id )  ;
	 long Write( /* struct stringtbl *self, */ FILE *file, long id, int level )
	 ;

	/* The file format for a stringtbl is the bitvector in hex, 
		a newline, 	and then a sequence of the strings, each 
		followed by a newline.
	*/
	 char * ViewName()  ;


	virtual void Clear( /* struct stringtbl *self */ );		
		/* Clears the string table of existing strings */
	virtual short AddString( /* struct stringtbl *self, */ char *s)  ;
		/* Adds a string to the set of strings in the table, 
			returns its accession number 
			returns -1 if table is full */
	virtual void RemoveString( /* struct stringtbl *self, */ char *s);
			/* Removes the specified string from the table.
			If the string is absent, the call is ignored */
	virtual void SetBit( /* struct stringtbl *self, */ char *s, boolean val);
		/* finds the named string in the table 
			and sets its associated bit to the given val */
	virtual boolean GetBit( /* struct stringtbl *self, */ char *s)  ;
		/* finds the named string in the table and 
			returns the current value of its bit 
		   if s is absent, returns FALSE anyway */
	virtual void ClearBits( /* struct stringtbl *self */ );
		/* sets all bits to zero */
	virtual void RemoveEntry( /* struct stringtbl *self, */ short accnum );
		/* remove the entry with the given accnum 
			If the string is absent, the call is ignored */
	virtual void SetBitOfEntry( /* struct stringtbl *self, */  short accnum, boolean val );
		/* set the bit associated with the given accnum 
			If the string is absent, the call is ignored */
	virtual boolean GetBitOfEntry( /* struct stringtbl *self, */  short accnum )  ;
		/* return the bit for the given accnum 
			If the string is absent, returns FALSE */
	virtual char * GetStringOfEntry( /* struct stringtbl *self, */  short accnum )  ;
		/* return the string for the given accnum 
			If the string is absent, returns NULL */
	virtual short GetEntryOfString( /* struct stringtbl *self, */ char *string, short startIndex)  ;
		/* return the index of the entry that matches string, the search starts at startIndex.  Returns -1 if no item was found  Returns -2 if a bad string was sent in */	



	/* (the instances of " + 0 " prevent assignment to these fields) 
		It is a gross error to modify the string pointed at by IthString
		or to retain the pointer beyond the next AddString or RemoveString */

	inline short NStrings( /* struct stringtbl *self */ ) { return ((short)(this->used + 0)); }
	inline char * IthString( /* struct stringtbl *self, */  short i )  { return ((char *)(this->item[i] + 0)); }
	inline short NumAcc( /* struct stringtbl *self */ ) { return ((short)(this->numacc+0)); }



	
	stringtbl();
	
	virtual ~stringtbl();



	char *(item[MAXSTRINGSINTABLE]);	/* pointers to the strings */
	unsigned long highlight;		/* the bits.  bit (1<<i) is for item[i] */
	short used;		/* the first -used- of the elements in -item- have values */
	short numacc;		/* number of accessions */
	short accmap[32];	/* the accession number for each entry */
	boolean ContainsInitialStrings;	/* TRUE until client first changes table */
};


#endif /* _stringtbl_H_ */
