ATK_INTER
#ifndef _lookz_H_
#define _lookz_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 

/*
lookz.H

	lookz data object

	This inset provides for editing the styles of its parent text

	The file format for a lookz has a single line between
	\begindata and \enddata.  The only text on this line is one of the 
	words "visible" or "hidden", determining whether the 
	style editor is exposed or hidden in the text.

*/

#define  lookz_PROGRAMMERVERSION    1

/* status values for NotifyObservers */
#define lookz_VISIBILITYCHANGED 1
#define lookz_CANCLOSECHANGED 2
#define lookz_TEXTOBJECTCHANGED 4

#include <dataobject.H>
class lookz : public  dataobject  {
public:
	virtual ATKregistryEntry *ATKregistry();




	 long Read( /* struct lookz *self, */ FILE *file, long id )  ;
	 long Write( /* struct lookz *self, */ FILE *file, long id, int level )
			 ;
	 void ObservedChanged(/* struct lookzview *self, */ class observable *dobj, long status);


	
	virtual void SetVisibility( /* struct lookz *self, */ boolean visible );
	virtual void SetTextObject(class text *text);
	virtual void SetCanClose(boolean canClose);


	inline boolean GetVisibility( /* struct lookz *self */ ) { return (((class lookz *)this)->visible + 0); }

        inline boolean GetCanClose() { return (this->canClose); }
        inline class text * GetTextObject() { return (this->text); }


	
	lookz();
	
	virtual ~lookz();



	boolean visible;		/* if FALSE, only an icon is displayed
						if TRUE, the editor is displayed 
						this field is constrained to be 
						TRUE or FALSE  */

	boolean canClose;
	class text *text;
};


#endif /* _lookz_H_ */
