#ifndef _htmltext_H_
#define _htmltext_H_
ATK_INTER

/* File htmltext.H created by Ward Nelson
       (c) Copyright IBM Corp 1995.  All rights reserved. 

    htmltext, an object for reading and writing HTML+ formatted files. */

class style;
class attlist;
class htmltext;
class htmlenv;
class dataobject;

enum ListType { 
		listtype_UNORDERED, 
		listtype_ORDERED, 
		listtype_DEFINITION 
};

struct htmltaginfo {
    style *thestyle;
    attlist *atts;
    long startpos;
    long arrayidx;
    char *tagid;
};

struct namelist {
    char *name;
    struct namelist *next;
};

typedef union {
    long integer;
    double real;
    const char *cstr;
    pointer obj;
    procedure f;
    char c;
    int i;
    boolean b;
} arbval;

/* htmlefptr - type for functions passed to EnumerateInsets.
	If function returns TRUE, 	the enumeration halts and
	returns the position of the inset most recently passed.
	For an error, EnumerateInsets returns -9 for an error
	and -1 if the function returns FALSE for all insets.

	self - the htmltext being scanned
	pos - the location of the embedded data object
	dobj - the dataobject at pos
	rock - arbitrary data for use by function
	needsgif - TRUE if htmltext cannot process this inset type	
*/
typedef boolean (*htmlefptr)(htmltext *self, long pos, htmlenv *env,
	dataobject *dobj, arbval rock, boolean needsgif);

#include <text.H>
class htmltext: public text {
  public:
    virtual ATKregistryEntry *ATKregistry();
    htmltext();
    virtual ~htmltext();
    static boolean InitializeClass();

    long ReadSubString(long pos, FILE *file, 
		boolean quoteCharacters);
    void WriteSubString(long pos, long len, FILE *file, 
		boolean quoteCharacters);
    long Read(FILE *file, long id);
    long Write(FILE *file, long writeID, int level);
    void Clear();
    void ClearCompletely();
    virtual htmlenv *AddImage(long pos, char *file, 
		attlist  *atts=NULL);
    virtual void RenumberList(long pos, enum ListType ltype, 
		htmlenv *env);
    virtual htmlenv *AddDingbat(long pos, 
		enum ListType ltype, htmlenv *env);
    virtual long FindDestId(char *dest);
    virtual char *GetAnchor(long pos);
    virtual void ShowComments(boolean viewcomments);
    virtual void ShowRaw(boolean viewraw);
    virtual char *GififyInset(long pos, htmlenv *env,
		char *path, 	// dir for html file 
		char *relgifdir,  // dir for gif; rel to path
		char *giffile // name of gif file  (w/  .gif)
		); 
		// path and relgifdir are empty or end w/ /
		// returns error message, else NULL
    virtual long EnumerateInsets(htmlefptr f, arbval rock);
    
    struct namelist *renderlist;    
    boolean readonly;
};

#endif /* _htmltext_H_ */
