ATK_INTER
#ifndef _fontsel_H_
#define _fontsel_H_
/* fontsel.ch - font selection inset dataobject */
/*
	Copyright Carnegie Mellon University 1992 - All rights reserved
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
  $Header: /afs/cs/user/rr2b/7.4/src/RCS/fontsel.H,v 3.3 1994/11/30 20:42:06 rr2b Stab74 $
*/

#define	fontsel_DATACHANGED	(1)

#define	fontsel_Style	(0)
#define	fontsel_Size	(1)
#define	fontsel_Family	(2)

#define	fontsel_default_Style	(0)
#define	fontsel_default_Size	(12)
#define	fontsel_default_Family	("andy")

#include <dataobject.H>

class fontsel : public  dataobject  {
public:
	virtual ATKregistryEntry *ATKregistry();


    
      
	static boolean InitializeClass();

      
	fontsel();
      
	virtual ~fontsel();

    
      virtual void SetStyle(long mask);
      virtual void SetSize(short val);
      virtual void SetFamily(char *val);

    
      inline long   GetStyle()  { return ((this)->style); }
      inline short   GetSize()  { return ((this)->size); }
      inline char  * GetFamily()  { return ((this)->family); }
      inline long IsActive(int val)  { return ((this)->active & ((unsigned long)1<<(val))); }
      inline void UnsetStyle()  { (((this))->SetStyle( fontsel_default_Style), (this)->active &= ~((unsigned long)1<<fontsel_Style)); }
      inline void UnsetSize()  { (((this))->SetSize( fontsel_default_Size), (this)->active &= ~((unsigned long)1<<fontsel_Size)); }
      inline void UnsetFamily()  { (((this))->SetFamily( fontsel_default_Family), (this)->active &= ~((unsigned long)1<<fontsel_Family)); }

    
      long style;
      short size;
      char *family;

      long active;
};

#endif /* _fontsel_H_ */
